/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.starflow.formserver;

import com.starbase.starteam.starflow.formserver.CAT;
import com.starbase.starteam.starflow.formserver.FormServer;
import com.starbase.util.ByteOrder;
import java.io.IOException;
import java.io.OutputStream;

class DataOutputStream
extends OutputStream {
    public static final byte INT_TYPE = 1;
    public static final byte STRING_TYPE = 2;
    public static final byte ARGS_TYPE = 3;
    protected final OutputStream m_stream;

    public DataOutputStream(OutputStream stream) {
        this.m_stream = stream;
    }

    public void write(int c) throws IOException {
        this.m_stream.write(c);
    }

    public void writeCookie(String cookie) throws IOException {
        if (cookie.length() != FormServer.MAGIC_COOKIE_LENGTH) {
            throw new Error("Invalid cookie, must be exactly 30 characters long");
        }
        char[] chars = cookie.toCharArray();
        int i = 0;
        while (i < FormServer.MAGIC_COOKIE_LENGTH) {
            this.write(chars[i]);
            ++i;
        }
        CAT.debug("wrote cookie");
    }

    public void writeArgs(String[] args) throws IOException {
        this.write(3);
        this.writeInt(args.length);
        int i = 0;
        while (i < args.length) {
            this.writeUTF(args[i]);
            ++i;
        }
    }

    public void writeInt(int i) throws IOException {
        byte[] tmp = new byte[4];
        ByteOrder.writeInt((byte[])tmp, (int)i);
        this.write(1);
        this.write(tmp[0]);
        this.write(tmp[1]);
        this.write(tmp[2]);
        this.write(tmp[3]);
    }

    public void writeUTF(String s) throws IOException {
        byte[] tmp = s.getBytes("UTF-8");
        this.write(2);
        this.writeInt(tmp.length);
        int i = 0;
        while (i < tmp.length) {
            this.write(tmp[i]);
            ++i;
        }
    }
}

