/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.starflow.formserver;

import com.starbase.starteam.starflow.formserver.FormServer;
import com.starbase.util.ByteOrder;
import java.io.IOException;
import java.io.InputStream;

class DataInputStream
extends InputStream {
    protected final InputStream m_stream;

    public DataInputStream(InputStream stream) {
        this.m_stream = stream;
    }

    public int available() throws IOException {
        return this.m_stream.available();
    }

    public int read() throws IOException {
        return this.m_stream.read();
    }

    public String readCookie() throws IOException {
        char[] chars = new char[FormServer.MAGIC_COOKIE_LENGTH];
        int i = 0;
        while (i < chars.length) {
            chars[i] = (char)this.read();
            ++i;
        }
        String ret = new String(chars);
        return ret;
    }

    public String[] readArgs() throws IOException {
        byte type = (byte)this.read();
        if (type != 3) {
            throw new IOException("Expecting to receive args, but received something unknown");
        }
        int length = this.readInt();
        String[] ret = new String[length];
        int i = 0;
        while (i < length) {
            ret[i] = this.readUTF();
            ++i;
        }
        return ret;
    }

    public int readInt() throws IOException {
        byte type = (byte)this.read();
        if (type != 1) {
            throw new IOException("Expecting to receive an int, but received something unknown");
        }
        byte[] tmp = new byte[]{(byte)this.read(), (byte)this.read(), (byte)this.read(), (byte)this.read()};
        return ByteOrder.readInt((byte[])tmp);
    }

    public String readUTF() throws IOException {
        byte type = (byte)this.read();
        if (type != 2) {
            throw new IOException("Expecting to receive a String, but received something unknown");
        }
        int length = this.readInt();
        byte[] tmp = new byte[length];
        int i = 0;
        while (i < length) {
            tmp[i] = (byte)this.read();
            ++i;
        }
        return new String(tmp, "UTF-8");
    }
}

