/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.starflow;

import com.starbase.starteam.BuildNumber;
import com.starbase.starteam.EnumeratedValue;
import com.starbase.starteam.GroupAccount;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerException;
import com.starbase.starteam.User;
import com.starbase.starteam.starflow.ItemWrapper;
import com.starbase.starteam.starflow.UnknownWorkflowStatusException;
import com.starbase.starteam.starflow.WorkflowHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Workflow {
    private static final boolean DEBUG_ON = false;
    protected static final String STEP_ENUM = "stepenum";
    protected static final String AUTHORIZED = "authorized";
    protected static final String REQUIRED = "required";
    protected static final String DISABLED = "disabled";
    protected static final String HIDDEN = "hidden";
    protected static final String CASE_PROPERTY = "caseproperty";
    protected static final String CONDITIONS = "conditions";
    protected static final String CONDITIONAL_NEXT_STEPS = "conditionalnextsteps";
    protected static final String DEFAULT_NEXT_STEPS = "defaultnextsteps";
    protected static final String DYNAMIC_DEFAULTS_SOURCE_PROPERTY_NAMES = "dynamicdefaultssourcepropertynames";
    protected static final String DYNAMIC_DEFAULTS = "dynamicdefaults";
    protected static final Object OTHERWISE = new Object();
    protected static Class _enumClass;
    protected static Class _translationsClass;
    protected final Document m_document;
    protected String m_version;
    protected boolean m_isDisabled = false;
    protected EnumeratedValue[] m_allSteps;
    protected final HashMap m_namesToCodes = new HashMap();
    protected final HashMap m_steps = new HashMap();
    protected String m_workflowPropertyName;
    protected String m_itemType;
    protected EnumeratedValue m_startingStep;
    private final Hashtable m_userToGroups = new Hashtable();
    static /* synthetic */ Class class$com$starbase$starteam$EnumeratedValue;
    static /* synthetic */ Class class$java$lang$String;

    public static Workflow createWorkflow(InputStream workflow, InputStream groups) throws IOException {
        Workflow w = new Workflow(workflow, groups);
        Workflow ret = w.isWorkflowDisabled() ? null : w;
        return ret;
    }

    public static Workflow createWorkflow(Reader workflow, Reader groups) throws IOException {
        Workflow w = new Workflow(workflow, groups);
        Workflow ret = w.isWorkflowDisabled() ? null : w;
        return ret;
    }

    public static Workflow createWorkflow(InputSource workflow, InputSource groups) throws IOException {
        Workflow w = new Workflow(workflow, groups);
        Workflow ret = w.isWorkflowDisabled() ? null : w;
        return ret;
    }

    public Workflow(InputStream workflow, InputStream groups) throws IOException {
        this(new InputSource(workflow), groups != null ? new InputSource(groups) : null);
    }

    public Workflow(Reader workflow, Reader groups) throws IOException {
        this(new InputSource(workflow), groups != null ? new InputSource(groups) : null);
    }

    public Workflow(InputSource workflow, InputSource groups) throws IOException {
        try {
            Document doc;
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = fact.newDocumentBuilder();
            this.m_document = doc = parser.parse(workflow);
            this.buildCache(doc);
            if (!this.isWorkflowDisabled() && groups != null) {
                this.initGroups(groups);
            }
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Unable to initialize workflow parser: " + e.toString());
        }
        catch (SAXException e) {
            throw new IOException("Failed to parse workflow: " + e.toString());
        }
    }

    protected void buildCache(Document doc) {
        block31: {
            String version = doc.getDocumentElement().getAttribute("version");
            this.m_version = version != null ? version.trim() : "0.0";
            this.m_isDisabled = DISABLED.equals(doc.getDocumentElement().getTagName());
            if (this.m_isDisabled) break block31;
            NodeList setupInfoNodes = doc.getElementsByTagName("SetupInfo");
            int setupInfoNodesLength = setupInfoNodes.getLength();
            if (setupInfoNodesLength != 1) {
                throw new RuntimeException("Workflow definition is corrupt (<SetupInfo> not found)");
            }
            Node setupInfoNode = setupInfoNodes.item(0);
            Node workflowPropertyNode = Workflow.findChild(setupInfoNode, "WorkflowProperty");
            this.m_workflowPropertyName = workflowPropertyNode == null ? null : workflowPropertyNode.getFirstChild().getNodeValue().trim();
            Node itemTypeNode = Workflow.findChild(setupInfoNode, "ItemType");
            this.m_itemType = itemTypeNode == null ? null : itemTypeNode.getFirstChild().getNodeValue().trim();
            Node startingStepNode = Workflow.findChild(setupInfoNode, "StartingStep");
            if (startingStepNode == null) {
                throw new RuntimeException("Workflow definition is corrupt (<StartingStep> not found)");
            }
            Node startingStepEnumNode = Workflow.findChild(startingStepNode, "enumvalue");
            this.m_startingStep = this.createEnumeratedValue(Integer.parseInt(Workflow.findChild(startingStepEnumNode, "code").getFirstChild().getNodeValue()), Workflow.findChild(startingStepEnumNode, "name").getFirstChild().getNodeValue());
            NodeList steps = doc.getElementsByTagName("step");
            ArrayList<EnumeratedValue> tmpAllSteps = new ArrayList<EnumeratedValue>();
            int stepsLength = steps.getLength();
            int stepIndex = 0;
            while (stepIndex < stepsLength) {
                Node conditionNode;
                Element step = (Element)steps.item(stepIndex);
                EnumeratedValue stepEnum = this.createEnumeratedValue(Integer.parseInt(step.getAttribute("code")), step.getAttribute("name"));
                tmpAllSteps.add(stepEnum);
                String name = stepEnum.getDescription() != null ? stepEnum.getDescription() : stepEnum.toString();
                this.m_namesToCodes.put(name.toUpperCase(), new Integer(stepEnum.getCode()));
                HashMap<String, Object> stepAttributes = new HashMap<String, Object>();
                this.m_steps.put(new Integer(stepEnum.getCode()), stepAttributes);
                stepAttributes.put(STEP_ENUM, stepEnum);
                Node authorizedNode = Workflow.findChild(step, "Authorized");
                if (authorizedNode == null) {
                    throw new RuntimeException("Workflow definition is corrupt (<Authorized> not found)");
                }
                NodeList authorizedNodes = authorizedNode.getChildNodes();
                ArrayList<String> tmpAuthorized = new ArrayList<String>();
                int authorizedNodesLength = authorizedNodes.getLength();
                int i = 0;
                while (i < authorizedNodesLength) {
                    Node node = authorizedNodes.item(i);
                    if ("listvalue".equals(node.getNodeName())) {
                        tmpAuthorized.add(node.getFirstChild().getNodeValue());
                    }
                    ++i;
                }
                String[] authorized = tmpAuthorized.toArray(new String[0]);
                stepAttributes.put(AUTHORIZED, authorized);
                Node requiredNode = Workflow.findChild(step, "ValidateFields");
                if (requiredNode == null) {
                    throw new RuntimeException("Workflow definition is corrupt (<ValidateFields> not found)");
                }
                NodeList requiredNodes = requiredNode.getChildNodes();
                ArrayList<String> tmpRequired = new ArrayList<String>();
                int requiredNodesLength = requiredNodes.getLength();
                int i2 = 0;
                while (i2 < requiredNodesLength) {
                    Node node = requiredNodes.item(i2);
                    if ("listvalue".equals(node.getNodeName())) {
                        tmpRequired.add(node.getFirstChild().getNodeValue());
                    }
                    ++i2;
                }
                String[] required = tmpRequired.toArray(new String[0]);
                stepAttributes.put(REQUIRED, required);
                Node disabledNode = Workflow.findChild(step, "DisableControls");
                if (disabledNode == null) {
                    throw new RuntimeException("Workflow definition is corrupt (<DisableControls> not found)");
                }
                NodeList disabledNodes = disabledNode.getChildNodes();
                ArrayList<String> tmpDisabled = new ArrayList<String>();
                int disabledNodesLength = disabledNodes.getLength();
                int i3 = 0;
                while (i3 < disabledNodesLength) {
                    Node node = disabledNodes.item(i3);
                    if ("listvalue".equals(node.getNodeName())) {
                        tmpDisabled.add(node.getFirstChild().getNodeValue());
                    }
                    ++i3;
                }
                String[] disabled = tmpDisabled.toArray(new String[0]);
                stepAttributes.put(DISABLED, disabled);
                Node hiddenNode = Workflow.findChild(step, "HideControls");
                if (hiddenNode == null) {
                    throw new RuntimeException("Workflow definition is corrupt (<HideControls> not found)");
                }
                NodeList hiddenNodes = hiddenNode.getChildNodes();
                ArrayList<String> tmpHidden = new ArrayList<String>();
                int hiddenNodesLength = hiddenNodes.getLength();
                int i4 = 0;
                while (i4 < hiddenNodesLength) {
                    Node node = hiddenNodes.item(i4);
                    if ("listvalue".equals(node.getNodeName())) {
                        tmpHidden.add(node.getFirstChild().getNodeValue());
                    }
                    ++i4;
                }
                String[] hidden = tmpHidden.toArray(new String[0]);
                stepAttributes.put(HIDDEN, hidden);
                Node nextStepNode = Workflow.findChild(step, "NextStep");
                if (nextStepNode == null) {
                    throw new RuntimeException("Workflow definition is corrupt (<NextStep> not found)");
                }
                NodeList defaultNextStepNodes = nextStepNode.getChildNodes();
                ArrayList<EnumeratedValue> nextStepsList = new ArrayList<EnumeratedValue>();
                int defaultNextStepNodesLength = defaultNextStepNodes.getLength();
                int i5 = 0;
                while (i5 < defaultNextStepNodesLength) {
                    Node node = defaultNextStepNodes.item(i5);
                    if ("listvalue".equals(node.getNodeName())) {
                        Node enumNode = Workflow.findChild(node, "enumvalue");
                        nextStepsList.add(this.createEnumeratedValue(Integer.parseInt(Workflow.findChild(enumNode, "code").getFirstChild().getNodeValue()), Workflow.findChild(enumNode, "name").getFirstChild().getNodeValue()));
                    }
                    ++i5;
                }
                EnumeratedValue[] nextSteps = nextStepsList.toArray(new EnumeratedValue[0]);
                stepAttributes.put(DEFAULT_NEXT_STEPS, nextSteps);
                Node caseNode = Workflow.findChild(step, "CaseField");
                if (caseNode != null) {
                    stepAttributes.put(CASE_PROPERTY, caseNode.getFirstChild().getNodeValue().trim());
                } else {
                    stepAttributes.put(CASE_PROPERTY, null);
                }
                ArrayList<String> conditions = new ArrayList<String>();
                HashMap<String, EnumeratedValue[]> conditionalNextSteps = new HashMap<String, EnumeratedValue[]>();
                int z = 1;
                while ((conditionNode = Workflow.findChild(step, "Case" + z + "Condition")) != null) {
                    String condition = conditionNode.getFirstChild().getNodeValue().trim();
                    conditions.add(condition);
                    Node conditionalNextStepNode = Workflow.findChild(step, "Case" + z + "NextStep");
                    NodeList conditionalNextStepNodes = conditionalNextStepNode.getChildNodes();
                    ArrayList<EnumeratedValue> tmp = new ArrayList<EnumeratedValue>();
                    int conditionalNextStepNodesLength = conditionalNextStepNodes.getLength();
                    int k = 0;
                    while (k < conditionalNextStepNodesLength) {
                        Node node = conditionalNextStepNodes.item(k);
                        if ("listvalue".equals(node.getNodeName())) {
                            Node enumNode = Workflow.findChild(node, "enumvalue");
                            tmp.add(this.createEnumeratedValue(Integer.parseInt(Workflow.findChild(enumNode, "code").getFirstChild().getNodeValue()), Workflow.findChild(enumNode, "name").getFirstChild().getNodeValue()));
                        }
                        ++k;
                    }
                    conditionalNextSteps.put(condition.toUpperCase(), tmp.toArray(new EnumeratedValue[0]));
                    ++z;
                }
                stepAttributes.put(CONDITIONS, conditions.size() > 0 ? conditions.toArray(new String[0]) : null);
                stepAttributes.put(CONDITIONAL_NEXT_STEPS, conditions.size() > 0 ? conditionalNextSteps : null);
                Node dynamicDefaultsNode = Workflow.findChild(step, DYNAMIC_DEFAULTS);
                if (dynamicDefaultsNode == null) {
                    throw new RuntimeException("Workflow definition is corrupt (<dynamicdefaults> not found)");
                }
                NodeList sourcePropertyNodes = dynamicDefaultsNode.getChildNodes();
                ArrayList<String> tmpSourcePropertyNames = new ArrayList<String>();
                HashMap<String, DynamicDefaultsCase[]> dynamicDefaults = new HashMap<String, DynamicDefaultsCase[]>();
                int sourcePropertyNodesLength = sourcePropertyNodes.getLength();
                int i6 = 0;
                while (i6 < sourcePropertyNodesLength) {
                    block32: {
                        Node sourcePropertyNode = sourcePropertyNodes.item(i6);
                        if (!"sourceproperty".equals(sourcePropertyNode.getNodeName())) break block32;
                        String sourcePropertyName = ((Element)sourcePropertyNode).getAttribute("name").trim();
                        tmpSourcePropertyNames.add(sourcePropertyName);
                        ArrayList<DynamicDefaultsCase> cases = new ArrayList<DynamicDefaultsCase>();
                        NodeList caseNodes = sourcePropertyNode.getChildNodes();
                        int caseNodesLength = caseNodes.getLength();
                        int k = 0;
                        while (k < caseNodesLength) {
                            block35: {
                                Node node;
                                String conditionalValue;
                                block34: {
                                    block33: {
                                        conditionalValue = null;
                                        node = caseNodes.item(k);
                                        if (!"whenequals".equals(node.getNodeName())) break block33;
                                        conditionalValue = ((Element)node).getAttribute("value").trim();
                                        break block34;
                                    }
                                    if (!"otherwise".equals(node.getNodeName())) break block35;
                                    conditionalValue = null;
                                }
                                Hashtable<String, String> sideEffects = new Hashtable<String, String>();
                                NodeList sideEffectNodes = node.getChildNodes();
                                int sideEffectNodesLength = sideEffectNodes.getLength();
                                int m = 0;
                                while (m < sideEffectNodesLength) {
                                    Node sideEffectNode = sideEffectNodes.item(m);
                                    if ("set".equals(sideEffectNode.getNodeName())) {
                                        String targetPropertyName = ((Element)sideEffectNode).getAttribute("property").trim();
                                        String targetValue = sideEffectNode.getFirstChild().getNodeValue().trim();
                                        sideEffects.put(targetPropertyName, targetValue);
                                    }
                                    ++m;
                                }
                                DynamicDefaultsCase ddCase = new DynamicDefaultsCase(sourcePropertyName, conditionalValue, sideEffects);
                                cases.add(ddCase);
                            }
                            ++k;
                        }
                        dynamicDefaults.put(sourcePropertyName.toUpperCase(), cases.toArray(new DynamicDefaultsCase[0]));
                    }
                    ++i6;
                }
                String[] sourcePropertyNames = tmpSourcePropertyNames.toArray(new String[0]);
                stepAttributes.put(DYNAMIC_DEFAULTS_SOURCE_PROPERTY_NAMES, sourcePropertyNames);
                stepAttributes.put(DYNAMIC_DEFAULTS, dynamicDefaults);
                ++stepIndex;
            }
            this.m_allSteps = tmpAllSteps.toArray(new EnumeratedValue[0]);
        }
    }

    protected Object findAttribute(String workflowStatusName, int workflowStatusCode, String attribute) {
        Integer key;
        if (workflowStatusName != null) {
            key = (Integer)this.m_namesToCodes.get(workflowStatusName.toUpperCase());
            if (key == null) {
                throw new UnknownWorkflowStatusException("Workflow definition is corrupt or is out of sync with the Workflow Status values defined in this server.  Could not find a status " + (workflowStatusName != null ? "named " + workflowStatusName : "for code " + workflowStatusCode) + ".");
            }
        } else {
            key = new Integer(workflowStatusCode);
        }
        HashMap step = (HashMap)this.m_steps.get(key);
        return step.get(attribute);
    }

    public String getVersion() {
        return this.m_version;
    }

    public boolean isWorkflowDisabled() {
        return this.m_isDisabled;
    }

    public boolean isAuthorized(ItemWrapper item, int workflowStatusCode) throws UnknownWorkflowStatusException {
        return this.isAuthorized(item, null, workflowStatusCode);
    }

    protected boolean isAuthorized(ItemWrapper item, String workflowStatusName, int workflowStatusCode) throws UnknownWorkflowStatusException {
        boolean ret = false;
        String[] authorized = (String[])this.findAttribute(workflowStatusName, workflowStatusCode, AUTHORIZED);
        if (authorized.length > 0) {
            int i = 0;
            while (i < authorized.length) {
                if ("<all>".equals(authorized[i])) {
                    ret = true;
                    break;
                }
                if (this.matchToUserID(authorized[i], item)) {
                    ret = true;
                    break;
                }
                ++i;
            }
        } else {
            ret = true;
        }
        return ret;
    }

    public String getWorkflowStatusPropertyName() {
        return this.m_workflowPropertyName;
    }

    public String getItemType() {
        return this.m_itemType;
    }

    public EnumeratedValue getStartingStep() {
        return this.m_startingStep;
    }

    public EnumeratedValue[] getAllSteps() {
        return this.m_allSteps;
    }

    public EnumeratedValue[] getNextSteps(ItemWrapper item) throws UnknownWorkflowStatusException {
        EnumeratedValue[] ret;
        int stepCode = item == null ? this.getStartingStep().getCode() : item.getInitialWorkflowStatus();
        String[] conditions = (String[])this.findAttribute(null, stepCode, CONDITIONS);
        if (item == null || conditions == null) {
            ret = (EnumeratedValue[])this.findAttribute(null, stepCode, DEFAULT_NEXT_STEPS);
        } else {
            String caseProperty = (String)this.findAttribute(null, stepCode, CASE_PROPERTY);
            HashMap conditionalNextSteps = (HashMap)this.findAttribute(null, stepCode, CONDITIONAL_NEXT_STEPS);
            EnumeratedValue[] tmp = null;
            int i = 0;
            while (i < conditions.length) {
                if (Workflow.compare(item.get(caseProperty), WorkflowHelper.resolveStringToObject(item, caseProperty, conditions[i]))) {
                    tmp = (EnumeratedValue[])conditionalNextSteps.get(conditions[i].toUpperCase());
                    break;
                }
                ++i;
            }
            ret = tmp != null ? tmp : (EnumeratedValue[])this.findAttribute(null, stepCode, DEFAULT_NEXT_STEPS);
        }
        return ret;
    }

    public String getCaseCondition(int workflowStatusCode) throws UnknownWorkflowStatusException {
        return this.getCaseCondition(null, workflowStatusCode);
    }

    protected String getCaseCondition(String workflowStatusName, int workflowStatusCode) throws UnknownWorkflowStatusException {
        return (String)this.findAttribute(workflowStatusName, workflowStatusCode, CASE_PROPERTY);
    }

    public boolean isRequired(String propertyName, int workflowStatusCode) throws UnknownWorkflowStatusException {
        return this.arrayContains(propertyName, null, workflowStatusCode, REQUIRED);
    }

    public boolean isDisabled(String propertyName, int workflowStatusCode) throws UnknownWorkflowStatusException {
        return this.arrayContains(propertyName, null, workflowStatusCode, DISABLED);
    }

    public boolean isHidden(String propertyName, int workflowStatusCode) throws UnknownWorkflowStatusException {
        return this.arrayContains(propertyName, null, workflowStatusCode, HIDDEN);
    }

    public Dictionary getDynamicDefaults(int workflowStatusCode, String propertyName, ItemWrapper item) throws UnknownWorkflowStatusException {
        return this.getDynamicDefaults(null, workflowStatusCode, propertyName, item);
    }

    protected Dictionary getDynamicDefaults(String workflowStatusName, int workflowStatusCode, String propertyName, ItemWrapper item) throws UnknownWorkflowStatusException {
        Hashtable ret = new Hashtable();
        String[] sourcePropertyNames = (String[])this.findAttribute(workflowStatusName, workflowStatusCode, DYNAMIC_DEFAULTS_SOURCE_PROPERTY_NAMES);
        HashMap dynamicDefaults = (HashMap)this.findAttribute(workflowStatusName, workflowStatusCode, DYNAMIC_DEFAULTS);
        int i = 0;
        while (i < sourcePropertyNames.length) {
            String sourcePropertyName = sourcePropertyNames[i];
            if (item.getWorkflowStatusPropertyName().equals(propertyName) || propertyName.equals(sourcePropertyName)) {
                DynamicDefaultsCase[] cases = (DynamicDefaultsCase[])dynamicDefaults.get(sourcePropertyName.toUpperCase());
                int k = 0;
                while (k < cases.length) {
                    if (cases[k].isMatch(item)) {
                        Dictionary sideEffects = cases[k].getSideEffects();
                        Enumeration keys = sideEffects.keys();
                        while (keys.hasMoreElements()) {
                            Object key = keys.nextElement();
                            ((Dictionary)ret).put(key, sideEffects.get(key));
                        }
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
        return ret;
    }

    protected static boolean compare(Object a, Object b) {
        boolean ret = a == null && b == null ? true : (a == null ^ b == null ? false : (a instanceof String && b instanceof String ? ((String)a).equalsIgnoreCase((String)b) : a.equals(b)));
        return ret;
    }

    protected boolean arrayContains(String valueToMatch, String workflowStatusName, int workflowStatusCode, String attributeName) {
        boolean ret = false;
        String[] array = (String[])this.findAttribute(workflowStatusName, workflowStatusCode, attributeName);
        int i = 0;
        while (i < array.length) {
            if (array[i].equalsIgnoreCase(valueToMatch)) {
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }

    protected boolean listContains(String valueToMatch, String workflowStatusName, int workflowStatusCode, String fieldName) throws UnknownWorkflowStatusException {
        boolean ret = false;
        Node listNode = Workflow.findChild(this.findStep(workflowStatusName, workflowStatusCode), fieldName);
        if (listNode == null) {
            throw new RuntimeException("Workflow definition is corrupt (2)");
        }
        NodeList fields = listNode.getChildNodes();
        int fieldsLength = fields.getLength();
        int i = 0;
        while (i < fieldsLength) {
            Node node = fields.item(i);
            if ("listvalue".equals(node.getNodeName()) && node.getFirstChild().getNodeValue().trim().equalsIgnoreCase(valueToMatch)) {
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }

    protected Node findStep(String workflowStatusName, int workflowStatusCode) throws UnknownWorkflowStatusException {
        Node step = null;
        NodeList nodes = this.m_document.getElementsByTagName("step");
        int nodesLength = nodes.getLength();
        int i = 0;
        while (i < nodesLength) {
            Node node = nodes.item(i);
            if ("WorkflowConfiguration".equals(node.getParentNode().getNodeName())) {
                if (workflowStatusName != null) {
                    if (((Element)node).getAttribute("name").equals(workflowStatusName)) {
                        step = node;
                        break;
                    }
                } else if (Integer.parseInt(((Element)node).getAttribute("code")) == workflowStatusCode) {
                    step = node;
                    break;
                }
            }
            ++i;
        }
        if (step == null) {
            throw new UnknownWorkflowStatusException("Workflow definition is corrupt or is out of sync with the Workflow Status values defined in this server.  Could not find a status " + (workflowStatusName != null ? "named " + workflowStatusName : "for code " + workflowStatusCode) + ".");
        }
        return step;
    }

    protected static Node findChild(Node parent, String childTagName) {
        Node ret = null;
        NodeList children = parent.getChildNodes();
        int childrenLength = children.getLength();
        int i = 0;
        while (i < childrenLength) {
            Node node = children.item(i);
            if (node.getNodeName().equals(childTagName)) {
                ret = node;
                break;
            }
            ++i;
        }
        return ret;
    }

    protected void getAncestors(Node node, Vector v) {
        Node parent = node.getParentNode();
        if (parent != null && parent instanceof Element) {
            v.addElement(parent);
            this.getAncestors(parent, v);
        }
    }

    protected boolean isUserInGroup(String user, String group) {
        Vector groups = (Vector)this.m_userToGroups.get(user);
        boolean ret = groups != null ? groups.contains(group) : false;
        return ret;
    }

    protected boolean isUserInGroup(User user, String group, Server server) {
        boolean ret = false;
        if (BuildNumber.getMajorVersion() > 5 || BuildNumber.getMajorVersion() == 5 && BuildNumber.getMinorVersion() >= 3) {
            try {
                GroupAccount[] groups = server.getAdministration().getGroupAccounts();
                int i = 0;
                while (i < groups.length) {
                    if (groups[i].getName().equalsIgnoreCase(group)) {
                        ret = groups[i].isMember(user.getID());
                    }
                    ++i;
                }
            }
            catch (ServerException e) {
                if (e.getErrorCode() == 6) {
                    ret = this.isUserInGroup(user.getName(), group);
                }
                throw e;
            }
        } else {
            ret = this.isUserInGroup(user.getName(), group);
        }
        return ret;
    }

    protected boolean matchToUserID(String s, ItemWrapper item) {
        boolean ret = false;
        User user = item.getType().getServer().getUser(item.getType().getServer().getSession().getUserID());
        if (s.equalsIgnoreCase("{{ResponsibilityResolved}}")) {
            s = "{{Responsibility}}";
        }
        if ("<originator>".equals(s) || "<Entered By>".equals(s)) {
            ret = user.getID() == ((Integer)item.getInitialValue(item.getPropertyNames().CREATED_USER_ID)).intValue();
        } else if (s.startsWith("{{") && s.endsWith("}}")) {
            String property = s.substring("{{".length(), s.length() - "}}".length());
            ret = user.getID() == ((Integer)item.getInitialValue(property)).intValue();
        } else if (user.getName().equalsIgnoreCase(s)) {
            ret = true;
        } else if (this.isUserInGroup(user, s, item.getType().getServer())) {
            ret = true;
        }
        return ret;
    }

    protected void initGroups(InputSource groups) throws IOException, SAXException, ParserConfigurationException {
        if (groups != null) {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = fact.newDocumentBuilder();
            Document doc = parser.parse(groups);
            Hashtable<String, Vector<String>> aliasMap = new Hashtable<String, Vector<String>>();
            NodeList aliasNodes = doc.getElementsByTagName("alias");
            int aliasNodesLength = aliasNodes.getLength();
            int i = 0;
            while (i < aliasNodesLength) {
                Node node = aliasNodes.item(i);
                String alias = ((Element)node).getAttribute("name");
                String starteamName = ((Element)node).getAttribute("starteamName");
                Vector<String> v = (Vector<String>)aliasMap.get(starteamName);
                if (v == null) {
                    v = new Vector<String>();
                    aliasMap.put(starteamName, v);
                }
                v.addElement(alias);
                ++i;
            }
            NodeList userNodes = doc.getElementsByTagName("user");
            int userNodesLength = userNodes.getLength();
            int i2 = 0;
            while (i2 < userNodesLength) {
                Node node = userNodes.item(i2);
                String userName = ((Element)node).getAttribute("name");
                Vector<String> v = (Vector<String>)this.m_userToGroups.get(userName);
                if (v == null) {
                    v = new Vector<String>();
                    this.m_userToGroups.put(userName, v);
                }
                Vector ancestors = new Vector();
                this.getAncestors(node, ancestors);
                int k = 0;
                while (k < ancestors.size()) {
                    Vector aliases;
                    String starteamName = ((Element)ancestors.elementAt(k)).getAttribute("name");
                    if (!v.contains(ancestors.elementAt(k))) {
                        v.addElement(starteamName);
                    }
                    if ((aliases = (Vector)aliasMap.get(starteamName)) != null) {
                        int z = 0;
                        while (z < aliases.size()) {
                            if (!v.contains(aliases.elementAt(z))) {
                                v.addElement((String)aliases.elementAt(z));
                            }
                            ++z;
                        }
                    }
                    ++k;
                }
                ++i2;
            }
        }
    }

    protected EnumeratedValue createEnumeratedValue(int code, String displayName) {
        EnumeratedValue ev = null;
        try {
            Constructor enumConstructor = null;
            Constructor translationsConstructor = null;
            if (_enumClass == null) {
                Class clazz = _enumClass = class$com$starbase$starteam$EnumeratedValue == null ? (class$com$starbase$starteam$EnumeratedValue = Workflow.class$("com.starbase.starteam.EnumeratedValue")) : class$com$starbase$starteam$EnumeratedValue;
            }
            if (_translationsClass == null) {
                _translationsClass = Class.forName("com.starbase.starteam.Translations");
            }
            translationsConstructor = _translationsClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = Workflow.class$("java.lang.String")) : class$java$lang$String);
            enumConstructor = _enumClass.getConstructor(Integer.TYPE, _translationsClass);
            Object translations = translationsConstructor.newInstance(displayName);
            ev = (EnumeratedValue)enumConstructor.newInstance(new Integer(code), translations);
        }
        catch (Exception e) {
            ev = new EnumeratedValue(code, displayName);
        }
        return ev;
    }

    public boolean isAuthorized(ItemWrapper item, String workflowStatusName) throws UnknownWorkflowStatusException {
        return this.isAuthorized(item, workflowStatusName, -1);
    }

    public String getCaseCondition(String workflowStatusName) throws UnknownWorkflowStatusException {
        return this.getCaseCondition(workflowStatusName, -1);
    }

    public boolean isRequired(String propertyName, String workflowStatusName) throws UnknownWorkflowStatusException {
        return this.arrayContains(propertyName, workflowStatusName, -1, REQUIRED);
    }

    public boolean isDisabled(String propertyName, String workflowStatusName) throws UnknownWorkflowStatusException {
        return this.arrayContains(propertyName, workflowStatusName, -1, DISABLED);
    }

    public boolean isHidden(String propertyName, String workflowStatusName) throws UnknownWorkflowStatusException {
        return this.arrayContains(propertyName, workflowStatusName, -1, HIDDEN);
    }

    public Dictionary getDynamicDefaults(String workflowStatusName, String propertyName, ItemWrapper item) throws UnknownWorkflowStatusException {
        return this.getDynamicDefaults(workflowStatusName, -1, propertyName, item);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class DynamicDefaultsCase {
        protected final String m_sourcePropertyName;
        protected final String m_condition;
        protected final Dictionary m_sideEffects;

        public DynamicDefaultsCase(String sourcePropertyName, String conditionValue, Dictionary sideEffects) {
            this.m_sourcePropertyName = sourcePropertyName;
            this.m_condition = conditionValue;
            this.m_sideEffects = sideEffects;
        }

        public boolean isMatch(ItemWrapper item) {
            return this.m_condition == null || Workflow.compare(item.get(this.m_sourcePropertyName), WorkflowHelper.resolveStringToObject(item, this.m_sourcePropertyName, this.m_condition));
        }

        public Dictionary getSideEffects() {
            return this.m_sideEffects;
        }

        public String toString() {
            return this.m_sourcePropertyName + ": " + this.m_condition + " -> " + this.toString(this.m_sideEffects);
        }

        protected String toString(Dictionary dict) {
            String ret = "";
            Enumeration keys = dict.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                ret = ret + key + " := " + dict.get(key);
                if (!keys.hasMoreElements()) continue;
                ret = ret + ", ";
            }
            return ret;
        }
    }
}

