/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.starflow;

import com.starbase.starteam.Item;
import com.starbase.starteam.PropertyEnums;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Task;
import com.starbase.starteam.TaskDependency;
import com.starbase.starteam.WorkRecord;
import com.starbase.starteam.starflow.ItemWrapper;
import com.starbase.starteam.starflow.RequirementNotFulfilledException;
import com.starbase.starteam.starflow.Workflow;
import com.starbase.util.OLEDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class TaskWrapper
extends ItemWrapper {
    protected WorkRecordCopy[] m_originalCopies;
    protected final ArrayList m_records = new ArrayList();
    protected final ArrayList m_newRecords = new ArrayList();
    protected final ArrayList m_deletedRecords = new ArrayList();

    public TaskWrapper(Task item, Workflow workflow, String workflowStatusPropertyName) {
        super((Item)item, workflow, workflowStatusPropertyName);
        this.m_records.addAll(Arrays.asList(((Task)this.m_item).getWorkRecords()));
        this.initOriginalCopies();
    }

    protected void initOriginalCopies() {
        this.m_originalCopies = new WorkRecordCopy[this.m_records.size()];
        int i = 0;
        Iterator iter = this.m_records.iterator();
        while (iter.hasNext()) {
            WorkRecord record = (WorkRecord)iter.next();
            this.m_originalCopies[i] = new WorkRecordCopy(record.getID(), record.getWorkPerformedBy(), record.getDateWorkBegan(), record.getHoursRemaining(), record.getHoursWorked(), record.getNotes());
            ++i;
        }
    }

    public boolean isPropertyDisabled(String propertyName) {
        this.rememberVersion();
        PropertyNames names = this.getView().getServer().getPropertyNames();
        PropertyEnums enums = this.getView().getServer().getPropertyEnums();
        boolean ret = super.isPropertyDisabled(propertyName) ? true : (names.TASK_IS_REPLICATED.equalsIgnoreCase(propertyName) && this.getInt(names.TASK_IS_REPLICATED) == enums.TASK_ORIGIN_MSPROJECT ? false : (this.getInt(names.TASK_IS_REPLICATED) == enums.TASK_ORIGIN_MSPROJECT ? names.TASK_NAME.equalsIgnoreCase(propertyName) || names.TASK_DURATION.equalsIgnoreCase(propertyName) || names.TASK_MILESTONE.equalsIgnoreCase(propertyName) || names.TASK_PRIORITY.equalsIgnoreCase(propertyName) || names.TASK_NOTES.equalsIgnoreCase(propertyName) || names.TASK_ESTIMATED_START.equalsIgnoreCase(propertyName) || names.TASK_ESTIMATED_FINISH.equalsIgnoreCase(propertyName) || names.TASK_ESTIMATED_HOURS.equalsIgnoreCase(propertyName) || names.TASK_PERCENT_COMPLETE.equalsIgnoreCase(propertyName) : (this.m_item.getInt(names.TASK_PARENT_ID) == -1 && this.m_item.getInt(names.TASK_WORKRECORD_COUNT) > 0 ? names.TASK_DURATION.equalsIgnoreCase(propertyName) : false)));
        return ret;
    }

    protected boolean isUserModifiable(String propertyName) {
        PropertyNames names = this.getView().getServer().getPropertyNames();
        boolean modifiable = super.isUserModifiable(propertyName) || names.TASK_IS_REPLICATED.equalsIgnoreCase(propertyName) || names.TASK_RESOURCE_NAMES.equalsIgnoreCase(propertyName);
        return modifiable;
    }

    public TaskDependency[] getPredecessorLinks() {
        this.rememberVersion();
        return ((Task)this.m_item).getPredecessorLinks();
    }

    public TaskDependency[] getSuccessorLinks() {
        this.rememberVersion();
        return ((Task)this.m_item).getSuccessorLinks();
    }

    public WorkRecord[] getWorkRecords() {
        this.rememberVersion();
        return this.m_records.toArray(new WorkRecord[this.m_records.size()]);
    }

    public WorkRecord createWorkRecord() {
        this.rememberVersion();
        return new WorkRecord((Task)this.m_item, this.getView().getServer().getSession().getUserID());
    }

    public void addWorkRecord(WorkRecord work) {
        if (!this.isAuthorized() || this.isReadOnly() || this.isLockedByAnotherUser()) {
            throw new IllegalStateException("The item you have attempted to edit is not editable by you.");
        }
        this.rememberVersion();
        this.m_records.add(work);
        this.m_newRecords.add(work);
        this.setDirty(this.anythingChanged());
    }

    public void removeWorkRecord(WorkRecord work) {
        if (!this.isAuthorized() || this.isReadOnly() || this.isLockedByAnotherUser()) {
            throw new IllegalStateException("The item you have attempted to edit is not editable by you.");
        }
        this.rememberVersion();
        if (!this.m_records.remove(work)) {
            throw new RuntimeException("Task.removeWorkRecord: Invalid work record");
        }
        this.m_deletedRecords.add(work);
        this.setDirty(this.anythingChanged());
    }

    public void reset() {
        super.reset();
        this.m_records.clear();
        this.m_records.addAll(Arrays.asList(((Task)this.m_item).getWorkRecords()));
        this.initOriginalCopies();
    }

    public void update() throws RequirementNotFulfilledException {
        try {
            Iterator iter = this.m_newRecords.iterator();
            while (iter.hasNext()) {
                WorkRecord record = (WorkRecord)iter.next();
                ((Task)this.m_item).addWorkRecord(record);
            }
            Iterator iter2 = this.m_deletedRecords.iterator();
            while (iter2.hasNext()) {
                WorkRecord record = (WorkRecord)iter2.next();
                ((Task)this.m_item).removeWorkRecord(record);
            }
            super.update();
        }
        catch (RuntimeException e) {
            this.m_item.discard();
            this.m_records.clear();
            this.m_newRecords.clear();
            this.m_deletedRecords.clear();
            this.m_records.addAll(Arrays.asList(((Task)this.m_item).getWorkRecords()));
            this.initOriginalCopies();
            throw e;
        }
        this.m_records.clear();
        this.m_newRecords.clear();
        this.m_deletedRecords.clear();
        this.m_records.addAll(Arrays.asList(((Task)this.m_item).getWorkRecords()));
        this.initOriginalCopies();
    }

    public void notifyEditedWorkRecord() {
        boolean changed = this.anythingChanged();
        this.setDirty(changed);
    }

    protected boolean anythingChanged() {
        boolean ret;
        boolean answerFromParent = super.anythingChanged();
        if (answerFromParent) {
            ret = true;
        } else {
            WorkRecord[] current = this.getWorkRecords();
            if (this.m_originalCopies.length != current.length) {
                ret = true;
            } else {
                boolean differ = false;
                int i = 0;
                while (i < this.m_originalCopies.length) {
                    boolean bl = differ = !this.areWorkRecordsEqual(this.m_originalCopies[i], current[i]);
                    if (differ) break;
                    ++i;
                }
                ret = differ;
            }
        }
        return ret;
    }

    protected boolean areWorkRecordsEqual(WorkRecord workRecord, WorkRecord otherWorkRecord) {
        return this.areOLEDatesEqual(workRecord.getDateWorkBegan(), otherWorkRecord.getDateWorkBegan()) && workRecord.getHoursRemaining() == otherWorkRecord.getHoursRemaining() && workRecord.getHoursWorked() == otherWorkRecord.getHoursWorked() && workRecord.getID() == otherWorkRecord.getID() && workRecord.getNotes().equals(otherWorkRecord.getNotes()) && workRecord.getWorkPerformedBy() == otherWorkRecord.getWorkPerformedBy();
    }

    protected boolean areWorkRecordsEqual(WorkRecordCopy copy, WorkRecord workRecord) {
        return this.areOLEDatesEqual(copy._dateWorkBegan, workRecord.getDateWorkBegan()) && copy._hoursRemaining == workRecord.getHoursRemaining() && copy._hoursWorked == workRecord.getHoursWorked() && copy._id == workRecord.getID() && copy._notes.equals(workRecord.getNotes()) && copy._workPerformedBy == workRecord.getWorkPerformedBy();
    }

    protected void init() {
        super.init();
        this.rememberVersion();
        if (this.m_records != null) {
            this.m_records.addAll(Arrays.asList(((Task)this.m_item).getWorkRecords()));
            this.initOriginalCopies();
        }
    }

    protected class WorkRecordCopy {
        protected final int _id;
        protected final int _workPerformedBy;
        protected final OLEDate _dateWorkBegan;
        protected final double _hoursRemaining;
        protected final double _hoursWorked;
        protected final String _notes;

        protected WorkRecordCopy(int id, int workPerformedBy, OLEDate dateWorkBegan, double hoursRemaining, double hoursWorked, String notes) {
            this._id = id;
            this._workPerformedBy = workPerformedBy;
            this._dateWorkBegan = dateWorkBegan;
            this._hoursRemaining = hoursRemaining;
            this._hoursWorked = hoursWorked;
            this._notes = notes;
        }
    }
}

