/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.starflow;

import com.starbase.starteam.Item;
import com.starbase.starteam.Label;
import com.starbase.starteam.Project;
import com.starbase.starteam.PromotionState;
import com.starbase.starteam.Server;
import com.starbase.starteam.StarTeamURL;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import com.starbase.starteam.shell.CommandLineSpec;
import com.starbase.starteam.shell.Option;
import com.starbase.starteam.shell.PositiveIntegerOption;
import com.starbase.starteam.shell.TimeOption;
import com.starbase.starteam.vts.comm.EncryptionAlgorithm;
import com.starbase.util.OLEDate;
import com.starbase.util.UTF8;
import com.starbase.util.errorhandling.NestedException;
import java.util.Date;
import java.util.StringTokenizer;

public class PropertyEditorCommand {
    protected final CommandLineSpec m_spec;
    protected final String m_command;
    protected final String[] m_args;
    protected final StarTeamURL m_url;
    protected final String m_password;
    protected final String m_viewConfigLabel;
    protected final OLEDate m_viewConfigTime;
    protected final String m_viewConfigPromotionState;
    protected final int m_current;
    protected final int m_parent;
    protected final int m_versionNumber;
    protected final boolean m_useWorkflow;
    protected final int[] m_itemIDs;

    public PropertyEditorCommand(Item[] items, int firstItemIndex, boolean isHistoryItem) throws IllegalArgumentException {
        throw new Error("Not implemented");
    }

    public PropertyEditorCommand(String command, String[] args) throws IllegalArgumentException {
        this.m_args = args;
        this.m_command = command;
        this.m_spec = "edit".equalsIgnoreCase(this.m_command) || "read".equalsIgnoreCase(this.m_command) ? new CommandLineSpec(true, false) : new CommandLineSpec(false, false);
        this.m_spec.addOption(new Option("Project", true));
        this.m_spec.addOption(new Option("EncryptedPassword", false));
        this.m_spec.addOption(new Option("DisableWorkflow", false));
        if ("read".equalsIgnoreCase(this.m_command)) {
            Object configgroup = new Object();
            this.m_spec.addOption(new Option("ViewLabel", false, configgroup));
            this.m_spec.addOption(new TimeOption("ViewDate", false, configgroup));
            this.m_spec.addOption(new Option("ViewPromotionState", false, configgroup));
            this.m_spec.addOption(new PositiveIntegerOption("VersionNumber", false, false));
        }
        if ("edit".equalsIgnoreCase(this.m_command) || "read".equalsIgnoreCase(this.m_command)) {
            this.m_spec.addOption(new Option("CurrentVMID", false));
        }
        if ("add".equalsIgnoreCase(this.m_command)) {
            this.m_spec.addOption(new Option("ParentVMID", false));
        }
        if (!this.m_spec.parse(args)) {
            throw new IllegalArgumentException(this.m_spec.errorMessage());
        }
        Option opt_p = this.m_spec.findSpecifiedOption(Option.getName("Project"));
        StarTeamURL url = new StarTeamURL((String)this.m_spec.getOptionValues(opt_p).elementAt(0));
        if (url.getUserName() == null || url.getHostName() == null || url.getPort() == null || url.getProjectName() == null) {
            throw new IllegalArgumentException("" + url + " does not contain the required components for a property editor command.");
        }
        this.m_url = url;
        Option opt_encpwd = this.m_spec.findSpecifiedOption(Option.getName("EncryptedPassword"));
        if (opt_encpwd != null) {
            String arg = (String)this.m_spec.getOptionValues(opt_encpwd).elementAt(0);
            byte[] passwordBytes = new byte[arg.length() / 2];
            int i = 0;
            while (i < passwordBytes.length) {
                passwordBytes[i] = (byte)(Integer.parseInt(arg.substring(i * 2, i * 2 + 2), 16) ^ passwordBytes.length);
                ++i;
            }
            this.m_password = UTF8.Utf8ToString((byte[])passwordBytes);
        } else {
            this.m_password = this.m_url.getPassword() == null ? "" : this.m_url.getPassword();
        }
        Option opt_cfgl = this.m_spec.findSpecifiedOption(Option.getName("ViewLabel"));
        Option opt_cfgd = this.m_spec.findSpecifiedOption(Option.getName("ViewDate"));
        Option opt_cfgp = this.m_spec.findSpecifiedOption(Option.getName("ViewPromotionState"));
        this.m_viewConfigLabel = opt_cfgl != null ? (String)this.m_spec.getOptionValues(opt_cfgl).elementAt(0) : null;
        this.m_viewConfigTime = opt_cfgd != null ? new OLEDate(((Date)this.m_spec.getOptionValues(opt_cfgd).elementAt(0)).getTime()) : null;
        this.m_viewConfigPromotionState = opt_cfgp != null ? (String)this.m_spec.getOptionValues(opt_cfgp).elementAt(0) : null;
        Option opt_current = this.m_spec.findSpecifiedOption(Option.getName("CurrentVMID"));
        this.m_current = opt_current != null ? Integer.parseInt((String)this.m_spec.getOptionValues(opt_current).elementAt(0)) : -1;
        Option opt_parent = this.m_spec.findSpecifiedOption(Option.getName("ParentVMID"));
        this.m_parent = opt_parent != null ? Integer.parseInt((String)this.m_spec.getOptionValues(opt_parent).elementAt(0)) : -1;
        this.m_useWorkflow = this.m_spec.findSpecifiedOption(Option.getName("DisableWorkflow")) == null;
        Option opt_vn = this.m_spec.findSpecifiedOption(Option.getName("VersionNumber"));
        this.m_versionNumber = opt_vn != null ? (Integer)this.m_spec.getOptionValues(opt_vn).elementAt(0) : -1;
        String[] nums = this.m_spec.getParameters();
        this.m_itemIDs = new int[nums.length];
        int i = 0;
        while (i < nums.length) {
            this.m_itemIDs[i] = Integer.parseInt(nums[i]);
            ++i;
        }
    }

    public String getCommand() {
        return this.m_command;
    }

    public String[] getArgs() {
        return this.m_args;
    }

    public StarTeamURL getURL() {
        return this.m_url;
    }

    public String getProject() {
        return this.m_url.getProjectName();
    }

    public String getView() {
        String path = this.m_url.getPath();
        int index = path.indexOf("/");
        return index == -1 ? path : path.substring(0, index);
    }

    public String getUser() {
        return this.m_url.getUserName();
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getViewConfigLabel() {
        return this.m_viewConfigLabel;
    }

    public OLEDate getViewConfigTime() {
        return this.m_viewConfigTime;
    }

    public String getViewConfigPromotionState() {
        return this.m_viewConfigPromotionState;
    }

    public boolean isViewConfigurationSpecified() {
        return this.getViewConfigPromotionState() != null || this.getViewConfigTime() != null || this.getViewConfigLabel() != null;
    }

    public int getVersionNumber() {
        return this.m_versionNumber;
    }

    public int getCurrentItemOffset() {
        return this.m_current;
    }

    public int getParentVMID() {
        return this.m_parent;
    }

    public boolean isUseWorkflow() {
        return this.m_useWorkflow;
    }

    public int[] getItemIDs() {
        return this.m_itemIDs;
    }

    public static Server openServer(PropertyEditorCommand cmd) {
        Server s = null;
        String strPort = cmd.getURL().getPort();
        int nPort = 0;
        try {
            nPort = Integer.parseInt(strPort);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid port: " + strPort);
        }
        s = new Server(cmd.getURL().getHostName(), nPort, EncryptionAlgorithm.NULL, false, cmd.getURL().getProtocol());
        s.logOn(cmd.getUser(), cmd.getPassword());
        return s;
    }

    protected static Project openProject(PropertyEditorCommand cmd) {
        Server s = PropertyEditorCommand.openServer(cmd);
        Project[] projects = s.getProjects();
        Project p = null;
        int i = 0;
        while (i < projects.length) {
            Project tmp = projects[i];
            if (tmp.getName().equalsIgnoreCase(cmd.getProject())) {
                p = tmp;
                break;
            }
            ++i;
        }
        return p;
    }

    protected static View openView(PropertyEditorCommand cmd) {
        Project p = PropertyEditorCommand.openProject(cmd);
        StringTokenizer toks = cmd.getURL().getFolders();
        View result = null;
        if (toks.hasMoreTokens()) {
            String first = toks.nextToken();
            View v = null;
            View[] views = p.getViews();
            int i = 0;
            while (i < views.length) {
                View tmp = views[i];
                if (tmp.getName().equalsIgnoreCase(first)) {
                    v = tmp;
                    break;
                }
                ++i;
            }
            result = v;
        } else {
            result = p.getDefaultView();
        }
        return result;
    }

    public View openView() {
        View view = null;
        String user = this.getUser();
        try {
            view = PropertyEditorCommand.openView(this);
        }
        catch (NullPointerException e) {
            throw new NestedException("Could not open view (" + user + ":XXXXXXX" + "@" + this.getURL().getHostName() + ":" + this.getURL().getPort() + "/" + this.getProject() + (this.getView() != null ? "/" + this.getView() : "") + ").  Check to see that it exists.", e);
        }
        return view;
    }

    public View openViewWithConfiguration(View baseView) {
        View view;
        if (this.getViewConfigLabel() != null) {
            String name = this.getViewConfigLabel();
            Label label = PropertyEditorCommand.findLabel(baseView, name);
            if (label == null) {
                throw new RuntimeException("Label \"" + name + "\" not found in " + baseView.getName() + ".");
            }
            view = new View(baseView, ViewConfiguration.createFromLabel((int)label.getID()));
        } else if (this.getViewConfigTime() != null) {
            OLEDate oledate = this.getViewConfigTime();
            view = new View(baseView, ViewConfiguration.createFromTime((OLEDate)oledate));
        } else if (this.getViewConfigPromotionState() != null) {
            String name = this.getViewConfigPromotionState();
            PromotionState state = PropertyEditorCommand.findPromotionState(baseView, name);
            if (state == null) {
                throw new RuntimeException("Promotion State \"" + name + "\" not found in " + baseView.getName());
            }
            view = new View(baseView, ViewConfiguration.createFromPromotionState((int)state.getObjectID()));
        } else {
            view = null;
        }
        return view;
    }

    protected static Label findLabel(View view, String labelName) {
        Label[] labels = view.getLabels();
        int i = 0;
        while (i < labels.length) {
            Label lbl = labels[i];
            if (!lbl.isDeleted() && labelName.equalsIgnoreCase(lbl.getName())) {
                return lbl;
            }
            ++i;
        }
        return null;
    }

    protected static PromotionState findPromotionState(View view, String name) {
        PromotionState[] states = view.getPromotionModel().getPromotionStates();
        int i = 0;
        while (i < states.length) {
            PromotionState state = states[i];
            if (state.getName().equalsIgnoreCase(name)) {
                return state;
            }
            ++i;
        }
        return null;
    }
}

