/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.starflow;

import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Label;
import com.starbase.starteam.Link;
import com.starbase.starteam.NoSuchPropertyException;
import com.starbase.starteam.Property;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerException;
import com.starbase.starteam.Type;
import com.starbase.starteam.TypedResource;
import com.starbase.starteam.User;
import com.starbase.starteam.View;
import com.starbase.starteam.starflow.CompoundValue;
import com.starbase.starteam.starflow.DefaultPossibleValueProducer;
import com.starbase.starteam.starflow.RequirementNotFulfilledException;
import com.starbase.starteam.starflow.UnknownWorkflowStatusException;
import com.starbase.starteam.starflow.UpdateConflictException;
import com.starbase.starteam.starflow.Workflow;
import com.starbase.starteam.starflow.WorkflowHelper;
import com.starbase.starteam.starflow.WorkflowStatusProducer;
import com.starbase.util.OLEDate;
import com.starbase.util.errorhandling.NestedException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class ItemWrapper
extends TypedResource {
    protected final Item m_item;
    protected final PropertyChangeSupport m_changeSupport = new PropertyChangeSupport((Object)this);
    protected final Hashtable m_modifiedValues = new Hashtable();
    protected final ArrayList m_modifiedAttachments = new ArrayList();
    protected final Workflow m_workflow;
    protected final String m_workflowStatusPropertyName;
    protected boolean m_dirty = false;
    protected boolean m_readOnly = false;
    protected Object m_objectID;
    protected Object m_rootObjectID;
    protected Object m_revisionNumber;
    protected int m_lastStatusCheckedValid = -1;
    protected boolean m_isWorkflowStatusValid = false;
    protected int m_lastStatusCheckedAuthorized = -1;
    protected boolean m_isAuthorized = false;
    protected final Semaphore m_usersSemaphore = new Semaphore();
    protected final Semaphore m_labelsSemaphore = new Semaphore();
    protected Label[] m_labels;
    protected Link[] m_links;
    static /* synthetic */ Class class$com$starbase$starteam$View;

    protected static Label[] fetchAllLabels(View view) {
        Method m;
        Label[] labels = null;
        try {
            m = (class$com$starbase$starteam$View == null ? (class$com$starbase$starteam$View = ItemWrapper.class$("com.starbase.starteam.View")) : class$com$starbase$starteam$View).getMethod("refreshActiveLabels", new Class[0]);
            m.invoke((Object)view, new Object[0]);
            Method m2 = (class$com$starbase$starteam$View == null ? (class$com$starbase$starteam$View = ItemWrapper.class$("com.starbase.starteam.View")) : class$com$starbase$starteam$View).getMethod("getActiveLabels", new Class[0]);
            labels = (Label[])m2.invoke((Object)view, new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (labels == null) {
            try {
                m = (class$com$starbase$starteam$View == null ? (class$com$starbase$starteam$View = ItemWrapper.class$("com.starbase.starteam.View")) : class$com$starbase$starteam$View).getMethod("fetchAllLabels", new Class[0]);
                labels = (Label[])m.invoke((Object)view, new Object[0]);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (labels == null) {
            view.refreshLabels();
            labels = view.getLabels();
        }
        return labels;
    }

    public static void refreshLabels(final ItemWrapper[] items) {
        final View view = items[0].getView();
        int i = 0;
        while (i < items.length) {
            if (!items[i].getView().equals((Object)view)) {
                throw new IllegalArgumentException("All items must be from the same view.");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < items.length) {
            items[i2].m_labelsSemaphore.waitOnCompletion();
            ++i2;
        }
        new Thread(new Runnable(){

            public void run() {
                Label[] labels = ItemWrapper.fetchAllLabels(view);
                int i = 0;
                while (i < items.length) {
                    items[i].m_labels = labels;
                    items[i].m_labelsSemaphore.completed();
                    ++i;
                }
            }
        }).start();
    }

    public static void refreshUsers(final ItemWrapper[] items) {
        Server server = items[0].getView().getServer();
        int i = 0;
        while (i < items.length) {
            if (!items[i].getView().getServer().equals((Object)server)) {
                throw new IllegalArgumentException("All items must be from the same server.");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < items.length) {
            items[i2].m_usersSemaphore.waitOnCompletion();
            ++i2;
        }
        new Thread(new Runnable(){

            public void run() {
                items[0].getView().getServer().refreshUsers();
                int i = 0;
                while (i < items.length) {
                    items[i].m_usersSemaphore.completed();
                    ++i;
                }
            }
        }).start();
    }

    protected Label[] getLabels() {
        try {
            this.m_labelsSemaphore.acquire();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.m_labels == null) {
            this.m_labels = ItemWrapper.fetchAllLabels(this.getView());
        }
        return this.m_labels;
    }

    protected User[] getUsers() {
        try {
            this.m_usersSemaphore.acquire();
        }
        catch (InterruptedException e) {}
        return this.getView().getServer().getUsers();
    }

    public ItemWrapper(Item item, Workflow workflow, String workflowStatusPropertyName) {
        if (item == null) {
            throw new RuntimeException("Item wrapped by ItemWrapper may not be null.");
        }
        this.m_item = item;
        this.m_dirty = this.m_item.isDirty();
        this.m_workflow = workflow;
        this.m_workflowStatusPropertyName = workflowStatusPropertyName;
        this.init();
    }

    protected void init() {
        if (this.m_item.isNew() && this.m_workflow != null) {
            this.m_item.put(this.m_workflowStatusPropertyName.toUpperCase(), (Object)new Integer(this.m_workflow.getStartingStep().getCode()));
            try {
                this.put(this.m_workflowStatusPropertyName, new Integer(this.m_workflow.getNextSteps(null)[0].getCode()));
            }
            catch (UnknownWorkflowStatusException e) {
                throw new NestedException("Encountered unexpected workflow definition corruption.  The 'StartingStep' of the workflow definition appears to be invalid.", e);
            }
            Property[] properties = this.getType().getProperties();
            int i = 0;
            while (i < properties.length) {
                int type;
                String propertyName = properties[i].getName();
                if (!propertyName.equals(this.getWorkflowStatusPropertyName()) && this.isPropertyRequired(propertyName) && ((type = properties[i].getTypeCode()) == 2 || type == 4 || type == 10 || type == 3)) {
                    this.m_modifiedValues.put(properties[i].getName().toUpperCase(), new Integer(-1));
                }
                ++i;
            }
        }
    }

    public Folder getParentFolder() {
        return this.m_item.getParentFolder();
    }

    public View getView() {
        return this.m_item.getView();
    }

    public Type getType() {
        return this.m_item.getType();
    }

    public int getItemID() {
        return this.m_item.getItemID();
    }

    public Object getInitialValue(String propertyName) {
        return this.m_item.get(propertyName);
    }

    public Object get(String propertyName) {
        Object ret;
        Object modified = this.m_modifiedValues.get(propertyName.toUpperCase());
        if (modified != null) {
            ret = modified;
        } else {
            if (this.m_modifiedAttachments.isEmpty()) {
                ret = this.m_item.get(propertyName);
            } else {
                PropertyNames pn = this.getPropertyNames();
                ret = pn.ATTACHMENT_COUNT.equalsIgnoreCase(propertyName) ? new Integer(this.getAttachmentIDs().length) : (pn.ATTACHMENT_NAMES.equalsIgnoreCase(propertyName) ? this.getAttachmentNames() : (pn.ATTACHMENT_IDS.equalsIgnoreCase(propertyName) ? (Object)this.getAttachmentIDs() : this.m_item.get(propertyName)));
            }
            this.rememberVersion();
        }
        return ret;
    }

    public Object put(String propertyName, Object value) {
        return this.put(propertyName, value, this.isWorkflowStatusValid());
    }

    protected Object put(String propertyName, Object value, boolean enactDynamicDefaults) {
        Object ret;
        if (!this.isAuthorized() || this.isReadOnly() || this.isLockedByAnotherUser()) {
            throw new IllegalStateException("The item you have attempted to edit is not editable by you.");
        }
        Object oldValue = this.get(propertyName);
        Property property = this.getType().propertyForName(propertyName);
        if (value != null && oldValue != null && this.hasPropertyChanged(property, oldValue, value) || value == null ^ oldValue == null) {
            if (this.checkValue(propertyName, value)) {
                if (this.hasPropertyChanged(property, this.m_item.get(propertyName), value)) {
                    this.m_modifiedValues.put(propertyName.toUpperCase(), value);
                } else {
                    this.m_modifiedValues.remove(propertyName.toUpperCase());
                }
                ret = oldValue;
                try {
                    if (this.m_workflow != null && propertyName.equalsIgnoreCase(this.m_workflow.getCaseCondition(this.getInitialWorkflowStatus()))) {
                        CompoundValue[] validStates = this.getAllowedValues(this.getWorkflowStatusPropertyName());
                        if (this.getWorkflowStatus() != this.getInitialWorkflowStatus()) {
                            boolean found = false;
                            int i = 0;
                            while (i < validStates.length) {
                                if (this.getWorkflowStatus() == ((Integer)validStates[i].getPropertyValue()).intValue()) {
                                    found = true;
                                    break;
                                }
                                ++i;
                            }
                            if (!found) {
                                this.put(this.getWorkflowStatusPropertyName(), new Integer(this.getInitialWorkflowStatus()), false);
                            }
                        }
                    }
                }
                catch (NoSuchPropertyException e) {
                    e.printStackTrace();
                }
                if (enactDynamicDefaults) {
                    try {
                        this.dynamicDefaults(propertyName);
                    }
                    catch (RuntimeException e) {
                        this.put(propertyName, oldValue, false);
                        throw e;
                    }
                }
                this.setDirty(this.anythingChanged());
                if (property.getName().equalsIgnoreCase(this.getWorkflowStatusPropertyName())) {
                    this.m_changeSupport.firePropertyChange("workflowStatus", oldValue, value);
                } else {
                    this.m_changeSupport.firePropertyChange(property.getName(), oldValue, value);
                }
            } else {
                ret = null;
            }
        } else {
            ret = null;
        }
        return ret;
    }

    protected boolean checkValue(String propertyName, Object value) {
        return true;
    }

    protected int getInitialWorkflowStatus() {
        Integer val = this.m_workflow != null ? (Integer)this.m_item.get(this.m_workflowStatusPropertyName.toUpperCase()) : new Integer(-1);
        return val;
    }

    public int getWorkflowStatus() {
        return this.m_workflow != null ? (Integer)this.get(this.m_workflowStatusPropertyName) : -1;
    }

    public CompoundValue[] getAllowedValues(String propertyName) {
        DefaultPossibleValueProducer p = this.m_workflow != null && this.getWorkflowStatusPropertyName().equalsIgnoreCase(propertyName) ? new WorkflowStatusProducer() : new DefaultPossibleValueProducer();
        p.setItem(this, propertyName);
        return p.getPossibleValues();
    }

    public boolean isNew() {
        return this.m_item.isNew();
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    protected void setDirty(boolean dirty) {
        if (this.m_dirty != dirty) {
            boolean old = this.m_dirty;
            this.m_dirty = dirty;
            this.m_changeSupport.firePropertyChange("dirty", old, this.m_dirty);
        }
    }

    protected boolean anythingChanged() {
        return !this.m_modifiedAttachments.isEmpty() || !this.m_modifiedValues.isEmpty();
    }

    protected boolean hasPropertyChanged(Property property) {
        boolean ret = !property.isCalculated() && !property.isHeader() ? this.hasPropertyChanged(property, this.getInitialValue(property.getName()), this.get(property.getName())) : false;
        return ret;
    }

    protected boolean hasPropertyChanged(Property property, Object oldValue, Object newValue) {
        boolean ret = false;
        short revLevel = this.getType().getServer().getRevisionLevel();
        if (property.getTypeCode() == 9) {
            byte[] initialArray = (byte[])oldValue;
            byte[] newArray = (byte[])newValue;
            if (!(initialArray == newArray || this.isArrayEmpty(revLevel, initialArray) && this.isArrayEmpty(revLevel, newArray))) {
                if (initialArray.length != newArray.length) {
                    ret = true;
                } else {
                    int k = 0;
                    while (k < initialArray.length) {
                        if (initialArray[k] != newArray[k]) {
                            ret = true;
                            break;
                        }
                        ++k;
                    }
                }
            }
        } else if (property.getTypeCode() == 11) {
            int[] initialArray = (int[])oldValue;
            int[] newArray = (int[])newValue;
            if (initialArray != newArray) {
                if (initialArray.length != newArray.length) {
                    ret = true;
                } else {
                    int k = 0;
                    while (k < initialArray.length) {
                        if (initialArray[k] != newArray[k]) {
                            ret = true;
                            break;
                        }
                        ++k;
                    }
                }
            }
        } else if (property.getTypeCode() == 7) {
            OLEDate old = (OLEDate)oldValue;
            OLEDate current = (OLEDate)newValue;
            ret = !this.areOLEDatesEqual(old, current);
        } else if (!oldValue.equals(newValue)) {
            ret = true;
        }
        return ret;
    }

    protected boolean areOLEDatesEqual(OLEDate one, OLEDate other) {
        return Double.doubleToLongBits(one.getDoubleValue()) == Double.doubleToLongBits(other.getDoubleValue());
    }

    protected boolean isArrayEmpty(short revLevel, byte[] array) {
        boolean ret = array.length == 0 ? true : (array.length == 1 ? revLevel < 67 && array[0] == -1 : false);
        return ret;
    }

    public boolean isDirty(String propertyName) {
        boolean dirty;
        boolean bl = dirty = this.m_modifiedValues.get(propertyName) != null;
        if (!dirty && !this.m_modifiedAttachments.isEmpty()) {
            PropertyNames names = this.getPropertyNames();
            dirty = names.ATTACHMENT_COUNT.equalsIgnoreCase(propertyName) || names.ATTACHMENT_IDS.equalsIgnoreCase(propertyName) || names.ATTACHMENT_NAMES.equalsIgnoreCase(propertyName);
        }
        return dirty;
    }

    protected boolean hasOriginalValueEntry(String propertyName) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPropertyRequired(String propertyName) {
        if (this.m_workflow == null) return false;
        if (!this.isWorkflowStatusValid()) return false;
        if (this.isPropertyDisabled(propertyName)) return false;
        if (this.m_workflow.isRequired(propertyName, this.getWorkflowStatus())) return true;
        if (!this.isNew()) return false;
        if (!this.m_workflow.isRequired(propertyName, this.getInitialWorkflowStatus())) return false;
        return true;
    }

    public boolean isPropertyHidden(String propertyName) {
        boolean ret = this.m_workflow != null ? (this.isWorkflowStatusValid() ? (this.isNew() ? !this.isPropertyRequired(propertyName) && this.m_workflow.isHidden(propertyName, this.getInitialWorkflowStatus()) : !this.isPropertyRequired(propertyName) && this.m_workflow.isHidden(propertyName, this.getWorkflowStatus())) : false) : false;
        return ret;
    }

    public boolean isPropertyDisabled(String propertyName) {
        boolean ret = this.isUserModifiable(propertyName) && !this.isReadOnly() && !this.isLockedByAnotherUser() ? (this.m_workflow != null ? (this.isWorkflowStatusValid() ? (this.isNew() ? !this.isAuthorized() || this.m_workflow.isDisabled(propertyName, this.getInitialWorkflowStatus()) : !this.isAuthorized() || this.m_workflow.isDisabled(propertyName, this.getWorkflowStatus())) : !this.getWorkflowStatusPropertyName().equalsIgnoreCase(propertyName)) : false) : true;
        return ret;
    }

    protected boolean isUserModifiable(String propertyName) {
        boolean modifiable = true;
        try {
            PropertyNames pn = this.getPropertyNames();
            modifiable = this.getType().propertyForName(propertyName).isUserModifiable() || pn.ATTACHMENT_NAMES.equalsIgnoreCase(propertyName) || pn.COMMENT.equalsIgnoreCase(propertyName) || pn.RECIPIENT_NAMES.equalsIgnoreCase(propertyName) || "ResponsibleNames".equalsIgnoreCase(propertyName);
        }
        catch (NoSuchPropertyException e) {
            modifiable = true;
        }
        return modifiable;
    }

    public boolean isAuthorized() {
        boolean ret;
        if (this.m_workflow != null) {
            if (this.isWorkflowStatusValid()) {
                if (this.getInitialWorkflowStatus() != this.m_lastStatusCheckedAuthorized) {
                    this.m_isAuthorized = this.m_workflow.isAuthorized(this, this.getInitialWorkflowStatus());
                    this.m_lastStatusCheckedAuthorized = this.getInitialWorkflowStatus();
                }
                ret = this.m_isAuthorized;
            } else {
                ret = true;
            }
        } else {
            ret = true;
        }
        return ret;
    }

    public boolean isWorkflowStatusValid() {
        boolean ret;
        if (this.m_workflow != null) {
            if (this.getInitialWorkflowStatus() != this.m_lastStatusCheckedValid) {
                this.m_isWorkflowStatusValid = WorkflowHelper.validateWorkflowStatus(this, this.getInitialWorkflowStatus(), this.m_workflow);
                this.m_lastStatusCheckedValid = this.getInitialWorkflowStatus();
            }
            ret = this.m_isWorkflowStatusValid;
        } else {
            ret = true;
        }
        return ret;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        boolean old = this.m_readOnly;
        this.m_readOnly = readOnly;
        this.m_changeSupport.firePropertyChange("readOnly", old, this.m_readOnly);
    }

    public Workflow getWorkflow() {
        return this.m_workflow;
    }

    public String getWorkflowStatusPropertyName() {
        return this.m_workflowStatusPropertyName;
    }

    public void reset() {
        this.unrememberVersion();
        this.m_item.discard();
        this.m_modifiedValues.clear();
        this.m_modifiedAttachments.clear();
        this.m_links = null;
        this.init();
        if (this.isNew()) {
            this.setDirty(false);
            this.setDirty(true);
        } else {
            this.setDirty(false);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void update() throws RequirementNotFulfilledException {
        block18: {
            if (!this.isAuthorized() || this.isReadOnly()) {
                throw new IllegalStateException("The item you have attempted to update isnot editable by you.");
            }
            if (!this.checkVersion()) {
                throw new UpdateConflictException();
            }
            if (this.m_workflow != null) {
                this.validateProperties();
            }
            try {
                if (this.m_workflow != null) {
                    p = this.getType().propertyForName(this.getWorkflowStatusPropertyName());
                    validStates = this.getAllowedValues(this.getWorkflowStatusPropertyName());
                    found = false;
                    i = 0;
                    while (i < validStates.length) {
                        if (this.getWorkflowStatus() == ((Integer)validStates[i].getPropertyValue()).intValue()) {
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    if (!found) {
                        throw new IllegalStateException("Please select a valid " + p.getDisplayName() + ".");
                    }
                }
            }
            catch (NoSuchPropertyException e) {
                // empty catch block
            }
            originalValues = new HashMap<String, Object>();
            try {
                iter = this.m_modifiedValues.keySet().iterator();
                while (iter.hasNext()) {
                    modifiedProperty = (String)iter.next();
                    originalValues.put(modifiedProperty, this.m_item.get(modifiedProperty));
                }
                if (!this.m_modifiedAttachments.isEmpty()) {
                    pn = this.getPropertyNames();
                    attachmentIDs = this.getAttachmentIDs();
                    namesArray = this.getAttachmentNames();
                    attachmentNames = "";
                    i = 0;
                    while (i < namesArray.length) {
                        attachmentNames = attachmentNames + namesArray[i] + "\n";
                        ++i;
                    }
                    this.m_item.put(pn.ATTACHMENT_COUNT, (Object)new Integer(attachmentIDs.length));
                    this.m_item.put(pn.ATTACHMENT_IDS, (Object)attachmentIDs);
                }
                iter = this.m_modifiedValues.keySet().iterator();
                while (iter.hasNext()) {
                    modifiedPropertyUpper = (String)iter.next();
                    modifiedPropertyCanonical = this.getType().propertyForName(modifiedPropertyUpper).getName();
                    this.m_item.put(modifiedPropertyCanonical, this.m_modifiedValues.get(modifiedPropertyUpper));
                }
                this.m_item.update();
                break block18;
            }
            catch (RuntimeException e) {
                iter = originalValues.keySet().iterator();
                ** while (iter.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                originalProperty = (String)iter.next();
                try {
                    this.m_item.put(originalProperty, originalValues.get(originalProperty));
                }
                catch (RuntimeException eat) {
                    // empty catch block
                }
                continue;
            }
lbl66:
            // 1 sources

            throw e;
        }
        this.unrememberVersion();
        this.rememberVersion();
        this.m_modifiedValues.clear();
        this.m_modifiedAttachments.clear();
        this.m_links = null;
        this.init();
        this.setDirty(false);
    }

    protected void validateProperties() throws RequirementNotFulfilledException {
        Property[] properties = this.getType().getProperties();
        Vector<Property> unmet = new Vector<Property>();
        int i = 0;
        while (i < properties.length) {
            String propertyName = properties[i].getName();
            if (!WorkflowHelper.validateRequired(this, propertyName)) {
                unmet.addElement(properties[i]);
            }
            ++i;
        }
        if (unmet.size() > 0) {
            Object[] tmp = new Property[unmet.size()];
            unmet.copyInto(tmp);
            throw new RequirementNotFulfilledException((Property[])tmp);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_changeSupport.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.m_changeSupport.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.m_changeSupport.removePropertyChangeListener(propertyName, l);
    }

    public boolean equals(Object o) {
        Object other;
        boolean ret = o != null ? ((other = o instanceof Item ? (Item)o : (o != null && o instanceof ItemWrapper && ((ItemWrapper)((Object)o)).m_item != null ? ((ItemWrapper)((Object)o)).m_item : null)) != null ? (other.isNew() && this.isNew() ? this.m_item == other : this.m_item.getItemID() == other.getItemID() && this.m_item.getRootObjectID() == other.getRootObjectID() && this.m_item.getDotNotation().equals(other.getDotNotation())) : false) : false;
        return ret;
    }

    protected void dynamicDefaults(String propertyName) {
        if (this.m_workflow != null) {
            Dictionary dynamicDefaults = this.m_workflow.getDynamicDefaults(this.getWorkflowStatus(), propertyName, this);
            Enumeration keys = dynamicDefaults.keys();
            while (keys.hasMoreElements()) {
                String targetPropertyName = (String)keys.nextElement();
                String targetValueString = ((String)dynamicDefaults.get(targetPropertyName)).trim();
                this.put(targetPropertyName, WorkflowHelper.resolveStringToObject(this, targetPropertyName, targetValueString), false);
            }
        }
    }

    public int createAttachmentFromFile(String name, File source) throws IOException {
        return this.m_item.createAttachmentFromFile(name, source);
    }

    public void getAttachmentToFile(int attachmentID, File file) throws IOException {
        this.m_item.getAttachmentToFile(attachmentID, file);
    }

    public String[] getAttachmentNames() {
        ArrayList<String> list = new ArrayList<String>();
        String[] original = this.m_item.getAttachmentNames();
        int i = 0;
        while (i < original.length) {
            list.add(original[i]);
            ++i;
        }
        Iterator iter = this.m_modifiedAttachments.iterator();
        while (iter.hasNext()) {
            Attachment attachment = (Attachment)iter.next();
            if (attachment.m_delete) {
                list.remove(attachment.m_attachmentName);
                continue;
            }
            list.add(attachment.m_attachmentName);
        }
        this.rememberVersion();
        return list.toArray(new String[list.size()]);
    }

    public int[] getAttachmentIDs() {
        PropertyNames pn = this.getPropertyNames();
        ArrayList<Integer> list = new ArrayList<Integer>();
        int[] original = (int[])this.m_item.get(pn.ATTACHMENT_IDS.toUpperCase());
        int i = 0;
        while (i < original.length) {
            list.add(new Integer(original[i]));
            ++i;
        }
        Iterator iter = this.m_modifiedAttachments.iterator();
        while (iter.hasNext()) {
            Attachment attachment = (Attachment)iter.next();
            if (attachment.m_delete) {
                list.remove(new Integer(attachment.m_attachmentID));
                continue;
            }
            list.add(new Integer(attachment.m_attachmentID));
        }
        this.rememberVersion();
        int[] ids = new int[list.size()];
        int i2 = 0;
        Iterator iter2 = list.iterator();
        while (iter2.hasNext()) {
            Integer id = (Integer)iter2.next();
            ids[i2] = id;
            ++i2;
        }
        return ids;
    }

    public void addAttachment(String name, int attachmentID) {
        if (!this.isAuthorized() || this.isReadOnly() || this.isLockedByAnotherUser()) {
            throw new IllegalStateException("The item you have attempted to edit is not editable by you.");
        }
        PropertyNames names = this.getPropertyNames();
        this.m_modifiedAttachments.add(new Attachment(name, attachmentID, false));
        String[] newNames = this.getAttachmentNames();
        Property property = this.getType().propertyForName(names.ATTACHMENT_NAMES);
        String[] oldValue = this.m_item.getAttachmentNames();
        if (!this.hasPropertyChanged(property, oldValue, newNames)) {
            this.m_modifiedAttachments.clear();
        }
        this.setDirty(this.anythingChanged());
    }

    public void removeAttachment(int attachmentID) {
        if (!this.isAuthorized() || this.isReadOnly() || this.isLockedByAnotherUser()) {
            throw new IllegalStateException("The item you have attempted to edit is not editable by you.");
        }
        PropertyNames names = this.getPropertyNames();
        String name = null;
        Iterator iter = this.m_modifiedAttachments.iterator();
        while (iter.hasNext()) {
            Attachment att = (Attachment)iter.next();
            if (att.m_attachmentID != attachmentID) continue;
            name = att.m_attachmentName;
            break;
        }
        if (name == null) {
            int[] ids = this.m_item.getAttachmentIDs();
            int index = -1;
            int i = 0;
            while (i < ids.length) {
                if (ids[i] == attachmentID) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index != -1) {
                name = this.m_item.getAttachmentNames()[index];
            }
        }
        if (name != null) {
            this.m_modifiedAttachments.add(new Attachment(name, attachmentID, true));
            String[] newNames = this.getAttachmentNames();
            Property property = this.getType().propertyForName(names.ATTACHMENT_NAMES);
            String[] oldValue = this.m_item.getAttachmentNames();
            if (!this.hasPropertyChanged(property, oldValue, newNames)) {
                this.m_modifiedAttachments.clear();
            }
            this.setDirty(this.anythingChanged());
        }
    }

    public Link[] getLinks() {
        if (this.m_links == null) {
            this.m_links = this.getType().getServer().findLinks(this.m_item);
        }
        return this.m_links;
    }

    public Link linkItem(Item item, boolean pinItems) {
        this.rememberVersion();
        Link ret = new Link(this.m_item, item);
        Link[] old = this.getLinks();
        if (pinItems) {
            ret.pinParent(this.m_item);
            ret.pinChild(item);
        }
        ret.update();
        this.m_changeSupport.firePropertyChange("Links", old, this.getLinks());
        return ret;
    }

    public void modifyReadStatusForUser(boolean readStatus) {
        this.rememberVersion();
        this.m_item.modifyReadStatusForUser(readStatus);
    }

    public boolean isBranchable() {
        return this.m_item.isBranchable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getLocker() {
        int locker = -1;
        short revLevel = this.getView().getServer().getRevisionLevel();
        if (revLevel < 81) return -1;
        try {
            Method getLocker = this.m_item.getClass().getMethod("getLocker", new Class[0]);
            Object val = getLocker.invoke((Object)this.m_item, new Object[0]);
            if (val == null) return locker;
            if (!(val instanceof Integer)) return locker;
            return (Integer)val;
        }
        catch (IllegalAccessException e) {
            throw new NestedException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t == null) throw new NestedException(e);
            if (t instanceof ServerException) {
                throw (ServerException)t;
            }
            if (!t.getClass().getName().equals("com.starbase.starteam.SDKRuntimeException")) return locker;
            throw (RuntimeException)t;
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Item locking is not supported by the version of the StarTeam SDK you are currently using.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMyLock() {
        int myLock = 0;
        short revLevel = this.getView().getServer().getRevisionLevel();
        if (revLevel < 81) return 0;
        try {
            Method getMyLock = this.m_item.getClass().getMethod("getMyLock", new Class[0]);
            Object val = getMyLock.invoke((Object)this.m_item, new Object[0]);
            if (val == null) return myLock;
            if (!(val instanceof Integer)) return myLock;
            return (Integer)val;
        }
        catch (IllegalAccessException e) {
            throw new NestedException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t == null) throw new NestedException(e);
            if (t instanceof ServerException) {
                throw (ServerException)t;
            }
            if (!t.getClass().getName().equals("com.starbase.starteam.SDKRuntimeException")) return myLock;
            throw (RuntimeException)t;
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Item locking is not supported by the version of the StarTeam SDK you are currently using.");
        }
    }

    public boolean isMyExclusiveLock() {
        int locker = this.getLocker();
        return locker == this.m_item.getServer().getSession().getUserID();
    }

    public boolean isLockedByAnotherUser() {
        int locker = this.getLocker();
        return locker != this.m_item.getServer().getSession().getUserID() && locker != -1;
    }

    public void lock() {
        this.putLock(1, false);
    }

    public void putLock(int lockType, boolean breakLock) throws UnsupportedOperationException, ServerException {
        int oldLocker = this.getLocker();
        try {
            Method putLock = this.m_item.getClass().getMethod("putLock", Integer.TYPE, Boolean.TYPE);
            putLock.invoke((Object)this.m_item, new Integer(lockType), new Boolean(breakLock));
        }
        catch (IllegalAccessException e) {
            throw new NestedException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t != null) {
                if (t instanceof ServerException) {
                    throw (ServerException)t;
                }
                if (t.getClass().getName().equals("com.starbase.starteam.SDKRuntimeException")) {
                    throw (RuntimeException)t;
                }
            }
            throw new NestedException(e);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Item locking is not supported by the version of the StarTeam SDK you are currently using.");
        }
        int newLocker = this.getLocker();
        this.m_changeSupport.firePropertyChange("locker", oldLocker, newLocker);
    }

    public void unlock() {
        this.putLock(0, false);
    }

    protected void rememberVersion() {
        PropertyNames pn = this.getType().getServer().getPropertyNames();
        if (this.m_objectID == null) {
            this.m_objectID = this.m_item.get(pn.OBJECT_ID);
            this.m_rootObjectID = this.m_item.isBranchable() ? this.m_item.get(pn.ROOT_OBJECT_ID) : null;
            this.m_revisionNumber = this.m_item.get(pn.REVISION_NUMBER);
        }
    }

    protected void unrememberVersion() {
        this.m_objectID = null;
        this.m_rootObjectID = null;
        this.m_revisionNumber = null;
    }

    protected boolean checkVersion() {
        PropertyNames pn = this.getType().getServer().getPropertyNames();
        return this.m_item.get(pn.OBJECT_ID).equals(this.m_objectID) && (!this.m_item.isBranchable() || this.m_item.get(pn.ROOT_OBJECT_ID).equals(this.m_rootObjectID)) && this.m_item.get(pn.REVISION_NUMBER).equals(this.m_revisionNumber);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class Attachment {
        protected final int m_attachmentID;
        protected final String m_attachmentName;
        protected final boolean m_delete;

        protected Attachment(String name, int id, boolean delete) {
            this.m_attachmentID = id;
            this.m_attachmentName = name;
            this.m_delete = delete;
        }
    }

    protected class Semaphore {
        private boolean wait = false;

        protected Semaphore() {
        }

        public synchronized void waitOnCompletion() {
            this.wait = true;
        }

        public synchronized void completed() {
            if (this.wait) {
                this.wait = false;
                this.notifyAll();
            }
        }

        public synchronized void acquire() throws InterruptedException {
            while (this.wait) {
                this.wait(30000L);
            }
        }
    }
}

