/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.starflow;

import com.starbase.starteam.Item;
import com.starbase.starteam.NoSuchPropertyException;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerException;
import com.starbase.starteam.deployer.GraphicalErrorHandler;
import com.starbase.starteam.gui.basic.CannotEditItemException;
import com.starbase.starteam.gui.basic.ErrorHandler;
import com.starbase.starteam.gui.basic.ItemEditor;
import com.starbase.starteam.starflow.ItemWrapper;
import com.starbase.starteam.starflow.RequirementNotFulfilledException;
import com.starbase.starteam.starflow.Unwrapper;
import com.starbase.starteam.starflow.Workflow;
import com.starbase.starteam.starflow.locator.Locator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ItemEditorAdapter
implements ItemEditor {
    protected ItemWrapper m_item;
    protected final JComponent m_component = new JPanel(new BorderLayout());
    protected ErrorHandler m_errorHandler = new ErrorHandler(){
        final GraphicalErrorHandler m_delegate = new GraphicalErrorHandler();

        public Object handleErrors(Component parent, String title, String message, Throwable error, Object source, Object[] options, int defaultSelectionIndex, int closeOperationIndex) {
            return this.m_delegate.handleErrors(parent, title, message, error, source, options, defaultSelectionIndex, closeOperationIndex);
        }
    };
    protected Object m_launcher;
    protected Locator m_locator;
    protected boolean m_readOnly;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Container;
    static /* synthetic */ Class class$com$starbase$starteam$Item;
    static /* synthetic */ Class class$com$starbase$starteam$starflow$Workflow;
    static /* synthetic */ Class class$com$starbase$starteam$starflow$ItemWrapper;

    public void setLegacyLauncherClass(Class launcherClass) {
        block4: {
            try {
                this.m_launcher = launcherClass.newInstance();
                Component component = ItemEditorAdapter.extractForm(launcherClass);
                if (component == null) {
                    this.m_component.add(new JLabel("Alternate Property Editor could not be adapted"));
                    break block4;
                }
                this.m_component.add(component);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {}
        }
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
        if (this.m_item != null) {
            this.m_item.setReadOnly(readOnly);
        }
    }

    public Item getItem() {
        return Unwrapper.unwrap(this.m_item);
    }

    public void setItem(Item item) throws CannotEditItemException {
        ItemWrapper old = this.m_item;
        if (item != null) {
            try {
                Locator locator = this.getLocator(item.getServer());
                String typeName = this.getFriendlyTypeName();
                Workflow workflow = locator.getWorkflow(item.getView().getProject().getName(), item.getView().getName(), typeName == null ? item.getType().getName() : typeName);
                this.m_item = this.createItemWrapper(item, workflow, this.getWorkflowStatusPropertyName());
            }
            catch (IOException e) {
                new GraphicalErrorHandler().handleErrors(this.m_component, "StarTeam", null, e, this, null, 0, 0);
                throw new CannotEditItemException(item);
            }
        } else {
            this.m_item = null;
        }
        if (this.m_item != null) {
            this.m_item.setReadOnly(this.m_readOnly);
        }
        try {
            this.propogatingPanelPropertyChange(new PropertyChangeEvent(this, "currentItem", (Object)old, (Object)this.m_item));
        }
        catch (NoSuchPropertyException e) {
            new GraphicalErrorHandler().handleErrors(this.m_component, "StarTeam", "" + e.getMessage() + "  This is commonly caused by using a workflow that specifies a non-existent property as its Workflow Status Property.  Run the Workflow Designer to correct the problem.", e, this, null, 0, 0);
            throw new CannotEditItemException(item);
        }
    }

    public JComponent getComponent() {
        return this.m_component;
    }

    public boolean apply() {
        boolean ret = true;
        if (this.m_item != null) {
            try {
                if (!this.m_item.isReadOnly() && this.m_item.isDirty()) {
                    this.m_item.update();
                }
            }
            catch (RequirementNotFulfilledException e) {
                JOptionPane.showMessageDialog(this.m_component, e.getMessage(), "Field values required", 2);
                ret = false;
            }
            catch (IllegalStateException e) {
                this.m_errorHandler.handleErrors((Component)this.m_component, "Illegal State", null, (Throwable)e, (Object)this, null, 0, 0);
                ret = false;
            }
            catch (ServerException e) {
                if (e.getErrorCode() == 5) {
                    String msg = e.getMessage() + "  Your modifications have been left intact, " + "but you won't be able to save this item " + "without resetting first.";
                    JOptionPane.showMessageDialog(this.m_component, msg, "Update Conflict", 2);
                    ret = false;
                }
                if (e.getErrorCode() == 6) {
                    JOptionPane.showMessageDialog(this.m_component, e.getMessage(), "Access Denied", 2);
                    ret = false;
                }
                throw e;
            }
        }
        return ret;
    }

    public void reset() {
        if (this.m_item != null) {
            this.m_item.reset();
        }
    }

    public boolean isDirty() {
        boolean dirty = false;
        if (this.m_item != null) {
            dirty = this.m_item.isDirty();
        }
        return dirty;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.m_item != null) {
            this.m_item.addPropertyChangeListener(listener);
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.m_item != null) {
            this.m_item.addPropertyChangeListener(propertyName, listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.m_item != null) {
            this.m_item.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.m_item != null) {
            this.m_item.removePropertyChangeListener(propertyName, listener);
        }
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.m_errorHandler = handler;
    }

    protected void propogatingPanelPropertyChange(PropertyChangeEvent ev) {
        block4: {
            Component panel = ItemEditorAdapter.findComponent(this.m_component, "com.starbase.starteam.starflow.guicomponents.PropogatingPanel");
            if (panel == null) break block4;
            try {
                Method method = panel.getClass().getMethod("propertyChange", ev.getClass());
                method.invoke((Object)panel, ev);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {}
        }
    }

    protected Locator getLocator(Server server) {
        if (this.m_locator == null || !this.m_locator.getServer().equals((Object)server)) {
            this.m_locator = new Locator(server);
        }
        return this.m_locator;
    }

    protected String getFriendlyTypeName() {
        String name = null;
        try {
            Method method = ItemEditorAdapter.findGetFriendlyTypeNameMethod(this.m_launcher.getClass());
            if (method != null) {
                name = (String)method.invoke(this.m_launcher, new Object[0]);
            }
        }
        catch (IllegalAccessException e) {
            name = null;
        }
        catch (InvocationTargetException e) {
            name = null;
        }
        return name;
    }

    protected String getWorkflowStatusPropertyName() {
        String name = null;
        try {
            Method method = ItemEditorAdapter.findGetWorkflowStatusPropertyNameMethod(this.m_launcher.getClass());
            if (method != null) {
                name = (String)method.invoke(this.m_launcher, new Object[0]);
            }
        }
        catch (IllegalAccessException e) {
            name = null;
        }
        catch (InvocationTargetException e) {
            name = null;
        }
        return name;
    }

    protected ItemWrapper createItemWrapper(Item item, Workflow workflow, String workflowStatusPropertyName) {
        ItemWrapper wrapper = null;
        try {
            Method method = ItemEditorAdapter.findCreateItemWrapperMethod(this.m_launcher.getClass());
            if (method != null) {
                wrapper = (ItemWrapper)((Object)method.invoke(this.m_launcher, item, workflow, workflowStatusPropertyName));
            }
        }
        catch (IllegalAccessException e) {
            wrapper = null;
        }
        catch (InvocationTargetException e) {
            wrapper = null;
        }
        return wrapper;
    }

    protected static Component extractForm(Class launcherClass) {
        Component component = null;
        try {
            Container form;
            Constructor<?> constructor;
            Method method = ItemEditorAdapter.findCreateFormMethod(launcherClass);
            if (method != null && (constructor = method.getReturnType().getConstructor(new Class[0])) != null && Modifier.isPublic(constructor.getModifiers()) && (component = ItemEditorAdapter.findComponent(form = (Container)constructor.newInstance(new Object[0]), "com.starbase.starteam.starflow.guicomponents.PropogatingPanel")) != null) {
                ItemEditorAdapter.disableButtons(component);
            }
        }
        catch (NoSuchMethodException e) {
            component = null;
        }
        catch (InstantiationException e) {
            component = null;
        }
        catch (IllegalAccessException e) {
            component = null;
        }
        catch (InvocationTargetException e) {
            component = null;
        }
        return component;
    }

    protected static Method findGetFriendlyTypeNameMethod(Class c) {
        Method method = null;
        while (method == null && c != null) {
            try {
                method = c.getDeclaredMethod("getFriendlyTypeName", new Class[0]);
                if ((class$java$lang$String == null ? (class$java$lang$String = ItemEditorAdapter.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(method.getReturnType())) break;
                method = null;
                break;
            }
            catch (NoSuchMethodException e) {
                method = null;
                c = c.getSuperclass();
            }
        }
        return method;
    }

    protected static Method findGetWorkflowStatusPropertyNameMethod(Class c) {
        Method method = null;
        while (method == null && c != null) {
            try {
                method = c.getDeclaredMethod("getWorkflowStatusPropertyName", new Class[0]);
                if ((class$java$lang$String == null ? (class$java$lang$String = ItemEditorAdapter.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(method.getReturnType())) break;
                method = null;
                break;
            }
            catch (NoSuchMethodException e) {
                method = null;
                c = c.getSuperclass();
            }
        }
        return method;
    }

    protected static Method findCreateFormMethod(Class c) {
        Method method = null;
        while (method == null && c != null) {
            try {
                method = c.getDeclaredMethod("createForm", new Class[0]);
                if ((class$java$awt$Container == null ? (class$java$awt$Container = ItemEditorAdapter.class$("java.awt.Container")) : class$java$awt$Container).isAssignableFrom(method.getReturnType())) break;
                method = null;
                break;
            }
            catch (NoSuchMethodException e) {
                method = null;
                c = c.getSuperclass();
            }
        }
        return method;
    }

    protected static Method findCreateItemWrapperMethod(Class c) {
        Method method = null;
        while (method == null && c != null) {
            try {
                method = c.getDeclaredMethod("createItemWrapper", class$com$starbase$starteam$Item == null ? (class$com$starbase$starteam$Item = ItemEditorAdapter.class$("com.starbase.starteam.Item")) : class$com$starbase$starteam$Item, class$com$starbase$starteam$starflow$Workflow == null ? (class$com$starbase$starteam$starflow$Workflow = ItemEditorAdapter.class$("com.starbase.starteam.starflow.Workflow")) : class$com$starbase$starteam$starflow$Workflow, class$java$lang$String == null ? (class$java$lang$String = ItemEditorAdapter.class$("java.lang.String")) : class$java$lang$String);
                if ((class$com$starbase$starteam$starflow$ItemWrapper == null ? (class$com$starbase$starteam$starflow$ItemWrapper = ItemEditorAdapter.class$("com.starbase.starteam.starflow.ItemWrapper")) : class$com$starbase$starteam$starflow$ItemWrapper).isAssignableFrom(method.getReturnType())) break;
                method = null;
                break;
            }
            catch (NoSuchMethodException e) {
                method = null;
                c = c.getSuperclass();
            }
        }
        return method;
    }

    protected static Component findComponent(Container container, String className) {
        Component found = null;
        Component[] children = container.getComponents();
        int i = 0;
        while (i < children.length) {
            if (ItemEditorAdapter.isInstance(className, children[i])) {
                found = children[i];
            } else if (children[i] instanceof Container) {
                found = ItemEditorAdapter.findComponent((Container)children[i], className);
            }
            if (found != null) break;
            ++i;
        }
        return found;
    }

    protected static boolean isInstance(String className, Object instance) {
        return instance.getClass().getName().equals(className);
    }

    protected static void disableButtons(Component component) {
        if (component instanceof Container) {
            Component testButton;
            Component navigator = ItemEditorAdapter.findComponent((Container)component, "com.starbase.starteam.starflow.guicomponents.Navigator");
            if (navigator != null) {
                navigator.setVisible(false);
                navigator.setEnabled(false);
            }
            if ((testButton = ItemEditorAdapter.findComponent((Container)component, "com.starbase.starteam.starflow.guicomponents.TestButton")) != null) {
                testButton.setVisible(false);
                testButton.setEnabled(false);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

