/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.starflow;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.GroupAccount;
import com.starbase.starteam.Item;
import com.starbase.starteam.Project;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerAdministration;
import com.starbase.starteam.StarTeamFinder;
import com.starbase.starteam.StarTeamURL;
import com.starbase.starteam.UserAccount;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GroupConverter {
    private static final boolean DEBUG_ON = false;

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("usage: GroupConverter user:password@host:port");
            System.exit(0);
        }
        StarTeamURL url = new StarTeamURL(args[0]);
        Server server = StarTeamFinder.openServer((String)(url.getUserName() + ":" + url.getPassword() + "@" + url.getHostName() + ":" + Integer.parseInt(url.getPort()) + "/" + "StarFlow Extensions"));
        ServerAdministration sa = server.getAdministration();
        GroupAccount[] groups = sa.getGroupAccounts();
        GroupAccount rootGroup = null;
        int i = 0;
        while (i < groups.length) {
            if (groups[i].getParent() == null) {
                rootGroup = groups[i];
                break;
            }
            ++i;
        }
        if (rootGroup == null) {
            throw new RuntimeException("Could not find top-level user group");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = doc.createElement("groups");
        doc.appendChild((Node)root);
        root.appendChild(GroupConverter.buildXML(rootGroup, (Document)doc));
        Project project = StarTeamFinder.openProject((String)(url.getUserName() + ":" + url.getPassword() + "@" + url.getHostName() + ":" + Integer.parseInt(url.getPort()) + "/" + "StarFlow Extensions"));
        if (project == null) {
            System.out.println("Server at " + url.getHostName() + ":" + url.getPort() + " does not have a " + "StarFlow Extensions" + " project.  Please create one before proceeding");
            System.exit(1);
        }
        OutputFormat format = new OutputFormat((Document)doc, "UTF-8", true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLSerializer serializer = new XMLSerializer((OutputStream)out, format);
        serializer.asDOMSerializer();
        serializer.serialize(doc.getDocumentElement());
        Folder folder = StarTeamFinder.findFolder((Folder)project.getDefaultView().getRootFolder(), (String)"Projects");
        Item[] files = folder.getItems(folder.getServer().getTypeNames().FILE);
        File existingVersion = null;
        int i2 = 0;
        while (i2 < files.length) {
            if (((File)files[i2]).getName().equals("groups.xml")) {
                existingVersion = (File)files[i2];
            }
            ++i2;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        if (existingVersion != null) {
            existingVersion.checkinFromStream((InputStream)in, "Newer version", 3, true);
        } else {
            File f = new File(folder);
            f.addFromStream((InputStream)in, "groups.xml", "Groups description", "", 3, true);
        }
    }

    private static Element buildXML(GroupAccount group, Document doc) {
        Element ret = doc.createElement("group");
        ret.setAttribute("name", group.getName().trim());
        ret.setAttribute("gid", String.valueOf(group.getID()));
        GroupAccount[] children = group.getSubGroupAccounts();
        int i = 0;
        while (i < children.length) {
            ret.appendChild(GroupConverter.buildXML(children[i], doc));
            ++i;
        }
        UserAccount[] users = group.getUserAccounts();
        int i2 = 0;
        while (i2 < users.length) {
            Element user = doc.createElement("user");
            user.setAttribute("name", users[i2].getName());
            user.setAttribute("uid", String.valueOf(users[i2].getID()));
            ret.appendChild(user);
            ++i2;
        }
        return ret;
    }
}

