/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.starflow;

import com.starbase.starteam.Catalog;
import com.starbase.starteam.Label;
import com.starbase.starteam.Property;
import com.starbase.starteam.Type;
import com.starbase.starteam.User;
import com.starbase.starteam.starflow.CompoundValue;
import com.starbase.starteam.starflow.ItemWrapper;
import com.starbase.starteam.starflow.PossibleValueProducer;
import com.starbase.util.collections.Iterator;
import com.starbase.util.collections.Set;
import java.util.Vector;

public class DefaultPossibleValueProducer
implements PossibleValueProducer {
    protected ItemWrapper m_item;
    protected String m_propertyName;

    public void setItem(ItemWrapper item, String propertyName) {
        this.m_item = item;
        this.m_propertyName = propertyName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompoundValue[] getPossibleValues() {
        Type t = this.m_item.getType();
        Property p = t.propertyForName(this.m_propertyName);
        int labelClassID = t.getServer().typeForName(t.getServer().getTypeNames().LABEL).getClassID();
        int userClassID = t.getServer().typeForName(t.getServer().getTypeNames().USER).getClassID();
        if (this.m_item == null) return null;
        if (this.m_propertyName == null) return null;
        if (p.getTypeCode() == 4 && p.getClassIDOfValue() == labelClassID) {
            return this.getPossibleLabels();
        }
        if (p.getTypeCode() == 3) return this.getPossibleUsers();
        if (p.getTypeCode() == 4 && p.getClassIDOfValue() == userClassID) {
            return this.getPossibleUsers();
        }
        if (p.getTypeCode() == 4) {
            return this.getPossibleObjects();
        }
        if (p.getTypeCode() != 2) throw new RuntimeException("Property type (" + p.getTypeCode() + ") not supported by " + this.getClass().getName() + ".");
        return this.getPossibleEnums();
    }

    protected CompoundValue[] getPossibleLabels() {
        Type t = this.m_item.getType();
        Property p = t.propertyForName(this.m_propertyName);
        int propertyValue = (Integer)this.m_item.get(this.m_propertyName);
        boolean foundValueInList = false;
        Vector<Label> v = new Vector<Label>();
        Label[] labels = this.m_item.getLabels();
        int i = 0;
        while (i < labels.length) {
            if (!labels[i].isDeleted() && !labels[i].isRevisionLabel() && labels[i].isBuildLabel() && labels[i].getID() != -1) {
                block8: {
                    int k = 0;
                    while (k < v.size()) {
                        if (labels[i].getTime().getDoubleValue() > ((Label)v.elementAt(k)).getTime().getDoubleValue()) {
                            v.insertElementAt(labels[i], k);
                            break block8;
                        }
                        ++k;
                    }
                    v.addElement(labels[i]);
                }
                if (propertyValue == labels[i].getID()) {
                    foundValueInList = true;
                }
            }
            ++i;
        }
        Vector<CompoundValue> compoundValues = new Vector<CompoundValue>();
        compoundValues.addElement(new CompoundValue("", new Integer(-1)));
        if (!foundValueInList && propertyValue != -1 && propertyValue != -2) {
            Catalog cat = t.getServer().typeForClassID(p.getClassIDOfValue()).getCatalog();
            Object descriptor = cat.getPrimaryDescriptor(propertyValue);
            compoundValues.addElement(new CompoundValue(descriptor.toString(), new Integer(propertyValue)));
        }
        int i2 = 0;
        while (i2 < v.size()) {
            Label l = (Label)v.elementAt(i2);
            compoundValues.addElement(new CompoundValue(l.getName(), new Integer(l.getID())));
            ++i2;
        }
        if (this.m_item.getTypeNames().CHANGEREQUEST.equals(this.m_item.getType().getName()) && p.getName().equals(this.m_item.getPropertyNames().CR_ADDRESSED_IN)) {
            compoundValues.addElement(new CompoundValue("Next Build", new Integer(-2)));
        }
        Object[] ret = new CompoundValue[compoundValues.size()];
        compoundValues.copyInto(ret);
        return ret;
    }

    protected CompoundValue[] getPossibleUsers() {
        int propertyValue = (Integer)this.m_item.get(this.m_propertyName);
        Vector<CompoundValue> v = new Vector<CompoundValue>();
        User[] users = this.m_item.getUsers();
        if (propertyValue == -1) {
            v.addElement(new CompoundValue("", new Integer(propertyValue)));
        }
        int i = 0;
        while (i < users.length) {
            if (!users[i].isDeleted()) {
                v.addElement(new CompoundValue(users[i].getName(), new Integer(users[i].getID())));
            } else if (propertyValue == users[i].getID()) {
                v.addElement(new CompoundValue(users[i].getName(), new Integer(users[i].getID())));
            }
            ++i;
        }
        Object[] ret = new CompoundValue[v.size()];
        v.copyInto(ret);
        return ret;
    }

    protected CompoundValue[] getPossibleEnums() {
        Property p = this.m_item.getType().propertyForName(this.m_propertyName);
        int propertyValue = (Integer)this.m_item.get(this.m_propertyName);
        Vector<CompoundValue> v = new Vector<CompoundValue>();
        int[] codes = p.getEnumValues();
        if (propertyValue == -1) {
            v.addElement(new CompoundValue("", new Integer(propertyValue)));
        }
        int i = 0;
        while (i < codes.length) {
            if (!p.getEnumDisabled(codes[i])) {
                v.addElement(new CompoundValue(p.getEnumDisplayName(codes[i]), new Integer(codes[i])));
            } else if (propertyValue == codes[i]) {
                v.addElement(new CompoundValue(p.getEnumDisplayName(codes[i]), new Integer(codes[i])));
            }
            ++i;
        }
        Object[] ret = new CompoundValue[v.size()];
        v.copyInto(ret);
        return ret;
    }

    protected CompoundValue[] getPossibleObjects() {
        CompoundValue[] ret;
        Property p = this.m_item.getType().propertyForName(this.m_propertyName);
        int propertyValue = (Integer)this.m_item.get(this.m_propertyName);
        Catalog cat = this.m_item.getType().getServer().typeForClassID(p.getClassIDOfValue()).getCatalog();
        Set ids = cat.getIDs();
        Iterator iter = ids.iterator();
        int pos = 0;
        if (propertyValue == -1) {
            ret = new CompoundValue[ids.size() + 1];
            ret[0] = new CompoundValue("", new Integer(propertyValue));
            ++pos;
        } else {
            ret = new CompoundValue[ids.size()];
        }
        while (iter.hasNext()) {
            Integer id = (Integer)iter.next();
            Object descriptor = cat.getPrimaryDescriptor(id.intValue());
            ret[pos] = new CompoundValue(descriptor.toString(), id);
            ++pos;
        }
        return ret;
    }
}

