/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.shell;

import com.starbase.starteam.shell.Option;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Date;

public class TimeOption
extends Option {
    private Date m_Value = null;
    private final int[] m_styles = new int[]{3, 2, 1, 0};

    public TimeOption(String sOpName, boolean required) {
        super(sOpName, required);
    }

    public TimeOption(String sOpName, boolean required, Object group) {
        super(sOpName, required, group);
    }

    public TimeOption(String sOpName, int min, int max, Object group) {
        super(sOpName, min, max, group);
    }

    public Date getDateValue() {
        return this.m_Value;
    }

    String getUsageDescription() {
        StringBuffer buff = new StringBuffer();
        String eol = System.getProperty("line.separator");
        Date now = new Date();
        buff.append("Valid Date and Time Formats:" + eol);
        int i = 0;
        while (i < this.m_styles.length) {
            DateFormat format = DateFormat.getDateTimeInstance(this.m_styles[i], this.m_styles[i]);
            buff.append("        \"" + format.format(now) + "\"" + eol);
            ++i;
        }
        return buff.toString();
    }

    public Object getPropertyValue(String prop) {
        Date d = null;
        ParsePosition pos = new ParsePosition(0);
        int i = 0;
        while (i < this.m_styles.length && d == null) {
            int j = 0;
            while (j < this.m_styles.length && d == null) {
                pos.setIndex(0);
                try {
                    DateFormat format = DateFormat.getDateTimeInstance(this.m_styles[i], this.m_styles[j]);
                    d = format.parse(prop, pos);
                }
                catch (Throwable e) {
                    d = null;
                }
                ++j;
            }
            ++i;
        }
        return d;
    }
}

