/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.shell;

import com.starbase.starteam.shell.Option;
import com.starbase.starteam.shell.ParseException;
import com.starbase.util.Platform;
import java.util.Enumeration;
import java.util.Vector;

public class CommandLineSpec {
    private String m_sErrorMsg = null;
    private Vector m_Parameters = new Vector();
    private Vector m_OptionList = new Vector();
    private boolean m_bAllowParams = true;
    private boolean m_bRequireParams = true;
    private Vector m_options = new Vector();
    private Vector m_values = new Vector();
    private Vector m_uniqueOptions = new Vector();

    Enumeration getUniqueOptions() {
        return this.m_uniqueOptions.elements();
    }

    public Vector getOptionValues(Option option) {
        Vector v = new Vector();
        Enumeration oenum = this.m_options.elements();
        Enumeration venum = this.m_values.elements();
        while (oenum.hasMoreElements()) {
            Option opt = (Option)oenum.nextElement();
            Object val = venum.nextElement();
            if (!opt.equals(option)) continue;
            v.addElement(val);
        }
        return v;
    }

    Vector getOptionValues(Vector options) {
        Vector v = new Vector();
        Enumeration oenum = this.m_options.elements();
        Enumeration venum = this.m_values.elements();
        while (oenum.hasMoreElements()) {
            Option opt = (Option)oenum.nextElement();
            Object val = venum.nextElement();
            if (!options.contains(opt)) continue;
            v.addElement(val);
        }
        return v;
    }

    private void addOptionValue(Option option, Object value) {
        if (!this.m_uniqueOptions.contains(option)) {
            this.m_uniqueOptions.addElement(option);
        }
        this.m_options.addElement(option);
        this.m_values.addElement(value);
    }

    private void clearOptions() {
        this.m_options.removeAllElements();
        this.m_values.removeAllElements();
        this.m_uniqueOptions.removeAllElements();
    }

    public CommandLineSpec(boolean bAllowParams, boolean bRequireParams) {
        this.m_bAllowParams = bAllowParams;
        this.m_bRequireParams = bRequireParams;
    }

    public final void addOption(Option aOpt) {
        this.m_OptionList.addElement(aOpt);
    }

    public final void removeOption(String keyName) {
        Option opt = this.findPossibleOption(Option.getName(keyName));
        this.m_OptionList.removeElement(opt);
    }

    public final Option findSpecifiedOption(String name) {
        Enumeration e = this.getUniqueOptions();
        Option opt = null;
        while (e.hasMoreElements()) {
            Option tmp = (Option)e.nextElement();
            if (!tmp.matches(name)) continue;
            opt = tmp;
            break;
        }
        return opt;
    }

    public final String[] getParameters() {
        int len = this.m_Parameters.size();
        String[] result = new String[len];
        int i = 0;
        while (i < len) {
            result[i] = (String)this.m_Parameters.elementAt(i);
            ++i;
        }
        return result;
    }

    public final String errorMessage() {
        return this.m_sErrorMsg;
    }

    void setErrorMsg(String msg) {
        this.m_sErrorMsg = msg;
    }

    public final String getOptions() {
        StringBuffer buff = new StringBuffer();
        Enumeration enumeration = this.m_OptionList.elements();
        while (enumeration.hasMoreElements()) {
            Option opt = (Option)enumeration.nextElement();
            if (opt.getHidden()) continue;
            buff.append("    " + opt.usage() + Platform.getEOL());
        }
        return buff.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean parse(String[] sCommandLine) {
        this.resetParse();
        int argc = sCommandLine.length;
        int pos = 0;
        String sOption = null;
        String sOpName = null;
        String sProp = null;
        try {
            while (argc > 0 && this.isOption(sCommandLine[pos])) {
                sOption = sCommandLine[pos];
                sOpName = sOption.substring(1);
                Option opt = this.findPossibleOption(sOpName);
                if (opt == null) {
                    throw new ParseException(Option.OPTION_UNKNOWN + sOption);
                }
                if (opt.hasProperty()) {
                    if (--argc == 0) throw new ParseException(Option.OPTION_NEEDSARG + opt.usage());
                    if (this.isOption(sProp = sCommandLine[++pos])) throw new ParseException(Option.OPTION_NEEDSARG + opt.usage());
                    Object propval = opt.getPropertyValue(sProp);
                    if (propval == null) throw new ParseException(Option.OPTION_INVALID + sProp + " [" + opt.usage() + "]");
                    this.saveOption(opt, propval);
                } else {
                    this.saveOption(opt, null);
                }
                ++pos;
                --argc;
            }
            if (argc > 0) {
                while (argc > 0) {
                    if (!"-1".equals(sCommandLine[pos]) && this.hasOptionPrefix(sCommandLine[pos])) {
                        throw new ParseException(Option.OPTION_UNKNOWN + sCommandLine[pos]);
                    }
                    this.addNonOption(sCommandLine[pos]);
                    ++pos;
                    --argc;
                }
                if (!this.m_bAllowParams) {
                    throw new ParseException(Option.OPTION_NOPARAMS);
                }
            } else if (this.m_bRequireParams) {
                throw new ParseException(Option.OPTION_NEEDPARAMS);
            }
            this.anyMissing();
            return true;
        }
        catch (ParseException e) {
            this.m_sErrorMsg = e.getMessage();
            return false;
        }
    }

    public void printOpts() {
        System.out.println("=========================================================");
        Enumeration e = this.getUniqueOptions();
        while (e.hasMoreElements()) {
            Option opt = (Option)e.nextElement();
            Vector v = this.getOptionValues(opt);
            System.out.println("OPTION: " + opt.getName());
            if (v == null) {
                System.out.println("null vector");
                continue;
            }
            int len = v.size();
            int i = 0;
            while (i < len) {
                System.out.println(i + ": " + v.elementAt(i));
                ++i;
            }
        }
        System.out.println("Parameters follow:");
        int i = 0;
        while (i < this.getParameters().length) {
            System.out.println("" + i + ": " + this.getParameters()[i]);
            ++i;
        }
        System.out.println("=========================================================");
    }

    private final void saveOption(Option opt, Object propval) {
        this.addOptionValue(opt, propval);
    }

    private final void addNonOption(String sOption) {
        this.m_Parameters.addElement(sOption);
    }

    private final void resetParse() {
        this.m_sErrorMsg = null;
        this.clearOptions();
        this.m_Parameters.removeAllElements();
    }

    public Option findPossibleOption(String sOpName) {
        Option aResult = null;
        Enumeration e = this.m_OptionList.elements();
        while (e.hasMoreElements()) {
            Object a = e.nextElement();
            Option opt = (Option)a;
            if (!opt.matches(sOpName)) continue;
            aResult = opt;
            break;
        }
        return aResult;
    }

    private final void anyMissing() throws ParseException {
        Option opt;
        Enumeration e = this.m_OptionList.elements();
        while (e.hasMoreElements()) {
            Object a = e.nextElement();
            opt = (Option)a;
            if (!opt.isRequired() || this.getOptionValues(opt).size() != 0) continue;
            throw new ParseException(Option.OPTION_REQUIRED + opt.usage());
        }
        e = this.getUniqueOptions();
        while (e.hasMoreElements()) {
            Option opt2 = (Option)e.nextElement();
            Vector v = this.getOptionValues(opt2);
            int actual = v.size();
            if (opt2.minRequired() > actual) {
                throw new ParseException(Option.OPTION_MULTI_REQUIRED + opt2.usage());
            }
            if (opt2.maxAllowed() >= actual) continue;
            throw new ParseException(Option.OPTION_TOO_MANY + opt2.usage());
        }
        Vector<Object> groups = new Vector<Object>();
        e = this.getUniqueOptions();
        while (e.hasMoreElements()) {
            opt = (Option)e.nextElement();
            Object grp = opt.getGroup();
            if (grp == null) continue;
            if (groups.contains(grp)) {
                throw new ParseException(this.makeGroupErrorMsg(grp));
            }
            groups.addElement(grp);
        }
        e = this.getUniqueOptions();
        while (e.hasMoreElements()) {
            opt = (Option)e.nextElement();
            Object grp = opt.getRequiredGroup();
            if (grp == null || groups.contains(grp)) continue;
            throw new ParseException(this.makeRequiredGroupErrorMsg(opt, grp));
        }
    }

    private String makeRequiredGroupErrorMsg(Option opt, Object grp) {
        StringBuffer buff = new StringBuffer(200);
        buff.append(opt.usage());
        buff.append(Platform.getEOL());
        buff.append(Option.OPTION_REQUIREDGROUP);
        buff.append(Platform.getEOL());
        Enumeration e = this.m_OptionList.elements();
        while (e.hasMoreElements()) {
            Option o = (Option)e.nextElement();
            if (o.getGroup() != grp) continue;
            buff.append("    ");
            buff.append(o.usage());
            buff.append(Platform.getEOL());
        }
        return buff.toString();
    }

    private String makeGroupErrorMsg(Object grp) {
        StringBuffer buff = new StringBuffer(200);
        buff.append(Option.OPTION_ONLYONE);
        buff.append(Platform.getEOL());
        Enumeration e = this.m_OptionList.elements();
        while (e.hasMoreElements()) {
            Option o = (Option)e.nextElement();
            if (o.getGroup() != grp) continue;
            buff.append("    ");
            buff.append(o.usage());
            buff.append(Platform.getEOL());
        }
        return buff.toString();
    }

    private final boolean isOption(String arg) {
        if ("-1".equals(arg)) {
            return false;
        }
        if (this.hasOptionPrefix(arg)) {
            return this.findPossibleOption(arg.substring(1)) != null;
        }
        return false;
    }

    private final boolean hasOptionPrefix(String arg) {
        if (arg.length() == 0) {
            return false;
        }
        char c = arg.charAt(0);
        return c == '-' || c == '/';
    }

    public String usage(String prefix) {
        StringBuffer buff = new StringBuffer(200);
        buff.append(prefix);
        Vector<Option> done = new Vector<Option>();
        Enumeration e = this.m_OptionList.elements();
        while (e.hasMoreElements()) {
            Option opt = (Option)e.nextElement();
            if (done.contains(opt) || opt.getHidden()) continue;
            Object grp = opt.getGroup();
            if (grp == null) {
                buff.append(" ");
                if (!opt.isRequired()) {
                    buff.append("[");
                }
                buff.append(Option.OPTION_PREFIX);
                buff.append(opt.getName());
                if (opt.getArgName() != null) {
                    buff.append(" ");
                    buff.append(opt.getArgName());
                }
                if (opt.isRequired()) continue;
                buff.append("]");
                continue;
            }
            buff.append(" [");
            boolean first = true;
            Enumeration grpenum = this.m_OptionList.elements();
            while (grpenum.hasMoreElements()) {
                Option gopt = (Option)grpenum.nextElement();
                if (gopt.getGroup() != grp || done.contains(gopt)) continue;
                if (!first) {
                    buff.append(" | ");
                }
                buff.append(Option.OPTION_PREFIX);
                buff.append(gopt.getName());
                if (gopt.getArgName() != null) {
                    buff.append(" ");
                    buff.append(gopt.getArgName());
                }
                first = false;
                done.addElement(gopt);
            }
            buff.append("]");
        }
        if (this.m_bAllowParams) {
            buff.append(" ");
            if (!this.m_bRequireParams) {
                buff.append("[");
            }
            buff.append("files...");
            if (!this.m_bRequireParams) {
                buff.append("]");
            }
        }
        return buff.toString();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        Enumeration e = this.m_OptionList.elements();
        while (e.hasMoreElements()) {
            Object a = e.nextElement();
            Option opt = (Option)a;
            buff.append("Name: " + opt.getName() + " Value: " + opt + Platform.getEOL());
        }
        return buff.toString();
    }
}

