/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.gui.extensions;

import com.starbase.starteam.Item;
import com.starbase.starteam.NoSuchPropertyException;
import com.starbase.starteam.Project;
import com.starbase.starteam.Server;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class EditorUtils {
    private EditorUtils() {
    }

    public static EditorProperties getEditorProperties(Item item) {
        boolean useAlternateEditor = false;
        String cmd = "";
        if (item != null) {
            String typeName = item.getType().getName();
            Project project = item.getView().getProject();
            boolean isLicensed = true;
            Server server = item.getServer();
            try {
                Class<?> c = server.getClass().getClassLoader().loadClass("com.starbase.starteam.ProductCodes");
                Field eliteField = c.getField("ELITE");
                Method hasProductCodeInformation = server.getClass().getMethod("hasProductCodeInformation", new Class[0]);
                Method hasProductCode = server.getClass().getMethod("hasProductCode", Integer.TYPE);
                if (((Boolean)hasProductCodeInformation.invoke((Object)server, new Object[0])).booleanValue()) {
                    isLicensed = (Boolean)hasProductCode.invoke((Object)server, eliteField.get(null));
                }
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
            if (isLicensed) {
                try {
                    if ("ChangeRequest".equals(typeName)) {
                        useAlternateEditor = project.getInt("DisplayAltCREditor") == 1;
                        cmd = project.getString("AltCREditorPath");
                    } else if ("Requirement".equals(typeName) || "CStRequirement".equals(typeName)) {
                        useAlternateEditor = project.getInt("DisplayAltReqEditor") == 1;
                        cmd = project.getString("AltReqEditorPath");
                    } else if ("Task".equals(typeName)) {
                        useAlternateEditor = project.getInt("DisplayAltTaskEditor") == 1;
                        cmd = project.getString("AltTaskEditorPath");
                    } else if ("Topic".equals(typeName)) {
                        useAlternateEditor = project.getInt("DisplayAltTopicEditor") == 1;
                        cmd = project.getString("AltTopicEditorPath");
                    } else if ("File".equals(typeName)) {
                        useAlternateEditor = project.getInt("DisplayAltFileEditor") == 1;
                        cmd = project.getString("AltFileEditorPath");
                    } else {
                        useAlternateEditor = false;
                        cmd = "";
                    }
                }
                catch (NoSuchPropertyException e) {
                    useAlternateEditor = false;
                }
            }
        }
        return new EditorProperties(useAlternateEditor, cmd);
    }

    public static class EditorProperties {
        public final boolean use;
        public final String command;
        public final String name;

        public EditorProperties(boolean use, String command) {
            this.use = use;
            this.command = command;
            StringTokenizer tok = new StringTokenizer(command);
            String key = "";
            if (tok.hasMoreTokens() && ("locator".equalsIgnoreCase(key = tok.nextToken()) || "locatordebug".equalsIgnoreCase(key))) {
                key = tok.nextToken();
            }
            this.name = key;
        }

        public String toString() {
            return "use: " + this.use + ", command: " + this.command + ", name: " + this.name;
        }
    }
}

