/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.gui.extensions;

import com.starbase.starteam.Item;
import com.starbase.starteam.deployer.Attribute;
import com.starbase.starteam.deployer.DeployerBootstrap;
import com.starbase.starteam.deployer.MisconfigurationException;
import com.starbase.starteam.deployer.ResourceLocator;
import com.starbase.starteam.deployer.ResourceLocatorFactory;
import com.starbase.starteam.deployer.SearchPathElement;
import com.starbase.starteam.editorlocator.DefaultEditorLocator;
import com.starbase.starteam.editorlocator.EditorLocator;
import com.starbase.starteam.gui.basic.CannotEditItemException;
import com.starbase.starteam.gui.basic.EditorFactory;
import com.starbase.starteam.gui.basic.EditorManager;
import com.starbase.starteam.gui.basic.ErrorHandler;
import com.starbase.starteam.gui.basic.ItemEditor;
import com.starbase.starteam.gui.extensions.EditorUtils;
import com.starbase.util.errorhandling.GraphicalErrorHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class BasicDelegatingItemEditor
implements ItemEditor {
    protected final JPanel panel = new JPanel(new BorderLayout());
    protected ItemEditor editor;
    protected final Vector listeners = new Vector();
    protected boolean readOnly = false;
    protected final ItemEditor defaultEditor;
    protected ErrorHandler m_errorHandler = new ErrorHandler(){
        final GraphicalErrorHandler m_delegate = new GraphicalErrorHandler();

        public Object handleErrors(Component parent, String title, String message, Throwable error, Object source, Object[] options, int defaultSelectionIndex, int closeOperationIndex) {
            return this.m_delegate.handleErrors(parent, title, message, error, source, options, defaultSelectionIndex, closeOperationIndex);
        }
    };

    public BasicDelegatingItemEditor() {
        EditorFactory factory = EditorManager.getDefaultEditorFactory();
        this.defaultEditor = factory != null ? factory.getEditor() : null;
    }

    public boolean isReadOnly() {
        if (this.editor != null) {
            return this.editor.isReadOnly();
        }
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        block2: {
            this.readOnly = readOnly;
            if (this.editor == null) break block2;
            try {
                this.editor.setReadOnly(readOnly);
            }
            catch (NullPointerException e) {}
        }
    }

    public Item getItem() {
        Item item;
        block2: {
            item = null;
            if (this.editor == null) break block2;
            try {
                item = this.editor.getItem();
            }
            catch (NullPointerException e) {}
        }
        return item;
    }

    public synchronized void setItem(Item item) throws CannotEditItemException {
        ItemEditor old = this.editor;
        final EditorUtils.EditorProperties props = EditorUtils.getEditorProperties(item);
        if (props.use) {
            EditorLocator locator;
            try {
                locator = this.getEditorLocator(item);
            }
            catch (MisconfigurationException e) {
                new GraphicalErrorHandler().handleErrors(this.panel, "StarTeam", null, e, this, null, 0, 0);
                throw new CannotEditItemException(item);
            }
            catch (IOException e) {
                new GraphicalErrorHandler().handleErrors(this.panel, "StarTeam", null, e, this, null, 0, 0);
                throw new CannotEditItemException(item);
            }
            Attribute attr = new Attribute(){

                public String getID() {
                    return "name";
                }

                public Object get(int index) {
                    if (index != 0) {
                        String msg = "" + index + " is not within bounds (0-0)";
                        throw new ArrayIndexOutOfBoundsException(msg);
                    }
                    return props.name + ".propertyeditor.xml";
                }

                public int size() {
                    return 1;
                }
            };
            ItemEditor newEditor = locator.getEditor(this.getClass().getClassLoader(), new Attribute[]{attr});
            if (newEditor == null) {
                throw new CannotEditItemException(item);
            }
            this.editor = newEditor;
        } else {
            this.editor = this.defaultEditor;
        }
        if (item != null && this.editor == null) {
            throw new CannotEditItemException(item);
        }
        if (this.editor != null && !this.editor.equals(old) || this.editor == null && old != null) {
            int i = 0;
            while (i < this.listeners.size()) {
                ListenerKey key = (ListenerKey)this.listeners.get(i);
                if (old != null) {
                    if (key.name != null) {
                        old.removePropertyChangeListener(key.name, key.listener);
                    } else {
                        old.removePropertyChangeListener(key.listener);
                    }
                }
                if (this.editor != null) {
                    if (key.name != null) {
                        this.editor.addPropertyChangeListener(key.name, key.listener);
                    } else {
                        this.editor.addPropertyChangeListener(key.listener);
                    }
                }
                ++i;
            }
            if (this.editor != null) {
                try {
                    this.editor.setReadOnly(this.readOnly);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        if (this.editor == null || !this.editor.equals(old)) {
            if (old != null) {
                this.panel.remove(old.getComponent());
            }
            if (this.editor != null) {
                this.panel.add(this.editor.getComponent());
            }
        }
        if (this.editor != null) {
            this.editor.setItem(item);
        }
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public synchronized boolean apply() {
        boolean ret = false;
        if (this.editor != null) {
            ret = this.editor.apply();
        }
        return ret;
    }

    public synchronized void reset() {
        if (this.editor != null) {
            this.editor.reset();
        }
    }

    public synchronized boolean isDirty() {
        boolean ret = false;
        if (this.editor != null) {
            ret = this.editor.isDirty();
        }
        return ret;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(null, listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        ListenerKey key = new ListenerKey(propertyName, listener);
        if (!this.listeners.contains(key)) {
            this.listeners.add(key);
            if (this.editor != null) {
                this.editor.addPropertyChangeListener(listener);
            }
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(null, listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        ListenerKey key = new ListenerKey(propertyName, listener);
        this.listeners.remove(key);
    }

    public void setErrorHandler(ErrorHandler handler) {
    }

    protected EditorLocator getEditorLocator(Item item) throws MisconfigurationException, IOException {
        DeployerBootstrap slb = new DeployerBootstrap(item.getServer());
        SearchPathElement[] fullPath = slb.getSearchPath(item.getView());
        ResourceLocatorFactory rf = slb.getResourceLocatorFactory();
        ResourceLocator rl = rf.createResourceLocator(fullPath);
        DefaultEditorLocator locator = new DefaultEditorLocator(rl, slb.getClassLoaderFactory());
        return locator;
    }

    protected static class ListenerKey {
        protected final String name;
        protected final PropertyChangeListener listener;

        public ListenerKey(String propertyName, PropertyChangeListener listener) {
            this.name = propertyName;
            this.listener = listener;
        }

        public int hashCode() {
            return (this.name != null ? this.name.hashCode() : 0) + this.listener.hashCode();
        }

        public boolean equals(Object o) {
            boolean ret;
            if (!(o instanceof ListenerKey)) {
                ListenerKey other = (ListenerKey)o;
                ret = (this.name != null ? this.name.equals(other.name) : other.name == null) && this.listener.equals(other.listener);
            } else {
                ret = false;
            }
            return ret;
        }
    }
}

