/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.gui;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Items;
import com.starbase.starteam.NoSuchPropertyException;
import com.starbase.starteam.Project;
import com.starbase.starteam.Server;
import com.starbase.starteam.StarTeamFinder;
import com.starbase.starteam.View;
import com.starbase.starteam.gui.AlternateItemEditor;
import com.starbase.starteam.gui.CustomToolFactory;
import com.starbase.starteam.gui.DefaultItemEditor;
import com.starbase.starteam.gui.ItemListContext;
import com.starbase.starteam.gui.ViewContext;
import com.starbase.starteam.starflow.locator.Bootstrap;
import com.starbase.util.MD5;
import com.starbase.util.errorhandling.GraphicalErrorHandler;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;

public class EliteAdapterImpl
implements AlternateItemEditor,
CustomToolFactory {
    public static boolean DEBUG = false;
    public static final String IMPL_VERSION = "1.0.0";
    public static final String VERSION = "1.0.0";
    public static final String CACHE_DIR_PARENT_KEY = "st.deploy.cache-dir.parent";
    public static final String CACHE_DIR_PARENT_DEFAULT = ".starbase";
    public static final String CACHE_DIR_ROOT_KEY = "st.deploy.cache-dir.root";
    public static final String CACHE_DIR_ROOT_DEFAULT = ".deployer-cache";
    public static final String CACHE_DIR_BOOTSTRAP_KEY = "st.deploy.cache-dir.bootstrap";
    public static final String CACHE_DIR_BOOTSTRAP_DEFAULT = ".bootstrap";
    public static final String BOOTSTRAP_JAR_NAME_KEY = "st.deploy.bootstrap.jar";
    public static final String BOOTSTRAP_JAR_NAME_DEFAULT = "cpc-extensions-1.0.0.jar";
    public static final String BOOTSTRAP_CLASS_NAME_KEY = "st.elite-adapter-impl.class";
    public static final String BOOTSTRAP_CLASS_NAME_DEFAULT = "com.starbase.starteam.gui.elite.EliteAdapterImplDelegate";
    public static final String RESOURCE_PROJECT_KEY = "st.deploy.resource-project";
    public static final String RESOURCE_PROJECT_DEFAULT = "StarFlow Extensions";
    public static final String RESOURCE_VIEW_KEY = "st.deploy.resource-view";
    public static final String RESOURCE_VIEW_DEFAULT = null;
    public static final String RESOURCE_FOLDER_KEY = "st.deploy.cpc.resource-folder";
    public static final String RESOURCE_FOLDER_DEFAULT = "Projects";
    protected static final java.io.File m_cacheDirRoot;
    protected static final java.io.File m_cacheDirBootstrap;
    protected static final String m_bootstrapImplJarName;
    protected static final String m_eliteAdapterImplClassName;
    protected static final String m_resourceProject;
    protected static final String m_resourceView;
    protected static final String m_resourceFolder;
    public static boolean UEA;
    protected static final Object SERVER_FEATURE_DISABLED;
    protected final WeakHashMap m_impls = new WeakHashMap();
    private static Hashtable m_locators;
    static /* synthetic */ Class class$com$starbase$starteam$gui$ItemListContext;
    static /* synthetic */ Class class$com$starbase$starteam$gui$ViewContext;
    static /* synthetic */ Class class$java$awt$Window;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Lcom$starbase$starteam$Item;

    public void editItems(Dialog parent, Items list, int firstItemIndex, boolean isHistoryItem) {
        EliteAdapterImpl.debug("EliteAdapterImpl.editItems(Dialog...) called");
        Server server = list.getAt(0).getServer();
        AlternateItemEditor e = this.getAlternateItemEditor(server);
        if (e != null) {
            e.editItems(parent, list, firstItemIndex, isHistoryItem);
        } else {
            EliteAdapterImpl.debug("EliteAdapterImpl.editItems(Dialog...) calling editItemsImpl");
            this.editItemsImpl(parent, list, firstItemIndex, isHistoryItem);
        }
    }

    public void editItems(Frame parent, Items list, int firstItemIndex, boolean isHistoryItem) {
        EliteAdapterImpl.debug("EliteAdapterImpl.editItems(Frame...) called");
        Server server = list.getAt(0).getServer();
        AlternateItemEditor e = this.getAlternateItemEditor(server);
        if (e != null) {
            e.editItems(parent, list, firstItemIndex, isHistoryItem);
        } else {
            EliteAdapterImpl.debug("EliteAdapterImpl.editItems(Frame...) calling editItemsImpl");
            this.editItemsImpl(parent, list, firstItemIndex, isHistoryItem);
        }
    }

    public JMenuItem[] createComponentMenuItems(ItemListContext ctx) {
        CustomToolFactory f;
        EliteAdapterImpl.debug("EliteAdapterImpl.createComponentMenuItems called");
        JMenuItem[] ret = null;
        if (ctx != null && ctx.getViewContext() != null && ctx.getViewContext().getView() != null && (f = this.getCustomToolFactory(ctx.getViewContext().getView().getServer())) != null) {
            ret = f.createComponentMenuItems(ctx);
        }
        return ret;
    }

    public JMenuItem[] createComponentPopupMenuItems(ItemListContext ctx) {
        CustomToolFactory f;
        EliteAdapterImpl.debug("EliteAdapterImpl.createComponentPopupMenuItems called");
        JMenuItem[] ret = null;
        if (ctx != null && ctx.getViewContext() != null && ctx.getViewContext().getView() != null && (f = this.getCustomToolFactory(ctx.getViewContext().getView().getServer())) != null) {
            ret = f.createComponentPopupMenuItems(ctx);
        }
        return ret;
    }

    public JToolBar createComponentToolbar(ItemListContext ctx) {
        CustomToolFactory f;
        EliteAdapterImpl.debug("EliteAdapterImpl.createComponentToolbar called");
        JToolBar ret = null;
        if (ctx != null && ctx.getViewContext() != null && ctx.getViewContext().getView() != null && (f = this.getCustomToolFactory(ctx.getViewContext().getView().getServer())) != null) {
            ret = f.createComponentToolbar(ctx);
        }
        return ret;
    }

    public Action[] getComponentToolActions(ItemListContext ctx) {
        Action[] ret;
        block5: {
            EliteAdapterImpl.debug("EliteAdapterImpl.getComponentToolActions called");
            ret = null;
            if (ctx == null || ctx.getViewContext() == null || ctx.getViewContext().getView() == null) break block5;
            try {
                CustomToolFactory f = this.getCustomToolFactory(ctx.getViewContext().getView().getServer());
                if (f != null) {
                    Method m = f.getClass().getMethod("getComponentToolActions", class$com$starbase$starteam$gui$ItemListContext == null ? (class$com$starbase$starteam$gui$ItemListContext = EliteAdapterImpl.class$("com.starbase.starteam.gui.ItemListContext")) : class$com$starbase$starteam$gui$ItemListContext);
                    ret = (Action[])m.invoke((Object)f, ctx);
                }
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (IllegalAccessException e) {}
        }
        return ret;
    }

    public JToolBar createViewToolbar(ViewContext ctx) {
        CustomToolFactory f;
        EliteAdapterImpl.debug("EliteAdapterImpl.createViewToolbar called");
        JToolBar ret = null;
        if (ctx != null && ctx.getView() != null && (f = this.getCustomToolFactory(ctx.getView().getServer())) != null) {
            ret = f.createViewToolbar(ctx);
        }
        return ret;
    }

    public Action[] getViewToolActions(ViewContext ctx) {
        Action[] ret;
        block5: {
            EliteAdapterImpl.debug("EliteAdapterImpl.getViewToolActions called");
            ret = null;
            if (ctx == null || ctx.getView() == null) break block5;
            try {
                CustomToolFactory f = this.getCustomToolFactory(ctx.getView().getServer());
                if (f != null) {
                    Method m = f.getClass().getMethod("getViewToolActions", class$com$starbase$starteam$gui$ViewContext == null ? (class$com$starbase$starteam$gui$ViewContext = EliteAdapterImpl.class$("com.starbase.starteam.gui.ViewContext")) : class$com$starbase$starteam$gui$ViewContext);
                    ret = (Action[])m.invoke((Object)f, ctx);
                }
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (IllegalAccessException e) {}
        }
        return ret;
    }

    protected AlternateItemEditor getAlternateItemEditor(Server server) {
        AlternateItemEditor ret = null;
        try {
            ret = (AlternateItemEditor)this.getImpl(server);
        }
        catch (Exception e) {
            EliteAdapterImpl.debug(e);
            ret = null;
        }
        return ret;
    }

    protected CustomToolFactory getCustomToolFactory(Server server) {
        CustomToolFactory ret = null;
        try {
            ret = (CustomToolFactory)this.getImpl(server);
        }
        catch (Exception e) {
            EliteAdapterImpl.debug(e);
            ret = null;
        }
        return ret;
    }

    protected Object getImpl(Server server) throws IOException {
        Object ret;
        Object value = this.m_impls.get(server);
        if (value == null) {
            Folder folder;
            Project[] projects = server.getProjects();
            Project resourceProject = null;
            int i = 0;
            while (i < projects.length) {
                if (m_resourceProject.equalsIgnoreCase(projects[i].getName())) {
                    resourceProject = projects[i];
                    break;
                }
                ++i;
            }
            if (resourceProject != null) {
                View resourceView = null;
                if (m_resourceView == null) {
                    resourceView = resourceProject.getDefaultView();
                } else {
                    View[] views = resourceProject.getViews();
                    int i2 = 0;
                    while (i2 < views.length) {
                        if (m_resourceView.equalsIgnoreCase(views[i2].getName())) {
                            resourceView = views[i2];
                            break;
                        }
                        ++i2;
                    }
                }
                if (resourceView != null) {
                    folder = StarTeamFinder.findFolder((Folder)resourceView.getRootFolder(), (String)m_resourceFolder);
                    if (folder != null) {
                        folder.populateNow(server.getTypeNames().FILE, new String[]{server.getPropertyNames().FILE_NAME, server.getPropertyNames().FILE_MD5_CHECKSUM, server.getPropertyNames().FILE_ENCODING, server.getPropertyNames().DOTNOTATION}, 0);
                    }
                } else {
                    folder = null;
                }
            } else {
                folder = null;
            }
            if (folder != null) {
                java.io.File cached = this.getCached(folder, m_bootstrapImplJarName);
                if (cached != null) {
                    Vector v = new Vector();
                    this.getDependentJars(cached, folder, v);
                    URL[] urls = new URL[v.size() + 1];
                    urls[0] = cached.toURL();
                    String jarNames = urls[0] + ", ";
                    int i3 = 0;
                    while (i3 < v.size()) {
                        urls[i3 + 1] = (URL)v.get(i3);
                        jarNames = jarNames + urls[i3] + ", ";
                        ++i3;
                    }
                    URLClassLoader loader = new URLClassLoader(urls, this.getClass().getClassLoader());
                    EliteAdapterImpl.debug("Created ClassLoader from " + jarNames);
                    try {
                        Class<?> c = loader.loadClass(m_eliteAdapterImplClassName);
                        ret = c.newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        this.m_impls.put(server, SERVER_FEATURE_DISABLED);
                        throw new NestedException(e);
                    }
                    catch (InstantiationException e) {
                        this.m_impls.put(server, SERVER_FEATURE_DISABLED);
                        throw new NestedException(e);
                    }
                    catch (IllegalAccessException e) {
                        this.m_impls.put(server, SERVER_FEATURE_DISABLED);
                        throw new NestedException(e);
                    }
                    catch (Exception e) {
                        this.m_impls.put(server, SERVER_FEATURE_DISABLED);
                        throw new NestedException(e);
                    }
                    this.m_impls.put(server, ret);
                } else {
                    ret = null;
                    this.m_impls.put(server, SERVER_FEATURE_DISABLED);
                }
            } else {
                ret = null;
                this.m_impls.put(server, SERVER_FEATURE_DISABLED);
            }
        } else {
            ret = value.equals(SERVER_FEATURE_DISABLED) ? null : (Object)value;
        }
        return ret;
    }

    protected void getDependentJars(java.io.File jar, Folder folder, Vector accumulator) throws IOException {
        String classPath;
        JarFile jarFile = new JarFile(jar);
        Manifest manifest = jarFile.getManifest();
        if (manifest != null && (classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) != null) {
            StringTokenizer tok = new StringTokenizer(classPath);
            while (tok.hasMoreTokens()) {
                String element = tok.nextToken();
                java.io.File additionalCached = this.getCached(folder, element);
                if (additionalCached != null) {
                    EliteAdapterImpl.debug("Found dependent jar: " + element);
                    accumulator.add(additionalCached.toURL());
                    this.getDependentJars(additionalCached, folder, accumulator);
                    continue;
                }
                EliteAdapterImpl.debug("Failed to find dependent jar: " + element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected java.io.File getCached(Folder folder, String jarName) throws IOException {
        java.io.File ret;
        Folder folder2 = folder;
        synchronized (folder2) {
            File repoJar = StarTeamFinder.findFile((Folder)folder, (String)jarName, (boolean)false);
            if (repoJar != null) {
                java.io.File serverWorkingDir = new java.io.File(m_cacheDirBootstrap, folder.getServer().getRepositoryID().toString() + "/");
                if (!serverWorkingDir.exists() && !serverWorkingDir.mkdirs()) {
                    throw new RuntimeException("Could not create bootstrap cache root: " + serverWorkingDir + ".");
                }
                ret = new java.io.File(serverWorkingDir, repoJar.getDotNotation().replace('.', '_') + "_" + repoJar.getName());
                if (ret.exists()) {
                    MD5 repoSignature = new MD5(repoJar.getMD5());
                    MD5 cacheSignature = new MD5();
                    cacheSignature.computeFileMD5(ret);
                    if (!repoSignature.equals((Object)cacheSignature)) {
                        repoJar.checkoutTo(ret, 3, true, false, false);
                    }
                } else {
                    repoJar.checkoutTo(ret, 3, true, false, false);
                }
            } else {
                ret = null;
            }
        }
        return ret;
    }

    protected void editItemsImpl(Dialog parent, Items list, int firstItemIndex, boolean isHistoryItem) {
        Item[] array = new Item[list.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = list.getAt(i);
            ++i;
        }
        if (!this.editItemsImpl((Window)parent, array, firstItemIndex, isHistoryItem)) {
            DefaultItemEditor.editItems((Dialog)parent, (Items)list, (int)firstItemIndex, (boolean)isHistoryItem);
        }
    }

    protected void editItemsImpl(Frame parent, Items list, int firstItemIndex, boolean isHistoryItem) {
        Item[] array = new Item[list.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = list.getAt(i);
            ++i;
        }
        if (!this.editItemsImpl((Window)parent, array, firstItemIndex, isHistoryItem)) {
            DefaultItemEditor.editItems((Frame)parent, (Items)list, (int)firstItemIndex, (boolean)isHistoryItem);
        }
    }

    protected boolean editItemsImpl(Window frameOrDialog, Item[] list, int firstItemIndex, boolean isHistoryItem) {
        boolean ret;
        Item sample = list[0];
        String typeName = sample.getType().getName();
        Project project = sample.getView().getProject();
        boolean useAlternateEditor = false;
        String cmd = "";
        try {
            if ("ChangeRequest".equals(typeName)) {
                useAlternateEditor = project.getInt("DisplayAltCREditor") == 1;
                cmd = project.getString("AltCREditorPath");
            } else if ("Requirement".equals(typeName) || "CStRequirement".equals(typeName)) {
                useAlternateEditor = project.getInt("DisplayAltReqEditor") == 1;
                cmd = project.getString("AltReqEditorPath");
            } else if ("Task".equals(typeName)) {
                useAlternateEditor = project.getInt("DisplayAltTaskEditor") == 1;
                cmd = project.getString("AltTaskEditorPath");
            } else if ("Topic".equals(typeName)) {
                useAlternateEditor = project.getInt("DisplayAltTopicEditor") == 1;
                cmd = project.getString("AltTopicEditorPath");
            } else if ("File".equals(typeName)) {
                useAlternateEditor = project.getInt("DisplayAltFileEditor") == 1;
                cmd = project.getString("AltFileEditorPath");
            } else {
                useAlternateEditor = false;
                cmd = "";
            }
        }
        catch (NoSuchPropertyException e) {
            useAlternateEditor = false;
        }
        if (useAlternateEditor) {
            StringTokenizer tok = new StringTokenizer(cmd);
            String key = tok.nextToken();
            if ("locator".equalsIgnoreCase(key) || "locatordebug".equalsIgnoreCase(key)) {
                key = tok.nextToken();
            }
            String platform = System.getProperty("os.name");
            try {
                java.io.File workingDir = new java.io.File(System.getProperty("user.dir"));
                Object locator = EliteAdapterImpl.fetchMaybeCacheLocator(sample.getServer(), workingDir);
                Class<?> locatorClass = locator.getClass();
                Method runMethod = locatorClass.getMethod("launchPropertyEditor", class$java$awt$Window == null ? (class$java$awt$Window = EliteAdapterImpl.class$("java.awt.Window")) : class$java$awt$Window, class$java$lang$String == null ? (class$java$lang$String = EliteAdapterImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EliteAdapterImpl.class$("java.lang.String")) : class$java$lang$String, array$Lcom$starbase$starteam$Item == null ? (array$Lcom$starbase$starteam$Item = EliteAdapterImpl.class$("[Lcom.starbase.starteam.Item;")) : array$Lcom$starbase$starteam$Item, Integer.TYPE, Boolean.TYPE);
                runMethod.invoke(locator, frameOrDialog, key, platform, list, new Integer(firstItemIndex), new Boolean(isHistoryItem));
            }
            catch (Exception e) {
                this.showException(e);
            }
            ret = true;
        } else {
            ret = false;
        }
        return ret;
    }

    protected void showException(Exception e) {
        JFrame f = new JFrame("StarTeam");
        try {
            URL imageUrl = this.getClass().getClassLoader().getResource("com/starbase/starteam/starflow/guicomponents/images/StarTeam16x16.gif");
            if (imageUrl != null) {
                f.setIconImage(Toolkit.getDefaultToolkit().createImage(imageUrl));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        new GraphicalErrorHandler().handleErrors(f, "StarTeam", null, e, null, null, 0, 0);
    }

    static Object fetchMaybeCacheLocator(Server server, java.io.File workingDir) throws Exception {
        Class<?> c;
        Method starTeamRootMethod;
        Folder root;
        String serverKey = EliteAdapterImpl.makeServerKey(server);
        Object locator = m_locators.get(serverKey);
        if (locator == null) {
            EliteAdapterImpl.debug("Locator not found, instantiating new one");
            locator = Bootstrap.bootstrapLocator(server, workingDir);
            m_locators.put(serverKey, locator);
        }
        if (!(root = (Folder)(starTeamRootMethod = (c = locator.getClass()).getMethod("getStarTeamRoot", new Class[0])).invoke(locator, new Object[0])).getServer().ping()) {
            EliteAdapterImpl.debug("Locator not connected, instantiating new one");
            locator = Bootstrap.bootstrapLocator(server, workingDir);
            m_locators.put(serverKey, locator);
        }
        return locator;
    }

    static String makeServerKey(Server server) {
        return server.getAddress() + server.getPort();
    }

    protected static void debug(Object message) {
        if (DEBUG) {
            System.out.println(message);
        }
    }

    protected static void debug(Throwable throwable) {
        if (DEBUG) {
            System.out.println(throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    protected static String ensureTrailingSeparator(String path) {
        if (!path.endsWith(java.io.File.separator)) {
            path = path + java.io.File.separator;
        }
        return path;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        UEA = true;
        SERVER_FEATURE_DISABLED = "disabled";
        String userHomeProperty = System.getProperty("user.home");
        if (userHomeProperty == null) {
            throw new RuntimeException("Cannot determine the location of the user's home/personal directory from the user.home system property.  Try setting the property by passing -Duser.home=path-to-home-dir on the command line to Java, or by whatever mechanism is appropriate for your runtime environment.");
        }
        String cacheDirParent = System.getProperty(CACHE_DIR_PARENT_KEY, userHomeProperty + java.io.File.separator + CACHE_DIR_PARENT_DEFAULT);
        String cacheDirRoot = System.getProperty(CACHE_DIR_ROOT_KEY, CACHE_DIR_ROOT_DEFAULT);
        String cacheDirBootstrap = System.getProperty(CACHE_DIR_BOOTSTRAP_KEY, CACHE_DIR_BOOTSTRAP_DEFAULT);
        m_bootstrapImplJarName = System.getProperty(BOOTSTRAP_JAR_NAME_KEY, BOOTSTRAP_JAR_NAME_DEFAULT);
        m_eliteAdapterImplClassName = System.getProperty(BOOTSTRAP_CLASS_NAME_KEY, BOOTSTRAP_CLASS_NAME_DEFAULT);
        m_cacheDirRoot = new java.io.File(EliteAdapterImpl.ensureTrailingSeparator(cacheDirParent) + EliteAdapterImpl.ensureTrailingSeparator(cacheDirRoot));
        m_cacheDirBootstrap = new java.io.File(EliteAdapterImpl.ensureTrailingSeparator(m_cacheDirRoot.getAbsolutePath()) + EliteAdapterImpl.ensureTrailingSeparator(cacheDirBootstrap) + EliteAdapterImpl.ensureTrailingSeparator("1.0.0"));
        m_resourceProject = System.getProperty(RESOURCE_PROJECT_KEY, RESOURCE_PROJECT_DEFAULT);
        m_resourceView = System.getProperty(RESOURCE_VIEW_KEY, RESOURCE_VIEW_DEFAULT);
        m_resourceFolder = System.getProperty(RESOURCE_FOLDER_KEY, RESOURCE_FOLDER_DEFAULT);
        try {
            Class.forName("com.starbase.starteam.gui.extensions.CPCExtensions");
        }
        catch (Throwable e) {
            EliteAdapterImpl.debug("Couldn't load CPCExtensions");
        }
        m_locators = new Hashtable();
    }

    public static interface ViewContextEx
    extends ViewContext {
        public Dialog getDialog();
    }

    public static class NestedException
    extends RuntimeException {
        private final Exception m_exception;

        public NestedException(Exception exception) {
            this.m_exception = exception;
        }

        public Exception getException() {
            return this.m_exception;
        }

        public String getMessage() {
            return this.m_exception.getMessage();
        }

        public String getLocalizedMessage() {
            return this.m_exception.getLocalizedMessage();
        }

        public String toString() {
            return this.getClass().getName() + ": " + this.m_exception;
        }

        public void printStackTrace() {
            this.printStackTrace(System.err);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printStackTrace(PrintStream s) {
            PrintStream printStream = s;
            synchronized (printStream) {
                s.print(this.getClass().getName() + ": ");
                this.m_exception.printStackTrace(s);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printStackTrace(PrintWriter s) {
            PrintWriter printWriter = s;
            synchronized (printWriter) {
                s.print(this.getClass().getName() + ": ");
                this.m_exception.printStackTrace(s);
            }
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

