/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.editorlocator;

import com.starbase.starteam.deployer.Attribute;
import com.starbase.starteam.deployer.ClassLoaderFactory;
import com.starbase.starteam.deployer.ErrorHandler;
import com.starbase.starteam.deployer.GraphicalErrorHandler;
import com.starbase.starteam.deployer.MisconfigurationException;
import com.starbase.starteam.deployer.Resource;
import com.starbase.starteam.deployer.ResourceLocator;
import com.starbase.starteam.deployer.ResourceNotFoundException;
import com.starbase.starteam.deployer.standard.ManuallyRefreshable;
import com.starbase.starteam.editor.PropertyEditorDescriptor;
import com.starbase.starteam.editorlocator.EditorLocator;
import com.starbase.starteam.gui.basic.ItemEditor;
import com.starbase.starteam.starflow.ItemEditorAdapter;
import com.starbase.util.logging.Log;
import java.beans.Beans;
import java.io.IOException;

public class DefaultEditorLocator
implements EditorLocator,
ManuallyRefreshable {
    protected ResourceLocator m_locator;
    protected ClassLoaderFactory m_classLoaderFactory;
    protected ErrorHandler m_errorHandler = new GraphicalErrorHandler();

    public DefaultEditorLocator(ResourceLocator locator, ClassLoaderFactory loaderFactory) {
        this.m_locator = locator;
        this.m_classLoaderFactory = loaderFactory;
    }

    public ItemEditor getEditor(ClassLoader parentLoader, Attribute[] attributes) {
        PropertyEditorDescriptor descriptor = this.getDescriptor(attributes);
        ItemEditor editor = descriptor != null ? this.loadEditor(parentLoader, descriptor) : null;
        return editor;
    }

    /*
     * Unable to fully structure code
     */
    public PropertyEditorDescriptor getDescriptor(Attribute[] attributes) {
        block10: {
            ret = null;
            resources = null;
            try {
                resources = this.m_locator.getResources(attributes);
                break block10;
            }
            catch (IOException e) {
                attr = "";
                i = 0;
                ** while (i < attributes.length)
            }
lbl-1000:
            // 1 sources

            {
                attr = attr + attributes[i];
                if (i < attributes.length - 1) {
                    attr = attr + ", ";
                }
                ++i;
                continue;
            }
lbl15:
            // 1 sources

            handler = this.getDefaultErrorHandler();
            msg = "I/O error occurred while searching for property editor descriptor matching " + attr + ".";
            if (handler != null) {
                handler.handleErrors(null, "StarTeam", msg, e, this, null, 0, 0);
            }
        }
        if (resources.length > 0) {
            try {
                ret = PropertyEditorDescriptor.load(resources[0].getInputStream());
            }
            catch (IOException e) {
                handler = this.getDefaultErrorHandler();
                msg = "I/O error occurred while loading item editor descriptor.";
                if (handler != null) {
                    handler.handleErrors(null, "StarTeam", "I/O error occurred while loading item editor descriptor.", e, this, null, 0, 0);
                }
            }
        } else {
            ret = null;
        }
        return ret;
    }

    protected ClassLoader findClassLoader(ClassLoader parent, String[] jarNames) throws IOException, ResourceNotFoundException, MisconfigurationException {
        Resource[] jars = new Resource[jarNames.length];
        int i = 0;
        while (i < jars.length) {
            Resource r = this.m_locator.getResource(jarNames[i]);
            if (r == null) {
                throw new ResourceNotFoundException(jarNames[i] + " not found.");
            }
            jars[i] = r;
            ++i;
        }
        ClassLoader loader = this.m_classLoaderFactory.getClassLoader(parent, jars, this.m_locator, 1, 0);
        return loader;
    }

    protected ItemEditor loadEditor(ClassLoader parentLoader, PropertyEditorDescriptor desc) {
        ItemEditor editor;
        block14: {
            editor = null;
            try {
                PropertyEditorDescriptor.JavaItemEditorTarget target = desc.getJavaItemEditorTarget();
                if (target != null) {
                    String[] jarNames = target.getJarNames();
                    ClassLoader loader = this.findClassLoader(parentLoader, jarNames);
                    if (Log.logging) {
                        Log.write(500, "Loading editor (" + desc + ") with: " + loader, "tool");
                    }
                    editor = (ItemEditor)Beans.instantiate(loader, target.getClassName(), null);
                } else {
                    PropertyEditorDescriptor.JavaInvocationTarget launcherTarget = desc.getJavaInvocationTarget();
                    if (launcherTarget != null) {
                        String[] jarNames = launcherTarget.getJarNames();
                        ClassLoader loader = this.findClassLoader(parentLoader, jarNames);
                        Class<?> launcherClass = loader.loadClass(launcherTarget.getClassName());
                        ItemEditorAdapter adapter = new ItemEditorAdapter();
                        adapter.setLegacyLauncherClass(launcherClass);
                        editor = adapter;
                    }
                }
            }
            catch (ResourceNotFoundException e) {
                ErrorHandler handler = this.getDefaultErrorHandler();
                if (handler != null) {
                    handler.handleErrors(null, "StarTeam", null, e, this, null, 0, 0);
                }
            }
            catch (MisconfigurationException e) {
                ErrorHandler handler = this.getDefaultErrorHandler();
                String msg = "Failure creating class loader.";
                if (handler != null) {
                    handler.handleErrors(null, "StarTeam", "Failure creating class loader.", e, this, null, 0, 0);
                }
            }
            catch (IOException e) {
                ErrorHandler handler = this.getDefaultErrorHandler();
                String msg = "I/O failure while fetching resources.";
                if (handler != null) {
                    handler.handleErrors(null, "StarTeam", "I/O failure while fetching resources.", e, this, null, 0, 0);
                }
            }
            catch (ClassNotFoundException e) {
                ErrorHandler handler = this.getDefaultErrorHandler();
                if (handler != null) {
                    handler.handleErrors(null, "StarTeam", null, e, this, null, 0, 0);
                }
            }
            catch (NoClassDefFoundError e) {
                ErrorHandler handler = this.getDefaultErrorHandler();
                String msg = "Tool named " + desc + " is missing implementation " + "resources: " + e.getMessage();
                if (handler == null) break block14;
                handler.handleErrors(null, "StarTeam", msg, e, this, null, 0, 0);
            }
        }
        return editor;
    }

    public ErrorHandler getDefaultErrorHandler() {
        return this.m_errorHandler;
    }

    public void setDefaultErrorHandler(ErrorHandler handler) {
        this.m_errorHandler = handler;
    }

    public String toString() {
        return "ToolLocator using " + this.m_locator;
    }

    public void triggerRefresh(long threshold) {
        if (this.m_locator instanceof ManuallyRefreshable) {
            ((ManuallyRefreshable)((Object)this.m_locator)).triggerRefresh(threshold);
        }
    }
}

