/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.deployer.standard;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Server;
import com.starbase.starteam.StarTeamFinder;
import com.starbase.starteam.deployer.Attribute;
import com.starbase.starteam.deployer.DeployerBootstrap;
import com.starbase.starteam.deployer.MisconfigurationException;
import com.starbase.starteam.deployer.Resource;
import com.starbase.starteam.deployer.ResourceLocator;
import com.starbase.starteam.deployer.SearchPathElement;
import com.starbase.starteam.deployer.StarTeamURLFactory;
import com.starbase.starteam.deployer.standard.DefaultResourceLocator;
import com.starbase.starteam.deployer.standard.ManuallyRefreshable;
import com.starbase.util.errorhandling.NestedException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class StarbaseLocator {
    protected java.io.File m_cacheRoot;
    protected final URL m_baseURL;
    static /* synthetic */ Class class$com$starbase$starteam$Folder;

    public StarbaseLocator(Server server, String resourceProjectName, String resourceViewName, String folderPath) {
        if (resourceProjectName == null || "".equals(resourceProjectName)) {
            throw new IllegalArgumentException("Must specify the name of the Project that contains the resources you wish to deploy");
        }
        DeployerBootstrap bootstrap = null;
        try {
            bootstrap = DeployerBootstrap.getOrCreateAndCacheBootstrap(server, null, false);
        }
        catch (MisconfigurationException e) {
            throw new NestedException("Unexpected problem creating Locator in StarbaseLocator.  " + resourceProjectName + "/" + resourceViewName + "/" + folderPath + ".", e);
        }
        StarTeamURLFactory urlFactory = bootstrap.getStarTeamURLFactory();
        folderPath = folderPath.startsWith("/") ? folderPath.substring("/".length()) : folderPath;
        folderPath = !folderPath.endsWith("/") ? folderPath + "/" : folderPath;
        try {
            resourceViewName = resourceViewName != null ? resourceViewName : resourceProjectName;
            this.m_baseURL = urlFactory.createURL(server, resourceProjectName + "/" + resourceViewName + "/" + folderPath);
            Folder f = (Folder)this.m_baseURL.getContent(new Class[]{class$com$starbase$starteam$Folder == null ? (class$com$starbase$starteam$Folder = StarbaseLocator.class$("com.starbase.starteam.Folder")) : class$com$starbase$starteam$Folder});
            if (f == null) {
                throw new RuntimeException(folderPath + " folder not found in " + resourceProjectName + "/" + resourceViewName);
            }
        }
        catch (MalformedURLException e) {
            throw new NestedException("Unexpected problem creating base URL in StarbaseLocator.  " + resourceProjectName + "/" + resourceViewName + "/" + folderPath + ".", e);
        }
        catch (IOException e) {
            throw new NestedException("Problem creating base URL in StarbaseLocator.  " + resourceProjectName + "/" + resourceViewName + "/" + folderPath + ".", e);
        }
    }

    public Folder getStarTeamRoot() {
        Folder f;
        try {
            f = (Folder)this.m_baseURL.getContent(new Class[]{class$com$starbase$starteam$Folder == null ? (class$com$starbase$starteam$Folder = StarbaseLocator.class$("com.starbase.starteam.Folder")) : class$com$starbase$starteam$Folder});
        }
        catch (IOException e) {
            throw new NestedException("Unexpected problem accessing URL content in StarbaseLocator.  " + this.m_baseURL, e);
        }
        return f;
    }

    public java.io.File getCacheRoot() {
        return this.m_cacheRoot;
    }

    public ResourceLocator getViewShadowingCachingLocator(final String projectName, final String viewName, final boolean caseSensitiveSearch) {
        return new ManuallyRefreshableResourceLocator(){

            public Resource getResource(String resourceName) throws IOException {
                return StarbaseLocator.this.getResourceImpl(projectName, viewName, resourceName, caseSensitiveSearch);
            }

            public Resource[] getResources(String pattern) throws IOException {
                return StarbaseLocator.this.getResources(projectName, viewName, pattern, caseSensitiveSearch);
            }

            public Resource[] getResources(Attribute[] attributes) throws IOException {
                return StarbaseLocator.this.getResources(projectName, viewName, attributes, caseSensitiveSearch);
            }

            public String[] getResourceNames(String pattern) throws IOException {
                return StarbaseLocator.this.getResourceNames(projectName, viewName, pattern, caseSensitiveSearch);
            }

            public String[] getResourceNames(Attribute[] attributes) throws IOException {
                return StarbaseLocator.this.getResourceNames(projectName, viewName, attributes, caseSensitiveSearch);
            }

            public void triggerRefresh(long threshold) {
                ResourceLocator r = StarbaseLocator.this.getResourceLocator(projectName, viewName, caseSensitiveSearch);
                if (r instanceof ManuallyRefreshable) {
                    ((ManuallyRefreshable)((Object)r)).triggerRefresh(threshold);
                }
            }
        };
    }

    protected java.io.File getResource(String projectName, String viewName, String resourceName, boolean caseSensitiveSearch) throws IOException {
        Resource resource = this.getResourceImpl(projectName, viewName, resourceName, caseSensitiveSearch);
        java.io.File ret = resource != null ? resource.getFile() : null;
        return ret;
    }

    protected InputStream getResourceAsStream(String projectName, String viewName, String resourceName, boolean caseSensitiveSearch) throws IOException {
        Resource resource = this.getResourceImpl(projectName, viewName, resourceName, caseSensitiveSearch);
        return resource != null ? resource.getInputStream() : null;
    }

    protected ResourceLocator getResourceLocator(String projectName, String viewName, boolean caseSensitiveSearch) {
        Vector<SearchPathElement> v = new Vector<SearchPathElement>();
        try {
            if (viewName != null && !"".equals(viewName)) {
                v.add(new SearchPathElement(new URL(this.m_baseURL, projectName + "/" + viewName + "/"), caseSensitiveSearch));
            }
        }
        catch (MalformedURLException e) {
            throw new NestedException("Unexpected problem creating view URL in StarbaseLocator.  " + this.m_baseURL + " + " + projectName + "/" + viewName + "/ : " + e, e);
        }
        try {
            if (projectName != null && !"".equals(projectName)) {
                v.add(new SearchPathElement(new URL(this.m_baseURL, projectName + "/"), caseSensitiveSearch));
            }
        }
        catch (MalformedURLException e) {
            throw new NestedException("Unexpected problem creating project URL in StarbaseLocator.  " + this.m_baseURL + " + " + projectName + "/", e);
        }
        v.add(new SearchPathElement(this.m_baseURL, caseSensitiveSearch));
        Object[] path = new SearchPathElement[v.size()];
        v.copyInto(path);
        return new DefaultResourceLocator((SearchPathElement[])path);
    }

    protected Resource getResourceImpl(String projectName, String viewName, String resourceName, boolean caseSensitiveSearch) throws IOException {
        return this.getResourceLocator(projectName, viewName, caseSensitiveSearch).getResource(resourceName);
    }

    protected Resource[] getResources(String projectName, String viewName, String pattern, boolean caseSensitiveSearch) throws IOException {
        return this.getResourceLocator(projectName, viewName, caseSensitiveSearch).getResources(pattern);
    }

    protected Resource[] getResources(String projectName, String viewName, Attribute[] attributes, boolean caseSensitiveSearch) throws IOException {
        return this.getResourceLocator(projectName, viewName, caseSensitiveSearch).getResources(attributes);
    }

    protected String[] getResourceNames(String projectName, String viewName, String pattern, boolean caseSensitiveSearch) throws IOException {
        return this.getResourceLocator(projectName, viewName, caseSensitiveSearch).getResourceNames(pattern);
    }

    protected String[] getResourceNames(String projectName, String viewName, Attribute[] attributes, boolean caseSensitiveSearch) throws IOException {
        return this.getResourceLocator(projectName, viewName, caseSensitiveSearch).getResourceNames(attributes);
    }

    protected File locateResourceInStarTeam(String projectName, String viewName, String resourceName, boolean caseSensitiveSearch) throws IOException {
        Folder f;
        File file = null;
        Folder starteamRoot = this.getStarTeamRoot();
        if (viewName != null && (f = StarTeamFinder.findFolder((Folder)starteamRoot, (String)(projectName + "/" + viewName))) != null) {
            file = StarTeamFinder.findFile((Folder)f, (String)resourceName, (boolean)caseSensitiveSearch);
        }
        if (projectName != null && file == null && (f = StarTeamFinder.findFolder((Folder)starteamRoot, (String)projectName)) != null) {
            file = StarTeamFinder.findFile((Folder)f, (String)resourceName, (boolean)caseSensitiveSearch);
        }
        if (file == null) {
            file = StarTeamFinder.findFile((Folder)starteamRoot, (String)resourceName, (boolean)caseSensitiveSearch);
        }
        return file;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface ManuallyRefreshableResourceLocator
    extends ResourceLocator,
    ManuallyRefreshable {
    }
}

