/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.deployer.standard;

import com.starbase.starteam.deployer.StarTeamResourceCache;
import com.starbase.starteam.deployer.StarTeamURLString;
import com.starbase.starteam.deployer.standard.CachingStarTeamURLConnection;
import com.starbase.util.logging.Log;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Hashtable;

class StarTeamURLStreamHandler
extends URLStreamHandler {
    protected final StarTeamResourceCache m_resourceCache;
    protected final Hashtable m_connections = new Hashtable();

    public StarTeamURLStreamHandler(StarTeamResourceCache resourceCache) {
        this.m_resourceCache = resourceCache;
        if (Log.logging) {
            Log.write(500, "Creating " + this, "deployer-classloader");
        }
    }

    public URLConnection openConnection(URL url) throws MalformedURLException {
        URLConnection ret;
        if ("sbdeployer".equals(url.getProtocol())) {
            URLConnection conn = (URLConnection)this.m_connections.get(url);
            if (conn == null) {
                if (Log.logging) {
                    Log.write(500, "Cache miss: looking for: " + url + " in <" + this + ">", "deployer-classloader");
                }
                conn = new CachingStarTeamURLConnection(url, this.m_resourceCache);
                this.m_connections.put(url, conn);
            }
            ret = conn;
        } else {
            ret = null;
        }
        return ret;
    }

    protected void parseURL(URL url, String spec, int start, int limit) {
        super.parseURL(url, spec, start, limit);
        String missing = "";
        if (url.getHost() == null || "".equals(url.getHost())) {
            missing = "host (" + url.getHost() + ")";
        }
        if (url.getPort() < 1) {
            missing = "port (" + url.getPort() + ")";
        }
        if ("".equals(missing) && (url.getUserInfo() == null || url.getUserInfo().indexOf(":") == -1)) {
            try {
                StarTeamURLString urlString = new StarTeamURLString(url.toExternalForm());
                if (this.m_resourceCache == null || this.m_resourceCache.getServer(urlString, false) == null) {
                    missing = "username/password (" + url.getUserInfo() + ")";
                }
            }
            catch (MalformedURLException e) {
                missing = "username/password (" + url.getUserInfo() + ")...";
            }
        }
        if (!"".equals(missing)) {
            final String msg = missing;
            throw new RuntimeException(""){

                public String toString() {
                    return "Missing required information: " + msg;
                }
            };
        }
    }
}

