/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.deployer.standard;

import com.starbase.starteam.File;
import com.starbase.starteam.deployer.Resource;
import com.starbase.util.GUID;
import com.starbase.util.logging.Log;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;

class StarTeamFileResource
implements Resource {
    protected final Object m_ID;
    protected final URL m_url;
    protected final File m_file;
    static /* synthetic */ Class class$java$io$File;

    public StarTeamFileResource(URL url, File file) {
        this.m_ID = new ID(file);
        this.m_url = url;
        this.m_file = file;
    }

    public Object getID() {
        return this.m_ID;
    }

    public URL getURL() {
        return this.m_url;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.getFile());
    }

    public java.io.File getFile() throws IOException {
        return (java.io.File)this.m_url.getContent(new Class[]{class$java$io$File == null ? (class$java$io$File = StarTeamFileResource.class$("java.io.File")) : class$java$io$File});
    }

    public Object getSignature() {
        return new Signature(this.m_file);
    }

    public String toString() {
        return "Resource: url=" + this.getURL();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Signature
    implements Serializable {
        protected final byte[] m_repositoryID;
        protected final int m_objectID;
        protected final int m_revisionNumber;

        public Signature(File file) {
            this.m_repositoryID = file.getServer().getRepositoryID().getData();
            this.m_objectID = file.getObjectID();
            this.m_revisionNumber = file.getRevisionNumber();
        }

        public boolean equals(Object o) {
            boolean ret;
            boolean bl = ret = o != null && o instanceof Signature && Signature.compare(((Signature)o).m_repositoryID, this.m_repositoryID) && ((Signature)o).m_objectID == this.m_objectID && ((Signature)o).m_revisionNumber == this.m_revisionNumber;
            if (Log.logging) {
                Log.write(500, "Signatures are " + (ret ? "" : "not") + "equal" + "(" + this + " v. " + o + ")", "deployer");
            }
            return ret;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("StarTeamFileResource.Signature<");
            buff.append(System.identityHashCode(this));
            buff.append(">: repID=");
            buff.append(new GUID(this.m_repositoryID));
            buff.append(", oid=");
            buff.append(this.m_objectID);
            buff.append(", rid=");
            buff.append(this.m_revisionNumber);
            return buff.toString();
        }

        protected static boolean compare(byte[] a, byte[] b) {
            boolean ret = true;
            int i = 0;
            while (i < a.length) {
                ret &= a[i] == b[i];
                ++i;
            }
            return ret;
        }
    }

    static class ID {
        protected final byte[] _repositoryID;
        protected final int _rootObjectID;
        protected final int _hash;

        public ID(File file) {
            this._repositoryID = file.getServer().getRepositoryID().getData();
            this._rootObjectID = file.getRootObjectID();
            this._hash = (file.getServer().getRepositoryID().toString() + this._rootObjectID).hashCode();
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object o) {
            return o != null && o instanceof ID && ((ID)o)._rootObjectID == this._rootObjectID && Signature.compare(((ID)o)._repositoryID, this._repositoryID);
        }
    }
}

