/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.deployer.standard;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ServiceDescriptor {
    private final Description m_description;
    private final RunContext m_runContext;
    private final Properties m_properties;
    public static final String[] SUPPORTED_VERSIONS = new String[]{"1.0"};

    public ServiceDescriptor(Description description, RunContext runContext, Properties properties) {
        if (runContext == null) {
            throw new IllegalArgumentException("[runContext : RunContext] may not be null");
        }
        this.m_description = description != null ? description : new Description("", "", "");
        this.m_runContext = runContext;
        this.m_properties = properties != null ? properties : new Properties();
    }

    public Description getDescription() {
        return this.m_description;
    }

    public RunContext getRunContext() {
        return this.m_runContext;
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        String eol = System.getProperty("line.separator");
        buff.append(this.m_description + eol);
        buff.append(this.m_runContext + eol);
        buff.append(this.m_properties + eol);
        return buff.toString();
    }

    public static ServiceDescriptor load(InputStream input) throws IOException {
        Document doc;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = fact.newDocumentBuilder();
            doc = parser.parse(new InputSource(input));
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.toString());
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
        Element rootNode = doc.getDocumentElement();
        if (!"service".equals(rootNode.getNodeName())) {
            throw new IOException("Input appears not to be a service descriptor");
        }
        Vector<String> versions = new Vector<String>();
        int i = 0;
        while (i < SUPPORTED_VERSIONS.length) {
            versions.addElement(SUPPORTED_VERSIONS[i]);
            ++i;
        }
        String formatVersion = rootNode.getAttribute("format-version").trim();
        if (!versions.contains(formatVersion)) {
            String supportedVersions = "";
            int i2 = 0;
            while (i2 < SUPPORTED_VERSIONS.length) {
                supportedVersions = supportedVersions + SUPPORTED_VERSIONS[i2];
                if (i2 < SUPPORTED_VERSIONS.length - 1) {
                    supportedVersions = supportedVersions + ", ";
                }
                ++i2;
            }
            throw new IOException("Input appears to be a service descriptor, but uses format-version " + formatVersion + ".  " + "This service understands versions " + supportedVersions);
        }
        Node runContextNode = ServiceDescriptor.findChild(rootNode, "javaclass");
        RunContext runContext = runContextNode != null ? RunContext.read(runContextNode) : null;
        if (runContext == null) {
            throw new IOException("Input appears to be a service descriptor, but is missing a javaclass node and is therefore invalid.");
        }
        return new ServiceDescriptor(Description.read(ServiceDescriptor.findChild(rootNode, "description")), runContext, Properties.read(ServiceDescriptor.findChild(rootNode, "properties")));
    }

    protected static String getChildElementValue(Node parent, String tag) {
        Node node = ServiceDescriptor.findChild(parent, tag);
        String ret = ServiceDescriptor.getChildText(node);
        return ret;
    }

    protected static Node findChild(Node parent, String childTagName) {
        Node[] children = ServiceDescriptor.findChildren(parent, childTagName);
        return children.length > 0 ? children[0] : null;
    }

    protected static Node[] findChildren(Node parent, String childTagName) {
        Vector<Node> v = new Vector<Node>();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeName().equals(childTagName)) {
                v.addElement(children.item(i));
            }
            ++i;
        }
        Object[] ret = new Node[v.size()];
        v.copyInto(ret);
        return ret;
    }

    protected static String getChildText(Node node) {
        String ret;
        if (node == null) {
            ret = null;
        } else {
            StringBuffer stringbuffer = new StringBuffer();
            Node child = node.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                    stringbuffer.append(child.getNodeValue());
                }
                child = child.getNextSibling();
            }
            ret = stringbuffer.toString();
        }
        return ret;
    }

    protected static String[] split(String s, String delim) {
        Vector<String> v = new Vector<String>();
        int index = s.indexOf(delim);
        while (index != -1) {
            v.addElement(s.substring(0, index).trim());
            s = s.substring(index + delim.length()).trim();
            index = s.indexOf(delim);
        }
        if (!"".equals(s)) {
            v.addElement(s);
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    static class Properties
    extends java.util.Properties {
        public static final String NODE_NAME = "properties";

        Properties() {
        }

        public String getProperty(String name) {
            return this.getProperty(name, null);
        }

        public String getProperty(String name, String defaultValue) {
            String value = (String)this.get(name);
            return value != null ? value : defaultValue;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            String eol = System.getProperty("line.separator");
            buff.append("Properties" + eol);
            Enumeration<Object> enumeration = this.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                buff.append("  " + key + ": " + this.get(key) + eol);
            }
            return buff.toString();
        }

        protected static Properties read(Node in) throws IOException {
            Properties ret;
            if (in != null && NODE_NAME.equals(in.getNodeName())) {
                ret = new Properties();
                Node[] nodes = ServiceDescriptor.findChildren(in, "property");
                int i = 0;
                while (i < nodes.length) {
                    String name = ((Element)nodes[i]).getAttribute("name").trim();
                    String value = ServiceDescriptor.getChildText(nodes[i]);
                    if (name == null) {
                        throw new IOException("Malformed <property> element: missing \"name\" attribute");
                    }
                    ret.put(name, value);
                    ++i;
                }
            } else {
                ret = null;
            }
            return ret;
        }
    }

    static class RunContext {
        public static final String NODE_NAME = "javaclass";
        private final String m_className;
        private final String[] m_jars;

        public RunContext(String className, String[] jars) {
            this.m_className = className;
            this.m_jars = jars;
        }

        public String getClassName() {
            return this.m_className;
        }

        public String[] getJarNames() {
            return this.m_jars;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            String eol = System.getProperty("line.separator");
            buff.append("RunContext" + eol);
            buff.append("  Class: " + this.m_className + eol);
            buff.append("  Jars: ");
            int i = 0;
            while (i < this.m_jars.length) {
                buff.append(this.m_jars[i]);
                if (i < this.m_jars.length - 1) {
                    buff.append(", ");
                }
                ++i;
            }
            buff.append(eol);
            return buff.toString();
        }

        protected static RunContext read(Node in) throws IOException {
            RunContext ret;
            if (in != null && NODE_NAME.equals(in.getNodeName())) {
                String className = ((Element)in).getAttribute("name").trim();
                Node[] jarNodes = ServiceDescriptor.findChildren(in, "jar");
                String[] jars = new String[jarNodes.length];
                int i = 0;
                while (i < jarNodes.length) {
                    jars[i] = ((Element)jarNodes[i]).getAttribute("name").trim();
                    ++i;
                }
                ret = new RunContext(className, jars);
            } else {
                ret = null;
            }
            return ret;
        }
    }

    static class Description {
        public static final String NODE_NAME = "description";
        private String m_displayName;
        private String m_shortDescription;
        private String m_longDescription;

        public Description(String displayName, String shortDescription, String longDescription) {
            this.m_displayName = displayName;
            this.m_shortDescription = shortDescription;
            this.m_longDescription = longDescription;
        }

        public String getDisplayName() {
            return this.m_displayName;
        }

        public String getShortDescription() {
            return this.m_shortDescription;
        }

        public String getLongDescription() {
            return this.m_longDescription;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            String eol = System.getProperty("line.separator");
            buff.append("Description" + eol);
            buff.append("  m_displayName: " + this.m_displayName + eol);
            buff.append("  m_shortDescription: " + this.m_shortDescription + eol);
            buff.append("  m_longDescription: " + this.m_longDescription + eol);
            return buff.toString();
        }

        protected static Description read(Node in) throws IOException {
            Description ret = in != null && NODE_NAME.equals(in.getNodeName()) ? new Description(ServiceDescriptor.getChildElementValue(in, "display-name"), ServiceDescriptor.getChildElementValue(in, "short-description"), ServiceDescriptor.getChildElementValue(in, "long-description")) : null;
            return ret;
        }
    }
}

