/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.deployer.standard;

import com.starbase.starteam.deployer.InvalidDescriptorFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class RunContextDescriptor {
    public static final String[] SUPPORTED_VERSIONS = new String[]{"1.0"};

    private RunContextDescriptor() {
    }

    public boolean isMatchSupersets() {
        throw new Error("not implemented");
    }

    public String[] getJarNames() {
        throw new Error("not implemented");
    }

    public String[] getDeclaredJarNames() {
        throw new Error("not implemented");
    }

    public RunContextDescriptor getParent() {
        throw new Error("not implemented");
    }

    public RunContextDescriptor load(InputStream input) throws IOException, InvalidDescriptorFormatException {
        Document doc;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = fact.newDocumentBuilder();
            doc = parser.parse(new InputSource(input));
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.toString());
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
        Element rootElement = doc.getDocumentElement();
        return RunContextDescriptor.load(rootElement);
    }

    public static RunContextDescriptor load(Element rootElement) throws InvalidDescriptorFormatException {
        if (!"runcontext".equals(rootElement.getNodeName())) {
            throw new InvalidDescriptorFormatException("Input appears not to be a run context descriptor");
        }
        Vector<String> versions = new Vector<String>();
        int i = 0;
        while (i < SUPPORTED_VERSIONS.length) {
            versions.addElement(SUPPORTED_VERSIONS[i]);
            ++i;
        }
        String formatVersion = rootElement.getAttribute("format-version").trim();
        if (!versions.contains(formatVersion)) {
            String supportedVersions = "";
            int i2 = 0;
            while (i2 < SUPPORTED_VERSIONS.length) {
                supportedVersions = supportedVersions + SUPPORTED_VERSIONS[i2];
                if (i2 < SUPPORTED_VERSIONS.length - 1) {
                    supportedVersions = supportedVersions + ", ";
                }
                ++i2;
            }
            String msg = "Input appears to be a run context descriptor, but uses format-version " + formatVersion + ".  " + "This class understands versions " + supportedVersions;
            throw new InvalidDescriptorFormatException(msg);
        }
        throw new Error("not implemented");
    }
}

