/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.deployer.standard;

import com.starbase.starteam.deployer.Resource;
import com.starbase.util.logging.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;

class FileResource
implements Resource {
    protected final ID m_id;
    protected final URL m_url;
    protected final File m_file;

    public FileResource(URL url, File file) {
        this.m_id = new ID(file);
        this.m_url = url;
        this.m_file = file;
    }

    public Object getID() {
        return this.m_id;
    }

    public URL getURL() {
        return this.m_url;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.getFile());
    }

    public File getFile() throws IOException {
        return this.m_file;
    }

    public Object getSignature() {
        return new Signature(this.m_file);
    }

    public String toString() {
        return "Resource: url=" + this.getURL();
    }

    static class Signature
    implements Serializable {
        protected final String m_path;
        protected final long m_timestamp;
        protected final long m_size;

        public Signature(File file) {
            this.m_path = file.getAbsolutePath();
            this.m_timestamp = file.lastModified();
            this.m_size = file.length();
        }

        public boolean equals(Object o) {
            boolean ret;
            boolean bl = ret = o != null && o instanceof Signature && ((Signature)o).m_path.equals(this.m_path) && ((Signature)o).m_timestamp == this.m_timestamp && ((Signature)o).m_size == this.m_size;
            if (Log.logging) {
                Log.write(500, "Signatures are " + (ret ? "" : "not") + "equal" + "(" + this + " v. " + o + ")", "deployer");
            }
            return ret;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("FileResource.Signature<");
            buff.append(System.identityHashCode(this));
            buff.append(">: file=");
            buff.append(this.m_path);
            buff.append(", time=");
            buff.append(this.m_timestamp);
            buff.append(", size=");
            buff.append(this.m_size);
            return buff.toString();
        }
    }

    static class ID {
        protected final File _file;

        protected ID(File file) {
            this._file = file;
        }

        public int hashCode() {
            return this._file.hashCode();
        }

        public boolean equals(Object o) {
            return o != null && o instanceof ID && ((ID)o)._file.equals(this._file);
        }
    }
}

