/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.deployer.standard;

import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Project;
import com.starbase.starteam.Server;
import com.starbase.starteam.View;
import com.starbase.starteam.deployer.StarTeamResourceCache;
import com.starbase.starteam.deployer.StarTeamURLFactory;
import com.starbase.starteam.deployer.StarTeamURLString;
import com.starbase.starteam.deployer.standard.StarTeamURLStreamHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import javax.swing.JOptionPane;

public class DefaultStarTeamURLFactory
implements StarTeamURLFactory {
    protected final StarTeamResourceCache m_cache;
    static /* synthetic */ Class class$com$starbase$starteam$deployer$StarTeamURLFactory;
    static /* synthetic */ Class class$com$starbase$starteam$deployer$standard$DefaultStarTeamURLFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultStarTeamURLFactory() {
        boolean upgraded;
        block18: {
            this.m_cache = null;
            URL version = (class$com$starbase$starteam$deployer$StarTeamURLFactory == null ? (class$com$starbase$starteam$deployer$StarTeamURLFactory = DefaultStarTeamURLFactory.class$("com.starbase.starteam.deployer.StarTeamURLFactory")) : class$com$starbase$starteam$deployer$StarTeamURLFactory).getResource("/[Elite Extensions 5.2.0, Build 05222002].txt");
            URL replacement = (class$com$starbase$starteam$deployer$standard$DefaultStarTeamURLFactory == null ? (class$com$starbase$starteam$deployer$standard$DefaultStarTeamURLFactory = DefaultStarTeamURLFactory.class$("com.starbase.starteam.deployer.standard.DefaultStarTeamURLFactory")) : class$com$starbase$starteam$deployer$standard$DefaultStarTeamURLFactory).getResource("/elite.jar-5.2.0.05222002-replacement");
            if (version == null) {
                return;
            }
            upgraded = false;
            if (replacement != null) {
                String msg = "StarTeam has detected an older version\nof elite.jar on this machine.  Would\nyou like to upgrade now?";
                int result = JOptionPane.showConfirmDialog(null, "StarTeam has detected an older version\nof elite.jar on this machine.  Would\nyou like to upgrade now?", "Upgrade", 0, 3);
                if (result == 0) {
                    URL eliteURL = (class$com$starbase$starteam$deployer$StarTeamURLFactory == null ? (class$com$starbase$starteam$deployer$StarTeamURLFactory = DefaultStarTeamURLFactory.class$("com.starbase.starteam.deployer.StarTeamURLFactory")) : class$com$starbase$starteam$deployer$StarTeamURLFactory).getResource("/elite.jar");
                    File eliteFile = eliteURL != null && "file".equals(eliteURL.getProtocol()) ? new File(URLDecoder.decode(eliteURL.getPath())).getAbsoluteFile() : null;
                    try {
                        block19: {
                            boolean keepGoing;
                            int c;
                            InputStream newJar;
                            FileOutputStream oldOut;
                            File backupFile;
                            block17: {
                                backupFile = new File(eliteFile.getParentFile(), "elite.jar.backup");
                                FileInputStream oldIn = new FileInputStream(eliteFile);
                                FileOutputStream backupOut = new FileOutputStream(backupFile);
                                oldOut = new FileOutputStream(eliteFile);
                                newJar = replacement.openStream();
                                c = -1;
                                keepGoing = true;
                                try {
                                    Object var19_19;
                                    try {
                                        c = oldIn.read();
                                        while (c != -1) {
                                            backupOut.write(c);
                                            c = oldIn.read();
                                        }
                                    }
                                    catch (IOException e) {
                                        String backupMessage = "StarTeam has encountered a problem trying to create a\nbackup of the original elite.jar file (located at\n" + eliteFile.getPath() + ".\n" + "Would you like to continue without creating a backup?";
                                        int answer = JOptionPane.showConfirmDialog(null, backupMessage, "Problem Creating Backup", 0, 0);
                                        keepGoing = answer == 0;
                                        var19_19 = null;
                                        oldIn.close();
                                        backupOut.flush();
                                        backupOut.close();
                                        break block17;
                                    }
                                    var19_19 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var19_20 = null;
                                    oldIn.close();
                                    backupOut.flush();
                                    backupOut.close();
                                    throw throwable;
                                }
                                oldIn.close();
                                backupOut.flush();
                                backupOut.close();
                            }
                            if (!keepGoing) break block18;
                            try {
                                try {
                                    c = newJar.read();
                                    while (c != -1) {
                                        oldOut.write(c);
                                        c = newJar.read();
                                    }
                                }
                                catch (IOException e) {
                                    String abortMessage = "A problem occurred while upgrading elite.jar.\nShutdown StarTeam Cross-Platform Client and copy\n" + backupFile.getPath() + "\n" + "over " + eliteFile.getPath() + "\n" + "and then restart the client.  If the problem persists,\n" + "see your system administrator.";
                                    JOptionPane.showMessageDialog(null, abortMessage, "Error While Upgrading", 0);
                                    Object var21_28 = null;
                                    oldOut.close();
                                    newJar.close();
                                    break block19;
                                }
                                Object var21_27 = null;
                            }
                            catch (Throwable throwable) {
                                Object var21_29 = null;
                                oldOut.close();
                                newJar.close();
                                throw throwable;
                            }
                            oldOut.close();
                            newJar.close();
                        }
                        upgraded = true;
                        String endMessage = "Upgrade procedure is complete.  Please restart\nStarTeam Cross-Platform Client for changes to take effect.";
                        JOptionPane.showMessageDialog(null, "Upgrade procedure is complete.  Please restart\nStarTeam Cross-Platform Client for changes to take effect.", "Finished Upgrading", 1);
                    }
                    catch (FileNotFoundException e) {
                        String notFoundMessage = "StarTeam encountered an unexpected error trying to upgrade\n" + eliteFile.getPath() + ".\n" + e.getMessage();
                        JOptionPane.showMessageDialog(null, notFoundMessage, "Error While Upgrading", 0);
                    }
                    catch (IOException e) {
                        String ioMessage = "StarTeam encountered an unexpected I/O error trying to upgrade\n" + eliteFile.getPath() + ".\n" + e.getMessage();
                        JOptionPane.showMessageDialog(null, ioMessage, "Error While Upgrading", 0);
                    }
                }
            }
        }
        if (upgraded) {
            throw new RuntimeException("elite.jar has been upgraded.  Please restart for the changes to take effect.");
        }
        throw new RuntimeException("elite.jar is out of date.  Please upgrade.  Disabling custom tool bar feature for the current execution.");
    }

    public DefaultStarTeamURLFactory(StarTeamResourceCache cache) {
        this.m_cache = cache;
    }

    public URL createURL(Server server, String serverRelativePath) throws MalformedURLException, IOException {
        this.m_cache.put(server);
        StarTeamURLStreamHandler handler = new StarTeamURLStreamHandler(this.m_cache);
        StarTeamURLString urlString = new StarTeamURLString(server);
        URL base = new URL(null, urlString.toString(), handler);
        return new URL(base, serverRelativePath);
    }

    public URL createURL(String url) throws MalformedURLException, IOException {
        StarTeamURLStreamHandler handler = new StarTeamURLStreamHandler(this.m_cache);
        URL ret = url.startsWith("sbdeployer:") ? new URL(null, url, handler) : new URL(url);
        return ret;
    }

    public URL createURL(Server server) throws MalformedURLException, IOException {
        return this.createURL(server, "");
    }

    public URL createURL(Project project) throws MalformedURLException, IOException {
        return this.createURL(project.getServer(), new StarTeamURLString(project).getServerRelativePortion());
    }

    public URL createURL(View view) throws MalformedURLException, IOException {
        return this.createURL(view.getServer(), new StarTeamURLString(view).getServerRelativePortion());
    }

    public URL createURL(Folder folder) throws MalformedURLException, IOException {
        return this.createURL(folder.getServer(), new StarTeamURLString(folder).getServerRelativePortion());
    }

    public URL createURL(Item item) throws MalformedURLException, IOException {
        return this.createURL(item.getServer(), new StarTeamURLString(item).getServerRelativePortion());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

