/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.deployer.standard;

import com.starbase.starteam.deployer.ClassLoaderFactory;
import com.starbase.starteam.deployer.MisconfigurationException;
import com.starbase.starteam.deployer.Resource;
import com.starbase.starteam.deployer.ResourceLocator;
import com.starbase.starteam.deployer.ServiceLocator;
import com.starbase.starteam.deployer.standard.ServiceDescriptor;
import com.starbase.util.logging.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;

public class DefaultServiceLocator
implements ServiceLocator {
    protected ResourceLocator m_locator;
    protected ClassLoaderFactory m_classLoaderFactory;

    public DefaultServiceLocator(ResourceLocator locator, ClassLoaderFactory loaderFactory) {
        this.m_locator = locator;
        this.m_classLoaderFactory = loaderFactory;
    }

    public Object getService(ClassLoader parent, String name) throws IOException, MisconfigurationException {
        Object ret;
        block17: {
            URL url;
            InputStream in;
            if (Log.logging) {
                Log.write(500, "Fetching service descriptor: " + name, "deployer-service");
            }
            Resource r = this.m_locator.getResource(name + ".service.xml");
            if (Log.logging) {
                Log.write(500, "Found: " + r, "deployer-service");
            }
            if ((in = r != null ? r.getInputStream() : ((url = parent.getResource(name + ".service.xml")) != null ? url.openStream() : null)) != null) {
                ServiceDescriptor sd = ServiceDescriptor.load(in);
                String[] jars = sd.getRunContext().getJarNames();
                ArrayList<Resource> tmp = new ArrayList<Resource>();
                int i = 0;
                while (i < jars.length) {
                    Resource res = this.m_locator.getResource(jars[i]);
                    if (res != null) {
                        tmp.add(res);
                    }
                    if (Log.logging) {
                        Log.write(500, "Using resource: " + res, "deployer-service");
                    }
                    ++i;
                }
                Resource[] paths = tmp.toArray(new Resource[0]);
                ClassLoader loader = paths.length == 0 ? parent : this.m_classLoaderFactory.getClassLoader(parent, paths, this.m_locator, 1, 0);
                try {
                    try {
                        Object o = null;
                        ret = o = loader.loadClass(sd.getRunContext().getClassName()).newInstance();
                        if (Log.logging) {
                            Log.write(500, "Loaded " + sd.getRunContext().getClassName() + " in " + this.toString(), "deployer-service");
                        }
                        break block17;
                    }
                    catch (IllegalAccessException e) {
                        throw new MisconfigurationException(e);
                    }
                    catch (InstantiationException e) {
                        throw new MisconfigurationException(e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new MisconfigurationException(e);
                    }
                    catch (NoClassDefFoundError e) {
                        throw new MisconfigurationException(e);
                    }
                }
                catch (MisconfigurationException e) {
                    if (Log.logging) {
                        Log.write(800, "Misconfiguration: " + e + " trying to " + "load " + sd.getRunContext().getClassName() + " in " + this.toString() + " using " + loader, "deployer-service");
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    if (Log.logging) {
                        Log.write(800, "Encountered " + e.toString() + "trying to " + "load " + sd.getRunContext().getClassName() + " in " + this.toString() + " using " + loader, "deployer-service");
                    }
                    throw e;
                }
            }
            ret = null;
        }
        return ret;
    }
}

