/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.deployer.standard;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Server;
import com.starbase.starteam.deployer.Attribute;
import com.starbase.starteam.deployer.Resource;
import com.starbase.starteam.deployer.ResourceLocator;
import com.starbase.starteam.deployer.SearchPathElement;
import com.starbase.starteam.deployer.StringPattern;
import com.starbase.starteam.deployer.standard.FileResource;
import com.starbase.starteam.deployer.standard.ManuallyRefreshable;
import com.starbase.starteam.deployer.standard.StarTeamFileResource;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class DefaultResourceLocator
implements ResourceLocator,
ManuallyRefreshable {
    protected static final HashSet m_needsRefresh = new HashSet();
    protected SearchPathElement[] m_path;
    static /* synthetic */ Class class$com$starbase$starteam$Folder;

    public DefaultResourceLocator(SearchPathElement[] path) {
        this.m_path = path;
    }

    public Resource getResource(final String name) throws IOException {
        Attribute attr = new Attribute(){

            public String getID() {
                return "name";
            }

            public Object get(int index) {
                if (index != 0) {
                    String msg = "" + index + " is not within bounds (0-0)";
                    throw new ArrayIndexOutOfBoundsException(msg);
                }
                return name;
            }

            public int size() {
                return 1;
            }
        };
        Resource[] resources = this.getResourcesImpl(attr, true);
        Resource ret = resources.length > 0 ? resources[0] : null;
        return ret;
    }

    public Resource[] getResources(String pattern) throws IOException {
        final StringPattern sp = new StringPattern(pattern, false);
        Attribute attr = new Attribute(){

            public String getID() {
                return "name";
            }

            public Object get(int index) {
                if (index != 0) {
                    String msg = "" + index + " is not within bounds (0-0)";
                    throw new ArrayIndexOutOfBoundsException(msg);
                }
                return sp;
            }

            public int size() {
                return 1;
            }
        };
        return this.getResources(new Attribute[]{attr});
    }

    public Resource[] getResources(Attribute[] attributes) throws IOException {
        Resource[] ret = attributes == null || attributes.length == 0 ? this.getResources("*") : (attributes.length > 1 ? new Resource[]{} : (!"name".equalsIgnoreCase(attributes[0].getID()) ? new Resource[]{} : this.getResourcesImpl(attributes[0], false)));
        return ret;
    }

    public String[] getResourceNames(String pattern) throws IOException {
        final StringPattern sp = new StringPattern(pattern, false);
        Attribute attr = new Attribute(){

            public String getID() {
                return "name";
            }

            public Object get(int index) {
                if (index != 0) {
                    String msg = "" + index + " is not within bounds (0-0)";
                    throw new ArrayIndexOutOfBoundsException(msg);
                }
                return sp;
            }

            public int size() {
                return 1;
            }
        };
        return this.getResourceNames(new Attribute[]{attr});
    }

    public String[] getResourceNames(Attribute[] attributes) throws IOException {
        String[] ret;
        if (attributes == null || attributes.length == 0) {
            ret = this.getResourceNames("*");
        } else if (attributes.length > 1) {
            ret = new String[]{};
        } else if (!"name".equalsIgnoreCase(attributes[0].getID())) {
            ret = new String[]{};
        } else {
            Hashtable t = new Hashtable();
            int i = 0;
            while (i < this.m_path.length) {
                this.getResourceNamesImpl(this.m_path[i], attributes[0], t);
                ++i;
            }
            ret = new String[t.values().size()];
            Iterator iter = t.values().iterator();
            int i2 = 0;
            while (iter.hasNext()) {
                ret[i2] = (String)iter.next();
                ++i2;
            }
        }
        return ret;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        String eol = System.getProperty("line.separator");
        buff.append(this.getClass().getName() + " (" + (this.m_path != null ? this.m_path.length : 0) + " path elements)" + eol);
        if (this.m_path != null) {
            int i = 0;
            while (i < this.m_path.length) {
                buff.append(this.m_path[i] + eol);
                ++i;
            }
        }
        return buff.toString();
    }

    protected Resource[] getResourcesImpl(Attribute attribute, boolean stopAtFirstMatch) throws IOException {
        if (!"name".equalsIgnoreCase(attribute.getID())) {
            throw new IllegalArgumentException(attribute.getID() + " is not a supported attribute.");
        }
        Vector v = new Vector();
        int i = 0;
        while (i < this.m_path.length) {
            this.getResourcesImpl(this.m_path[i], attribute, stopAtFirstMatch, v);
            if (stopAtFirstMatch && v.size() > 0) break;
            ++i;
        }
        Object[] ret = new Resource[v.size()];
        v.copyInto(ret);
        return ret;
    }

    protected void getResourcesImpl(SearchPathElement pathElement, Attribute attribute, boolean stopAtFirstMatch, Vector collector) throws IOException {
        if (!"name".equalsIgnoreCase(attribute.getID())) {
            throw new IllegalArgumentException(attribute.getID() + " is not a supported attribute.");
        }
        if ("sbdeployer".equals(pathElement.getURL().getProtocol())) {
            Folder f = (Folder)pathElement.getURL().getContent(new Class[]{class$com$starbase$starteam$Folder == null ? (class$com$starbase$starteam$Folder = DefaultResourceLocator.class$("com.starbase.starteam.Folder")) : class$com$starbase$starteam$Folder});
            if (f != null) {
                this.refreshIfNeeded(f, pathElement);
            }
            Vector v = this.findMatchingFilesInFolder(f, attribute, stopAtFirstMatch);
            int i = 0;
            while (i < v.size()) {
                File file = (File)v.elementAt(i);
                URL url = new URL(pathElement.getURL(), file.getName());
                collector.addElement(new StarTeamFileResource(url, file));
                ++i;
            }
        } else if ("file".equals(pathElement.getURL().getProtocol())) {
            java.io.File dir = new java.io.File(pathElement.getURL().getPath());
            Vector v = this.findMatchingFilesInDirectory(dir, attribute, stopAtFirstMatch);
            int i = 0;
            while (i < v.size()) {
                java.io.File file = (java.io.File)v.elementAt(i);
                URL url = new URL(pathElement.getURL(), file.getName());
                collector.addElement(new FileResource(url, file));
                ++i;
            }
        } else {
            throw new Error(pathElement.getURL().getProtocol() + " urls not supported");
        }
    }

    protected void getResourceNamesImpl(SearchPathElement pathElement, Attribute attribute, Hashtable collector) throws IOException {
        if (!"name".equalsIgnoreCase(attribute.getID())) {
            throw new IllegalArgumentException(attribute.getID() + " is not a supported attribute.");
        }
        if ("sbdeployer".equals(pathElement.getURL().getProtocol())) {
            Folder f = (Folder)pathElement.getURL().getContent(new Class[]{class$com$starbase$starteam$Folder == null ? (class$com$starbase$starteam$Folder = DefaultResourceLocator.class$("com.starbase.starteam.Folder")) : class$com$starbase$starteam$Folder});
            if (f != null) {
                this.refreshIfNeeded(f, pathElement);
            }
            Vector v = this.findMatchingFilesInFolder(f, attribute, false);
            int i = 0;
            while (i < v.size()) {
                File file = (File)v.elementAt(i);
                collector.put(file.getName(), file.getName());
                ++i;
            }
        } else if ("file".equals(pathElement.getURL().getProtocol())) {
            java.io.File dir = new java.io.File(pathElement.getURL().getPath());
            Vector v = this.findMatchingFilesInDirectory(dir, attribute, false);
            int i = 0;
            while (i < v.size()) {
                java.io.File file = (java.io.File)v.elementAt(i);
                collector.put(file.getName(), file.getName());
                ++i;
            }
        } else {
            throw new Error(pathElement.getURL().getProtocol() + " urls not supported");
        }
    }

    protected Vector findMatchingFilesInFolder(Folder folder, Attribute attribute, boolean stopAtFirstMatch) {
        if (!"name".equalsIgnoreCase(attribute.getID())) {
            throw new IllegalArgumentException(attribute.getID() + " is not a supported attribute.");
        }
        Vector<Item> ret = new Vector<Item>();
        if (folder != null) {
            Server s = folder.getServer();
            Item[] items = folder.getItems(s.getTypeNames().FILE);
            int i = 0;
            while (i < items.length) {
                Object value;
                String name = items[i].getString(s.getPropertyNames().FILE_NAME);
                boolean match = attribute.size() == 0 ? true : (attribute.size() == 1 ? ((value = attribute.get(0)) instanceof String ? ((String)value).equalsIgnoreCase(name) : value.equals(name)) : false);
                if (match) {
                    ret.add(items[i]);
                    if (stopAtFirstMatch) break;
                }
                ++i;
            }
        }
        return ret;
    }

    protected Vector findMatchingFilesInDirectory(java.io.File dir, Attribute attribute, boolean stopAtFirstMatch) {
        if (!"name".equalsIgnoreCase(attribute.getID())) {
            throw new IllegalArgumentException(attribute.getID() + " is not a supported attribute.");
        }
        Vector<java.io.File> ret = new Vector<java.io.File>();
        if (dir != null && dir.isDirectory()) {
            String[] files = dir.list();
            int i = 0;
            while (i < files.length) {
                if (!new java.io.File(dir, files[i]).isDirectory()) {
                    Object value;
                    String name = files[i];
                    boolean match = attribute.size() == 0 ? true : (attribute.size() == 1 ? ((value = attribute.get(0)) instanceof String ? ((String)value).equalsIgnoreCase(name) : value.equals(name)) : false);
                    if (match) {
                        ret.add(new java.io.File(dir, name));
                        if (stopAtFirstMatch) break;
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshIfNeeded(Folder f, SearchPathElement pathElement) {
        HashSet hashSet = m_needsRefresh;
        synchronized (hashSet) {
            if (m_needsRefresh.contains(pathElement)) {
                m_needsRefresh.remove(pathElement);
                f.refreshItems(f.getServer().getTypeNames().FILE, null, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerRefresh(long threshold) {
        HashSet hashSet = m_needsRefresh;
        synchronized (hashSet) {
            m_needsRefresh.addAll(Arrays.asList(this.m_path));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

