/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.deployer.standard;

import com.starbase.starteam.deployer.ClassLoaderFactory;
import com.starbase.starteam.deployer.MisconfigurationException;
import com.starbase.starteam.deployer.Resource;
import com.starbase.starteam.deployer.ResourceLocator;
import com.starbase.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class DefaultClassLoaderFactory
implements ClassLoaderFactory {
    protected final Vector m_cache = new Vector();

    public ClassLoader getClassLoader(ClassLoader parent, String runContextName, ResourceLocator locator) throws IOException, MisconfigurationException {
        throw new Error("not implemented");
    }

    public ClassLoader getClassLoader(ClassLoader parent, Resource[] classpath, ResourceLocator locator, int autoLoadBehavior, int cachePolicy) throws IOException, MisconfigurationException {
        ClassLoader ret = null;
        if (cachePolicy != 0) {
            ClassLoaderKey key = new ClassLoaderKey(parent, classpath);
            Iterator iter = this.m_cache.iterator();
            while (iter.hasNext()) {
                CacheElement elem = (CacheElement)iter.next();
                ClassLoader l = elem.getClassLoader();
                if (l == null) {
                    iter.remove();
                    continue;
                }
                try {
                    if (cachePolicy == 1) {
                        if (!elem.getKey().isExactMatch(key)) continue;
                        ret = l;
                        break;
                    }
                    if (cachePolicy == 2) {
                        if (!elem.getKey().contains(key)) continue;
                        ret = l;
                        break;
                    }
                    ret = null;
                    if (!Log.logging) continue;
                    Log.write(700, "getClassLoader called with unknown cache policy (" + cachePolicy + ")", "deployer-classloader");
                }
                catch (IllegalStateException e) {
                    iter.remove();
                }
            }
        }
        if (ret == null) {
            File[] jars = new File[classpath.length];
            int i = 0;
            while (i < classpath.length) {
                Resource r = classpath[i];
                jars[i] = r.getFile();
                if (jars[i] == null) {
                    throw new MisconfigurationException(r + " could not be represented " + "in the file system.");
                }
                ++i;
            }
            HashMap accumulator = new HashMap();
            if (autoLoadBehavior == 1 || autoLoadBehavior == 2) {
                int i2 = 0;
                while (i2 < jars.length) {
                    this.getDependentJars(jars[i2], locator, autoLoadBehavior, accumulator);
                    ++i2;
                }
            }
            String jarNames = "";
            URL[] urls = new URL[jars.length + accumulator.size()];
            int i3 = 0;
            while (i3 < jars.length) {
                urls[i3] = jars[i3].toURL();
                jarNames = jarNames + urls[i3] + ", ";
                ++i3;
            }
            Iterator iter = accumulator.entrySet().iterator();
            int pos = jars.length;
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                File file = (File)entry.getValue();
                urls[pos] = file.toURL();
                jarNames = jarNames + urls[pos] + ", ";
                ++pos;
            }
            ret = new URLClassLoader(urls, parent);
            if (Log.logging) {
                Log.write(500, "Created ClassLoader from " + jarNames, "deployer-classloader");
            }
            if (cachePolicy != 0) {
                this.m_cache.add(new CacheElement(new ClassLoaderKey(parent, classpath), ret));
            }
        }
        return ret;
    }

    protected void getDependentJars(File jar, ResourceLocator locator, int autoLoadBehavior, Map accumulator) throws IOException, MisconfigurationException {
        String classPath;
        JarFile jarFile = new JarFile(jar);
        Manifest manifest = jarFile.getManifest();
        if (manifest != null && (classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) != null) {
            StringTokenizer tok = new StringTokenizer(classPath);
            while (tok.hasMoreTokens()) {
                File additionalCached;
                String element = tok.nextToken();
                if (accumulator.containsKey(element)) continue;
                Resource r = locator.getResource(element);
                if (r != null) {
                    additionalCached = r.getFile();
                    if (additionalCached == null) {
                        throw new MisconfigurationException(r + " could not be " + "represented " + "in the file system.");
                    }
                } else {
                    additionalCached = null;
                }
                if (additionalCached != null) {
                    accumulator.put(element, additionalCached);
                    this.getDependentJars(additionalCached, locator, autoLoadBehavior, accumulator);
                    continue;
                }
                if (autoLoadBehavior == 2) {
                    if (Log.logging) {
                        Log.write(800, "Failed to find dependent jar: " + element, "deployer");
                    }
                    throw new MisconfigurationException("Failed to find dependent jar: " + element);
                }
                if (!Log.logging) continue;
                Log.write(700, "Failed to find dependent jar: " + element, "deployer");
            }
        }
    }

    public static class ClassLoaderKey {
        protected final ClassLoader m_parent;
        protected final Resource[] m_classpath;

        public ClassLoaderKey(ClassLoader parent, Resource[] classpath) {
            if (classpath == null) {
                throw new IllegalArgumentException("classpath may not be null");
            }
            this.m_parent = parent;
            this.m_classpath = classpath;
        }

        public boolean isExactMatch(ClassLoaderKey other) {
            return this.match(other, false);
        }

        public boolean contains(ClassLoaderKey other) {
            return this.match(other, true);
        }

        protected boolean matchParent(ClassLoaderKey other) {
            return this.m_parent != null && this.m_parent.equals(other.m_parent) || this.m_parent == null && other.m_parent == null;
        }

        protected boolean match(ClassLoaderKey other, boolean supersetMatch) {
            boolean ret = true;
            if (this.matchParent(other) && (supersetMatch || other.m_classpath.length == this.m_classpath.length)) {
                Vector<Resource> theseResources = new Vector<Resource>();
                int i = 0;
                while (i < this.m_classpath.length) {
                    theseResources.add(this.m_classpath[i]);
                    ++i;
                }
                boolean foundMatch = false;
                int i2 = 0;
                while (i2 < other.m_classpath.length) {
                    foundMatch = false;
                    Resource otherResource = other.m_classpath[i2];
                    Iterator iter = theseResources.iterator();
                    while (iter.hasNext()) {
                        Resource thisResource = (Resource)iter.next();
                        if (!otherResource.getID().equals(thisResource.getID()) || !otherResource.getSignature().equals(thisResource.getSignature())) continue;
                        foundMatch = true;
                        iter.remove();
                        break;
                    }
                    if (!foundMatch) break;
                    ++i2;
                }
                ret = foundMatch;
            } else {
                ret = false;
            }
            if (Log.logging) {
                Log.write(500, "ClassLoaderKey.match is returning " + ret, "deployer-classloader");
            }
            return ret;
        }
    }

    public static class CacheElement {
        protected final ClassLoaderKey m_key;
        protected final WeakReference m_loaderReference;

        public CacheElement(ClassLoaderKey key, ClassLoader loader) {
            this.m_key = key;
            this.m_loaderReference = new WeakReference<ClassLoader>(loader);
        }

        public ClassLoaderKey getKey() {
            return this.m_key;
        }

        public ClassLoader getClassLoader() {
            return (ClassLoader)this.m_loaderReference.get();
        }
    }
}

