/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.deployer.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashSet;

class ShadowingClassLoader
extends URLClassLoader {
    protected URLClassLoader m_shadowingURLs = new URLClassLoader(new URL[0]);
    protected MatchList m_nonShadowingPackages = new MatchList();
    protected MatchList m_shadowingPackages = new MatchList();
    protected MatchList m_nonShadowingClasses = new MatchList();
    protected MatchList m_shadowingClasses = new MatchList();
    protected MatchList m_nonShadowingResources = new MatchList();
    protected MatchList m_shadowingResources = new MatchList();

    public ShadowingClassLoader(URL[] urls) {
        super(urls);
    }

    public ShadowingClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public ShadowingClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    public void setShadowingURLs(URL[] urls) {
        this.m_shadowingURLs = new URLClassLoader(urls);
    }

    public URL[] getShadowingURLs() {
        return this.m_shadowingURLs.getURLs();
    }

    public void setShadowingPackages(String[] packageNames) {
        int i = 0;
        while (i < packageNames.length) {
            this.m_shadowingPackages.add(packageNames[i]);
            ++i;
        }
    }

    public String[] getShadowingPackages() {
        return this.m_shadowingPackages.toStringArray();
    }

    public void setNonShadowingPackages(String[] packageNames) {
        int i = 0;
        while (i < packageNames.length) {
            this.m_nonShadowingPackages.add(packageNames[i]);
            ++i;
        }
    }

    public String[] getNonShadowingPackages() {
        return this.m_nonShadowingPackages.toStringArray();
    }

    public void setShadowingClasses(String[] classNames) {
        int i = 0;
        while (i < classNames.length) {
            this.m_shadowingClasses.add(classNames[i]);
            ++i;
        }
    }

    public String[] getShadowingClasses() {
        return this.m_shadowingClasses.toStringArray();
    }

    public void setNonShadowingClasses(String[] classNames) {
        int i = 0;
        while (i < classNames.length) {
            this.m_nonShadowingClasses.add(classNames[i]);
            ++i;
        }
    }

    public String[] getNonShadowingClasses() {
        return this.m_nonShadowingClasses.toStringArray();
    }

    public void setShadowingResources(String[] resourceNames) {
        int i = 0;
        while (i < resourceNames.length) {
            this.m_shadowingResources.add(resourceNames[i]);
            ++i;
        }
    }

    public String[] getShadowingResources() {
        return this.m_shadowingResources.toStringArray();
    }

    public void setNonShadowingResources(String[] resourceNames) {
        int i = 0;
        while (i < resourceNames.length) {
            this.m_nonShadowingResources.add(resourceNames[i]);
            ++i;
        }
    }

    public String[] getNonShadowingResources() {
        return this.m_nonShadowingResources.toStringArray();
    }

    protected static String getOuterClassName(String name) {
        int index = name.indexOf(36);
        String outer = index != -1 ? name.substring(0, index) : name;
        return outer;
    }

    protected static String getPackageName(String name) {
        int index = name.lastIndexOf(46);
        String packageName = index != -1 ? name.substring(0, index) : "";
        return packageName;
    }

    public boolean isShadowingClass(String name) {
        String classFileName;
        String packageName;
        String outerClassName = ShadowingClassLoader.getOuterClassName(name);
        boolean shadowing = this.m_nonShadowingClasses.contains(outerClassName) ? false : (this.m_shadowingClasses.contains(outerClassName) ? true : (this.m_nonShadowingPackages.contains(packageName = ShadowingClassLoader.getPackageName(name)) ? false : (this.m_shadowingPackages.contains(packageName) ? true : this.m_shadowingURLs.findResource(classFileName = name.replace('.', '/').concat(".class")) != null)));
        return shadowing;
    }

    public boolean isShadowingResource(String name) {
        boolean shadowing = this.m_nonShadowingResources.contains(name) ? false : (this.m_shadowingResources.contains(name) ? true : this.m_shadowingURLs.findResource(name) != null);
        return shadowing;
    }

    public URL getResource(String name) {
        URL url = null;
        if (this.isShadowingResource(name)) {
            this.findResource(name);
        }
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream stream = null;
        URL url = this.getResource(name);
        try {
            stream = url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            stream = null;
        }
        return stream;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            if (this.isShadowingClass(name)) {
                c = this.findClass(name);
                if (resolve) {
                    this.resolveClass(c);
                }
            }
            if (c == null) {
                c = super.loadClass(name, resolve);
            }
        }
        return c;
    }

    public static URLClassLoader newInstance(URL[] urls, ClassLoader parent) {
        throw new Error("Not implemented");
    }

    public static URLClassLoader newInstance(URL[] urls) {
        throw new Error("Not implemented");
    }

    public static void main(String[] args) {
        System.out.println(ShadowingClassLoader.getOuterClassName("com.Foo"));
        System.out.println(ShadowingClassLoader.getOuterClassName("com.Foo$1"));
        System.out.println(ShadowingClassLoader.getOuterClassName("com.Foo$1$1"));
        System.out.println(ShadowingClassLoader.getPackageName("Foo"));
        System.out.println(ShadowingClassLoader.getPackageName("Foo$1"));
        System.out.println(ShadowingClassLoader.getPackageName("Foo$1$1"));
        System.out.println(ShadowingClassLoader.getPackageName("com.Foo"));
        System.out.println(ShadowingClassLoader.getPackageName("com.Foo$1"));
        System.out.println(ShadowingClassLoader.getPackageName("com.Foo$1$1"));
        System.out.println(ShadowingClassLoader.getPackageName("com.bar.Foo"));
        System.out.println(ShadowingClassLoader.getPackageName("com.bar.Foo$1"));
        System.out.println(ShadowingClassLoader.getPackageName("com.bar.Foo$1$1"));
        ShadowingClassLoader loader = new ShadowingClassLoader(new URL[0], null);
        loader.setShadowingPackages(new String[]{"com.starbase.starteam.gui.*"});
        System.out.println(loader.isShadowingClass("com.starbase.starteam.gui.basic.ItemsPane"));
        System.out.println(loader.getShadowingPackages());
    }

    protected static class MatchList {
        protected final ArrayList m_patterns = new ArrayList();
        protected final HashSet m_names = new HashSet();

        protected MatchList() {
        }

        public void add(String nameOrPattern) {
            int index = nameOrPattern.indexOf("*");
            if (index != -1) {
                if (nameOrPattern.substring(0, index).endsWith(".")) {
                    --index;
                }
                this.m_patterns.add(nameOrPattern.substring(0, index));
            } else {
                this.m_names.add(nameOrPattern);
            }
        }

        public boolean contains(String name) {
            boolean match = this.m_names.contains(name);
            if (!match) {
                int length = this.m_patterns.size();
                int i = 0;
                while (i < length) {
                    match = name.startsWith((String)this.m_patterns.get(i));
                    if (match) break;
                    ++i;
                }
            }
            return match;
        }

        public String[] toStringArray() {
            String[] ret = new String[this.m_names.size() + this.m_patterns.size()];
            this.m_names.toArray(ret);
            int namesLength = this.m_names.size();
            int patternsLength = this.m_patterns.size();
            int i = namesLength;
            while (i < patternsLength) {
                ret[i] = (String)this.m_patterns.get(i - namesLength) + "*";
                ++i;
            }
            return ret;
        }
    }
}

