/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.deployer;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Project;
import com.starbase.starteam.Server;
import com.starbase.starteam.StarTeamFinder;
import com.starbase.starteam.View;
import com.starbase.starteam.deployer.DeployerBootstrap;
import com.starbase.util.errorhandling.NestedException;
import com.starbase.util.logging.Log;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class StarTeamURLString {
    protected boolean m_includeUserPortion = true;
    protected boolean m_includePasswordPortion = true;
    protected boolean m_includeParentViewPortion = true;
    protected boolean m_includeViewConfigurationPortion = true;
    protected final Server m_server;
    protected String m_user;
    protected final String m_password;
    protected final String m_host;
    protected final String m_port;
    protected final String m_project;
    protected final String m_viewHierarchy;
    protected final String m_view;
    protected final String m_viewConfiguration;
    protected final String m_folderHierarchy;
    protected final String m_item;

    public StarTeamURLString(String url) throws MalformedURLException {
        if (!url.startsWith("sbdeployer://")) {
            throw new MalformedURLException(url);
        }
        String s = url.substring("sbdeployer://".length());
        int index = s.indexOf("/");
        URL dummy = new URL("http://" + (index == -1 ? s : s.substring(0, index)));
        s = index == -1 ? "" : s.substring(index);
        s = s.startsWith("/") ? s.substring(1) : s;
        index = s.indexOf("/");
        String projectName = index != -1 ? s.substring(0, index) : s;
        s = index != -1 ? s.substring(index + 1) : "";
        index = s.indexOf("/");
        String viewSpec = index != -1 ? s.substring(0, index) : s;
        s = index != -1 ? s.substring(index) : "";
        index = s.lastIndexOf("/");
        String folderNames = index != -1 ? s.substring(0, index + 1) : "";
        String fileName = s = index != -1 ? s.substring(index + 1) : s;
        if (projectName != null && !"".equals(projectName)) {
            this.m_project = projectName;
            if (viewSpec != null && !"".equals(viewSpec)) {
                this.m_view = this.splitViewName(viewSpec);
                this.m_viewHierarchy = this.splitViewHierarchy(viewSpec);
                this.m_viewConfiguration = this.splitViewConfiguration(viewSpec);
                if (folderNames != null && !"".equals(folderNames)) {
                    String str = folderNames;
                    this.m_folderHierarchy = str = !str.endsWith("/") ? str + "/" : str;
                    this.m_item = fileName != null && !"".equals(fileName) ? fileName : null;
                } else {
                    this.m_folderHierarchy = null;
                    this.m_item = null;
                }
            } else {
                this.m_view = null;
                this.m_viewHierarchy = null;
                this.m_viewConfiguration = null;
                this.m_folderHierarchy = null;
                this.m_item = null;
            }
        } else {
            this.m_project = null;
            this.m_view = null;
            this.m_viewHierarchy = null;
            this.m_viewConfiguration = null;
            this.m_folderHierarchy = null;
            this.m_item = null;
        }
        String userInfo = dummy.getUserInfo();
        this.m_server = null;
        this.m_user = userInfo != null && userInfo.indexOf(":") != -1 ? userInfo.substring(0, userInfo.indexOf(":")) : userInfo;
        this.m_password = userInfo != null && userInfo.indexOf(":") != -1 ? userInfo.substring(userInfo.indexOf(":") + 1) : null;
        this.m_host = dummy.getHost();
        this.m_port = "" + dummy.getPort();
    }

    public StarTeamURLString(Server server, String user, String password) {
        this(server, user, password, server.getAddress(), "" + server.getPort(), null, null, null, null, null, null);
    }

    public StarTeamURLString(Server server) {
        this(server, null, null);
    }

    public StarTeamURLString(Project project, String user, String password) {
        this(project.getServer(), user, password, project.getServer().getAddress(), "" + project.getServer().getPort(), project.getName(), null, null, null, null, null);
    }

    public StarTeamURLString(Project project) {
        this(project, null, null);
    }

    public StarTeamURLString(View view, String user, String password) {
        this(view.getServer(), user, password, view.getServer().getAddress(), "" + view.getServer().getPort(), view.getProject().getName(), view.getName(), StarTeamURLString.getViewHierarchy(view), StarTeamURLString.getViewConfiguration(view), null, null);
    }

    public StarTeamURLString(View view) {
        this(view, null, null);
    }

    public StarTeamURLString(Folder folder, String user, String password) {
        this(folder.getServer(), user, password, folder.getServer().getAddress(), "" + folder.getServer().getPort(), folder.getView().getProject().getName(), folder.getView().getName(), StarTeamURLString.getViewHierarchy(folder.getView()), StarTeamURLString.getViewConfiguration(folder.getView()), StarTeamURLString.getFolderHierarchy(folder), null);
    }

    public StarTeamURLString(Folder folder) {
        this(folder, null, null);
    }

    public StarTeamURLString(Item item, String user, String password) {
        this(item.getServer(), user, password, item.getServer().getAddress(), "" + item.getServer().getPort(), item.getView().getProject().getName(), item.getView().getName(), StarTeamURLString.getViewHierarchy(item.getView()), StarTeamURLString.getViewConfiguration(item.getView()), StarTeamURLString.getFolderHierarchy(item.getParentFolder()), StarTeamURLString.getItemIdentifier(item));
    }

    public StarTeamURLString(Item item) {
        this(item, null, null);
    }

    protected StarTeamURLString(Server server, String user, String password, String host, String port, String project, String view, String viewHierarchy, String viewConfiguration, String folderHierarchy, String item) {
        if (host == null || port == null) {
            throw new IllegalArgumentException("Host and port may not be null");
        }
        this.m_server = server;
        this.m_user = user;
        this.m_password = password;
        this.m_host = host;
        this.m_port = port;
        this.m_project = project;
        this.m_viewHierarchy = viewHierarchy;
        this.m_view = view;
        this.m_viewConfiguration = viewConfiguration;
        this.m_folderHierarchy = folderHierarchy;
        this.m_item = item;
    }

    protected void setIncludeUserPortion(boolean include) {
        this.m_includeUserPortion = include;
    }

    protected boolean isIncludeUserPortion() {
        return this.m_includeUserPortion && this.getUser() != null;
    }

    protected void setIncludePasswordPortion(boolean include) {
        this.m_includePasswordPortion = include;
    }

    protected boolean isIncludePasswordPortion() {
        return this.m_includePasswordPortion && this.getPassword() != null;
    }

    protected void setIncludeParentViewPortion(boolean include) {
        this.m_includeParentViewPortion = include;
    }

    protected boolean isIncludeParentViewPortion() {
        return this.m_includeParentViewPortion;
    }

    protected void setIncludeViewConfigurationPortion(boolean include) {
        this.m_includeViewConfigurationPortion = include;
    }

    protected boolean isIncludeViewConfigurationPortion() {
        return this.m_includeViewConfigurationPortion;
    }

    public String getUser() {
        if (this.m_user == null && this.m_server != null) {
            this.m_user = DeployerBootstrap.getLogOnName(this.m_server);
        }
        return this.m_user;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getAuthenticationPortion() {
        String ret = this.isIncludeUserPortion() && this.getUser() != null ? this.getUser() + (this.isIncludePasswordPortion() && this.getPassword() != null ? ":" + this.getPassword() : "") : null;
        return ret;
    }

    public String getHost() {
        return this.m_host;
    }

    public String getPort() {
        return this.m_port;
    }

    public String getServerPortion() {
        return this.m_host + ":" + this.m_port;
    }

    public String getServerURLString() {
        String auth = this.getAuthenticationPortion();
        return "sbdeployer://" + (auth != null ? auth + "@" : "") + this.getServerPortion() + "/";
    }

    public String getProjectPortion() {
        return this.m_project;
    }

    public String getProjectURLString() {
        return this.getProjectPortion() != null ? this.getServerURLString() + this.getProjectPortion() + "/" : null;
    }

    public String getViewName() {
        return this.m_view;
    }

    public String getViewConfigurationPortion() {
        return null;
    }

    public String getViewPortion() {
        String ret = this.m_viewHierarchy != null || this.m_view != null ? (this.isIncludeParentViewPortion() ? this.m_viewHierarchy : this.m_view) + (this.isIncludeViewConfigurationPortion() && this.getViewConfigurationPortion() != null ? "@" + this.getViewConfigurationPortion() : "") : null;
        return ret;
    }

    public String getViewURLString() {
        return this.getViewPortion() != null ? this.getProjectURLString() + this.getViewPortion() : null;
    }

    public String getFolderPortion() {
        return this.m_folderHierarchy;
    }

    public String getFolderURLString() {
        return this.getFolderPortion() != null ? this.getViewURLString() + this.getFolderPortion() : null;
    }

    public String getItemPortion() {
        return this.m_item;
    }

    public String getItemURLString() {
        return this.getItemPortion() != null ? this.getFolderURLString() + this.getItemPortion() : null;
    }

    public String getServerRelativePortion() {
        return this.toString().substring(this.getServerURLString().length());
    }

    public StarTeamURLString cloneAsServerURL() {
        StarTeamURLString ret = null;
        try {
            ret = new StarTeamURLString(this.getServerURLString());
            this.cloneIncludeSettings(ret);
        }
        catch (MalformedURLException e) {
            if (Log.logging) {
                Log.write(500, "cloneAsServerURL caught MalformedURLException", "deployer");
            }
            throw new NestedException(e);
        }
        return ret;
    }

    public StarTeamURLString cloneAsProjectURL() {
        StarTeamURLString ret = null;
        try {
            ret = new StarTeamURLString(this.getProjectURLString());
            this.cloneIncludeSettings(ret);
        }
        catch (MalformedURLException e) {
            if (Log.logging) {
                Log.write(500, "cloneAsProjectURL caught MalformedURLException", "deployer");
            }
            throw new NestedException(e);
        }
        return ret;
    }

    public StarTeamURLString cloneAsViewURL() {
        StarTeamURLString ret = null;
        try {
            ret = new StarTeamURLString(this.getViewURLString());
            this.cloneIncludeSettings(ret);
        }
        catch (MalformedURLException e) {
            if (Log.logging) {
                Log.write(500, "cloneAsViewURL caught MalformedURLException", "deployer");
            }
            throw new NestedException(e);
        }
        return ret;
    }

    public StarTeamURLString cloneAsFolderURL() {
        StarTeamURLString ret = null;
        try {
            ret = new StarTeamURLString(this.getFolderURLString());
            this.cloneIncludeSettings(ret);
        }
        catch (MalformedURLException e) {
            if (Log.logging) {
                Log.write(500, "cloneAsFolderURL caught MalformedURLException", "deployer");
            }
            throw new NestedException(e);
        }
        return ret;
    }

    public StarTeamURLString cloneAsItemURL() {
        StarTeamURLString ret = null;
        try {
            ret = new StarTeamURLString(this.getItemURLString());
            this.cloneIncludeSettings(ret);
        }
        catch (MalformedURLException e) {
            if (Log.logging) {
                Log.write(500, "cloneAsItemURL caught MalformedURLException", "deployer");
            }
            throw new NestedException(e);
        }
        return ret;
    }

    public StarTeamURLString cloneAsSameURL() {
        StarTeamURLString ret = null;
        try {
            ret = new StarTeamURLString(this.toString());
            this.cloneIncludeSettings(ret);
        }
        catch (MalformedURLException e) {
            if (Log.logging) {
                Log.write(500, "cloneAsSameURL caught MalformedURLException", "deployer");
            }
            throw new NestedException(e);
        }
        return ret;
    }

    public StarTeamURLString cloneWithoutUserInfo() {
        StarTeamURLString ret = null;
        try {
            ret = new StarTeamURLString(this.toString());
            this.cloneIncludeSettings(ret);
            ret.setIncludeUserPortion(false);
            ret.setIncludePasswordPortion(false);
        }
        catch (MalformedURLException e) {
            if (Log.logging) {
                Log.write(500, "cloneAsSameURL caught MalformedURLException", "deployer");
            }
            throw new NestedException(e);
        }
        return ret;
    }

    public StarTeamURLString cloneWithoutPassword() {
        StarTeamURLString ret = null;
        try {
            ret = new StarTeamURLString(this.toString());
            this.cloneIncludeSettings(ret);
            ret.setIncludePasswordPortion(false);
        }
        catch (MalformedURLException e) {
            if (Log.logging) {
                Log.write(500, "cloneAsSameURL caught MalformedURLException", "deployer");
            }
            throw new NestedException(e);
        }
        return ret;
    }

    public StarTeamURLString cloneWithoutViewConfiguration() {
        StarTeamURLString ret = null;
        try {
            ret = new StarTeamURLString(this.toString());
            this.cloneIncludeSettings(ret);
            ret.setIncludeViewConfigurationPortion(false);
        }
        catch (MalformedURLException e) {
            if (Log.logging) {
                Log.write(500, "cloneAsSameURL caught MalformedURLException", "deployer");
            }
            throw new NestedException(e);
        }
        return ret;
    }

    protected void cloneIncludeSettings(StarTeamURLString url) {
        url.setIncludeUserPortion(this.isIncludeUserPortion());
        url.setIncludePasswordPortion(this.isIncludePasswordPortion());
        url.setIncludeViewConfigurationPortion(this.isIncludeViewConfigurationPortion());
        url.setIncludeParentViewPortion(this.isIncludeParentViewPortion());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        boolean ret = true;
        if (o instanceof StarTeamURLString) {
            StarTeamURLString other = (StarTeamURLString)o;
            if (this.isIncludeUserPortion() || other.isIncludeUserPortion()) {
                String user = this.isIncludeUserPortion() ? this.getUser() : null;
                String otherUser = other.isIncludeUserPortion() ? other.getUser() : null;
                ret &= user == null && otherUser == null || user != null && otherUser != null && user.equalsIgnoreCase(otherUser);
            }
            try {
                InetAddress[] addresses = InetAddress.getAllByName(this.getHost());
                InetAddress[] otherAddresses = InetAddress.getAllByName(other.getHost());
                boolean addressMatch = false;
                int i = 0;
                while (i < addresses.length) {
                    int k = 0;
                    while (k < otherAddresses.length) {
                        addressMatch = addresses[i].equals(otherAddresses[k]);
                        if (addressMatch) break;
                        ++k;
                    }
                    if (!addressMatch) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (UnknownHostException e) {
                ret &= this.getHost().equalsIgnoreCase(other.getHost());
            }
            ret &= this.getPort().equals(other.getPort());
            if (this.getProjectPortion() != null || other.getProjectPortion() != null) {
                ret &= this.getProjectPortion() != null && other.getProjectPortion() != null && this.getProjectPortion().equalsIgnoreCase(other.getProjectPortion());
            }
            if (this.getViewPortion() != null || other.getViewPortion() != null) {
                ret &= this.getViewPortion() != null && other.getViewPortion() != null && this.getViewPortion().equalsIgnoreCase(other.getViewPortion());
            }
            if (this.getFolderPortion() != null || other.getFolderPortion() != null) {
                ret &= this.getFolderPortion() != null && other.getFolderPortion() != null && this.getFolderPortion().equalsIgnoreCase(other.getFolderPortion());
            }
            if (this.getItemPortion() != null || other.getItemPortion() != null) {
                ret &= this.getItemPortion() != null && other.getItemPortion() != null && this.getItemPortion().equalsIgnoreCase(other.getItemPortion());
            }
        } else {
            ret = false;
        }
        return ret;
    }

    public String toString() {
        String ret = this.getItemPortion() != null ? this.getItemURLString() : (this.getFolderPortion() != null ? this.getFolderURLString() : (this.getViewPortion() != null ? this.getViewURLString() : (this.getProjectPortion() != null ? this.getProjectURLString() : this.getServerURLString())));
        return ret;
    }

    public static String getViewConfiguration(View view) {
        return "";
    }

    public static String getViewHierarchy(View view) {
        String ret = "";
        View v = view;
        while (v != null) {
            ret = v.getName() + ("".equals(ret) ? "" : ":") + ret;
            v = v.getParentView();
        }
        return ret;
    }

    public static String getFolderHierarchy(Folder folder) {
        String ret = "/";
        Folder f = folder;
        while (f != null && f.getParentFolder() != null) {
            ret = "/" + f.getName() + ret;
            f = f.getParentFolder();
        }
        return ret;
    }

    public static String getItemIdentifier(Item item) {
        if (!item.getType().getName().equals(item.getServer().getTypeNames().FILE)) {
            throw new IllegalArgumentException("Items other than Files are not currently supported by the StarTeamURLFactory");
        }
        return ((File)item).getName();
    }

    protected String splitViewConfiguration(String spec) {
        int index = spec.indexOf("@");
        return index != -1 ? spec.substring(index + 1) : null;
    }

    protected String splitViewHierarchy(String spec) {
        int index = spec.indexOf("@");
        return index != -1 ? spec.substring(0, index) : spec;
    }

    protected String splitViewName(String spec) {
        String hierarchy = this.splitViewHierarchy(spec);
        int index = hierarchy.lastIndexOf(":");
        return index != -1 ? hierarchy.substring(index + 1) : hierarchy;
    }

    public static void main(String[] args) throws Exception {
        Folder f = StarTeamFinder.openFolder((String)"bstiles:@localhost:49201/StarFlow Extensions/New View/Samples/Tools/");
        StarTeamURLString s = new StarTeamURLString(f);
        System.out.println(s);
        System.out.println(s.getServerRelativePortion());
        StarTeamURLString s1 = new StarTeamURLString("sbdeployer://bstiles@localhost:49201");
        System.out.println(s1);
        s1.setIncludeUserPortion(true);
        System.out.println(s1);
        s1.setIncludePasswordPortion(true);
        System.out.println(s1);
        StarTeamURLString s2 = new StarTeamURLString("sbdeployer://bstiles:@localhost:49201");
        System.out.println(s2);
        s2.setIncludeUserPortion(true);
        System.out.println(s2);
        s2.setIncludePasswordPortion(true);
        System.out.println(s2);
        StarTeamURLString s3 = new StarTeamURLString("sbdeployer://bstiles:password@localhost:49201");
        System.out.println(s3);
        s3.setIncludeUserPortion(true);
        System.out.println(s3);
        s3.setIncludePasswordPortion(true);
        System.out.println(s3);
        StarTeamURLString s4 = new StarTeamURLString("sbdeployer://bstiles:password@localhost:49201/");
        System.out.println(s4);
        StarTeamURLString s5 = new StarTeamURLString("sbdeployer://bstiles:password@localhost:49201/project");
        System.out.println(s5);
        StarTeamURLString s6 = new StarTeamURLString("sbdeployer://bstiles:password@localhost:49201/project/");
        System.out.println(s6);
        StarTeamURLString s7 = new StarTeamURLString("sbdeployer://bstiles:password@localhost:49201/project/view");
        System.out.println(s7);
        StarTeamURLString s8 = new StarTeamURLString("sbdeployer://bstiles:password@localhost:49201/project/view/");
        System.out.println(s8);
        StarTeamURLString s9 = new StarTeamURLString("sbdeployer://bstiles:password@localhost:49201/project/view/item");
        System.out.println(s9);
        StarTeamURLString s10 = new StarTeamURLString("sbdeployer://bstiles:password@localhost:49201/project/view/folder/");
        System.out.println(s10);
        StarTeamURLString s11 = new StarTeamURLString("sbdeployer://bstiles:password@localhost:49201/project/view/folder/item");
        System.out.println(s11);
        StarTeamURLString s12 = new StarTeamURLString("sbdeployer://bstiles:password@localhost:49201/project/view/folder/folder/item");
        System.out.println(s12);
        StarTeamURLString s13 = new StarTeamURLString(f.getView().getRootFolder());
        System.out.println(s13);
        System.out.println(s12.getFolderPortion());
        String u0 = "sbdeployer://127.0.0.1:49201";
        String u1 = "sbdeployer://192.168.1.11:49201";
        String u2 = "sbdeployer://localhost:49201";
        String u3 = "sbdeployer://bstiles@localhost:49201";
        String u4 = "sbdeployer://bstiles:password@localhost:49201";
        String u5 = "sbdeployer://bstiles:password@localhost:49201/";
        String u6 = "sbdeployer://bstiles:password@localhost:49201/project";
        String u7 = "sbdeployer://bstiles:password@localhost:49201/project/";
        String u8 = "sbdeployer://bstiles:password@localhost:49201/project/view";
        String u9 = "sbdeployer://bstiles:password@localhost:49201/project/view/";
        String u10 = "sbdeployer://bstiles:password@localhost:49201/project/view/item";
        String u11 = "sbdeployer://bstiles:password@localhost:49201/project/view/folder/";
        String u12 = "sbdeployer://bstiles:password@localhost:49201/project/view/folder/item";
        boolean ret = true;
        System.out.println(ret &= StarTeamURLString.compare0("sbdeployer://127.0.0.1:49201", "sbdeployer://192.168.1.11:49201"));
        System.out.println(ret &= StarTeamURLString.compare0("sbdeployer://127.0.0.1:49201", "sbdeployer://localhost:49201"));
        System.out.println(ret &= StarTeamURLString.compare0("sbdeployer://192.168.1.11:49201", "sbdeployer://localhost:49201"));
        System.out.println(ret &= StarTeamURLString.compare0("sbdeployer://bstiles@localhost:49201", "sbdeployer://bstiles:password@localhost:49201/"));
        System.out.println(ret &= StarTeamURLString.compare0("sbdeployer://bstiles@localhost:49201", "sbdeployer://bstiles:password@localhost:49201"));
        System.out.println(ret &= StarTeamURLString.compare0("sbdeployer://bstiles:password@localhost:49201/project", "sbdeployer://bstiles:password@localhost:49201/project/"));
        System.out.println(ret &= StarTeamURLString.compare1("sbdeployer://127.0.0.1:49201", "sbdeployer://192.168.1.11:49201"));
        System.out.println(ret &= StarTeamURLString.compare1("sbdeployer://127.0.0.1:49201", "sbdeployer://bstiles@localhost:49201"));
        System.out.println(ret &= StarTeamURLString.compare1("sbdeployer://127.0.0.1:49201", "sbdeployer://bstiles:password@localhost:49201"));
        System.out.println(ret &= StarTeamURLString.compare1("sbdeployer://bstiles@localhost:49201", "sbdeployer://bstiles:password@localhost:49201"));
        System.out.println(ret &= !StarTeamURLString.compare0("sbdeployer://127.0.0.1:49201", "sbdeployer://bstiles:password@localhost:49201/project"));
        System.out.println(ret &= !StarTeamURLString.compare0("sbdeployer://bstiles:password@localhost:49201/project", "sbdeployer://bstiles:password@localhost:49201/project/view"));
        System.out.println(ret &= !StarTeamURLString.compare0("sbdeployer://bstiles:password@localhost:49201/project/view", "sbdeployer://bstiles:password@localhost:49201/project/view/"));
        System.out.println(ret &= !StarTeamURLString.compare0("sbdeployer://bstiles:password@localhost:49201/project/view/", "sbdeployer://bstiles:password@localhost:49201/project/view/item"));
        System.out.println(ret &= !StarTeamURLString.compare0("sbdeployer://bstiles:password@localhost:49201/project/view/item", "sbdeployer://bstiles:password@localhost:49201/project/view/folder/item"));
        long begin = System.currentTimeMillis();
        StarTeamURLString stus = null;
        int i = 0;
        while (i < 1000) {
            stus = new StarTeamURLString("sbdeployer://bstiles:password@localhost:49201/project/view/item");
            stus = new StarTeamURLString(f);
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.println(end - begin);
    }

    protected static boolean compare0(String u1, String u2) throws MalformedURLException {
        StarTeamURLString s1 = new StarTeamURLString(u1);
        StarTeamURLString s2 = new StarTeamURLString(u2);
        return s1.equals(s2);
    }

    protected static boolean compare1(String u1, String u2) throws MalformedURLException {
        boolean ret = true;
        StarTeamURLString s1 = new StarTeamURLString(u1);
        StarTeamURLString s2 = new StarTeamURLString(u2);
        ret = s1.equals(s2);
        s1.setIncludeUserPortion(false);
        ret = s1.equals(s2);
        s2.setIncludeUserPortion(false);
        ret = s1.equals(s2);
        return ret;
    }
}

