/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.deployer;

import com.starbase.starteam.Server;
import com.starbase.starteam.deployer.ClassLoaderFactory;
import com.starbase.starteam.deployer.DefaultStarTeamResourceCache;
import com.starbase.starteam.deployer.MisconfigurationException;
import com.starbase.starteam.deployer.ResourceLocator;
import com.starbase.starteam.deployer.ResourceLocatorFactory;
import com.starbase.starteam.deployer.SearchPathElement;
import com.starbase.starteam.deployer.ServiceLocator;
import com.starbase.starteam.deployer.ServiceLocatorFactory;
import com.starbase.starteam.deployer.StarTeamResourceCache;
import com.starbase.starteam.deployer.StarTeamURLFactory;
import com.starbase.starteam.deployer.standard.DefaultClassLoaderFactory;
import com.starbase.starteam.deployer.standard.DefaultResourceLocatorFactory;
import com.starbase.starteam.deployer.standard.DefaultServiceLocatorFactory;
import com.starbase.starteam.deployer.standard.DefaultStarTeamURLFactoryFactory;
import com.starbase.util.errorhandling.NestedException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class DeployerUtils {
    protected static final File baseCacheDir = new File(DeployerUtils.getBaseCacheDirectoryName());
    protected static final ClassLoaderFactory loaderFactory = new DefaultClassLoaderFactory();
    protected static final String resourceProjectName = System.getProperty("st.deploy.bootstrap.project", "StarFlow Extensions");
    protected static final String resourceViewName = System.getProperty("st.deploy.bootstrap.view", "StarFlow Extensions");
    protected static final String resourceFolderPath = System.getProperty("st.deploy.bootstrap.folderpath", "Projects");
    protected static final ResourceLocatorFactory resourceLocatorFactory = new DefaultResourceLocatorFactory();
    protected static final ServiceLocatorFactory serviceLocatorFactory = new DefaultServiceLocatorFactory();

    private DeployerUtils() {
    }

    public static StarTeamResourceCache createStarTeamResourceCache() {
        return new DefaultStarTeamResourceCache(baseCacheDir);
    }

    public static StarTeamURLFactory createStarTeamURLFactory(StarTeamResourceCache resourceCache) {
        return new DefaultStarTeamURLFactoryFactory().createStarTeamURLFactory(resourceCache);
    }

    public static URL getBaseResourceFolderURL(Server server, StarTeamURLFactory urlFactory) {
        URL url;
        try {
            url = urlFactory.createURL(server, "/" + resourceProjectName + "/" + resourceViewName + "/" + resourceFolderPath + "/");
        }
        catch (MalformedURLException e) {
            throw new NestedException(e);
        }
        catch (IOException e) {
            throw new NestedException(e);
        }
        return url;
    }

    public static SearchPathElement[] createSearchPath(Server server, StarTeamURLFactory urlFactory) throws MalformedURLException {
        URL[] additionalPaths;
        URL url = DeployerUtils.getBaseResourceFolderURL(server, urlFactory);
        try {
            additionalPaths = DeployerUtils.parseAdditionalPaths(System.getProperty("st.deploy.additionalresourcepaths", ""), urlFactory);
        }
        catch (IOException e) {
            throw new NestedException(e);
        }
        SearchPathElement[] path = new SearchPathElement[1 + additionalPaths.length];
        path[0] = new SearchPathElement(url, false);
        int i = 0;
        while (i < additionalPaths.length) {
            path[i + 1] = new SearchPathElement(additionalPaths[i], false);
            ++i;
        }
        return path;
    }

    public static ClassLoaderFactory getClassLoaderFactory() {
        return loaderFactory;
    }

    public static ResourceLocatorFactory getResourceLocatorFactory() {
        return resourceLocatorFactory;
    }

    public static ResourceLocator createResourceLocator(Server server, StarTeamURLFactory urlFactory) throws MisconfigurationException, IOException {
        return resourceLocatorFactory.createResourceLocator(DeployerUtils.createSearchPath(server, urlFactory));
    }

    public static ServiceLocatorFactory getServiceLocatorFactory() {
        return serviceLocatorFactory;
    }

    public static ServiceLocator createServiceLocator(Server server, StarTeamURLFactory urlFactory) throws MisconfigurationException, IOException {
        return serviceLocatorFactory.createServiceLocator(DeployerUtils.createResourceLocator(server, urlFactory), loaderFactory);
    }

    protected static URL[] parseAdditionalPaths(String paths, StarTeamURLFactory urlFactory) throws MalformedURLException, IOException {
        StringTokenizer tok = new StringTokenizer(paths, ";");
        Vector<URL> v = new Vector<URL>();
        while (tok.hasMoreTokens()) {
            URL url = urlFactory.createURL(tok.nextToken());
            v.add(url);
        }
        Object[] ret = new URL[v.size()];
        v.copyInto(ret);
        return ret;
    }

    protected static String getBaseCacheDirectoryName() {
        String userHomeProperty = System.getProperty("user.home");
        if (userHomeProperty == null) {
            throw new RuntimeException("Cannot determine the location of the user's home/personal directory from the user.home system property.  Try setting the property by passing -Duser.home=path-to-home-dir on the command line to Java, or by whatever mechanism is appropriate for your runtime environment.");
        }
        String bootstrapDotStarbaseSubdirProperty = System.getProperty("st.deploy.dotstarbase.dir", ".starbase");
        String bootstrapCacheSubdirProperty = System.getProperty("st.deploy.bootstrap.subdir", ".deployer-cache");
        String defaultCacheDir = userHomeProperty + File.separator + bootstrapDotStarbaseSubdirProperty + File.separator + bootstrapCacheSubdirProperty;
        String cacheDir = System.getProperty("st.deploy.bootstrap.cache", defaultCacheDir);
        String ret = !cacheDir.endsWith(File.separator) ? cacheDir + File.separator : cacheDir;
        return ret;
    }
}

