/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.deployer;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Project;
import com.starbase.starteam.Server;
import com.starbase.starteam.StarTeamFinder;
import com.starbase.starteam.View;
import com.starbase.starteam.deployer.ClassLoaderFactory;
import com.starbase.starteam.deployer.DefaultStarTeamResourceCache;
import com.starbase.starteam.deployer.MisconfigurationException;
import com.starbase.starteam.deployer.ResourceLocator;
import com.starbase.starteam.deployer.ResourceLocatorFactory;
import com.starbase.starteam.deployer.SearchPathElement;
import com.starbase.starteam.deployer.ServiceLocator;
import com.starbase.starteam.deployer.ServiceLocatorFactory;
import com.starbase.starteam.deployer.StarTeamResourceCache;
import com.starbase.starteam.deployer.StarTeamURLFactory;
import com.starbase.starteam.deployer.StarTeamURLFactoryFactory;
import com.starbase.starteam.deployer.StarTeamURLString;
import com.starbase.util.errorhandling.NestedException;
import com.starbase.util.logging.Log;
import java.beans.Beans;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;

public class DeployerBootstrap {
    protected static final WeakHashMap m_bootstraps = new WeakHashMap();
    protected static final WeakHashMap m_logOnNames = new WeakHashMap();
    protected StarTeamResourceCache m_resourceCache;
    protected WeakReference m_serverReference;
    protected Server m_server;
    protected ClassLoaderFactory m_classLoaderFactory;
    protected String m_classLoaderFactoryImplName;
    protected ResourceLocatorFactory m_resourceLocatorFactory;
    protected String m_resourceLocatorFactoryImplName;
    protected ServiceLocatorFactory m_serviceLocatorFactory;
    protected String m_serviceLocatorFactoryImplName;
    protected StarTeamURLFactory m_urlFactory;
    protected ClassLoader m_bootstrapClassLoader;
    protected ServiceLocator m_serviceLocator;
    protected String m_baseCacheDir;
    protected String m_jarName;
    protected String m_urlFactoryFactoryImplName;
    protected String m_projectName;
    protected String m_viewName;
    protected String m_folderPath;
    protected URL m_baseResourceFolderURL;
    protected SearchPathElement[] m_defaultSearchPath;
    protected String m_additionalResourcePaths;

    public static DeployerBootstrap getOrCreateAndCacheBootstrap(Server server, StarTeamResourceCache cache, boolean strongServerReference) throws MisconfigurationException {
        DeployerBootstrap bootstrap = (DeployerBootstrap)m_bootstraps.get(server);
        if (bootstrap == null) {
            bootstrap = new DeployerBootstrap(server, cache, strongServerReference);
            m_bootstraps.put(server, bootstrap);
        }
        return bootstrap;
    }

    public static DeployerBootstrap getBootstrap(Server server) {
        return (DeployerBootstrap)m_bootstraps.get(server);
    }

    public static void putBootstrap(Server server, DeployerBootstrap bootstrap) {
        m_bootstraps.put(server, bootstrap);
    }

    public DeployerBootstrap(Server server) throws MisconfigurationException {
        this(server, null);
    }

    public DeployerBootstrap(Server server, StarTeamResourceCache cache) throws MisconfigurationException {
        this(server, cache, true);
    }

    public DeployerBootstrap(Server server, StarTeamResourceCache cache, boolean strongServerReference) throws MisconfigurationException {
        this.m_serverReference = new WeakReference<Server>(server);
        if (strongServerReference) {
            this.m_server = server;
        }
        this.m_jarName = System.getProperty("st.deploy.bootstrap.jar", "starflow-extensions.jar");
        this.m_baseCacheDir = DeployerBootstrap.getBaseCacheDirectoryName();
        this.m_resourceCache = cache != null ? cache : new DefaultStarTeamResourceCache(new java.io.File(this.m_baseCacheDir));
        try {
            this.m_resourceCache.put(server);
        }
        catch (MalformedURLException e) {
            throw new MisconfigurationException(e);
        }
        catch (IOException e) {
            throw new MisconfigurationException(e);
        }
        this.m_classLoaderFactoryImplName = System.getProperty("st.deploy.bootstrap.classloaderfactoryimpl", "com.starbase.starteam.deployer.standard.DefaultClassLoaderFactory");
        this.m_resourceLocatorFactoryImplName = System.getProperty("st.deploy.bootstrap.resourcelocatorfactoryimpl", "com.starbase.starteam.deployer.standard.DefaultResourceLocatorFactory");
        this.m_serviceLocatorFactoryImplName = System.getProperty("st.deploy.bootstrap.servicelocatorfactoryimpl", "com.starbase.starteam.deployer.standard.DefaultServiceLocatorFactory");
        this.m_urlFactoryFactoryImplName = System.getProperty("st.deploy.bootstrap.urlfactoryfactoryimpl", "com.starbase.starteam.deployer.standard.DefaultStarTeamURLFactoryFactory");
        this.m_projectName = System.getProperty("st.deploy.bootstrap.project", "StarFlow Extensions");
        this.m_viewName = System.getProperty("st.deploy.bootstrap.view", "StarFlow Extensions");
        this.m_folderPath = System.getProperty("st.deploy.bootstrap.folderpath", "Projects");
        this.m_additionalResourcePaths = System.getProperty("st.deploy.additionalresourcepaths", "");
        try {
            this.initStarTeamURLFactory();
            this.initFactories();
            this.initBaseResourceFolderURL();
            this.initDefaultSearchPath();
            this.initServiceLocator();
        }
        catch (Exception e) {
            throw new MisconfigurationException(e);
        }
    }

    public static String getBaseCacheDirectoryName() {
        String userHomeProperty = System.getProperty("user.home");
        if (userHomeProperty == null) {
            throw new RuntimeException("Cannot determine the location of the user's home/personal directory from the user.home system property.  Try setting the property by passing -Duser.home=path-to-home-dir on the command line to Java, or by whatever mechanism is appropriate for your runtime environment.");
        }
        String bootstrapDotStarbaseSubdirProperty = System.getProperty("st.deploy.dotstarbase.dir", ".starbase");
        String bootstrapCacheSubdirProperty = System.getProperty("st.deploy.bootstrap.subdir", ".deployer-cache");
        String defaultCacheDir = userHomeProperty + java.io.File.separator + bootstrapDotStarbaseSubdirProperty + java.io.File.separator + bootstrapCacheSubdirProperty;
        String cacheDir = System.getProperty("st.deploy.bootstrap.cache", defaultCacheDir);
        String ret = !cacheDir.endsWith(java.io.File.separator) ? cacheDir + java.io.File.separator : cacheDir;
        return ret;
    }

    public ServiceLocator getServiceLocator() {
        return this.m_serviceLocator;
    }

    public ResourceLocatorFactory getResourceLocatorFactory() {
        return this.m_resourceLocatorFactory;
    }

    public ClassLoaderFactory getClassLoaderFactory() {
        return this.m_classLoaderFactory;
    }

    public ServiceLocatorFactory getServiceLocatorFactory() {
        return this.m_serviceLocatorFactory;
    }

    public StarTeamURLFactory getStarTeamURLFactory() {
        return this.m_urlFactory;
    }

    public StarTeamResourceCache getResourceCache() {
        return this.m_resourceCache;
    }

    public SearchPathElement[] getSearchPath() {
        return this.m_defaultSearchPath;
    }

    public SearchPathElement[] getSearchPath(View view) {
        URL baseURL = this.getBaseResoureFolderURL();
        SearchPathElement[] sp = this.getSearchPath();
        SearchPathElement[] fullPath = new SearchPathElement[sp.length + 2];
        String projectPortion = view.getProject().getName() + "/";
        String viewPortion = projectPortion + view.getName() + "/";
        try {
            int index = 0;
            fullPath[index] = new SearchPathElement(new URL(baseURL, viewPortion), false);
            fullPath[++index] = new SearchPathElement(new URL(baseURL, projectPortion), false);
            System.arraycopy(sp, 0, fullPath, ++index, sp.length);
        }
        catch (MalformedURLException e) {
            throw new NestedException(e);
        }
        return fullPath;
    }

    public URL getBaseResoureFolderURL() {
        return this.m_baseResourceFolderURL;
    }

    public String toString() {
        Server server = this.getServer();
        return (server != null ? server.getAddress() + ":" + server.getPort() : null) + "/" + this.m_projectName + "/" + (this.m_viewName != null ? this.m_viewName : "<default view>") + "/" + this.m_folderPath + ", " + this.m_baseCacheDir + java.io.File.separator + this.m_jarName + ":" + this.m_serviceLocatorFactoryImplName;
    }

    protected void initFactories() throws MalformedURLException, IOException, ClassNotFoundException {
        if (Log.logging) {
            Log.write(500, this.toString(), "deployer");
        }
        this.initBootstrapClassLoader();
        this.m_classLoaderFactory = (ClassLoaderFactory)Beans.instantiate(this.m_bootstrapClassLoader, this.m_classLoaderFactoryImplName);
        this.m_resourceLocatorFactory = (ResourceLocatorFactory)Beans.instantiate(this.m_bootstrapClassLoader, this.m_resourceLocatorFactoryImplName);
        this.m_serviceLocatorFactory = (ServiceLocatorFactory)Beans.instantiate(this.m_bootstrapClassLoader, this.m_serviceLocatorFactoryImplName);
    }

    protected void initStarTeamURLFactory() throws MisconfigurationException, MalformedURLException, IOException, ClassNotFoundException {
        if (Log.logging) {
            Log.write(500, this.toString(), "deployer");
        }
        this.initBootstrapClassLoader();
        StarTeamURLFactoryFactory f = (StarTeamURLFactoryFactory)Beans.instantiate(this.m_bootstrapClassLoader, this.m_urlFactoryFactoryImplName);
        this.m_urlFactory = f.createStarTeamURLFactory(this.getResourceCache());
    }

    protected void initBaseResourceFolderURL() throws IOException, MalformedURLException {
        this.m_baseResourceFolderURL = this.getStarTeamURLFactory().createURL(this.getServer(), "/" + this.m_projectName + "/" + this.m_viewName + "/" + this.m_folderPath + "/");
    }

    protected void initDefaultSearchPath() throws IOException, MalformedURLException {
        URL url = this.getBaseResoureFolderURL();
        URL[] additionalPaths = this.parseAdditionalPaths(this.m_additionalResourcePaths);
        this.m_defaultSearchPath = new SearchPathElement[1 + additionalPaths.length];
        this.m_defaultSearchPath[0] = new SearchPathElement(url, false);
        int i = 0;
        while (i < additionalPaths.length) {
            this.m_defaultSearchPath[i + 1] = new SearchPathElement(additionalPaths[i], false);
            ++i;
        }
    }

    protected void initServiceLocator() throws MisconfigurationException, IOException {
        SearchPathElement[] path = this.getSearchPath();
        ResourceLocator locator = this.getResourceLocatorFactory().createResourceLocator(path);
        ClassLoaderFactory loaderFactory = this.getClassLoaderFactory();
        this.m_serviceLocator = this.m_serviceLocatorFactory.createServiceLocator(locator, loaderFactory);
    }

    protected void initBootstrapClassLoader() throws MalformedURLException, IOException, ClassNotFoundException {
        if (this.m_bootstrapClassLoader == null) {
            File repoJar = this.getBootstrapJarFromRepository();
            java.io.File jar = this.m_resourceCache.getLocalFile(repoJar);
            if (!jar.exists()) {
                throw new IOException("Failed to retrieve bootstrap implementation jar: " + this.toString());
            }
            this.m_bootstrapClassLoader = new URLClassLoader(new URL[]{jar.toURL()}, this.getClass().getClassLoader());
            if (Log.logging) {
                Log.write(500, "Created ClassLoader from " + jar.toURL(), "deployer-bootstrap");
            }
        }
    }

    protected File getBootstrapJarFromRepository() throws IOException {
        if (this.m_projectName == null || "".equals(this.m_projectName)) {
            throw new IOException("No resource project name specified: " + this.toString());
        }
        Server s = this.getServer();
        StarTeamURLString url = new StarTeamURLString(s, DeployerBootstrap.getLogOnName(s), null);
        try {
            url = new StarTeamURLString(url.getServerURLString() + this.m_projectName + "/");
        }
        catch (MalformedURLException e) {
            throw new NestedException(e);
        }
        Project resourceProject = this.getResourceCache().getProject(url, true);
        if (resourceProject == null) {
            throw new IOException(this.m_projectName + " project not found in repository: " + this.toString());
        }
        View resourceView = null;
        if (this.m_viewName == null || "".equals(this.m_viewName)) {
            resourceView = resourceProject.getDefaultView();
        } else {
            url = new StarTeamURLString(url.getProjectURLString() + this.m_viewName + "/");
            resourceView = this.getResourceCache().getView(url, true);
        }
        if (resourceView == null) {
            throw new RuntimeException(this.m_viewName + " view not found in repository: " + this.toString());
        }
        Folder f = StarTeamFinder.findFolder((Folder)resourceView.getRootFolder(), (String)this.m_folderPath);
        if (f == null) {
            throw new IOException(this.m_folderPath + " folder not found in repository: " + this.toString());
        }
        f.populateNow(f.getServer().getTypeNames().FILE, null, 0);
        File ret = StarTeamFinder.findFile((Folder)f, (String)this.m_jarName, (boolean)false);
        if (ret == null) {
            throw new IOException(this.m_jarName + " not found in repository: " + this.toString());
        }
        return ret;
    }

    protected URL[] parseAdditionalPaths(String paths) throws MalformedURLException, IOException {
        StringTokenizer tok = new StringTokenizer(paths, ";");
        Vector<URL> v = new Vector<URL>();
        while (tok.hasMoreTokens()) {
            URL url = this.getStarTeamURLFactory().createURL(tok.nextToken());
            v.add(url);
        }
        Object[] ret = new URL[v.size()];
        v.copyInto(ret);
        return ret;
    }

    protected Server getServer() {
        return (Server)this.m_serverReference.get();
    }

    public static String getLogOnName(Server server) {
        String user = (String)m_logOnNames.get(server);
        if (user == null) {
            user = server.getMyUserAccount().getLogOnName();
            m_logOnNames.put(server, user);
        }
        return user;
    }
}

