/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.deployer;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Project;
import com.starbase.starteam.Server;
import com.starbase.starteam.StarTeamFinder;
import com.starbase.starteam.Type;
import com.starbase.starteam.TypeNames;
import com.starbase.starteam.View;
import com.starbase.starteam.deployer.DeployerBootstrap;
import com.starbase.starteam.deployer.StarTeamResourceCache;
import com.starbase.starteam.deployer.StarTeamURLString;
import com.starbase.util.OLEDate;
import com.starbase.util.Platform;
import com.starbase.util.logging.Log;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class DefaultStarTeamResourceCache
implements StarTeamResourceCache {
    protected static boolean m_useIsRefreshRequired = true;
    protected static Method m_isRefreshRequired;
    protected final java.io.File m_root;
    protected final HashMap m_cache = new HashMap();

    public DefaultStarTeamResourceCache(java.io.File root) {
        if (Log.logging) {
            Log.write(500, "Creating new DefaultStarTeamResourceCache<" + this + ">", "DefaultStarTeamResourceCache");
        }
        this.m_root = root;
        if (!this.m_root.exists() && !this.m_root.mkdirs()) {
            throw new RuntimeException("Could not create cache root: " + this.m_root);
        }
    }

    public Server getServer(StarTeamURLString url, boolean createIfNecessary) {
        return (Server)this.get(url.cloneAsServerURL(), createIfNecessary);
    }

    public Project getProject(StarTeamURLString url, boolean createIfNecessary) {
        return (Project)this.get(url.cloneAsProjectURL(), createIfNecessary);
    }

    public View getView(StarTeamURLString url, boolean createIfNecessary) {
        return (View)this.get(url.cloneAsViewURL(), createIfNecessary);
    }

    public Folder getFolder(StarTeamURLString url, boolean createIfNecessary) {
        return (Folder)this.get(url.cloneAsFolderURL(), createIfNecessary);
    }

    public File getFile(StarTeamURLString url, boolean createIfNecessary) {
        return (File)this.get(url.cloneAsItemURL(), createIfNecessary);
    }

    public Item getItem(StarTeamURLString url, boolean createIfNecessary) {
        return (Item)this.get(url.cloneAsItemURL(), createIfNecessary);
    }

    public Object get(StarTeamURLString url, boolean createIfNecessary) {
        if (Log.logging) {
            Log.write(500, "get<" + this + ">: " + url + (createIfNecessary ? ", create if necessary" : ""), "DefaultStarTeamResourceCache");
        }
        Object o = null;
        Key key = Key.createSearchKey(url);
        WeakReference ref = (WeakReference)this.m_cache.get(key);
        if (ref != null) {
            if (Log.logging) {
                Log.write(500, "found<" + this + ">: " + ref + " for " + url, "DefaultStarTeamResourceCache");
            }
            if ((o = (Object)ref.get()) == null) {
                if (Log.logging) {
                    Log.write(500, "referent was gc'd<" + this + ">: " + ref + " for " + url, "DefaultStarTeamResourceCache");
                }
                this.m_cache.remove(key);
            }
        }
        if ((ref == null || o == null) && createIfNecessary) {
            o = this.openAndCache(url);
        }
        Object ret = o;
        if (Log.logging) {
            Log.write(500, "get returning<" + this + ">: " + ret + " for " + url, "DefaultStarTeamResourceCache");
        }
        return ret;
    }

    protected Object openAndCache(StarTeamURLString url) {
        File ret;
        if (Log.logging) {
            Log.write(500, "openAndCache<" + this + ">: " + url, "DefaultStarTeamResourceCache");
        }
        if (url.getItemPortion() != null) {
            Folder folder = this.getFolder(url.cloneAsFolderURL(), true);
            if (folder == null) {
                ret = null;
            } else {
                File file = StarTeamFinder.findFile((Folder)folder, (String)url.getItemPortion(), (boolean)false);
                if (file == null) {
                    ret = null;
                } else {
                    this.put((Item)file);
                    ret = file;
                }
            }
        } else if (url.getFolderPortion() != null) {
            View view = this.getView(url.cloneAsViewURL(), true);
            if (view == null) {
                ret = null;
            } else if ("/".equals(url.getFolderPortion())) {
                this.put(view.getRootFolder());
                ret = view.getRootFolder();
            } else {
                String path = url.getFolderPortion().substring("/".length());
                Folder folder = StarTeamFinder.findFolder((Folder)view.getRootFolder(), (String)path);
                if (folder == null) {
                    ret = null;
                } else {
                    this.put(folder);
                    ret = folder;
                }
            }
        } else if (url.getViewPortion() != null) {
            Project project = this.getProject(url.cloneAsProjectURL(), true);
            if (project == null) {
                ret = null;
            } else {
                View[] views = project.getViews();
                View view = null;
                int i = 0;
                while (i < views.length) {
                    if (url.getViewPortion().equalsIgnoreCase(views[i].getName())) {
                        view = views[i];
                        break;
                    }
                    ++i;
                }
                if (view != null) {
                    this.put(view);
                }
                ret = view;
            }
        } else if (url.getProjectPortion() != null) {
            Server server = this.getServer(url.cloneAsServerURL(), true);
            if (server == null) {
                ret = null;
            } else {
                Project[] projects = server.getProjects();
                Project project = null;
                int i = 0;
                while (i < projects.length) {
                    if (url.getProjectPortion().equalsIgnoreCase(projects[i].getName())) {
                        project = projects[i];
                        break;
                    }
                    ++i;
                }
                if (project != null) {
                    this.put(project);
                }
                ret = project;
            }
        } else if (url.getAuthenticationPortion() != null && url.getPassword() != null) {
            Server server;
            if (Log.logging) {
                Log.write(500, "opening connection to Server from <" + this + "> to: " + url, "DefaultStarTeamResourceCache");
            }
            if ((server = StarTeamFinder.openServer((String)(url.getAuthenticationPortion() + "@" + url.getHost() + ":" + url.getPort()))) != null) {
                this.put(server);
            }
            ret = server;
        } else {
            ret = null;
        }
        if (Log.logging) {
            Log.write(500, "openAndCache returning<" + this + ">: " + ret + " for " + url, "DefaultStarTeamResourceCache");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.io.File getLocalFile(File resource) throws IOException {
        java.io.File ret;
        if (Log.logging) {
            Log.write(500, "getLocalFile<" + this + ">: " + resource, "DefaultStarTeamResourceCache");
        }
        Server server = resource.getServer();
        synchronized (server) {
            java.io.File cacheFile = this.getCacheFile(resource);
            if (cacheFile.exists()) {
                Folder parentFolder = resource.getParentFolder();
                String originalPathFragment = parentFolder.getAlternatePathFragment();
                parentFolder.setAlternatePathFragment(cacheFile.getParentFile().getAbsolutePath());
                parentFolder.populateNow(parentFolder.getServer().getTypeNames().FILE, null, 0);
                int status = 6;
                try {
                    double timestamp = Platform.getFileLastModified((java.io.File)cacheFile);
                    int size = (int)cacheFile.length();
                    status = resource.getStatusByTime(size, new OLEDate(timestamp));
                    Object var12_9 = null;
                }
                catch (Throwable throwable) {
                    Object var12_10 = null;
                    parentFolder.setAlternatePathFragment(originalPathFragment);
                    throw throwable;
                }
                parentFolder.setAlternatePathFragment(originalPathFragment);
                if (status != 0) {
                    if (Log.logging) {
                        Log.write(500, "" + resource.getParentFolder().getFolderHierarchy() + resource + " found in ResourceCache <" + System.identityHashCode(this) + ">, but not CURRENT", "deployer-classloader");
                    }
                    this.cacheResource(resource, cacheFile);
                }
            } else {
                this.cacheResource(resource, cacheFile);
            }
            ret = cacheFile;
        }
        return ret;
    }

    public void put(Server server) {
        StarTeamURLString urlString;
        Server cached;
        if (!server.isLoggedOn()) {
            throw new IllegalArgumentException("Server must be logged on before caching.");
        }
        if (Log.logging) {
            Log.write(500, "put(Server)<" + this + ">: " + server, "DefaultStarTeamResourceCache");
        }
        if ((cached = this.getServer(urlString = new StarTeamURLString(server, DeployerBootstrap.getLogOnName(server), null), false)) == null || cached != server) {
            if (cached != null) {
                this.invalidate(urlString);
            }
            this.m_cache.put(Key.createMapKey(urlString), new WeakReference<Server>(server));
            if (Log.logging) {
                Log.write(500, "added to cache: " + server, "DefaultStarTeamResourceCache");
            }
        }
    }

    public void put(Project project) {
        StarTeamURLString urlString;
        Project cached;
        if (Log.logging) {
            Log.write(500, "put(Project)<" + this + ">: " + project.getName(), "DefaultStarTeamResourceCache");
        }
        if ((cached = this.getProject(urlString = new StarTeamURLString(project, DeployerBootstrap.getLogOnName(project.getServer()), null), false)) == null || cached != project) {
            if (cached != null) {
                this.invalidate(urlString);
            }
            this.m_cache.put(Key.createMapKey(urlString), new WeakReference<Project>(project));
            if (Log.logging) {
                Log.write(500, "added to cache: " + project.getName(), "DefaultStarTeamResourceCache");
            }
        }
    }

    public void put(View view) {
        StarTeamURLString urlString;
        View cached;
        if (Log.logging) {
            Log.write(500, "put(View)<" + this + ">: " + view.getName(), "DefaultStarTeamResourceCache");
        }
        if ((cached = this.getView(urlString = new StarTeamURLString(view, DeployerBootstrap.getLogOnName(view.getServer()), null), false)) == null || cached != view) {
            if (cached != null) {
                this.invalidate(urlString);
            }
            this.m_cache.put(Key.createMapKey(urlString), new WeakReference<View>(view));
            if (Log.logging) {
                Log.write(500, "added to cache: " + view.getName(), "DefaultStarTeamResourceCache");
            }
        }
    }

    public void put(Folder folder) {
        StarTeamURLString urlString;
        Folder cached;
        if (Log.logging) {
            Log.write(500, "put(Folder)<" + this + ">: " + folder, "DefaultStarTeamResourceCache");
        }
        if ((cached = this.getFolder(urlString = new StarTeamURLString(folder, DeployerBootstrap.getLogOnName(folder.getServer()), null), false)) == null || cached != folder) {
            if (cached != null) {
                this.invalidate(urlString);
            }
            folder.populateNow(folder.getServer().getTypeNames().FILE, null, 0);
            this.m_cache.put(Key.createMapKey(urlString), new WeakReference<Folder>(folder));
            if (Log.logging) {
                Log.write(500, "added to cache: " + folder, "DefaultStarTeamResourceCache");
            }
        }
    }

    public void put(Item item) {
        StarTeamURLString urlString;
        Item cached;
        if (Log.logging) {
            Log.write(500, "put(Item)<" + this + ">: " + item, "DefaultStarTeamResourceCache");
        }
        if ((cached = this.getItem(urlString = new StarTeamURLString(item, DeployerBootstrap.getLogOnName(item.getServer()), null), false)) == null || cached != item) {
            if (cached != null) {
                this.invalidate(urlString);
            }
            this.m_cache.put(Key.createMapKey(urlString), new WeakReference<Item>(item));
            if (Log.logging) {
                Log.write(500, "added to cache: " + item, "DefaultStarTeamResourceCache");
            }
        }
    }

    public void invalidate(StarTeamURLString namespace) {
        Object o;
        if (Log.logging) {
            Log.write(500, "invalidating<" + this + ">: " + namespace, "DefaultStarTeamResourceCache");
        }
        if ((o = this.get(namespace, false)) instanceof Folder) {
            Folder f = (Folder)o;
            TypeNames tn = f.getServer().getTypeNames();
            Vector<String> componentNames = new Vector<String>();
            componentNames.add(tn.FILE);
            componentNames.add(tn.CHANGEREQUEST);
            componentNames.add(tn.TASK);
            componentNames.add(tn.TOPIC);
            componentNames.add(tn.AUDIT);
            componentNames.add("CStRequirement");
            componentNames.add("Requirement");
            Type[] types = f.getServer().getTypes();
            int i = 0;
            while (i < types.length) {
                if (componentNames.contains(types[i].getName())) {
                    f.discardItems(types[i].getName(), -1);
                }
                ++i;
            }
        } else if (o instanceof View || o instanceof Project || o instanceof Server) {
            String thisURLString = namespace.toString().toUpperCase();
            Iterator iter = this.m_cache.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                StarTeamURLString url = ((Key)entry.getKey()).m_url;
                String otherURLString = url.toString().toUpperCase();
                if (!otherURLString.startsWith(thisURLString)) continue;
                iter.remove();
            }
        } else if (o instanceof Item) {
            ((Item)o).discard();
        }
    }

    public void invalidateAll() {
        throw new Error("not implemented");
    }

    public void clear() {
        throw new Error("not implemented");
    }

    public void purge() {
    }

    public void clearLocalFile(StarTeamURLString starTeamFile) throws IOException {
        throw new Error("not implemented");
    }

    public void clearAllLocalFiles() throws IOException {
        throw new Error("not implemented");
    }

    protected java.io.File getCacheFile(File starteamFile) {
        return new java.io.File(this.m_root.getAbsolutePath() + java.io.File.separator + starteamFile.getServer().getRepositoryID() + java.io.File.separator + starteamFile.getParentFolder().getFolderHierarchy().replace('/', java.io.File.separatorChar) + starteamFile.getDotNotation().replace('.', '_') + "_" + starteamFile.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheResource(File starteamFile, java.io.File cacheFile) throws IOException {
        if (Log.logging) {
            Log.write(500, "cacheResource<" + this + ">: " + starteamFile.getParentFolder().getFolderHierarchy() + starteamFile + " in ResourceCache <" + System.identityHashCode(this) + ">, as " + cacheFile, "DefaultStarTeamResourceCache");
        }
        Server server = starteamFile.getServer();
        synchronized (server) {
            java.io.File initialCheckout = new java.io.File(cacheFile.getParent() + java.io.File.separatorChar + starteamFile.getName());
            Folder parentFolder = starteamFile.getParentFolder();
            String originalPathFragment = parentFolder.getAlternatePathFragment();
            parentFolder.setAlternatePathFragment(cacheFile.getParentFile().getAbsolutePath());
            try {
                starteamFile.checkout(3, true, false, true);
                if (cacheFile.exists() && !cacheFile.delete()) {
                    throw new RuntimeException("Could not write to " + cacheFile + ".  Check to see that the file is " + "not in use by another application. (1)");
                }
                if (!initialCheckout.renameTo(cacheFile)) {
                    throw new RuntimeException("Could not write to " + cacheFile + ".  Check to see that the file is not " + "in use by another application. (2)");
                }
                double timestamp = Platform.getFileLastModified((java.io.File)cacheFile);
                int size = (int)cacheFile.length();
                starteamFile.updateStatusFromTime(size, new OLEDate(timestamp));
                Object var11_9 = null;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                parentFolder.setAlternatePathFragment(originalPathFragment);
                throw throwable;
            }
            parentFolder.setAlternatePathFragment(originalPathFragment);
        }
    }

    protected static class Key {
        protected final StarTeamURLString m_url;
        protected final boolean m_mapKey;

        private Key(StarTeamURLString url, boolean mapKey) {
            StarTeamURLString urlSansPassword;
            this.m_url = urlSansPassword = url.cloneWithoutPassword();
            this.m_mapKey = mapKey;
        }

        protected static Key createMapKey(StarTeamURLString url) {
            return new Key(url, true);
        }

        protected static Key createSearchKey(StarTeamURLString url) {
            return new Key(url, false);
        }

        public int hashCode() {
            return this.m_url.hashCode();
        }

        public boolean equals(Object o) {
            boolean ret;
            if (o instanceof Key) {
                StarTeamURLString searchURL;
                StarTeamURLString mapURL;
                Key other = (Key)o;
                if (this.m_mapKey) {
                    mapURL = other.m_url.getAuthenticationPortion() == null ? this.m_url.cloneWithoutUserInfo() : this.m_url;
                    searchURL = other.m_url;
                } else if (other.m_mapKey) {
                    mapURL = this.m_url.getAuthenticationPortion() == null ? other.m_url.cloneWithoutUserInfo() : other.m_url;
                    searchURL = this.m_url;
                } else {
                    mapURL = this.m_url;
                    searchURL = other.m_url;
                }
                ret = searchURL.equals(mapURL);
            } else {
                ret = false;
            }
            return ret;
        }

        public String toString() {
            return this.m_url.toString();
        }
    }
}

