/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class UnGuardedHashtable
extends Dictionary
implements Cloneable,
Serializable {
    private transient HashtableEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private static final long serialVersionUID = 1421746759512286392L;

    public UnGuardedHashtable() {
        this(101, 0.75f);
    }

    public UnGuardedHashtable(int n) {
        this(n, 0.75f);
    }

    public UnGuardedHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new HashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    protected boolean areEqual(Object object, Object object2) {
        return object.equals(object2);
    }

    public void clear() {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = hashtableEntryArray.length;
        while (--n >= 0) {
            hashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            UnGuardedHashtable unGuardedHashtable = (UnGuardedHashtable)super.clone();
            unGuardedHashtable.table = new HashtableEntry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                unGuardedHashtable.table[n] = this.table[n] != null ? (HashtableEntry)this.table[n].clone() : null;
            }
            UnGuardedHashtable unGuardedHashtable2 = unGuardedHashtable;
            return unGuardedHashtable2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = hashtableEntryArray.length;
        while (n-- > 0) {
            HashtableEntry hashtableEntry = hashtableEntryArray[n];
            while (hashtableEntry != null) {
                if (this.areEqual(hashtableEntry.value, object)) {
                    return true;
                }
                hashtableEntry = hashtableEntry.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = this.getHash(object);
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && this.areEqual(hashtableEntry.key, object)) {
                return true;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return false;
    }

    public Enumeration elements() {
        return new HashtableEnumerator(this, this.table, false);
    }

    public Object get(Object object) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = this.getHash(object);
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && this.areEqual(hashtableEntry.key, object)) {
                return hashtableEntry.value;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    protected int getHash(Object object) {
        return object.hashCode();
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new HashtableEnumerator(this, this.table, true);
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = this.getHash(object);
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && this.areEqual(hashtableEntry.key, object)) {
                Object object3 = hashtableEntry.value;
                hashtableEntry.value = object2;
                return object3;
            }
            hashtableEntry = hashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(object, object2);
        }
        hashtableEntry = new HashtableEntry();
        hashtableEntry.hash = n;
        hashtableEntry.key = object;
        hashtableEntry.value = object2;
        hashtableEntry.next = hashtableEntryArray[n2];
        hashtableEntryArray[n2] = hashtableEntry;
        ++this.count;
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.loadFactor) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.table = new HashtableEntry[n3];
        this.count = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            --n2;
        }
    }

    protected void rehash() {
        int n = this.table.length;
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        HashtableEntry[] hashtableEntryArray2 = new HashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = hashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            HashtableEntry hashtableEntry = hashtableEntryArray[n3];
            while (hashtableEntry != null) {
                HashtableEntry hashtableEntry2 = hashtableEntry;
                hashtableEntry = hashtableEntry.next;
                int n4 = (hashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                hashtableEntry2.next = hashtableEntryArray2[n4];
                hashtableEntryArray2[n4] = hashtableEntry2;
            }
        }
    }

    public Object remove(Object object) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = this.getHash(object);
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        HashtableEntry hashtableEntry2 = null;
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && this.areEqual(hashtableEntry.key, object)) {
                if (hashtableEntry2 != null) {
                    hashtableEntry2.next = hashtableEntry.next;
                } else {
                    hashtableEntryArray[n2] = hashtableEntry.next;
                }
                --this.count;
                return hashtableEntry.value;
            }
            hashtableEntry2 = hashtableEntry;
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append("=").append(string2))));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        for (int i = this.table.length - 1; i >= 0; --i) {
            HashtableEntry hashtableEntry = this.table[i];
            while (hashtableEntry != null) {
                objectOutputStream.writeObject(hashtableEntry.key);
                objectOutputStream.writeObject(hashtableEntry.value);
                hashtableEntry = hashtableEntry.next;
            }
        }
    }

    static {
        serialVersionUID = 1421746759512286392L;
    }

    class HashtableEnumerator
    implements Enumeration {
        boolean keys;
        int index;
        HashtableEntry[] table;
        HashtableEntry entry;

        HashtableEnumerator(UnGuardedHashtable unGuardedHashtable, HashtableEntry[] hashtableEntryArray, boolean bl) {
            this.table = hashtableEntryArray;
            this.keys = bl;
            this.index = hashtableEntryArray.length;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                HashtableEntry hashtableEntry = this.entry;
                this.entry = hashtableEntry.next;
                return this.keys ? hashtableEntry.key : hashtableEntry.value;
            }
            throw new NoSuchElementException("HashtableEnumerator");
        }
    }

    class HashtableEntry {
        int hash;
        Object key;
        Object value;
        HashtableEntry next;

        HashtableEntry() {
        }

        protected Object clone() {
            HashtableEntry hashtableEntry = new HashtableEntry();
            hashtableEntry.hash = this.hash;
            hashtableEntry.key = this.key;
            hashtableEntry.value = this.value;
            hashtableEntry.next = this.next != null ? (HashtableEntry)this.next.clone() : null;
            return hashtableEntry;
        }
    }
}

