/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Trc {
    private static final transient String TRACE_VERSION = "00.00.00.A1.05";
    private static final transient String TRACE_SEP = "|";
    private static final transient String MODE_ENTER = ">";
    private static final transient String MODE_PRINTLN = "P";
    private static final transient String MODE_RETURN = "<";
    private static final transient String MODE_FINALIZE = "F";
    private static final transient String MODE_UNKNOWN = "?";
    private static final transient int MODE_CODE_ENTER = 1;
    private static final transient int MODE_CODE_PRINTLN = 2;
    private static final transient int MODE_CODE_RETURN = 3;
    private static final transient int MODE_CODE_FINALIZE = 4;
    private static transient boolean useFinalizers;
    private static transient boolean globalsSet;
    private static transient boolean disabled;
    private static transient boolean stackLineUnknown;
    private static transient int stackLine;
    private static transient long traceCount;
    private static transient boolean firstTraceCall;
    private static transient boolean logDepth;
    private static transient boolean logThread;
    private static transient boolean logType;
    private static transient boolean logHash;
    private static transient boolean logRetType;
    private static transient boolean logPackage;
    private static transient boolean logClass;
    private static transient boolean logMethod;
    private static transient boolean logParams;
    private static transient boolean logComment;
    private transient String threadName;
    private transient String hashName;
    private transient String typeName;
    private transient Class tracedClass;
    private transient String tracedClassName;
    private transient String stackedPackageName;
    private transient String stackedClassName;
    private transient String stackedMethodName;
    private transient String stackedParameters;
    private transient String stackedReturnType;
    private transient boolean isConstructor;
    private transient long traceDepth;
    private transient String traceText;
    private static transient String traceFileName;
    private static transient OutputStreamWriter outWriter;
    private static transient PrintStream outStream;
    private transient boolean error;
    private transient String errorMsg;

    public Trc(Object object) {
        if (!disabled) {
            try {
                long l = traceCount++;
                this.threadInit(object);
                if (firstTraceCall) {
                    this.logHeader();
                }
                this.getStackedMethod();
                this.logLine(l, null, 1);
            }
            catch (Exception exception) {
                this.panic(exception.toString());
            }
            if (this.error) {
                disabled = true;
            }
        }
    }

    public Trc(Object object, String string) {
        if (!disabled) {
            try {
                long l = traceCount++;
                this.threadInit(object);
                if (firstTraceCall) {
                    this.logHeader();
                }
                this.getStackedMethod();
                this.logLine(l, string, 1);
            }
            catch (Exception exception) {
                this.panic(exception.toString());
            }
            if (this.error) {
                disabled = true;
            }
        }
    }

    private void getStackedMethod() {
        String string = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            new Exception("Trc Exception used to generate a stack dump - ignore me!").printStackTrace(printWriter);
            string = stringWriter.toString();
        }
        catch (Exception exception) {
            this.errorMsg = exception.toString();
            this.error = true;
        }
        if (string == null) {
            this.error = true;
        }
        if (!this.error && stackLineUnknown) {
            this.parseStackDump(string);
        } else {
            this.ripStackDump(string);
        }
    }

    private void logHeader() {
        if (outStream == null && outWriter == null) {
            System.err.println("TRC(00.00.00.A1.05) : No destination specified for execution trace output. Trace disabled.");
            this.error = true;
        } else if (outStream != System.out && outStream != System.err && outWriter != null) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("TRC(00.00.00.A1.05) : Execution trace output is being written to ").append(traceFileName).append("."))));
        }
        String string = String.valueOf(String.valueOf(new StringBuffer("TRC(00.00.00.A1.05) : Trace output for thread \"").append(Thread.currentThread().toString()).append("\"\n").append("Key : ").append(TRACE_SEP).append("Mode").append(TRACE_SEP).append("Count").append(logDepth ? "|Depth" : "").append(logThread ? "|Thread" : "").append(logType ? "|Class/Iface" : "").append(logHash ? "|Hash" : "").append(logRetType ? "|ReturnType" : "").append(logPackage ? "|Package" : "").append(logClass ? "|Class" : "").append(logMethod ? "|Method" : "").append(logParams ? "|(Parameters)" : "").append(logComment ? "|UserComment" : "").append(TRACE_SEP).append("\n").append("(Usefull parameter information may not be availiable under the 1.2 JVM.)\n")));
        if (outWriter != null) {
            try {
                outWriter.write(string);
            }
            catch (IOException iOException) {
                this.errorMsg = iOException.toString();
                this.error = true;
            }
        }
        if (outStream != null) {
            outStream.print(string);
            if (outWriter != null) {
                outStream.print(String.valueOf(String.valueOf(new StringBuffer("(Execution trace output is also being written to ").append(traceFileName).append(")\n"))));
            }
            outStream.print("\n");
        }
        firstTraceCall = false;
    }

    private void logLine(long l, String string, int n) {
        String string2;
        switch (n) {
            case 1: {
                string2 = MODE_ENTER;
                break;
            }
            case 3: {
                string2 = MODE_RETURN;
                if (this.traceDepth >= (long)0) break;
                this.error = true;
                break;
            }
            case 4: {
                string2 = MODE_FINALIZE;
                if (this.traceDepth >= (long)0) break;
                this.error = true;
                break;
            }
            case 2: {
                string2 = MODE_PRINTLN;
                break;
            }
            default: {
                string2 = MODE_UNKNOWN;
                this.error = true;
            }
        }
        String string3 = null;
        if (!this.error) {
            this.traceText = String.valueOf(String.valueOf(new StringBuffer(TRACE_SEP).append(new Long(l).toString()).append(logDepth ? "|?" : "").append(logThread ? TRACE_SEP.concat(String.valueOf(String.valueOf(this.threadName))) : "").append(logType ? TRACE_SEP.concat(String.valueOf(String.valueOf(this.typeName))) : "").append(logHash ? TRACE_SEP.concat(String.valueOf(String.valueOf(this.hashName))) : "").append(logRetType ? TRACE_SEP.concat(String.valueOf(String.valueOf(this.stackedReturnType))) : "").append(logPackage ? TRACE_SEP.concat(String.valueOf(String.valueOf(this.stackedPackageName))) : "").append(logClass ? TRACE_SEP.concat(String.valueOf(String.valueOf(this.stackedClassName))) : "").append(logMethod ? TRACE_SEP.concat(String.valueOf(String.valueOf(this.stackedMethodName))) : "").append(logParams ? TRACE_SEP.concat(String.valueOf(String.valueOf(this.stackedParameters))) : "")));
            string3 = string == null ? "" : string;
        } else {
            this.traceText = TRACE_SEP.concat(String.valueOf(String.valueOf(new Long(l).toString())));
            if (this.errorMsg == null || this.errorMsg.length() == 0) {
                this.errorMsg = "Error detected. Trace will beb disabled for this thread";
            }
            string3 = this.errorMsg;
        }
        String string4 = String.valueOf(String.valueOf(new StringBuffer(TRACE_SEP).append(string2).append(this.traceText).append(logComment ? TRACE_SEP.concat(String.valueOf(String.valueOf(string3))) : "").append(TRACE_SEP).append('\n')));
        if (outWriter != null) {
            try {
                outWriter.write(string4);
                outWriter.flush();
            }
            catch (IOException iOException) {
                this.errorMsg = iOException.toString();
                this.error = true;
            }
        }
        if (outStream != null) {
            outStream.print(string4);
            outStream.flush();
        }
    }

    private void panic(String string) {
        this.error = true;
        this.errorMsg = string;
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("Trc : Unexpected Exception \"").append(this.errorMsg).append("\". Trace disabled for thread ").append(Thread.currentThread().toString()))));
    }

    private void parseStackDump(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string2 = this.getClass().getName();
        int n5 = string2.length();
        this.error = true;
        stackLine = 0;
        while (n2 >= 0) {
            n = n2;
            n2 = string.indexOf(string2, n + n5);
        }
        if (n > 0 && (n3 = string.indexOf(10, n + n5)) >= 0 && n3 < (n4 = string.indexOf(10, n3 + 1))) {
            int n6 = n3 - 1;
            while (n6 >= 0) {
                ++stackLine;
                n6 = string.lastIndexOf(10, n6 - 1);
            }
            if (stackLine >= 0) {
                this.parseStackedMethod(string, n3, n4);
                stackLineUnknown = false;
                this.error = false;
            }
        }
    }

    private void parseStackedMethod(String string, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        n3 = string.lastIndexOf(40, n2);
        this.stackedParameters = string.substring(n3, n2);
        this.isConstructor = string.indexOf(32, n) >= n3;
        n4 = string.lastIndexOf(46, n3 - 1);
        this.stackedMethodName = string.substring(n4 + 1, n3);
        if (this.isConstructor) {
            this.stackedClassName = this.stackedMethodName;
            n5 = n4;
            this.stackedMethodName = "<init>";
        } else {
            n5 = string.lastIndexOf(46, n4 - 1);
            this.stackedClassName = string.substring(n5 + 1, n4);
        }
        n6 = string.lastIndexOf(this.isConstructor ? 9 : 32, n5 - 1);
        this.stackedPackageName = string.substring(n6 + 1, n5);
        if (this.isConstructor) {
            this.stackedReturnType = "";
        } else {
            n7 = string.lastIndexOf(9, n6 - 1);
            this.stackedReturnType = string.substring(n7 + 1, n6);
        }
    }

    public void println(String string) {
        if (!disabled) {
            try {
                long l = traceCount++;
                if (firstTraceCall) {
                    this.error = true;
                }
                this.getStackedMethod();
                this.logLine(l, string, 2);
            }
            catch (Exception exception) {
                this.panic(exception.toString());
            }
            if (this.error) {
                disabled = true;
            }
        }
    }

    protected void ret() {
        if (!disabled) {
            try {
                long l = traceCount++;
                if (firstTraceCall) {
                    this.error = true;
                }
                this.getStackedMethod();
                this.logLine(l, null, 3);
            }
            catch (Exception exception) {
                this.panic(exception.toString());
            }
            if (this.error) {
                disabled = true;
            }
        }
    }

    private void ripStackDump(String string) {
        this.error = true;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i <= stackLine; ++i) {
            n2 = string.indexOf(10, n2 + 1);
        }
        if (n2 > 0 && (n = string.lastIndexOf(10, n2 - 1)) >= 0) {
            this.parseStackedMethod(string, n, n2);
            this.error = false;
        }
    }

    private void threadInit(Object object) {
        try {
            if (outWriter == null) {
                outWriter = new FileWriter(traceFileName);
            }
        }
        catch (IOException iOException) {
            this.errorMsg = iOException.toString();
            this.error = true;
        }
        this.tracedClass = object.getClass();
        this.tracedClassName = this.tracedClass.getName();
        this.threadName = Thread.currentThread().toString();
        this.hashName = Integer.toHexString(this.tracedClass.hashCode()).toUpperCase();
        this.typeName = this.tracedClass.isInterface() ? "I" : "C";
    }

    static {
        TRACE_VERSION = TRACE_VERSION;
        TRACE_SEP = TRACE_SEP;
        MODE_ENTER = MODE_ENTER;
        MODE_PRINTLN = MODE_PRINTLN;
        MODE_RETURN = MODE_RETURN;
        MODE_FINALIZE = MODE_FINALIZE;
        MODE_UNKNOWN = MODE_UNKNOWN;
        MODE_CODE_ENTER = 1;
        MODE_CODE_PRINTLN = 2;
        MODE_CODE_RETURN = 3;
        MODE_CODE_FINALIZE = 4;
        useFinalizers = false;
        globalsSet = false;
        disabled = false;
        stackLineUnknown = true;
        stackLine = 0;
        traceCount = 0L;
        firstTraceCall = true;
        logDepth = false;
        logThread = false;
        logType = false;
        logHash = false;
        logRetType = false;
        logPackage = false;
        logClass = true;
        logMethod = true;
        logParams = true;
        logComment = true;
        traceFileName = "trc.log";
        outWriter = null;
        outStream = null;
    }
}

