/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

import java.io.File;
import java.util.StringTokenizer;

public final class StringFunctions {
    public static boolean ArrayContainsString(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String ArrayToString(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        String string2 = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(string).append(stringArray[i])));
        }
        return string2;
    }

    public static String ISOLatin1CharToPrintable(char c, boolean bl) {
        switch (c) {
            case '\\': {
                return "\\\\";
            }
            case '\"': {
                return "\\\"";
            }
            case '\'': {
                return "\\'";
            }
        }
        if (c >= ' ' && c <= '~') {
            return "".concat(String.valueOf(String.valueOf(c)));
        }
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\b': {
                return "\\b";
            }
            case '\r': {
                return "\\r";
            }
            case '\f': {
                return "\\f";
            }
            case '\u0007': {
                if (!bl) {
                    return "\\a";
                }
            }
            case '\u000b': {
                if (bl) break;
                return "\\v";
            }
        }
        char c2 = c;
        char c3 = (char)(48 + (c2 >> 6));
        char c4 = (char)(48 + (c2 >> 3 & 7));
        char c5 = (char)(48 + (c2 & 7));
        return String.valueOf(String.valueOf(new StringBuffer("\\").append(c3).append(c4).append(c5)));
    }

    public static String ISOLatin1NoInvisibles(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c < '\u007f') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(StringFunctions.ISOLatin1CharToPrintable(c, true));
        }
        return stringBuffer.toString();
    }

    public static String ISOLatin1StringToPrintable(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(StringFunctions.ISOLatin1CharToPrintable(string.charAt(i), bl));
        }
        return stringBuffer.toString();
    }

    public static String ISOLatin1ToUnicode(String string) {
        int n = string.length();
        if (string.indexOf(92) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                String string2;
                char c2;
                if (i == n) {
                    StringFunctions.bogusEscape(string);
                }
                if ((c2 = string.charAt(++i)) == 'x' || c2 == 'X') {
                    int n2;
                    string2 = "";
                    for (n2 = i + 1; n2 < n && StringFunctions.isHex(c = string.charAt(n2)); ++n2) {
                        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(c)));
                    }
                    if (string2.length() == 0) {
                        StringFunctions.bogusEscape(string);
                    }
                    stringBuffer.append((char)StringFunctions.translateHexLiteral(string2, true));
                    i = n2 - 1;
                    continue;
                }
                if (c2 >= '0' && c2 <= '7') {
                    string2 = "".concat(String.valueOf(String.valueOf(c2)));
                    if (i + 1 < n && (c = string.charAt(i + 1)) >= '0' && c <= '7') {
                        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(c)));
                        if (++i + 1 < n && (c = string.charAt(i + 1)) >= '0' && c <= '7') {
                            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(c)));
                            ++i;
                        }
                    }
                    stringBuffer.append((char)StringFunctions.translateOctalLiteral(string2, true));
                    continue;
                }
                try {
                    stringBuffer.append((char)StringFunctions.translateCharacterLiteral(String.valueOf(String.valueOf(new StringBuffer("'\\").append(c2).append("'"))), false));
                }
                catch (NumberFormatException numberFormatException) {
                    StringFunctions.bogusEscape(string);
                }
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static void bogusEscape(String string) {
        throw new IllegalArgumentException("Util.StringLit.invalidEscape");
    }

    public static boolean isEqual(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        if (stringArray.length == stringArray2.length) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(stringArray2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static String prepFilename(String string) {
        return File.separatorChar == '\\' ? StringFunctions.stringize(string.replace('\\', '\u007f'), true, false).replace('\u007f', '\\') : StringFunctions.stringize(string, true, false);
    }

    public static String replaceString(String string, String string2, String string3) {
        return StringFunctions.ArrayToString(StringFunctions.toStringArray(string, string2), string3);
    }

    public static String stringize(String string, boolean bl, boolean bl2) {
        if (bl) {
            string = String.valueOf(String.valueOf(new StringBuffer("\"").append(string).append("\"")));
        }
        block0: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\"' && c != '\'') continue;
            char c2 = c;
            if (c2 == '\"') {
                string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string.substring(0, i)))).append('\\').append(string.substring(i))));
                i += 2;
            } else {
                ++i;
            }
            while (i < string.length()) {
                char c3 = string.charAt(i);
                if (c3 == '\\') {
                    if ((i += 2) < (string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string.substring(0, i)))).append('\\').append(string.substring(i))))).length() && string.charAt(i) == c2) {
                        string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string.substring(0, i)))).append('\\').append(string.substring(i))));
                        i += 2;
                    }
                    --i;
                } else if (c3 == c2) {
                    if (c2 != '\"') continue block0;
                    string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string.substring(0, i)))).append('\\').append(string.substring(i))));
                    ++i;
                    continue block0;
                }
                ++i;
            }
        }
        if (bl) {
            string = string.substring(2, string.length() - 2);
        }
        return bl2 ? String.valueOf(String.valueOf(new StringBuffer("\"").append(string).append("\""))) : string;
    }

    public static int toInt(char c) {
        return c >= '0' && c <= '9' ? c - 48 : (c >= 'A' && c <= 'F' ? c - 65 + 10 : (c >= 'a' && c <= 'f' ? c - 97 + 10 : -1));
    }

    public static String[] toStringArray(String string, String string2) {
        StringTokenizer stringTokenizer;
        int n;
        String[] stringArray = null;
        if (string != null && (n = (stringTokenizer = new StringTokenizer(string, string2)).countTokens()) != 0) {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
        }
        return stringArray;
    }

    public static long translateCharacterLiteral(String string, boolean bl) throws NumberFormatException {
        if ((string = string.substring(1, string.length() - 1)).length() == 1 && string.charAt(0) != '\\') {
            return string.charAt(0);
        }
        if (string.charAt(0) != '\\') {
            throw new NumberFormatException("Util.CharLit.malformed");
        }
        string = string.substring(1);
        int n = string.length();
        char c = string.charAt(0);
        if (n == 1) {
            switch (c) {
                case 'n': {
                    return 10L;
                }
                case 't': {
                    return 9L;
                }
                case 'v': {
                    return 11L;
                }
                case 'b': {
                    return 8L;
                }
                case 'r': {
                    return 13L;
                }
                case 'f': {
                    return 12L;
                }
                case 'a': {
                    return 7L;
                }
                case '\\': {
                    return 92L;
                }
                case '?': {
                    return 63L;
                }
                case '\'': {
                    return 39L;
                }
                case '\"': {
                    return 34L;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    return c - 48;
                }
            }
            throw new NumberFormatException("Util.CharLit.unrecognizedEscape");
        }
        if (c == 'x' || c == 'X') {
            if (n == 1) {
                throw new NumberFormatException("Util.HexLit.malformed");
            }
            for (int i = 1; i < n; ++i) {
                if (StringFunctions.isHex(string.charAt(i))) continue;
                throw new NumberFormatException("Util.HexLit.malformed");
            }
            return StringFunctions.translateHexLiteral(string.substring(1), true);
        }
        if (c >= '0' && c <= '7') {
            for (int i = 0; i < n; ++i) {
                if (string.charAt(i) >= '0' && string.charAt(i) <= '7') continue;
                throw new NumberFormatException("Util.OctalLit.malformed");
            }
            return StringFunctions.translateOctalLiteral(string, true);
        }
        if (bl && c == 'u') {
            long l = 0L;
            int n2 = 1;
            while ((c = string.charAt(n2)) == 'u') {
                ++n2;
            }
            if (n - n2 != 4) {
                throw new NumberFormatException("Util.CharLit.malformedUnicode");
            }
            while (n2 < n) {
                c = string.charAt(n2);
                if (!StringFunctions.isHex(c)) {
                    throw new NumberFormatException("Util.CharLit.malformedUnicode");
                }
                l = (l << 8) + (long)StringFunctions.toInt(c);
                ++n2;
            }
            return l;
        }
        throw new NumberFormatException("Util.CharLit.unrecognizedEscape");
    }

    public static long translateHexLiteral(String string, boolean bl) throws NumberFormatException {
        long l = 0L;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            long l2 = c >= '0' && c <= '9' ? (long)(c - 48) : (c >= 'a' && c <= 'f' ? (long)(c - 97 + 10) : (long)(c - 65 + 10));
            long l3 = l * (long)16 + l2;
            if (bl && l3 > (long)255 || !bl && l < 0L && l3 >= 0L) {
                throw new NumberFormatException("Util.HexLit.overflow");
            }
            l = l3;
        }
        return l;
    }

    public static long translateOctalLiteral(String string, boolean bl) throws NumberFormatException {
        long l = string.charAt(0) - 48;
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            long l2 = l * (long)8 + (long)string.charAt(i) - (long)48;
            if (bl && i == 2) {
                if (l2 > (long)255) {
                    throw new NumberFormatException("Util.OctalLit.overflow");
                }
                if (i < n - 1) {
                    throw new NumberFormatException("Util.OctalLit.malformed");
                }
                return l2;
            }
            if (!bl && l < 0L && l2 >= 0L) {
                throw new NumberFormatException("Util.OctalLit.overflow");
            }
            l = l2;
        }
        return l;
    }

    public static long translateWideCharacterLiteral(String string, boolean bl) throws NumberFormatException {
        int n;
        string = string.substring(1, string.length() - 1);
        int n2 = string.length();
        long l = 0L;
        block2: for (n = 0; n < 7 && n2 > 0; ++n) {
            int n3 = 0;
            for (int i = 1; i < n2; ++i) {
                int n4 = 0;
                try {
                    String string2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf('\''))).append(string.substring(0, i)).append('\'')));
                    n4 = (byte)StringFunctions.translateCharacterLiteral(string2, bl);
                    n3 = i;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    if (n3 <= 0) continue;
                    l |= (long)(n4 << n * 8);
                    string = string.substring(i - 1, n2);
                    n2 = string.length();
                    continue block2;
                }
            }
        }
        if (n == 0 || n2 > 0) {
            throw new NumberFormatException("Util.WideCharLit.malformed");
        }
        return l;
    }
}

