/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

import com.inprise.vbroker.util.RWFlag;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public abstract class Introspector {
    private static final Class[] writeObjectArgs = new Class[]{class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = Introspector.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream};
    private static final Class[] readObjectArgs = new Class[]{class$java$io$ObjectInputStream == null ? (class$java$io$ObjectInputStream = Introspector.class$("java.io.ObjectInputStream")) : class$java$io$ObjectInputStream};
    private static final int READ = 1;
    private static final int READSET = 2;
    private static final int WRITE = 4;
    private static final int WRITESET = 8;
    private static Hashtable RWCache;
    static Class class$java$io$ObjectOutputStream;
    static Class class$java$io$ObjectInputStream;

    public static boolean hasReadObject(Class clazz) throws SecurityException {
        RWFlag rWFlag = (RWFlag)RWCache.get(clazz);
        if (rWFlag == null) {
            rWFlag = new RWFlag();
            RWCache.put(clazz, rWFlag);
        }
        if ((rWFlag.val & 2) != 2) {
            try {
                Method method = clazz.getDeclaredMethod("readObject", readObjectArgs);
                int n = method.getModifiers();
                if (!Modifier.isPrivate(n) || Modifier.isStatic(n) || Modifier.isAbstract(n)) {
                    throw new NoSuchMethodException();
                }
                if (method.getReturnType() != Void.TYPE) {
                    throw new NoSuchMethodException();
                }
                rWFlag.val |= 3;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                rWFlag.val |= 2;
            }
        }
        return (rWFlag.val & 1) == 1;
    }

    public static boolean hasWriteObject(Class clazz) throws SecurityException {
        RWFlag rWFlag = (RWFlag)RWCache.get(clazz);
        if (rWFlag == null) {
            rWFlag = new RWFlag();
            RWCache.put(clazz, rWFlag);
        }
        if ((rWFlag.val & 8) != 8) {
            try {
                Method method = clazz.getDeclaredMethod("writeObject", writeObjectArgs);
                int n = method.getModifiers();
                if (!Modifier.isPrivate(n) || Modifier.isStatic(n) || Modifier.isAbstract(n)) {
                    throw new NoSuchMethodException();
                }
                if (method.getReturnType() != Void.TYPE) {
                    throw new NoSuchMethodException();
                }
                rWFlag.val |= 0xC;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                rWFlag.val |= 8;
            }
        }
        return (rWFlag.val & 4) == 4;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        READ = 1;
        READSET = 2;
        WRITE = 4;
        WRITESET = 8;
        RWCache = new Hashtable();
    }
}

