/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.backends.idl.ast;

import com.inprise.vbroker.compiler.ast.AliasNode;
import com.inprise.vbroker.compiler.ast.ArrayNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.FixedNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.ast.SequenceNode;
import com.inprise.vbroker.compiler.ast.StringNode;
import com.inprise.vbroker.compiler.ast.StructNode;
import com.inprise.vbroker.compiler.ast.TypeMapper;
import com.inprise.vbroker.compiler.ast.UnionNode;
import com.inprise.vbroker.compiler.ast.ValueBoxNode;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.ast.WStringNode;
import com.inprise.vbroker.compiler.backends.common.CommonOptions;

public class IDLMapper
extends TypeMapper {
    public IDLMapper(CommonOptions commonOptions) {
        super(commonOptions);
    }

    protected final String context2string(int n) {
        return null;
    }

    public String fullName(ContainedNode containedNode, String string) {
        this._buf.reset();
        if (containedNode._container.kind() != 17) {
            this._buf.append(((ContainedNode)((Object)containedNode._container))._beFullName);
        }
        this._buf.append("::");
        this._buf.append(string);
        return this._buf.toString();
    }

    protected void initializeKeywordAvoider() {
        this._keywordAvoider.caseSensitive(false);
        this._keywordAvoider.avoid("FALSE");
        this._keywordAvoider.avoid("Object");
        this._keywordAvoider.avoid("TRUE");
        this._keywordAvoider.avoid("ValueBase");
        this._keywordAvoider.avoid("abstract");
        this._keywordAvoider.avoid("any");
        this._keywordAvoider.avoid("attribute");
        this._keywordAvoider.avoid("boolean");
        this._keywordAvoider.avoid("case");
        this._keywordAvoider.avoid("char");
        this._keywordAvoider.avoid("const");
        this._keywordAvoider.avoid("context");
        this._keywordAvoider.avoid("custom");
        this._keywordAvoider.avoid("default");
        this._keywordAvoider.avoid("double");
        this._keywordAvoider.avoid("enum");
        this._keywordAvoider.avoid("exception");
        this._keywordAvoider.avoid("factory");
        this._keywordAvoider.avoid("fixed");
        this._keywordAvoider.avoid("float");
        this._keywordAvoider.avoid("in");
        this._keywordAvoider.avoid("inout");
        this._keywordAvoider.avoid("interface");
        this._keywordAvoider.avoid("long");
        this._keywordAvoider.avoid("module");
        this._keywordAvoider.avoid("octet");
        this._keywordAvoider.avoid("oneway");
        this._keywordAvoider.avoid("out");
        this._keywordAvoider.avoid("private");
        this._keywordAvoider.avoid("public");
        this._keywordAvoider.avoid("raises");
        this._keywordAvoider.avoid("readonly");
        this._keywordAvoider.avoid("sequence");
        this._keywordAvoider.avoid("short");
        this._keywordAvoider.avoid("string");
        this._keywordAvoider.avoid("struct");
        this._keywordAvoider.avoid("supports");
        this._keywordAvoider.avoid("switch");
        this._keywordAvoider.avoid("truncatable");
        this._keywordAvoider.avoid("typedef");
        this._keywordAvoider.avoid("union");
        this._keywordAvoider.avoid("unsigned");
        this._keywordAvoider.avoid("valuetype");
        this._keywordAvoider.avoid("void");
        this._keywordAvoider.avoid("wchar");
        this._keywordAvoider.avoid("wstring");
    }

    public String map(AliasNode aliasNode, int n, ContainerNode containerNode) {
        return this.relativeName(aliasNode, containerNode);
    }

    public String map(ArrayNode arrayNode, int n, ContainerNode containerNode) {
        this._buf.reset();
        this._buf.append(this.map(arrayNode._type, n, containerNode));
        this._buf.append('[');
        this._buf.append(Integer.toString(arrayNode._length));
        this._buf.append(']');
        return this._buf.toString();
    }

    public String map(EnumNode enumNode, int n, ContainerNode containerNode) {
        return this.relativeName(enumNode, containerNode);
    }

    public String map(ExceptionNode exceptionNode, int n, ContainerNode containerNode) {
        return this.relativeName(exceptionNode, containerNode);
    }

    public String map(FixedNode fixedNode, int n, ContainerNode containerNode) {
        return "fixed";
    }

    public String map(InterfaceNode interfaceNode, int n, ContainerNode containerNode) {
        return this.relativeName(interfaceNode, containerNode);
    }

    public String map(PrimitiveNode primitiveNode, int n, ContainerNode containerNode) {
        return primitiveNode.typeName();
    }

    public String map(SequenceNode sequenceNode, int n, ContainerNode containerNode) {
        this._buf.reset();
        this._buf.append('<');
        this._buf.append(this.map(sequenceNode._type, n, containerNode));
        if (sequenceNode._bound > 0) {
            this._buf.append(',');
            this._buf.append(Integer.toString(sequenceNode._bound));
        }
        this._buf.append('>');
        return "sequence".concat(String.valueOf(String.valueOf(this._buf.toString())));
    }

    public String map(StringNode stringNode, int n, ContainerNode containerNode) {
        return "string";
    }

    public String map(StructNode structNode, int n, ContainerNode containerNode) {
        return this.relativeName(structNode, containerNode);
    }

    public String map(UnionNode unionNode, int n, ContainerNode containerNode) {
        return this.relativeName(unionNode, containerNode);
    }

    public String map(ValueBoxNode valueBoxNode, int n, ContainerNode containerNode) {
        return this.relativeName(valueBoxNode, containerNode);
    }

    public String map(ValueNode valueNode, int n, ContainerNode containerNode) {
        return this.relativeName(valueNode, containerNode);
    }

    public String map(WStringNode wStringNode, int n, ContainerNode containerNode) {
        return "wstring";
    }

    public String relativeName(ContainedNode containedNode, ContainerNode containerNode) {
        return this.relativeName(containedNode, containerNode, "::", false);
    }

    public static final String relativize(String string, ContainerNode containerNode) {
        if (containerNode.kind() == 17) {
            return string;
        }
        return IDLMapper.relativize(string, ((ContainedNode)((Object)containerNode))._beFullName);
    }

    public static final String relativize(String string, String string2) {
        return TypeMapper.relativize(string, string2, "::", false);
    }
}

