/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.backends.idl;

import com.inprise.vbroker.compiler.ast.AliasNode;
import com.inprise.vbroker.compiler.ast.ArrayNode;
import com.inprise.vbroker.compiler.ast.AttributeNode;
import com.inprise.vbroker.compiler.ast.ConstantNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.FieldNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.ModuleNode;
import com.inprise.vbroker.compiler.ast.NativeNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.NodeFactory;
import com.inprise.vbroker.compiler.ast.OperationNode;
import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.ast.SequenceNode;
import com.inprise.vbroker.compiler.ast.StructNode;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.UnionNode;
import com.inprise.vbroker.compiler.ast.ValueBoxNode;
import com.inprise.vbroker.compiler.ast.ValueMemberNode;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.backends.common.GenericBackend;
import com.inprise.vbroker.compiler.backends.idl.IdlDependencySpec;
import com.inprise.vbroker.compiler.backends.idl.ast.IdlBeOptions;
import com.inprise.vbroker.compiler.backends.idl.ast.IdlNodeFactory;
import com.inprise.vbroker.compiler.util.BufferWriter;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.util.SimpleStringBuffer;
import com.inprise.vbroker.util.StringFunctions;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public final class IdlBackend
extends GenericBackend {
    public boolean _forComments = false;
    public boolean OutputAsHTML = false;
    private SimpleStringBuffer AnnotationText = new SimpleStringBuffer();
    private SimpleStringBuffer _buf = new SimpleStringBuffer();
    private Hashtable typesSeen = new Hashtable();
    private IdlBeOptions _options;
    private Vector _prefixStack = new Vector();
    private Vector _defaultPrefixStack = new Vector();
    private Stack _modulePragmaVersionStack = new Stack();

    public IdlBackend() {
        super(null, new IdlDependencySpec(), "", null);
    }

    public IdlBackend(ContainerNode containerNode, BufferWriter bufferWriter, String string, Vector vector) {
        super(((Node)((Object)containerNode))._repository, new IdlDependencySpec(), string, null);
        this._options = (IdlBeOptions)this._repository._options;
        this._prefixStack.addElement("");
        this._defaultPrefixStack.addElement("");
        this.generate(containerNode);
        bufferWriter.write(this._options._outputFile, this.Buffer, true, null, true);
    }

    protected void beginModule(ModuleNode moduleNode) {
        this.openModule(moduleNode);
    }

    protected void closeModule(ModuleNode moduleNode) {
        --this.Indent;
        this.println("};\n");
        if (!this._forComments) {
            this.prefixPop();
            String string = (String)this._modulePragmaVersionStack.pop();
            if (string != null) {
                this.println(string);
            }
        }
    }

    private String defaultPrefix() {
        String string = (String)this._defaultPrefixStack.elementAt(0);
        return string.equals("") ? string : String.valueOf(String.valueOf(string)).concat("/");
    }

    protected void dispatch(ContainedNode containedNode, String string) {
        boolean bl = containedNode.isContainer();
        String string2 = null;
        string2 = this.maybeOutputPragmas(containedNode);
        if (bl) {
            this.prefixPush(containedNode._beName);
        }
        super.dispatch(containedNode, string);
        if (string2 != null) {
            this.ensureNewLine();
            this.println(string2);
        }
        if (bl) {
            this.prefixPop();
        }
    }

    protected void endModule(ModuleNode moduleNode) {
        this.printAnnotations(moduleNode, null);
        this.closeModule(moduleNode);
    }

    private final String expandAnnotations(Hashtable hashtable) {
        this.AnnotationText.reset();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            this.AnnotationText.append(string);
            this.AnnotationText.append("=\"");
            this.AnnotationText.append(StringFunctions.ISOLatin1StringToPrintable(string2, false));
            this.AnnotationText.append('\"');
            if (!enumeration.hasMoreElements()) continue;
            this.AnnotationText.append(", ");
        }
        return this.AnnotationText.toString();
    }

    protected void forwardDeclareInterface(InterfaceNode interfaceNode) {
        String string = interfaceNode._beName;
        String string2 = null;
        string2 = this.maybeOutputPragmas(interfaceNode);
        this.print("interface ");
        this.add(string);
        this.addln(";");
        this.printStylePragmas(interfaceNode, true);
        this.printAnnotations(interfaceNode, interfaceNode._beFullName);
        if (string2 != null) {
            this.println(string2);
        }
    }

    protected void forwardDeclareValue(ValueNode valueNode) {
        String string = valueNode._beName;
        String string2 = null;
        string2 = this.maybeOutputPragmas(valueNode);
        this.print("valuetype ");
        this.add(string);
        this.addln(";");
        this.printStylePragmas(valueNode, true);
        this.printAnnotations(valueNode, valueNode._beFullName);
        if (string2 != null) {
            this.println(string2);
        }
    }

    protected void genAlias(AliasNode aliasNode) {
        this.genUserComments(aliasNode);
        this.print("typedef ");
        this.genType(aliasNode._type, aliasNode._beName);
        this.addln(";");
        this.printAnnotations(aliasNode, aliasNode._beFullName);
    }

    protected void genAttribute(AttributeNode attributeNode) {
        this.genUserComments(attributeNode);
        if (attributeNode._readOnly) {
            this.print("readonly attribute ");
        } else {
            this.print("attribute ");
        }
        this.genType(attributeNode._type, attributeNode._beName);
        this.addln(";");
        this.printOriginalName(attributeNode, true);
        this.printOriginalName(attributeNode, false);
        this.printAnnotations(attributeNode, attributeNode._beFullName);
    }

    protected void genConstant(ConstantNode constantNode) {
        this.genUserComments(constantNode);
        this.print("const ");
        this.genType(constantNode._type, constantNode._beName);
        this.add(" = ");
        this.add(constantNode._type.toLiteral(constantNode._value));
        this.addln(";");
        this.printAnnotations(constantNode, constantNode._beFullName);
    }

    protected void genEnum(EnumNode enumNode, String string) {
        this.genUserComments(enumNode);
        this.print("enum ");
        this.add(enumNode._beName);
        this.add(" {");
        this.commaSepList(enumNode, enumNode._memberNames);
        this.printAnnotations(enumNode, null);
        this.ensureIndent();
        if (string == null) {
            this.addln("};");
        } else {
            this.add("}");
            if (string.length() > 0) {
                this.add(" ");
            }
            this.add(string);
        }
    }

    protected void genException(ExceptionNode exceptionNode) {
        this.genUserComments(exceptionNode);
        this.print("exception ");
        this.add(exceptionNode._beName);
        this.addln(" {");
        ++this.Indent;
        this.printOriginalName(exceptionNode, true);
        if (this._forComments) {
            this.println("...");
        } else {
            Vector vector = exceptionNode._memberNames;
            Vector vector2 = exceptionNode._memberTypes;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                this.genMember(exceptionNode, (Type)vector2.elementAt(i), exceptionNode._repository._mapper.mapIdentifier((String)vector.elementAt(i)));
            }
        }
        this.printAnnotations(exceptionNode, null);
        --this.Indent;
        this.println("};");
    }

    protected void genInterface(InterfaceNode interfaceNode) {
        this.genUserComments(interfaceNode);
        if (!interfaceNode._defined) {
            this.forwardDeclareInterface(interfaceNode);
            return;
        }
        if (interfaceNode._abstract) {
            this.print("abstract ");
        }
        this.print("interface ");
        this.add(interfaceNode._beName);
        int n = interfaceNode._bases.size();
        if (n > 0) {
            this.add(" : ");
            this.commaSepDefs(interfaceNode._bases, true);
        }
        this.addln(" {");
        ++this.Indent;
        this.printStylePragmas(interfaceNode, false);
        if (this._forComments) {
            this.println("...");
        } else {
            this.genContents(interfaceNode);
        }
        this.printAnnotations(interfaceNode, null);
        --this.Indent;
        this.println("};");
    }

    private void genMember(ContainerNode containerNode, Type type, String string) {
        Node node = (Node)((Object)type);
        while (node._kind == 16 || node._kind == 15) {
            switch (node._kind) {
                case 16: {
                    node = (Node)((Object)((ArrayNode)node)._type);
                    break;
                }
                case 15: {
                    node = (Node)((Object)((SequenceNode)node)._type);
                }
            }
        }
        try {
            if (node.isContained() && ((ContainedNode)node)._container == containerNode) {
                if (this.typesSeen.get(node) == Boolean.TRUE) {
                    this.genType(type, string, false, true);
                    this.addln(";");
                } else {
                    this.genType(type, string, true, true);
                    this.addln(";");
                    this.typesSeen.put(node, Boolean.TRUE);
                }
            } else {
                this.print("");
                this.genType(type, string);
                this.addln(";");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void genNative(NativeNode nativeNode) {
        this.genUserComments(nativeNode);
        this.print("native ");
        this.add(nativeNode._beName);
        this.addln(";");
        this.printAnnotations(nativeNode, nativeNode._beFullName);
    }

    protected void genOperation(OperationNode operationNode) {
        int n;
        this.genUserComments(operationNode);
        if (operationNode._oneWay) {
            this.print("oneway ");
        } else {
            this.print("");
        }
        this.genType(operationNode._result, operationNode._beName);
        this.add(" (");
        Vector vector = operationNode._paramNames;
        Vector vector2 = operationNode._paramTypes;
        Vector vector3 = operationNode._paramModes;
        Vector vector4 = operationNode._contexts;
        int n2 = this._horizPos;
        this.beginLineBreaking();
        for (n = 0; n < vector.size(); ++n) {
            if (vector3.elementAt(n) == OperationNode.PARAM_IN) {
                this.add("in ");
            } else if (vector3.elementAt(n) == OperationNode.PARAM_OUT) {
                this.add("out ");
            } else {
                this.add("inout ");
            }
            this.genType((Type)vector2.elementAt(n), operationNode._repository._mapper.mapIdentifier((String)vector.elementAt(n)));
            if (n >= vector.size() - 1) continue;
            this.add(", ");
        }
        this.endLineBreaking();
        if (operationNode._exceptions.size() > 0) {
            this.addln(")");
            ++this.Indent;
            this.print("raises (");
            this.commaSepDefs(operationNode._exceptions, true);
            --this.Indent;
        }
        if (vector4.size() > 0) {
            this.addln(")");
            ++this.Indent;
            this.print("context (");
            this.beginLineBreaking();
            for (n = 0; n < vector4.size(); ++n) {
                this.add("\"");
                this.add((String)vector4.elementAt(n));
                this.add("\"");
                if (n >= vector4.size() - 1) continue;
                this.add(", ");
            }
            this.endLineBreaking();
            --this.Indent;
        }
        this.addln(");");
        this.printOriginalName(operationNode);
        this.printAnnotations(operationNode, operationNode._beFullName);
    }

    protected void genStruct(StructNode structNode, String string) {
        this.genUserComments(structNode);
        this.print("struct ");
        this.add(structNode._beName);
        this.addln(" {");
        ++this.Indent;
        if (this._forComments) {
            this.println("...");
        } else {
            Vector vector = structNode._memberNames;
            Vector vector2 = structNode._memberTypes;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                this.genMember(structNode, (Type)vector2.elementAt(i), structNode._repository._mapper.mapIdentifier((String)vector.elementAt(i)));
            }
        }
        this.printAnnotations(structNode, null);
        --this.Indent;
        if (string == null) {
            this.println("};");
        } else {
            this.print("} ");
            this.add(string);
        }
    }

    protected void genType(Type type, String string) {
        this.genType(type, string, false, false);
    }

    protected void genType(Type type, String string, boolean bl, boolean bl2) {
        Node node = (Node)((Object)type);
        int n = node._kind;
        switch (n) {
            case 15: {
                SequenceNode sequenceNode = (SequenceNode)type;
                if (this.OutputAsHTML) {
                    this.add("sequence&lt");
                } else {
                    this.add("sequence< ");
                }
                this.genType(sequenceNode._type, null, bl, bl2);
                if (sequenceNode._bound > 0) {
                    this.add(",".concat(String.valueOf(String.valueOf(sequenceNode._bound))));
                }
                if (this.OutputAsHTML) {
                    this.add("&gt");
                } else {
                    this.add(" >");
                }
                if (string != null) {
                    this.add(" ");
                    this.add(string);
                }
                return;
            }
            case 16: {
                ArrayNode arrayNode = (ArrayNode)type;
                this.genType(arrayNode._type, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append("[").append(arrayNode._length).append("]"))), bl, bl2);
                return;
            }
            case 14: 
            case 18: {
                this.add(node.typeName());
                break;
            }
            case 13: {
                this.add(node.typeName());
                if (string != null || ((PrimitiveNode)node)._pkind != 30000) break;
                this.add(" ");
                break;
            }
            default: {
                if (node.isContained()) {
                    ContainedNode containedNode = (ContainedNode)((Object)type);
                    if (bl) {
                        this.dispatch(containedNode, "");
                        break;
                    }
                    if (bl2) {
                        this.add(containedNode._beName);
                        break;
                    }
                    this.add(containedNode._beFullName);
                    break;
                }
                this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("unknown or invalid type ").append(node.typeName()).append(" (").append(n).append(") in IdlBackend.genType()"))));
            }
        }
        if (string != null) {
            this.add(" ");
            this.add(string);
        }
    }

    protected void genUnion(UnionNode unionNode, String string) {
        this.genUserComments(unionNode);
        this.print("union ");
        this.add(unionNode._beName);
        this.add(" switch (");
        int n = unionNode._discriminator.kind();
        if (n == 12 && ((EnumNode)unionNode._discriminator)._container == unionNode) {
            this.dispatch((EnumNode)unionNode._discriminator, "");
        } else {
            this.genType(unionNode._discriminator, null);
        }
        this.addln(") {");
        ++this.Indent;
        if (this._forComments) {
            this.println("...");
        } else {
            Vector vector = unionNode._memberTypes;
            Vector vector2 = unionNode._memberNames;
            Vector vector3 = unionNode._memberLabels;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                if (i == unionNode._defaultIndex) {
                    this.println("default:");
                }
                Vector vector4 = (Vector)vector3.elementAt(i);
                for (int j = 0; j < vector4.size(); ++j) {
                    Object e = vector4.elementAt(j);
                    this.print("case ");
                    if (n == 12) {
                        this.add(((EnumNode)unionNode._discriminator).toEnumName((String)e.toString())._beFullName);
                    } else {
                        this.add(unionNode._discriminator.toLiteral(e));
                    }
                    this.addln(":");
                }
                if (i != vector2.size() - 1 && vector2.elementAt(i).equals(vector2.elementAt(i + 1))) continue;
                ++this.Indent;
                this.genMember(unionNode, (Type)vector.elementAt(i), unionNode._repository._mapper.mapIdentifier((String)vector2.elementAt(i)));
                --this.Indent;
            }
        }
        this.printAnnotations(unionNode, null);
        --this.Indent;
        if (string == null) {
            this.println("};");
        } else {
            this.print("} ");
            this.add(string);
        }
    }

    protected void genUserComments(ContainedNode containedNode) {
        if (!this._forComments && this._options._comments && containedNode._comment != null && containedNode._comment.trim().length() > 0) {
            this.print("/*");
            this.add(containedNode._comment);
            this.addln("*/");
        }
    }

    protected void genValue(ValueNode valueNode) {
        String string;
        this.genUserComments(valueNode);
        if (valueNode._custom) {
            this.print("custom valuetype ");
        } else if (valueNode._abstract) {
            this.print("abstract valuetype ");
        } else {
            this.print("valuetype ");
        }
        this.add(valueNode._beName);
        this.add(" ");
        String string2 = string = valueNode._truncatable ? "truncatable " : "";
        if (valueNode._concreteBase != null || valueNode._abstractBases.size() > 0) {
            this.add(": ");
            if (valueNode._concreteBase != null) {
                this.add(string);
                this.add(valueNode._concreteBase._beFullName);
                if (valueNode._abstractBases.size() > 0) {
                    this.add(", ");
                }
            }
            this.commaSepDefs(valueNode._abstractBases, true);
        }
        if (valueNode._supportedInterface != null || valueNode._abstractInterfaces.size() > 0) {
            this.newLine();
            ++this.Indent;
            this.print("supports ");
            if (valueNode._supportedInterface != null) {
                this.add(valueNode._supportedInterface._beFullName);
                if (valueNode._abstractInterfaces.size() > 0) {
                    this.add(", ");
                }
            }
            this.commaSepDefs(valueNode._abstractInterfaces, true);
            --this.Indent;
        }
        this.addln(" {");
        ++this.Indent;
        this.printStylePragmas(valueNode, false);
        if (this._forComments) {
            this.println("...");
        } else {
            this.genContents(valueNode);
            Vector vector = valueNode._initParamNames;
            Vector vector2 = valueNode._initParamTypes;
            for (int i = 0; i < valueNode._initNames.size(); ++i) {
                String string3 = (String)valueNode._initNames.elementAt(i);
                Vector vector3 = (Vector)vector.elementAt(i);
                Vector vector4 = (Vector)vector2.elementAt(i);
                this.print(String.valueOf(String.valueOf(new StringBuffer("factory ").append(string3).append("("))));
                for (int j = 0; j < vector3.size(); ++j) {
                    this.add("in ");
                    this.genType((Type)vector4.elementAt(j), valueNode._repository._mapper.mapIdentifier((String)vector3.elementAt(j)));
                    if (j >= vector3.size() - 1) continue;
                    this.add(", ");
                }
                this.addln(");");
            }
        }
        this.printAnnotations(valueNode, null);
        --this.Indent;
        this.println("};");
    }

    protected void genValueBox(ValueBoxNode valueBoxNode) {
        this.genUserComments(valueBoxNode);
        this.print("valuetype ");
        this.add(valueBoxNode._beName);
        this.add(" ");
        this.genType(valueBoxNode._type, null);
        this.addln(";");
        this.printAnnotations(valueBoxNode, valueBoxNode._beFullName);
    }

    protected void genValueMember(ValueMemberNode valueMemberNode) {
        this.genUserComments(valueMemberNode);
        if (valueMemberNode._public) {
            this.print("public  ");
        } else {
            this.print("private ");
        }
        this.genType(valueMemberNode._type, valueMemberNode._beName);
        this.addln(";");
        this.printAnnotations(valueMemberNode, valueMemberNode._beFullName);
    }

    public static NodeFactory makeNodeFactory(ErrorReporter errorReporter) {
        return new IdlNodeFactory(errorReporter);
    }

    private String maybeOutputPragmas(ContainedNode containedNode) {
        boolean bl;
        if (this._forComments) {
            return null;
        }
        String string = containedNode._repId;
        String string2 = containedNode._name;
        this._buf.reset();
        this._buf.append("IDL:");
        String string3 = (String)this._prefixStack.elementAt(0);
        this._buf.append(string3);
        if (!string3.equals("")) {
            this._buf.append('/');
        }
        this._buf.append(string2);
        this._buf.append(":1.0");
        if (this._buf.equals(string)) {
            return null;
        }
        String string4 = containedNode._version;
        String string5 = ":".concat(String.valueOf(String.valueOf(string4)));
        String string6 = String.valueOf(String.valueOf(new StringBuffer("IDL:").append(this.prefix()).append(string2).append(string5)));
        if (string6.equals(string)) {
            return String.valueOf(String.valueOf(new StringBuffer("#pragma version ").append(string2).append(" ").append(string4)));
        }
        boolean bl2 = bl = string.startsWith("IDL:") && string.endsWith(string5);
        if (bl && string.endsWith(String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(string5))))) {
            String string7 = string.substring(4, string.lastIndexOf(String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(string5)))));
            if (string7.length() > 0 && string7.charAt(string7.length() - 1) == '/') {
                this.prefixSet(string7.substring(0, string7.length() - 1));
            } else {
                this.prefixSet(string7);
            }
            String string8 = this.defaultPrefix();
            if (!this._options._strict && string7.equals(string8)) {
                this.println("#pragma prefix");
            } else if (string7.length() == 0) {
                this.println(String.valueOf(String.valueOf(new StringBuffer("#pragma prefix \"").append(string7).append("\""))));
            } else {
                this.println(String.valueOf(String.valueOf(new StringBuffer("#pragma prefix \"").append(string7.substring(0, string7.length() - 1)).append("\""))));
            }
            return string4.equals("1.0") ? null : String.valueOf(String.valueOf(new StringBuffer("#pragma version ").append(string2).append(" ").append(string4)));
        }
        String string9 = String.valueOf(String.valueOf(new StringBuffer("#pragma ID ").append(string2).append(" \"").append(string).append("\"")));
        if (bl && !string4.equals("1.0")) {
            string9 = String.valueOf(String.valueOf(string9)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("\n#pragma version ").append(string2).append(" ").append(string4))))));
        }
        return string9;
    }

    protected void openModule(ModuleNode moduleNode) {
        if (!this._forComments) {
            this._modulePragmaVersionStack.push(this.maybeOutputPragmas(moduleNode));
            this.prefixPush(moduleNode._beName);
        }
        this.print("module ");
        this.add(moduleNode._beName);
        this.addln(" {");
        ++this.Indent;
        if (this._forComments) {
            this.println("...");
        }
    }

    private String prefix() {
        String string = (String)this._prefixStack.elementAt(0);
        return string.equals("") ? string : String.valueOf(String.valueOf(string)).concat("/");
    }

    private void prefixPop() {
        this._prefixStack.removeElementAt(0);
        this._defaultPrefixStack.removeElementAt(0);
    }

    private void prefixPush(String string) {
        String string2 = (String)this._prefixStack.elementAt(0);
        if (string2.equals("")) {
            this._prefixStack.insertElementAt(string, 0);
        } else {
            this._prefixStack.insertElementAt(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append("/").append(string))), 0);
        }
        string2 = (String)this._defaultPrefixStack.elementAt(0);
        if (string2.equals("")) {
            this._defaultPrefixStack.insertElementAt(string, 0);
        } else {
            this._defaultPrefixStack.insertElementAt(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append("/").append(string))), 0);
        }
    }

    private void prefixSet(String string) {
        if (string == null) {
            this._prefixStack.setElementAt(this._defaultPrefixStack.elementAt(0), 0);
        } else {
            this._prefixStack.setElementAt(string, 0);
        }
    }

    private void printAnnotations(ContainedNode containedNode, String string) {
        Object object;
        if (containedNode._annotations != null && containedNode._annotations.size() > 0) {
            object = string == null ? "#pragma hint " : String.valueOf(String.valueOf(new StringBuffer("#pragma hint ").append(string).append(" ")));
            this.printNameValuePairs((String)object, containedNode._annotations);
            this.newLine();
        }
        if (containedNode.hasFields()) {
            object = (FieldNode)containedNode;
            Vector vector = ((FieldNode)object)._memberAnnotations;
            if (vector != null) {
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    Hashtable hashtable = (Hashtable)vector.elementAt(i);
                    if (hashtable == null || hashtable.size() <= 0) continue;
                    this.printNameValuePairs(String.valueOf(String.valueOf(new StringBuffer("#pragma hint .").append(((FieldNode)object)._memberNames.elementAt(i)).append(" "))), hashtable);
                    this.newLine();
                }
            }
        }
    }

    private void printNameValuePairs(String string, Hashtable hashtable) {
        this.ensureNewLine();
        StringTokenizer stringTokenizer = new StringTokenizer(this.expandAnnotations(hashtable), ",");
        this.print(string);
        this.add(stringTokenizer.nextToken().trim());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (this._horizPos + string2.length() >= this._preferredLineWidth) {
                this.newLine();
                this.print(string);
                this.add(string2);
                continue;
            }
            this.add(',');
            this.add(string2);
        }
    }

    private void printOriginalName(AttributeNode attributeNode, boolean bl) {
        if (bl) {
            if (attributeNode._mutatorName == null) {
                return;
            }
            if (!"set_".concat(String.valueOf(String.valueOf(attributeNode._mutatorName))).equals(attributeNode._name)) {
                this.println(String.valueOf(String.valueOf(new StringBuffer("#pragma original_setter_name ").append(attributeNode._beName).append(" \"").append(attributeNode._mutatorName).append("\""))));
            }
        } else {
            if (attributeNode._accessorName == null) {
                return;
            }
            if (!"get_".concat(String.valueOf(String.valueOf(attributeNode._accessorName))).equals(attributeNode._name)) {
                this.println(String.valueOf(String.valueOf(new StringBuffer("#pragma original_getter_name ").append(attributeNode._beName).append(" \"").append(attributeNode._accessorName).append("\""))));
            }
        }
    }

    private void printOriginalName(ExceptionNode exceptionNode, boolean bl) {
        if (exceptionNode._originalName != null && !exceptionNode._originalName.equals(exceptionNode._name)) {
            if (bl) {
                this.println(String.valueOf(String.valueOf(new StringBuffer("#pragma original_name \"").append(exceptionNode._originalName).append("\""))));
            } else {
                this.println(String.valueOf(String.valueOf(new StringBuffer("#pragma original_name ").append(exceptionNode._beName).append(" \"").append(exceptionNode._originalName).append("\""))));
            }
        }
    }

    private void printOriginalName(OperationNode operationNode) {
        if (operationNode._originalName != null && !operationNode._originalName.equals(operationNode._name)) {
            this.println(String.valueOf(String.valueOf(new StringBuffer("#pragma original_name ").append(operationNode._beName).append(" \"").append(operationNode._originalName).append("\""))));
        }
    }

    private void printStylePragmas(InterfaceNode interfaceNode, boolean bl) {
        if (interfaceNode._pseudo) {
            this.println("#pragma pseudo ".concat(String.valueOf(String.valueOf(interfaceNode._beName))));
        }
    }

    private void printStylePragmas(ValueNode valueNode, boolean bl) {
        if (valueNode._pseudo) {
            this.println("#pragma pseudo ".concat(String.valueOf(String.valueOf(valueNode._beName))));
        }
    }
}

