/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.ast;

import com.inprise.vbroker.compiler.ast.AliasNode;
import com.inprise.vbroker.compiler.ast.ArrayNode;
import com.inprise.vbroker.compiler.ast.AttributeNode;
import com.inprise.vbroker.compiler.ast.ConstantNode;
import com.inprise.vbroker.compiler.ast.ContainedContainerNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.FieldNode;
import com.inprise.vbroker.compiler.ast.FixedNode;
import com.inprise.vbroker.compiler.ast.InheritableNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.NodeFactory;
import com.inprise.vbroker.compiler.ast.ObjectKey;
import com.inprise.vbroker.compiler.ast.OperationNode;
import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.ast.SequenceNode;
import com.inprise.vbroker.compiler.ast.StringNode;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.TypeMapper;
import com.inprise.vbroker.compiler.ast.UnionNode;
import com.inprise.vbroker.compiler.ast.ValueBoxNode;
import com.inprise.vbroker.compiler.ast.ValueMemberNode;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.ast.WStringNode;
import com.inprise.vbroker.compiler.backends.common.CommonOptions;
import com.inprise.vbroker.compiler.backends.depsolver.DepSolverDefs;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.compiler.util.QName;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RepositoryNode
extends Node
implements ContainerNode,
DepSolverDefs {
    public NodeFactory _factory;
    public CommonOptions _options;
    public ErrorReporter _ER;
    public TypeMapper _mapper;
    public Hashtable _objectTable = new Hashtable();
    public Hashtable _repIdTable = new Hashtable();
    public Vector _contents = new Vector();
    public Vector _arrays = new Vector();
    public Vector _sequences = new Vector();
    public Hashtable _strings = new Hashtable();
    public Hashtable _wstrings = new Hashtable();
    public Hashtable _fixeds = new Hashtable();
    public boolean _assignObjectKeys = false;
    public PrimitiveNode ANY_TYPE;
    public PrimitiveNode BOOL_TYPE;
    public PrimitiveNode CHAR_TYPE;
    public PrimitiveNode DOUBLE_TYPE;
    public PrimitiveNode FLOAT_TYPE;
    public PrimitiveNode LONGDOUBLE_TYPE;
    public PrimitiveNode LONGLONG_TYPE;
    public PrimitiveNode LONG_TYPE;
    public PrimitiveNode OBJREF_TYPE;
    public PrimitiveNode OCTET_TYPE;
    public PrimitiveNode PRINCIPAL_TYPE;
    public PrimitiveNode SHORT_TYPE;
    public PrimitiveNode STRING_TYPE;
    public PrimitiveNode TYPECODE_TYPE;
    public PrimitiveNode ULONGLONG_TYPE;
    public PrimitiveNode ULONG_TYPE;
    public PrimitiveNode USHORT_TYPE;
    public PrimitiveNode VOID_TYPE;
    public PrimitiveNode WCHAR_TYPE;
    public PrimitiveNode WSTRING_TYPE;
    public PrimitiveNode VALUEBASE_TYPE;

    public RepositoryNode(NodeFactory nodeFactory, ErrorReporter errorReporter, TypeMapper typeMapper, CommonOptions commonOptions) {
        super(17);
        this.init(nodeFactory, errorReporter, typeMapper, commonOptions);
    }

    void addNode(Node node) {
        if (this._assignObjectKeys && node != null) {
            node._objectKey = new ObjectKey();
            if (this._ER._verbose) {
                System.err.println("Adding node ".concat(String.valueOf(String.valueOf(node._objectKey))));
            }
            this._objectTable.put(node._objectKey, node);
        }
    }

    public void assignObjectKeys() {
        this._assignObjectKeys = true;
        this.addNode(this);
        this.addNode(this.ANY_TYPE);
        this.addNode(this.BOOL_TYPE);
        this.addNode(this.CHAR_TYPE);
        this.addNode(this.DOUBLE_TYPE);
        this.addNode(this.FLOAT_TYPE);
        this.addNode(this.LONGDOUBLE_TYPE);
        this.addNode(this.LONGLONG_TYPE);
        this.addNode(this.LONG_TYPE);
        this.addNode(this.OBJREF_TYPE);
        this.addNode(this.OCTET_TYPE);
        this.addNode(this.PRINCIPAL_TYPE);
        this.addNode(this.SHORT_TYPE);
        this.addNode(this.STRING_TYPE);
        this.addNode(this.TYPECODE_TYPE);
        this.addNode(this.ULONGLONG_TYPE);
        this.addNode(this.ULONG_TYPE);
        this.addNode(this.USHORT_TYPE);
        this.addNode(this.VOID_TYPE);
        this.addNode(this.WCHAR_TYPE);
        this.addNode(this.WSTRING_TYPE);
        this.addNode(this.VALUEBASE_TYPE);
    }

    public void clear() {
        this._contents.removeAllElements();
        this._repIdTable.clear();
        this._strings.clear();
        this._wstrings.clear();
        this._arrays.removeAllElements();
        this._sequences.removeAllElements();
        this._fixeds.clear();
        this._objectTable.clear();
        this.assignObjectKeys();
    }

    public Vector contents() {
        return this._contents;
    }

    public Node define(int n, String string, String string2, String string3, String string4) {
        return Node.define(n, string, this, string2, string3, string4, this._contents);
    }

    public Node define(int n, String string, String string2, String string3, String string4, boolean bl) {
        return Node.define(n, string, this, string2, string3, string4, this._contents, bl);
    }

    public void dump() {
        System.out.println("<REPOSITORY>");
        for (int i = 0; i < this._contents.size(); ++i) {
            RepositoryNode.dump("  ", (ContainedNode)this._contents.elementAt(i));
        }
    }

    private static void dump(String string, ContainedNode containedNode) {
        System.out.println(String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(containedNode._name))));
        if (containedNode.isContainer()) {
            ContainedContainerNode containedContainerNode = (ContainedContainerNode)containedNode;
            for (int i = 0; i < containedContainerNode._contents.size(); ++i) {
                RepositoryNode.dump(String.valueOf(String.valueOf(string)).concat("  "), (ContainedNode)containedContainerNode._contents.elementAt(i));
            }
        }
    }

    public Vector find(String string, int n, int n2, boolean bl) {
        return Node.find(this._contents, string, n, n2, bl);
    }

    public void finishParameterizedTypes() {
        int n;
        int n2 = this._arrays.size();
        for (n = 0; n < n2; ++n) {
            ((ArrayNode)this._arrays.elementAt(n)).finish(6);
        }
        n2 = this._sequences.size();
        for (n = 0; n < n2; ++n) {
            ((SequenceNode)this._sequences.elementAt(n)).finish(6);
        }
        Enumeration enumeration = this._strings.elements();
        while (enumeration.hasMoreElements()) {
            ((StringNode)enumeration.nextElement()).finish(6);
        }
        enumeration = this._wstrings.elements();
        while (enumeration.hasMoreElements()) {
            ((WStringNode)enumeration.nextElement()).finish(6);
        }
        enumeration = this._fixeds.elements();
        while (enumeration.hasMoreElements()) {
            ((FixedNode)enumeration.nextElement()).finish(6);
        }
    }

    public ArrayNode getArray(Type type, int n) {
        int n2 = this._arrays.size();
        for (int i = 0; i < n2; ++i) {
            ArrayNode arrayNode = (ArrayNode)this._arrays.elementAt(i);
            if (arrayNode._type != type || arrayNode._length != n) continue;
            arrayNode._fileNumber = this._ER._currentFileNumber;
            arrayNode._lineNumber = this._ER._currentLineNumber;
            return arrayNode;
        }
        return this.makeArray(type, n, true);
    }

    public FixedNode getFixed(short s, short s2) {
        Integer n;
        FixedNode fixedNode;
        if (s <= 0 || s >= 32) {
            this.error("Comp.AST.fixedOutOfRange", new Object[]{new Integer(32)});
        }
        if (s2 < 0 || s2 > s) {
            this.error("Comp.AST.fixedScaleOutOfRange", new Object[]{new Integer(s), new Integer(s2)});
        }
        if ((fixedNode = (FixedNode)this._fixeds.get(n = new Integer((s << 16) + s2))) == null) {
            fixedNode = (FixedNode)this._factory.create(19);
            fixedNode._digits = s;
            fixedNode._scale = s2;
            fixedNode._repository = this;
            this._fixeds.put(n, fixedNode);
        }
        fixedNode._fileNumber = this._ER._currentFileNumber;
        fixedNode._lineNumber = this._ER._currentLineNumber;
        return fixedNode;
    }

    public PrimitiveNode getPrimitive(int n) {
        switch (n) {
            case 11: {
                return this.ANY_TYPE;
            }
            case 8: {
                return this.BOOL_TYPE;
            }
            case 9: {
                return this.CHAR_TYPE;
            }
            case 7: {
                return this.DOUBLE_TYPE;
            }
            case 6: {
                return this.FLOAT_TYPE;
            }
            case 3: {
                return this.LONG_TYPE;
            }
            case 18: {
                return this.LONGDOUBLE_TYPE;
            }
            case 16: {
                return this.LONGLONG_TYPE;
            }
            case 15: {
                return this.OBJREF_TYPE;
            }
            case 10: {
                return this.OCTET_TYPE;
            }
            case 13: {
                return this.PRINCIPAL_TYPE;
            }
            case 2: {
                return this.SHORT_TYPE;
            }
            case 14: {
                return this.STRING_TYPE;
            }
            case 12: {
                return this.TYPECODE_TYPE;
            }
            case 5: {
                return this.ULONG_TYPE;
            }
            case 17: {
                return this.ULONGLONG_TYPE;
            }
            case 4: {
                return this.USHORT_TYPE;
            }
            case 1: {
                return this.VOID_TYPE;
            }
            case 19: {
                return this.WCHAR_TYPE;
            }
            case 20: {
                return this.WSTRING_TYPE;
            }
            case 21: {
                return this.VALUEBASE_TYPE;
            }
        }
        this._ER.error("Comp.AST.invalidType", new Object[]{PrimitiveNode.typeName(n), new Integer(n)});
        return null;
    }

    public SequenceNode getSequence(Type type, int n, boolean bl) {
        int n2 = this._sequences.size();
        for (int i = 0; i < n2; ++i) {
            SequenceNode sequenceNode = (SequenceNode)this._sequences.elementAt(i);
            if (sequenceNode._type != type || sequenceNode._bound != n) continue;
            sequenceNode._fileNumber = this._ER._currentFileNumber;
            sequenceNode._lineNumber = this._ER._currentLineNumber;
            return sequenceNode;
        }
        return this.makeSequence(type, n, true);
    }

    public Type getString(int n) {
        if (n == 0) {
            return this.STRING_TYPE;
        }
        Integer n2 = new Integer(n);
        StringNode stringNode = (StringNode)this._strings.get(n2);
        if (stringNode == null) {
            stringNode = (StringNode)this._factory.create(14);
            stringNode._bound = n;
            stringNode._repository = this;
            this._strings.put(n2, stringNode);
        }
        stringNode._fileNumber = this._ER._currentFileNumber;
        stringNode._lineNumber = this._ER._currentLineNumber;
        return stringNode;
    }

    public Type getWString(int n) {
        if (n == 0) {
            return this.WSTRING_TYPE;
        }
        Integer n2 = new Integer(n);
        WStringNode wStringNode = (WStringNode)this._wstrings.get(n2);
        if (wStringNode == null) {
            wStringNode = (WStringNode)this._factory.create(18);
            wStringNode._bound = n;
            wStringNode._repository = this;
            this._wstrings.put(n2, wStringNode);
        }
        wStringNode._fileNumber = this._ER._currentFileNumber;
        wStringNode._lineNumber = this._ER._currentLineNumber;
        return wStringNode;
    }

    private void init(NodeFactory nodeFactory, ErrorReporter errorReporter, TypeMapper typeMapper, CommonOptions commonOptions) {
        this._factory = nodeFactory;
        this._ER = errorReporter;
        this._mapper = typeMapper;
        this._options = commonOptions;
        this._repository = this;
        this.ANY_TYPE = this._factory.getPrimitive(11);
        this.ANY_TYPE._repository = this;
        this.ANY_TYPE.finish(6);
        this.BOOL_TYPE = this._factory.getPrimitive(8);
        this.BOOL_TYPE._repository = this;
        this.BOOL_TYPE.finish(6);
        this.CHAR_TYPE = this._factory.getPrimitive(9);
        this.CHAR_TYPE._repository = this;
        this.CHAR_TYPE.finish(6);
        this.DOUBLE_TYPE = this._factory.getPrimitive(7);
        this.DOUBLE_TYPE._repository = this;
        this.DOUBLE_TYPE.finish(6);
        this.FLOAT_TYPE = this._factory.getPrimitive(6);
        this.FLOAT_TYPE._repository = this;
        this.FLOAT_TYPE.finish(6);
        this.LONGDOUBLE_TYPE = this._factory.getPrimitive(18);
        this.LONGDOUBLE_TYPE._repository = this;
        this.LONGDOUBLE_TYPE.finish(6);
        this.LONGLONG_TYPE = this._factory.getPrimitive(16);
        this.LONGLONG_TYPE._repository = this;
        this.LONGLONG_TYPE.finish(6);
        this.LONG_TYPE = this._factory.getPrimitive(3);
        this.LONG_TYPE._repository = this;
        this.LONG_TYPE.finish(6);
        this.OBJREF_TYPE = this._factory.getPrimitive(15);
        this.OBJREF_TYPE._repository = this;
        this.OBJREF_TYPE.finish(6);
        this.OCTET_TYPE = this._factory.getPrimitive(10);
        this.OCTET_TYPE._repository = this;
        this.OCTET_TYPE.finish(6);
        this.PRINCIPAL_TYPE = this._factory.getPrimitive(13);
        this.PRINCIPAL_TYPE._repository = this;
        this.PRINCIPAL_TYPE.finish(6);
        this.SHORT_TYPE = this._factory.getPrimitive(2);
        this.SHORT_TYPE._repository = this;
        this.SHORT_TYPE.finish(6);
        this.STRING_TYPE = this._factory.getPrimitive(14);
        this.STRING_TYPE._repository = this;
        this.STRING_TYPE.finish(6);
        this.TYPECODE_TYPE = this._factory.getPrimitive(12);
        this.TYPECODE_TYPE._repository = this;
        this.TYPECODE_TYPE.finish(6);
        this.ULONGLONG_TYPE = this._factory.getPrimitive(17);
        this.ULONGLONG_TYPE._repository = this;
        this.ULONGLONG_TYPE.finish(6);
        this.ULONG_TYPE = this._factory.getPrimitive(5);
        this.ULONG_TYPE._repository = this;
        this.ULONG_TYPE.finish(6);
        this.USHORT_TYPE = this._factory.getPrimitive(4);
        this.USHORT_TYPE._repository = this;
        this.USHORT_TYPE.finish(6);
        this.VOID_TYPE = this._factory.getPrimitive(1);
        this.VOID_TYPE._repository = this;
        this.VOID_TYPE.finish(6);
        this.WCHAR_TYPE = this._factory.getPrimitive(19);
        this.WCHAR_TYPE._repository = this;
        this.WCHAR_TYPE.finish(6);
        this.WSTRING_TYPE = this._factory.getPrimitive(20);
        this.WSTRING_TYPE._repository = this;
        this.WSTRING_TYPE.finish(6);
    }

    public ContainedNode lookup(QName qName, boolean bl) {
        if (qName._s.startsWith("::")) {
            qName._s = qName._s.substring(2);
        }
        for (int i = 0; i < this._contents.size(); ++i) {
            ContainedNode containedNode = (ContainedNode)this._contents.elementAt(i);
            if (!containedNode._name.equalsIgnoreCase(qName._s)) continue;
            if (!containedNode._name.equals(qName._s)) {
                containedNode.warnCaseViolation(qName._s);
            }
            if (qName._next == null) {
                return containedNode;
            }
            if (!containedNode.isContainer()) continue;
            return ((ContainedContainerNode)containedNode).lookup(qName._next, true);
        }
        return null;
    }

    public ContainedNode lookup(String string, boolean bl) {
        for (int i = 0; i < this._contents.size(); ++i) {
            ContainedNode containedNode = (ContainedNode)this._contents.elementAt(i);
            if (!containedNode._name.equalsIgnoreCase(string)) continue;
            return containedNode;
        }
        return null;
    }

    public ContainedNode lookupId(String string) {
        return (ContainedNode)this._repIdTable.get(string);
    }

    protected ArrayNode makeArray(Type type, int n, boolean bl) {
        ArrayNode arrayNode = (ArrayNode)this._factory.create(16);
        arrayNode._type = type;
        arrayNode._length = n;
        arrayNode._repository = this;
        arrayNode._fileNumber = this._ER._currentFileNumber;
        arrayNode._lineNumber = this._ER._currentLineNumber;
        if (bl) {
            this._arrays.addElement(arrayNode);
        }
        return arrayNode;
    }

    protected SequenceNode makeSequence(Type type, int n, boolean bl) {
        SequenceNode sequenceNode = (SequenceNode)this._factory.create(15);
        sequenceNode._type = type;
        sequenceNode._bound = n;
        sequenceNode._repository = this;
        sequenceNode._fileNumber = this._ER._currentFileNumber;
        sequenceNode._lineNumber = this._ER._currentLineNumber;
        if (bl) {
            this._sequences.addElement(sequenceNode);
        }
        return sequenceNode;
    }

    public void merge(RepositoryNode repositoryNode, boolean bl) {
        RepositoryNode.mergeContent(this, this._contents, repositoryNode._contents, bl);
        this.recomputeCachedInfo();
    }

    private static Vector mergeContent(ContainerNode containerNode, Vector vector, Vector vector2, boolean bl) {
        int n;
        int n2;
        int n3 = vector.size();
        block0: for (n2 = 0; n2 < n3; ++n2) {
            ContainedNode containedNode = (ContainedNode)vector.elementAt(n2);
            int n4 = vector2.size();
            for (n = 0; n < n4; ++n) {
                ContainedNode containedNode2 = (ContainedNode)vector2.elementAt(n);
                if (!containedNode._name.equals(containedNode2._name)) continue;
                if (containedNode._kind == 6 || containedNode.isContainer() && bl) {
                    ContainedContainerNode containedContainerNode = (ContainedContainerNode)containedNode;
                    ContainedContainerNode containedContainerNode2 = (ContainedContainerNode)containedNode2;
                    containedContainerNode2._contents = RepositoryNode.mergeContent(containedContainerNode2, containedContainerNode._contents, containedContainerNode2._contents, bl);
                }
                vector.setElementAt(containedNode2, n2);
                containedNode2._container = containerNode;
                continue block0;
            }
        }
        n3 = vector2.size();
        block2: for (n2 = 0; n2 < n3; ++n2) {
            n = vector.size();
            for (int i = 0; i < n; ++i) {
                if (vector2.elementAt(n2).equals(vector.elementAt(i))) continue block2;
            }
            ContainedNode containedNode = (ContainedNode)vector2.elementAt(n2);
            vector.addElement(containedNode);
            containedNode._container = containerNode;
        }
        return vector2;
    }

    public final int numObjects() {
        return 1 + this._repIdTable.size() + this._strings.size() + this._wstrings.size() + this._arrays.size() + this._sequences.size() + this._fixeds.size();
    }

    public void recomputeCachedInfo() {
        Node node;
        Hashtable hashtable = this._repIdTable;
        this._repIdTable = new Hashtable();
        this.recomputeRepIdTable(this);
        this.recomputeCachedInfo(this);
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            node = (ContainedNode)enumeration.nextElement();
            Node node2 = (Node)this._repIdTable.get(node._repId);
            if (node2 == null) continue;
            node2._objectKey = node._objectKey;
        }
        enumeration = this._repIdTable.elements();
        while (enumeration.hasMoreElements()) {
            node = (Node)enumeration.nextElement();
            this._objectTable.put(node._objectKey, node);
        }
    }

    private void recomputeCachedInfo(Node node) {
        int n;
        Serializable serializable;
        node._repository = this;
        if (node._kind == 9) {
            serializable = (AliasNode)node;
            ((AliasNode)serializable)._type = this.recomputeCachedInfo(((AliasNode)serializable)._type);
        } else if (node._kind == 21) {
            serializable = (ValueBoxNode)node;
            ((ValueBoxNode)serializable)._type = this.recomputeCachedInfo(((ValueBoxNode)serializable)._type);
        } else if (node.isInheritable()) {
            serializable = (InheritableNode)node;
            this.recomputeCachedInfo(((InheritableNode)serializable)._bases);
            if (((Node)serializable)._kind == 20) {
                ValueNode valueNode = (ValueNode)serializable;
                int n2 = valueNode._bases.size();
                int n3 = 0;
                int n4 = 0;
                block4: for (n = 0; n < n2; ++n) {
                    InheritableNode inheritableNode = (InheritableNode)valueNode._bases.elementAt(n);
                    switch (inheritableNode._kind) {
                        case 20: {
                            if (inheritableNode._abstract) {
                                valueNode._abstractBases.setElementAt(inheritableNode, n3++);
                                continue block4;
                            }
                            valueNode._concreteBase = (ValueNode)inheritableNode;
                            continue block4;
                        }
                        case 5: {
                            if (inheritableNode._abstract) {
                                valueNode._abstractInterfaces.setElementAt(inheritableNode, n4++);
                                continue block4;
                            }
                            valueNode._supportedInterface = (InterfaceNode)inheritableNode;
                        }
                    }
                }
            }
            ((InheritableNode)node).cache();
        } else if (node._kind == 3) {
            serializable = (ConstantNode)node;
            ((ConstantNode)serializable)._type = this.recomputeCachedInfo(((ConstantNode)serializable)._type);
        } else if (node._kind == 22) {
            serializable = (ValueMemberNode)node;
            ((ValueMemberNode)serializable)._type = this.recomputeCachedInfo(((ValueMemberNode)serializable)._type);
        } else if (node.hasFields()) {
            this.recomputeCachedInfo(((FieldNode)node)._memberTypes);
            if (node._kind == 11) {
                serializable = (UnionNode)node;
                ((UnionNode)serializable)._discriminator = this.recomputeCachedInfo(((UnionNode)serializable)._discriminator);
            }
        } else if (node._kind == 7) {
            serializable = (OperationNode)node;
            this.recomputeCachedInfo(((OperationNode)serializable)._paramTypes);
            ((OperationNode)serializable)._result = this.recomputeCachedInfo(((OperationNode)serializable)._result);
            n = ((OperationNode)serializable)._exceptions.size();
            for (int i = 0; i < n; ++i) {
                ((OperationNode)serializable)._exceptions.setElementAt((ExceptionNode)this._repIdTable.get(((ExceptionNode)((OperationNode)serializable)._exceptions.elementAt((int)i))._repId), i);
            }
        } else if (node._kind == 2) {
            serializable = (AttributeNode)node;
            ((AttributeNode)serializable)._type = this.recomputeCachedInfo(((AttributeNode)serializable)._type);
        }
        if (node.isContainer()) {
            serializable = ((ContainerNode)((Object)node)).contents();
            n = ((Vector)serializable).size();
            for (int i = 0; i < n; ++i) {
                this.recomputeCachedInfo((Node)((Vector)serializable).elementAt(i));
            }
        }
    }

    private Type recomputeCachedInfo(PrimitiveNode primitiveNode) {
        switch (primitiveNode._pkind) {
            case 11: {
                return this.ANY_TYPE;
            }
            case 8: {
                return this.BOOL_TYPE;
            }
            case 9: {
                return this.CHAR_TYPE;
            }
            case 7: {
                return this.DOUBLE_TYPE;
            }
            case 6: {
                return this.FLOAT_TYPE;
            }
            case 18: {
                return this.LONGDOUBLE_TYPE;
            }
            case 16: {
                return this.LONGLONG_TYPE;
            }
            case 3: {
                return this.LONG_TYPE;
            }
            case 15: {
                return this.OBJREF_TYPE;
            }
            case 10: {
                return this.OCTET_TYPE;
            }
            case 13: {
                return this.PRINCIPAL_TYPE;
            }
            case 2: {
                return this.SHORT_TYPE;
            }
            case 14: {
                return this.STRING_TYPE;
            }
            case 12: {
                return this.TYPECODE_TYPE;
            }
            case 17: {
                return this.ULONGLONG_TYPE;
            }
            case 5: {
                return this.ULONG_TYPE;
            }
            case 4: {
                return this.USHORT_TYPE;
            }
            case 1: {
                return this.VOID_TYPE;
            }
            case 19: {
                return this.WCHAR_TYPE;
            }
            case 20: {
                return this.WSTRING_TYPE;
            }
            case 21: {
                return this.VALUEBASE_TYPE;
            }
        }
        this._ER.internalError("RepositoryNode.recomputeCachedInfo(PrimitiveNode): unexpected primitive type ".concat(String.valueOf(String.valueOf(primitiveNode.typeName()))));
        return null;
    }

    private Type recomputeCachedInfo(Type type) {
        switch (type.kind()) {
            case 16: {
                ArrayNode arrayNode = (ArrayNode)type;
                arrayNode._type = this.recomputeCachedInfo(arrayNode._type);
                return this.getArray(arrayNode._type, arrayNode._length);
            }
            case 15: {
                SequenceNode sequenceNode = (SequenceNode)type;
                sequenceNode._type = this.recomputeCachedInfo(sequenceNode._type);
                return this.getSequence(sequenceNode._type, sequenceNode._bound, false);
            }
            case 14: {
                return this.getString(((StringNode)type)._bound);
            }
            case 18: {
                return this.getWString(((WStringNode)type)._bound);
            }
            case 19: {
                return this.getFixed(((FixedNode)type)._digits, ((FixedNode)type)._scale);
            }
            case 13: {
                return this.recomputeCachedInfo((PrimitiveNode)type);
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 23: {
                return (Type)this._repIdTable.get(((ContainedNode)((Object)type))._repId);
            }
        }
        this._repository._ER.internalError("RepositoryNode.recomputeCachedInfo(Type): unexpected type ".concat(String.valueOf(String.valueOf(((Node)((Object)type)).typeName()))));
        return null;
    }

    private void recomputeCachedInfo(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            vector.setElementAt(this.recomputeCachedInfo((Type)vector.elementAt(i)), i);
        }
    }

    private void recomputeRepIdTable(ContainerNode containerNode) {
        Vector vector = containerNode.contents();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ContainedNode containedNode = (ContainedNode)vector.elementAt(i);
            this.updateId(containedNode);
            if (!containedNode.isContainer()) continue;
            this.recomputeRepIdTable((ContainerNode)((Object)containedNode));
        }
    }

    public void replaceId(String string, ContainedNode containedNode) {
        Object v = this._repIdTable.get(string);
        if (v != null && v != containedNode) {
            this.error("Comp.AST.repIdAlreadyExists");
            return;
        }
        this._repIdTable.remove(string);
        this.updateId(containedNode);
    }

    public void updateId(ContainedNode containedNode) {
        if (containedNode._repId != null) {
            this._repIdTable.put(containedNode._repId, containedNode);
        }
    }

    public void updateOptionsDependencies() {
        this._mapper.updateOptionsDependencies();
    }
}

