/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.util;

import com.inprise.vbroker.util.SimpleStringBuffer;

public class IndentableStringBuffer {
    protected static final String LINE_SEP = System.getProperty("line.separator");
    protected static final char LINE_SEP_CHAR = LINE_SEP.charAt(0);
    protected static final String COMMA_LINE_SEP = ",".concat(String.valueOf(String.valueOf(LINE_SEP)));
    protected int preferredLineWidth = 78;
    protected int horizPos;
    private int savedHorizPos;
    protected int virtualCharCount;
    protected SimpleStringBuffer outputBuffer;
    protected SimpleStringBuffer buffer = this.outputBuffer = new SimpleStringBuffer();
    private SimpleStringBuffer formerBuffer;
    private SimpleStringBuffer lineBreakBuffer = new SimpleStringBuffer();
    private SimpleStringBuffer tmpBuffer = new SimpleStringBuffer();
    protected static final int NUM_SPACES_PER_INDENT = 2;
    protected int indent = 0;
    public String tabString = null;

    public final void add(char c) {
        this.buffer.append(c);
        ++this.horizPos;
        ++this.virtualCharCount;
    }

    public final void add(int n) {
        this.add(Integer.toString(n));
    }

    public final void add(String string) {
        this.buffer.append(string);
        int n = string.length();
        this.horizPos += n;
        this.virtualCharCount += n;
    }

    public final void addln(int n) {
        this.addln(Integer.toString(n));
    }

    public final void addln(long l) {
        this.addln(Long.toString(l));
    }

    public final void addln(String string) {
        this.buffer.append(string);
        this.buffer.append(LINE_SEP);
        this.horizPos = 0;
        this.virtualCharCount += string.length() + 1;
    }

    public final void beginLineBreaking() {
        this.savedHorizPos = this.horizPos;
        this.lineBreakBuffer.reset();
        this.formerBuffer = this.buffer;
        this.buffer = this.lineBreakBuffer;
    }

    public final void endLineBreaking() {
        this.buffer = this.formerBuffer;
        this.horizPos = this.savedHorizPos;
        boolean bl = true;
        String string = this.lineBreakBuffer.toString();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ',') {
                if (i + 1 < n && string.charAt(i + 1) == ' ') {
                    ++i;
                }
                this.tmpBuffer.append(',');
                bl = this.lineBreakWord(bl);
                continue;
            }
            this.tmpBuffer.append(c);
        }
        this.lineBreakWord(bl);
    }

    public final void ensureIndent() {
        if (this.horizPos == 0) {
            this.indent();
        }
    }

    public final void ensureNewLine() {
        if (this.horizPos != 0) {
            this.newLine();
        }
    }

    public final String getCurrentIndent() {
        if (this.tabString == null) {
            String string = "";
            for (int i = 0; i < this.indent * 2; ++i) {
                string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(' ')));
            }
            return string;
        }
        return this.tabString;
    }

    public final int horizPos() {
        return this.horizPos;
    }

    public final void horizPos(int n) {
        this.indent = n;
    }

    public final void indent() {
        if (this.tabString == null) {
            int n = 2 * this.indent;
            this.buffer.append(' ', n);
            this.horizPos += n;
        } else {
            this.buffer.append(this.tabString);
            this.horizPos += this.tabString.length();
        }
    }

    public final void indent(int n) {
        this.indent += n;
    }

    public final void indentTo(int n) {
        this.buffer.append(' ', n);
        this.horizPos += n;
    }

    public int length() {
        return this.buffer.toString().length();
    }

    private final boolean lineBreakWord(boolean bl) {
        if (this.tmpBuffer.length() > 0) {
            String string = this.tmpBuffer.toString();
            this.tmpBuffer.reset();
            if (bl) {
                this.add(string);
            } else if (this.horizPos + 1 + string.length() > this.preferredLineWidth && this.horizPos > this.savedHorizPos) {
                this.newLine();
                this.indentTo(this.savedHorizPos);
                this.add(string);
            } else {
                this.add(' ');
                this.add(string);
            }
            return false;
        }
        return bl;
    }

    public final void newLine() {
        this.buffer.append(LINE_SEP);
        this.horizPos = 0;
        ++this.virtualCharCount;
    }

    public final void print(String string) {
        this.indent();
        this.buffer.append(string);
        int n = string.length();
        this.horizPos += n;
        this.virtualCharCount += n;
    }

    public final void printUnindented(String string) {
        this.buffer.append(string);
        int n = string.length();
        this.horizPos += n;
        this.virtualCharCount += n;
    }

    public final void println(String string) {
        this.indent();
        this.buffer.append(string);
        this.buffer.append(LINE_SEP);
        this.horizPos = 0;
        this.virtualCharCount += string.length() + 1;
    }

    public final void reset() {
        this.horizPos = 0;
        this.savedHorizPos = 0;
        this.virtualCharCount = 0;
        this.indent = 0;
        this.tabString = null;
        if (this.outputBuffer != null) {
            this.outputBuffer.reset();
        }
        if (this.formerBuffer != null) {
            this.formerBuffer.reset();
        }
        if (this.lineBreakBuffer != null) {
            this.lineBreakBuffer.reset();
        }
        if (this.tmpBuffer != null) {
            this.tmpBuffer.reset();
        }
        this.buffer = this.outputBuffer;
    }

    public final void setIndent(int n) {
        this.indent = n;
    }

    public String toString() {
        return this.buffer.toString();
    }

    static {
        NUM_SPACES_PER_INDENT = 2;
    }
}

