/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.preprocessor;

import com.inprise.vbroker.compiler.preprocessor.ConditionalInfo;
import com.inprise.vbroker.compiler.preprocessor.ConstExprParserWrapper;
import com.inprise.vbroker.compiler.preprocessor.FunctionalMacro;
import com.inprise.vbroker.compiler.preprocessor.IDLppOptions;
import com.inprise.vbroker.compiler.preprocessor.Macro;
import com.inprise.vbroker.compiler.preprocessor.OpenStream;
import com.inprise.vbroker.compiler.preprocessor.SimpleMacro;
import com.inprise.vbroker.compiler.util.BufferReader;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.compiler.util.Utils;
import com.inprise.vbroker.util.LexicalTables;
import com.inprise.vbroker.util.SimpleStringBuffer;
import com.inprise.vbroker.util.StringFunctions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public final class IDLpp
implements LexicalTables {
    private static final boolean Debug = false;
    private static final boolean Trace = false;
    private static final boolean Timing = false;
    private static final String _lineSeparator;
    private String CurrentWorkingDirectory;
    private String _sysInclLoc;
    String LineSeparator;
    byte FirstLineSeparatorChar;
    int LineSeparatorLength;
    private ErrorReporter ER;
    private OpenStream Input;
    private long InputDepth = 0L;
    private long SavedInputDepth = -1L;
    private BufferReader Reader;
    private Sink Out;
    private Sink PreviousSink;
    private Sink NormalSink;
    private Sink OneLineSink = new Sink();
    private Sink MacroArgSink = new Sink();
    private boolean GenerateOutput = true;
    private boolean GenerateLineDirectives = true;
    private boolean NotifyInclusions = false;
    private boolean RetainComments = false;
    private boolean RetainLineDirectives = true;
    private boolean ShowAllLines = false;
    private Vector IncludePaths = new Vector();
    private long PendingOutputNewlines = 0L;
    private long LastErrorCharLineNumber = -1L;
    private final Hashtable MacroTable = new Hashtable(128);
    final boolean[] MacroHitTable = new boolean[256];
    FunctionalMacro BuiltinDefinedMacro;
    private boolean SubstituteMacros = true;
    private int Mode = 0;
    private static final int NORMAL_MODE = 0;
    private static final int GATHERING_MACRO_ARGS_MODE = 1;
    private static final int READING_MACRO_BODY_MODE = 2;
    private FunctionalMacro CurrentMacro;
    private Vector MacroArgs = new Vector();
    private int ParenNestingLevel;
    private StringBuffer StrBuf = new StringBuffer(128);
    private final ConstExprParserWrapper ConstParser = new ConstExprParserWrapper();
    private Vector TopLevelIncludedFiles;
    private IDLppOptions _options;

    public IDLpp(String string, InputStream inputStream, OutputStream outputStream, IDLppOptions iDLppOptions, BufferReader bufferReader, Vector vector) {
        this.LineSeparator = System.getProperty("line.separator");
        this.LineSeparatorLength = this.LineSeparator.length();
        this.FirstLineSeparatorChar = (byte)this.LineSeparator.charAt(0);
        this._options = iDLppOptions;
        this.ER = iDLppOptions._ER;
        this.Reader = bufferReader;
        this.TopLevelIncludedFiles = vector;
        this.CurrentWorkingDirectory = System.getProperty("user.dir");
        String string2 = System.getProperty("vbroker.installDir");
        if (string2 != null) {
            this._sysInclLoc = Utils.canonicalize(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(File.separatorChar).append("idl"))));
        }
        try {
            this.Input = new OpenStream(inputStream, "", string, -1);
            this.Out = this.NormalSink = new Sink(outputStream);
        }
        catch (IOException iOException) {
            this.ER.internalError("unable to read from bootstrap stream");
        }
    }

    private void EOFCleanup() throws IOException {
        if (this.Mode == 1) {
            this.stopMacroArgs();
            this.error("MacroUse.EOF", this.CurrentMacro.name());
            this.CurrentMacro = null;
        }
        this.LastErrorCharLineNumber = -1L;
        this.Mode = 0;
        this.SubstituteMacros = true;
        this.PendingOutputNewlines = 0L;
    }

    public static Result VisiBrokerPreprocess(IDLppOptions iDLppOptions, String string, BufferReader bufferReader, Vector vector) {
        ErrorReporter errorReporter = iDLppOptions._ER;
        boolean bl = errorReporter._multipleMessagesPerLine;
        errorReporter._multipleMessagesPerLine = true;
        String string2 = System.getProperty("vbroker.installDir");
        if (string2 != null) {
            string2 = Utils.canonicalize(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(File.separatorChar).append("idl"))));
            iDLppOptions._includes.insertElementAt(string2, 0);
        }
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(string);
        Result result = IDLpp.preprocessToString(iDLppOptions, vector2, bufferReader, vector);
        errorReporter._multipleMessagesPerLine = bl;
        return result;
    }

    private void _newLine() throws IOException {
        for (int i = 0; i < this.LineSeparatorLength; ++i) {
            int n;
            byte[] byArray = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n2 = this.Out.I;
                n = n2;
                this.Out.I = n2 + 1;
            } else {
                n = this.f();
            }
            byArray[n] = (byte)this.LineSeparator.charAt(i);
        }
    }

    private String builtinFunctionalMacro(String string, Vector vector) {
        if (string.equals("defined")) {
            if (vector.size() != 1) {
                this.error("MacroUse.argNumberMismatch", "defined");
                return "0L";
            }
            String string2 = (String)vector.elementAt(0);
            String string3 = this.MacroTable.get(string2) == null ? "0L" : "1L";
            return string3;
        }
        this.ER.internalError("unknown builtin macro name ".concat(String.valueOf(String.valueOf(string))));
        return null;
    }

    private String builtinSimpleMacro(String string) {
        if (string.equals("__LINE__")) {
            return "".concat(String.valueOf(String.valueOf(this.Input.LineNumber)));
        }
        if (string.equals("__FILE__")) {
            return String.valueOf(String.valueOf(new StringBuffer("\"").append(this.Input.FileName).append("\"")));
        }
        if (string.equals("__DATE__")) {
            return this.getDateAsLiteralString();
        }
        if (string.equals("__TIME__")) {
            return this.getTimeAsLiteralString();
        }
        this.ER.internalError("unknown builtin macro name ".concat(String.valueOf(String.valueOf(string))));
        return null;
    }

    private boolean cleanupNewline() throws IOException {
        if (this.Input.Index == this.Input.Length && !this.reload()) {
            return false;
        }
        if (this.startsLineSep(this.Input.Buffer[this.Input.Index])) {
            this.processNewline(false);
            return true;
        }
        return false;
    }

    private byte[] collectAndProcessUntilNewline(boolean bl, String string) throws IOException {
        String string2 = String.valueOf(String.valueOf(this.gatherUntilNewline())).concat(String.valueOf(String.valueOf(string)));
        if (string2.length() == 0) {
            return new byte[0];
        }
        this.startLineGather();
        if (!bl) {
            this.SubstituteMacros = false;
        }
        OpenStream openStream = this.Input;
        this.Input = new OpenStream(string2.getBytes("8859_1"), this.Input, null);
        this.process();
        this.Input = openStream;
        byte[] byArray = this.Out.toByteArray();
        this.stopLineGather();
        if (!bl) {
            this.SubstituteMacros = true;
        }
        return byArray;
    }

    private void createFunctionalMacro(String string) throws IOException {
        String string2;
        this.gatherFormalArgs();
        this.CurrentMacro = new FunctionalMacro(string, this.Input.FileName, this.Input.LineNumber, this.MacroArgs.size(), false);
        this.Mode = 2;
        String string3 = this.stringCopyOfProcessedTextUntilNewline(true).trim();
        if (!string3.equals("") && (string2 = this.CurrentMacro.addLiteralString(string3)) != null) {
            this.error(string2);
        }
        if ((string2 = this.CurrentMacro.finishDefinition()) != null) {
            this.error(string2);
        }
        this.Mode = 0;
        this.installMacro(this.CurrentMacro, true);
    }

    private void createSimpleMacro(String string) throws IOException {
        byte[] byArray = this.collectAndProcessUntilNewline(false, " ");
        this.installMacro(new SimpleMacro(string, this.Input.FileName, this.Input.LineNumber, byArray), true);
    }

    private boolean directiveError(String string) {
        return this.ER.error("Comp.PP.Directive.".concat(String.valueOf(String.valueOf(string))), this.ER.setFile(this.Input.FileName), this.Input.LineNumber);
    }

    private boolean directiveError(String string, String string2) {
        return this.ER.error("Comp.PP.Directive.".concat(String.valueOf(String.valueOf(string))), this.ER.setFile(this.Input.FileName), this.Input.LineNumber, string2);
    }

    private boolean directiveWarn(String string) {
        return this.ER.warn("Comp.PP.Directive.".concat(String.valueOf(String.valueOf(string))), this.ER.setFile(this.Input.FileName), this.Input.LineNumber);
    }

    private boolean directiveWarn(String string, String string2) {
        return this.ER.warn("Comp.PP.Directive.".concat(String.valueOf(String.valueOf(string))), this.ER.setFile(this.Input.FileName), this.Input.LineNumber, string2);
    }

    private boolean directiveWarn(String string, String string2, long l) {
        return this.ER.warn2("Comp.PP.Directive.".concat(String.valueOf(String.valueOf(string))), this.ER.setFile(this.Input.FileName), this.Input.LineNumber, "Comp.PP.Directive.".concat(String.valueOf(String.valueOf(string2))), this.ER.setFile(this.Input.FileName), l);
    }

    private boolean eliminateLineContinuation() throws IOException {
        if (this.Input.advance() && this.startsLineSep(this.Input.Buffer[this.Input.Index])) {
            this.processNewline(true);
            return true;
        }
        return false;
    }

    private boolean error(String string) {
        return this.ER.error("Comp.PP.".concat(String.valueOf(String.valueOf(string))), this.ER.setFile(this.Input.FileName), this.Input.LineNumber);
    }

    private boolean error(String string, String string2) {
        return this.ER.error("Comp.PP.".concat(String.valueOf(String.valueOf(string))), this.ER.setFile(this.Input.FileName), this.Input.LineNumber, string2);
    }

    private String escChar(byte by) {
        return this.escChar((char)(by & 0xFF));
    }

    private String escChar(char c) {
        return String.valueOf(String.valueOf(new StringBuffer("'").append(StringFunctions.ISOLatin1CharToPrintable(c, false)).append("'")));
    }

    public void execute() {
        this.initializeBuiltinMacros();
        try {
            this.process();
        }
        catch (IOException iOException) {
            if (this.SavedInputDepth > 100L) {
                this.ER.fatal("Comp.IOErrorMaybeInputDepth", new Object[]{new Long(this.SavedInputDepth)});
            }
            this.ER.fatal("Comp.IOError");
        }
    }

    private int f() throws IOException {
        this.Out.flush();
        return this.Out.I++;
    }

    String[] fileSpecToPathNames(String string) {
        String string2 = Utils.canonicalize(string.substring(1, string.length() - 1));
        if (new File(string2).isAbsolute()) {
            return new String[]{string2};
        }
        if (string2.equals("-")) {
            return new String[]{null};
        }
        string2 = Utils.mapHyphenNames(string2);
        String[] stringArray = new String[this.IncludePaths.size() + 1];
        stringArray[0] = this.Input.Directory.equals(this.CurrentWorkingDirectory) ? string2 : new File(this.Input.Directory, string2).getAbsolutePath();
        for (int i = 0; i < this.IncludePaths.size(); ++i) {
            stringArray[i + 1] = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf((String)this.IncludePaths.elementAt(i)))).append(File.separatorChar).append(string2)));
        }
        return stringArray;
    }

    private String gatherErrorText() throws IOException {
        String string = this.gatherUntilNewline().trim();
        this.cleanupNewline();
        return string;
    }

    private void gatherFormalArgs() throws IOException {
        this.MacroArgs.setSize(0);
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        ++this.Input.Index;
        while (true) {
            if (this.Input.Index == this.Input.Length && !this.reload()) {
                this.directiveError("define.formals.EOF");
                return;
            }
            byte by = this.Input.Buffer[this.Input.Index];
            if (LexicalTables.IDLCharClass[by & 0xFF] == 1) {
                String string2 = this.gatherIdentifier();
                if (string == null) {
                    string = string2;
                } else {
                    this.directiveError("define.formals.multiForm", string2);
                }
                bl2 = false;
                continue;
            }
            if (LexicalTables.IDLCharClass[by & 0xFF] == 0) {
                this.outputWhitespace();
                continue;
            }
            if (by == 92) {
                if (this.eliminateLineContinuation()) continue;
                this.error("LonelyBackslash");
                continue;
            }
            if (by == 41) {
                if (string == null && bl2) {
                    this.directiveWarn("define.formals.emptyArg");
                }
                if (string != null) {
                    if (this.MacroArgs.contains(string)) {
                        this.directiveError("define.formals.dupName", string);
                    }
                    this.MacroArgs.addElement(string);
                }
                ++this.Input.Index;
                return;
            }
            if (by == 44) {
                if (string == null) {
                    this.directiveWarn("define.formals.emptyArg");
                    string = "";
                } else if (this.MacroArgs.contains(string)) {
                    this.directiveError("define.formals.dupName", string);
                }
                this.MacroArgs.addElement(string);
                string = null;
                bl2 = true;
                ++this.Input.Index;
                continue;
            }
            if (this.startsLineSep(by)) {
                this.directiveError("define.formals.unterminated");
                return;
            }
            if (!bl) {
                bl = true;
                this.directiveError("define.formals.badChar", this.escChar(by));
            }
            ++this.Input.Index;
        }
    }

    private String gatherIdentifier() throws IOException {
        this.StrBuf.setLength(0);
        this.StrBuf.append((char)(this.Input.Buffer[this.Input.Index] & 0xFF));
        ++this.Input.Index;
        while (this.Input.Index != this.Input.Length || this.reload()) {
            byte by = this.Input.Buffer[this.Input.Index];
            if (LexicalTables.IDLCharClass[by & 0xFF] == 1 || LexicalTables.IDLCharClass[by & 0xFF] == 2) {
                this.StrBuf.append((char)(by & 0xFF));
                ++this.Input.Index;
                continue;
            }
            if (by != 92) break;
            if (this.eliminateLineContinuation()) continue;
            this.error("LonelyBackslash");
            break;
        }
        return this.StrBuf.toString();
    }

    private String gatherUntilNewline() throws IOException {
        this.StrBuf.setLength(0);
        while (this.Input.Index != this.Input.Length || this.reload()) {
            byte by = this.Input.Buffer[this.Input.Index];
            if (by == 92) {
                if (this.eliminateLineContinuation()) continue;
                this.StrBuf.append((char)(by & 0xFF));
                continue;
            }
            if (this.startsLineSep(by)) {
                return this.StrBuf.toString();
            }
            this.StrBuf.append((char)(by & 0xFF));
            ++this.Input.Index;
        }
        return this.StrBuf.toString();
    }

    private String getDateAsLiteralString() {
        String string = "\"";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("dd");
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("yyyy");
        Date date = new Date();
        String string2 = simpleDateFormat.format(date);
        String string3 = simpleDateFormat2.format(date);
        String string4 = simpleDateFormat3.format(date);
        if (string3.charAt(0) == '0') {
            string3 = " ".concat(String.valueOf(String.valueOf(string3.charAt(1))));
        }
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(string2).append(" ").append(string3).append(" ").append(string4).append("\"")));
    }

    private String getTimeAsLiteralString() {
        return String.valueOf(String.valueOf(new StringBuffer("\"").append(new SimpleDateFormat("HH:mm:ss").format(new Date())).append("\"")));
    }

    private void handleDirective() throws IOException {
        block27: {
            byte by;
            block28: {
                while (true) {
                    if (this.Input.Index == this.Input.Length && !this.reload()) {
                        return;
                    }
                    by = this.Input.Buffer[this.Input.Index];
                    if (LexicalTables.IDLCharClass[by & 0xFF] == 0) {
                        this.outputWhitespace();
                        continue;
                    }
                    if (LexicalTables.IDLCharClass[by & 0xFF] == 1) break block27;
                    if (by != 92) break block28;
                    if (!this.eliminateLineContinuation()) break;
                }
                this.directiveError("lonelyBackslash1");
                return;
            }
            if (this.startsLineSep(by)) {
                this.cleanupNewline();
            } else {
                this.directiveError("badPostScratchChar", this.escChar(by));
                this.gatherErrorText();
            }
            return;
        }
        String string = this.gatherIdentifier();
        if (string.equals("include")) {
            this.processIncludeDirective();
            return;
        }
        if (string.equals("define")) {
            this.processDefineDirective();
        } else if (string.equals("if")) {
            this.processIfDirective();
        } else if (string.equals("else")) {
            this.processElseDirective();
        } else if (string.equals("endif")) {
            this.processEndIfDirective();
        } else if (string.equals("ifdef")) {
            this.processIfDefDirective(false);
        } else if (string.equals("ifndef")) {
            this.processIfDefDirective(true);
        } else if (string.equals("undef")) {
            this.processUnDefDirective();
        } else {
            if (string.equals("line")) {
                this.processLineDirective();
                return;
            }
            if (string.equals("elif")) {
                this.processElIfDirective();
            } else if (string.equals("error")) {
                this.processErrorDirective();
            } else if (string.equals("pragma")) {
                this.processPragmaDirective();
            } else {
                this.directiveError("unknown", string);
                this.gatherErrorText();
                return;
            }
        }
        this.cleanupNewline();
    }

    private void handleErrorChar(byte by) throws IOException {
        int n;
        if (by == 13 && this.FirstLineSeparatorChar != by) {
            ++this.Input.Index;
            return;
        }
        if (this.Input.LineNumber != this.LastErrorCharLineNumber) {
            this.warn("BadChar", this.escChar(by));
            this.LastErrorCharLineNumber = this.Input.LineNumber;
        }
        byte[] byArray = this.Out.Buf;
        if (this.Out.I < this.Out.Len) {
            int n2 = this.Out.I;
            n = n2;
            this.Out.I = n2 + 1;
        } else {
            n = this.f();
        }
        byArray[n] = by;
        ++this.Input.Index;
    }

    private void initializeBuiltinMacros() {
        this.installMacro(new SimpleMacro("__DATE__"), false);
        this.installMacro(new SimpleMacro("__FILE__"), false);
        this.installMacro(new SimpleMacro("__LINE__"), false);
        this.installMacro(new SimpleMacro("__TIME__"), false);
        this.BuiltinDefinedMacro = new FunctionalMacro("defined", null, -1L, 1, true);
    }

    private boolean installMacro(Macro macro, boolean bl) {
        Macro macro2;
        String string = macro.name();
        if (bl && (macro2 = (Macro)this.MacroTable.get(string)) != null) {
            if (macro2.isBuiltin()) {
                this.directiveError("define.builtin");
                return false;
            }
            if (macro2.equals(macro)) {
                return true;
            }
            if (this.directiveWarn("define.exists", string)) {
                if (macro2.fileName().equals(this.Input.FileName)) {
                    this.ER.add("Comp.PP.Directive.define.exists1", new Object[]{new Long(macro2.lineNumber())});
                } else {
                    this.ER.add("Comp.PP.Directive.define.exists2", new Object[]{this.prepFilename(macro2.fileName()), new Long(macro2.lineNumber())});
                }
            }
        }
        this.MacroTable.put(string, macro);
        byte by = (byte)string.charAt(0);
        this.MacroHitTable[by] = true;
        return true;
    }

    private void invokeMacro() throws IOException {
        String string = this.Out.toString().trim();
        this.stopMacroArgs();
        if (this.MacroArgs.size() > 0 || string.length() > 0) {
            this.MacroArgs.addElement(string);
        }
        this.Mode = 0;
        this.SubstituteMacros = true;
        if (this.CurrentMacro.isBuiltin()) {
            String string2 = this.builtinFunctionalMacro(this.CurrentMacro.name(), this.MacroArgs);
            byte[] byArray = string2.getBytes("8859_1");
            this.pushTemporaryInput(byArray, null);
        } else {
            this.MacroTable.remove(this.CurrentMacro.name());
            if (this.MacroArgs.size() != this.CurrentMacro.numArgs()) {
                this.error("MacroUse.argNumberMismatch", this.CurrentMacro.name());
            }
            this.pushTemporaryInput(this.CurrentMacro.value(this.MacroArgs), this.CurrentMacro);
        }
        this.CurrentMacro = null;
    }

    private static boolean isLegalIdent(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') {
            int n = string.length();
            for (int i = 1; i < n; ++i) {
                c = string.charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static ByteArrayInputStream makeBootstrapStream(IDLppOptions iDLppOptions, String string) {
        return IDLpp.makeBootstrapStreamWorker(iDLppOptions, string);
    }

    private static ByteArrayInputStream makeBootstrapStream(IDLppOptions iDLppOptions, Vector vector) {
        SimpleStringBuffer simpleStringBuffer = new SimpleStringBuffer();
        if (vector == null) {
            simpleStringBuffer.append("#include \"-\"".concat(String.valueOf(String.valueOf(_lineSeparator))));
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                simpleStringBuffer.append("#include \"");
                simpleStringBuffer.append((String)vector.elementAt(i));
                simpleStringBuffer.append("\"".concat(String.valueOf(String.valueOf(_lineSeparator))));
            }
        }
        return IDLpp.makeBootstrapStreamWorker(iDLppOptions, simpleStringBuffer.toString());
    }

    private static ByteArrayInputStream makeBootstrapStreamWorker(IDLppOptions iDLppOptions, String string) {
        String string2;
        int n;
        SimpleStringBuffer simpleStringBuffer = new SimpleStringBuffer();
        simpleStringBuffer.append("#line -2147483648".concat(String.valueOf(String.valueOf(_lineSeparator))));
        Vector vector = iDLppOptions._includes;
        int n2 = vector == null ? 0 : vector.size();
        for (n = 0; n < n2; ++n) {
            simpleStringBuffer.append("#pragma Inprise IDLpp appendToIncludePaths \"");
            simpleStringBuffer.append((String)vector.elementAt(n));
            simpleStringBuffer.append("\"".concat(String.valueOf(String.valueOf(_lineSeparator))));
        }
        if (!iDLppOptions._lineDirectives) {
            simpleStringBuffer.append("#pragma Inprise IDLpp suppressLinePragmas");
            simpleStringBuffer.append(_lineSeparator);
        }
        if (iDLppOptions._showInclusions) {
            simpleStringBuffer.append("#pragma Inprise IDLpp showInclusions");
            simpleStringBuffer.append(_lineSeparator);
        }
        if (iDLppOptions._retainComments) {
            simpleStringBuffer.append("#pragma Inprise IDLpp retainComments");
            simpleStringBuffer.append(_lineSeparator);
        }
        for (n = 0; n < iDLppOptions._defines.size(); ++n) {
            if (iDLppOptions._defOrUndef.elementAt(n) == Boolean.TRUE) {
                String string3 = string2 = (String)iDLppOptions._defines.elementAt(n);
                String string4 = "";
                if (string2.indexOf(61) != -1) {
                    string3 = string2.substring(0, string2.indexOf(61));
                    string4 = string2.substring(string2.indexOf(61) + 1, string2.length());
                }
                simpleStringBuffer.append("#ifdef ");
                simpleStringBuffer.append(string3);
                simpleStringBuffer.append(String.valueOf(String.valueOf(_lineSeparator)).concat("#undef "));
                simpleStringBuffer.append(string3);
                simpleStringBuffer.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(_lineSeparator))).append("#endif").append(_lineSeparator).append("#define "))));
                simpleStringBuffer.append(string3);
                simpleStringBuffer.append(" ");
                simpleStringBuffer.append(string4);
                simpleStringBuffer.append(_lineSeparator);
                continue;
            }
            string2 = (String)iDLppOptions._defines.elementAt(n);
            simpleStringBuffer.append("#ifdef ");
            simpleStringBuffer.append(string2);
            simpleStringBuffer.append(String.valueOf(String.valueOf(_lineSeparator)).concat("#undef "));
            simpleStringBuffer.append(string2);
            simpleStringBuffer.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(_lineSeparator))).append("#endif").append(_lineSeparator))));
        }
        simpleStringBuffer.append("#define __STD_IDL__ 1".concat(String.valueOf(String.valueOf(_lineSeparator))));
        simpleStringBuffer.append("#define __INPRISE__ 1".concat(String.valueOf(String.valueOf(_lineSeparator))));
        simpleStringBuffer.append("#define __MAJOR_VERSION__ 04".concat(String.valueOf(String.valueOf(_lineSeparator))));
        simpleStringBuffer.append("#define __MINOR_VERSION__ 00".concat(String.valueOf(String.valueOf(_lineSeparator))));
        simpleStringBuffer.append(string);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(simpleStringBuffer.toString().getBytes("8859_1"));
            return byteArrayInputStream;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = null;
            return string2;
        }
    }

    private void maybeInstantiateMacro(String string, Macro macro) throws IOException {
        if (macro.isSimple()) {
            if (macro.isBuiltin()) {
                this.pushTemporaryInput(this.builtinSimpleMacro(string).getBytes("8859_1"), null);
            } else {
                SimpleMacro simpleMacro = (SimpleMacro)macro;
                byte[] byArray = simpleMacro.value();
                if (byArray.length > 0) {
                    this.MacroTable.remove(macro.name());
                    this.pushTemporaryInput(byArray, macro);
                }
            }
            return;
        }
        this.CurrentMacro = (FunctionalMacro)macro;
        byte by = this.outputOptionalWhitespaceOrComment();
        if (this.Input.Index == this.Input.Length || this.Input.Buffer[this.Input.Index] != 40) {
            this.writeString(string);
            if (by == 47 || by == 92) {
                this.pushBack(by);
            }
            return;
        }
        ++this.Input.Index;
        this.ParenNestingLevel = 1;
        this.Mode = 1;
        this.MacroArgs.setSize(0);
        this.SubstituteMacros = false;
        if (by == 47 || by == 92) {
            this.pushBack(by);
        }
        this.startMacroArgs();
    }

    private void maybeWarnOfOpenConditionals(ConditionalInfo[] conditionalInfoArray) {
        if (conditionalInfoArray == null) {
            return;
        }
        for (int i = 0; i < conditionalInfoArray.length; ++i) {
            this.directiveWarn("OpenConditional", conditionalInfoArray[i].Type, conditionalInfoArray[i].LineNumber);
        }
    }

    private void newLine() throws IOException {
        this._newLine();
        if (this.GenerateLineDirectives && this.ShowAllLines) {
            this.writeString("#line ".concat(String.valueOf(String.valueOf(this.Input.LineNumber))));
            this._newLine();
        }
    }

    private OpenStream openFile(String string) throws IOException {
        if (string == null) {
            return new OpenStream(System.in, this.ER.getMesg("Comp.Stdin"), this.CurrentWorkingDirectory, -1);
        }
        File file = this.Reader.getFile(string);
        if (file.exists() && file.canRead()) {
            InputStream inputStream = this.Reader.getInputStream(file);
            ++this.InputDepth;
            String string2 = new File(file.getAbsolutePath()).getParent();
            return new OpenStream(inputStream, string, string2, (int)file.length());
        }
        return null;
    }

    private boolean outputComment() throws IOException {
        boolean bl;
        byte by;
        long l;
        block36: {
            block37: {
                l = this.Input.LineNumber;
                ++this.Input.Index;
                do {
                    if (this.Input.Index == this.Input.Length && !this.reload()) {
                        return false;
                    }
                    by = this.Input.Buffer[this.Input.Index];
                    if (by == 42) {
                        bl = true;
                        ++this.Input.Index;
                        break block36;
                    }
                    if (by == 47) {
                        bl = false;
                        ++this.Input.Index;
                        break block36;
                    }
                    if (by != 92) break block37;
                } while (this.eliminateLineContinuation());
                return false;
            }
            return false;
        }
        if (this.RetainComments) {
            int n;
            int n2;
            byte[] byArray = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n3 = this.Out.I;
                n2 = n3;
                this.Out.I = n3 + 1;
            } else {
                n2 = this.f();
            }
            byArray[n2] = 47;
            byte[] byArray2 = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n4 = this.Out.I;
                n = n4;
                this.Out.I = n4 + 1;
            } else {
                n = this.f();
            }
            byArray2[n] = bl ? 42 : 47;
        } else {
            int n;
            byte[] byArray = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n5 = this.Out.I;
                n = n5;
                this.Out.I = n5 + 1;
            } else {
                n = this.f();
            }
            byArray[n] = 32;
        }
        boolean bl2 = false;
        while (true) {
            if (this.Input.Index == this.Input.Length && !this.reload()) {
                if (bl) {
                    this.warn("Comment.unterminated", "".concat(String.valueOf(String.valueOf(l))));
                }
                return true;
            }
            by = this.Input.Buffer[this.Input.Index];
            if (this.startsLineSep(by)) {
                if (!bl) {
                    return true;
                }
                this.processNewline(false);
                continue;
            }
            if (by == 42) {
                bl2 = true;
                if (this.RetainComments) {
                    int n;
                    byte[] byArray = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n6 = this.Out.I;
                        n = n6;
                        this.Out.I = n6 + 1;
                    } else {
                        n = this.f();
                    }
                    byArray[n] = 42;
                }
                ++this.Input.Index;
                continue;
            }
            if (by == 47) {
                ++this.Input.Index;
                if (bl && bl2) {
                    if (this.RetainComments) {
                        int n;
                        byte[] byArray = this.Out.Buf;
                        if (this.Out.I < this.Out.Len) {
                            int n7 = this.Out.I;
                            n = n7;
                            this.Out.I = n7 + 1;
                        } else {
                            n = this.f();
                        }
                        byArray[n] = 47;
                    }
                    return true;
                }
                if (this.RetainComments) {
                    int n;
                    byte[] byArray = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n8 = this.Out.I;
                        n = n8;
                        this.Out.I = n8 + 1;
                    } else {
                        n = this.f();
                    }
                    byArray[n] = by;
                }
                bl2 = false;
                continue;
            }
            if (by == 92) {
                if (this.eliminateLineContinuation()) continue;
                if (this.RetainComments) {
                    int n;
                    byte[] byArray = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n9 = this.Out.I;
                        n = n9;
                        this.Out.I = n9 + 1;
                    } else {
                        n = this.f();
                    }
                    byArray[n] = 92;
                }
                bl2 = false;
                continue;
            }
            if (this.RetainComments) {
                int n;
                byte[] byArray = this.Out.Buf;
                if (this.Out.I < this.Out.Len) {
                    int n10 = this.Out.I;
                    n = n10;
                    this.Out.I = n10 + 1;
                } else {
                    n = this.f();
                }
                byArray[n] = by;
            }
            ++this.Input.Index;
            bl2 = false;
        }
    }

    private void outputEndOfFixedOrFloatingPointLiteral() throws IOException {
        this.outputInteger(10);
        if (this.outputIfPresent('e', 'E')) {
            this.outputIfPresent('+', '-');
            this.outputInteger(10);
            if (this.outputIfPresent('f', 'F')) {
                return;
            }
            this.outputIfPresent('l', 'L');
        } else {
            this.outputIfPresent('d', 'D');
        }
    }

    private void outputIdentifier(byte by) throws IOException {
        int n;
        byte[] byArray = this.Out.Buf;
        if (this.Out.I < this.Out.Len) {
            int n2 = this.Out.I;
            n = n2;
            this.Out.I = n2 + 1;
        } else {
            n = this.f();
        }
        byArray[n] = by;
        ++this.Input.Index;
        while (this.Input.Index != this.Input.Length || this.reload()) {
            byte by2 = this.Input.Buffer[this.Input.Index];
            if (LexicalTables.IDLCharClass[by2 & 0xFF] == 1 || LexicalTables.IDLCharClass[by2 & 0xFF] == 2) {
                int n3;
                byte[] byArray2 = this.Out.Buf;
                if (this.Out.I < this.Out.Len) {
                    int n4 = this.Out.I;
                    n3 = n4;
                    this.Out.I = n4 + 1;
                } else {
                    n3 = this.f();
                }
                byArray2[n3] = by2;
                ++this.Input.Index;
                continue;
            }
            if (by2 != 92) break;
            if (this.eliminateLineContinuation()) continue;
            this.error("LonelyBackslash");
            return;
        }
    }

    private void outputIdentifierInMacroBody(String string) throws IOException {
        if (this.MacroArgs.contains(string)) {
            String string2;
            String string3 = this.Out.toString().trim();
            if (!string3.equals("") && (string2 = this.CurrentMacro.addLiteralString(string3)) != null) {
                this.error(string2);
            }
            this.CurrentMacro.addFormal(this.MacroArgs.indexOf(string));
        } else {
            this.writeString(string);
        }
    }

    private boolean outputIfPresent(char c) throws IOException {
        return this.outputIfPresent(c, c);
    }

    private boolean outputIfPresent(char c, char c2) throws IOException {
        if (this.Input.Index == this.Input.Length && !this.reload()) {
            return false;
        }
        if (this.Input.Buffer[this.Input.Index] == c || this.Input.Buffer[this.Input.Index] == c2) {
            int n;
            byte[] byArray = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n2 = this.Out.I;
                n = n2;
                this.Out.I = n2 + 1;
            } else {
                n = this.f();
            }
            byArray[n] = this.Input.Buffer[this.Input.Index++];
            if (this.Input.Index == this.Input.Length) {
                this.reload();
            }
            return true;
        }
        return false;
    }

    private void outputInteger(int n) throws IOException {
        block17: {
            while (true) {
                byte by;
                if (n == 10) {
                    while (this.Input.Index < this.Input.Length && LexicalTables.IDLCharClass[this.Input.Buffer[this.Input.Index] & 0xFF] == 2) {
                        int n2;
                        byte[] byArray = this.Out.Buf;
                        if (this.Out.I < this.Out.Len) {
                            int n3 = this.Out.I;
                            n2 = n3;
                            this.Out.I = n3 + 1;
                        } else {
                            n2 = this.f();
                        }
                        byArray[n2] = this.Input.Buffer[this.Input.Index++];
                    }
                } else if (n == 8) {
                    while (this.Input.Index < this.Input.Length && LexicalTables.IDLCharClass[(by = this.Input.Buffer[this.Input.Index]) & 0xFF] == 2 && by != 56 && by != 57) {
                        int n4;
                        byte[] byArray = this.Out.Buf;
                        if (this.Out.I < this.Out.Len) {
                            int n5 = this.Out.I;
                            n4 = n5;
                            this.Out.I = n5 + 1;
                        } else {
                            n4 = this.f();
                        }
                        byArray[n4] = this.Input.Buffer[this.Input.Index++];
                    }
                } else if (n == 16) {
                    while (this.Input.Index < this.Input.Length && (LexicalTables.IDLCharClass[(by = this.Input.Buffer[this.Input.Index]) & 0xFF] == 2 || by >= 97 && by <= 102 || by >= 65 && by <= 70)) {
                        int n6;
                        byte[] byArray = this.Out.Buf;
                        if (this.Out.I < this.Out.Len) {
                            int n7 = this.Out.I;
                            n6 = n7;
                            this.Out.I = n7 + 1;
                        } else {
                            n6 = this.f();
                        }
                        byArray[n6] = this.Input.Buffer[this.Input.Index++];
                    }
                } else {
                    this.ER.internalError("unknown base for reading numeric literal");
                }
                if (this.Input.Index == this.Input.Length) {
                    if (this.reload()) continue;
                    return;
                }
                if (this.Input.Buffer[this.Input.Index] != 92) break block17;
                if (!this.eliminateLineContinuation()) break;
            }
            this.error("LonelyBackslash");
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void outputNumericLiteral() throws IOException {
        byte by = this.Input.Buffer[this.Input.Index];
        boolean bl = false;
        if (by == 48) {
            int n;
            byte[] byArray = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n2 = this.Out.I;
                n = n2;
                this.Out.I = n2 + 1;
            } else {
                n = this.f();
            }
            byArray[n] = 48;
            if (++this.Input.Index == this.Input.Length && !this.reload()) {
                return;
            }
            byte by2 = this.Input.Buffer[this.Input.Index];
            if (by2 >= 48 && by2 <= 55) {
                this.outputInteger(8);
            } else {
                int n3;
                if (by2 != 120 && by2 != 88) return;
                ++this.Input.Index;
                byte[] byArray2 = this.Out.Buf;
                if (this.Out.I < this.Out.Len) {
                    int n4 = this.Out.I;
                    n3 = n4;
                    this.Out.I = n4 + 1;
                } else {
                    n3 = this.f();
                }
                byArray2[n3] = 120;
                this.outputInteger(16);
            }
        } else {
            this.outputInteger(10);
            bl = true;
        }
        this.outputIfPresent('u', 'U');
        this.outputIfPresent('l', 'L');
        if (!bl) {
            return;
        }
        if (!this.outputIfPresent('.')) return;
        this.outputEndOfFixedOrFloatingPointLiteral();
    }

    private byte outputOptionalWhitespaceOrComment() throws IOException {
        block4: {
            String string = "";
            while (true) {
                if (this.Input.Index == this.Input.Length && !this.reload()) {
                    return 0;
                }
                byte by = this.Input.Buffer[this.Input.Index];
                if (LexicalTables.IDLCharClass[by & 0xFF] == 0) {
                    if (this.outputWhitespace()) continue;
                    return 92;
                }
                if (by == 47) {
                    if (this.outputComment()) continue;
                    return 47;
                }
                if (by != 92) break block4;
                if (!this.eliminateLineContinuation()) break;
            }
            return 92;
        }
        return 0;
    }

    private boolean outputStringOrCharacterLiteral(byte by) throws IOException {
        int n;
        String string = by == 34 ? "StringLit" : "CharLit";
        boolean bl = false;
        byte[] byArray = this.Out.Buf;
        if (this.Out.I < this.Out.Len) {
            int n2 = this.Out.I;
            n = n2;
            this.Out.I = n2 + 1;
        } else {
            n = this.f();
        }
        byArray[n] = this.Input.Buffer[this.Input.Index++];
        while (true) {
            int n3;
            if (this.Input.Index == this.Input.Length && !this.reload()) {
                this.error(String.valueOf(String.valueOf(string)).concat(".EOLN"));
                return false;
            }
            byte by2 = this.Input.Buffer[this.Input.Index];
            if (by2 == by) {
                int n4;
                if (bl) {
                    int n5;
                    int n6;
                    bl = false;
                    ++this.Input.Index;
                    byte[] byArray2 = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n7 = this.Out.I;
                        n6 = n7;
                        this.Out.I = n7 + 1;
                    } else {
                        n6 = this.f();
                    }
                    byArray2[n6] = 92;
                    byte[] byArray3 = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n8 = this.Out.I;
                        n5 = n8;
                        this.Out.I = n8 + 1;
                    } else {
                        n5 = this.f();
                    }
                    byArray3[n5] = by;
                    continue;
                }
                byte[] byArray4 = this.Out.Buf;
                if (this.Out.I < this.Out.Len) {
                    int n9 = this.Out.I;
                    n4 = n9;
                    this.Out.I = n9 + 1;
                } else {
                    n4 = this.f();
                }
                byArray4[n4] = by;
                ++this.Input.Index;
                return true;
            }
            if (by2 == 92) {
                this.Input.advance();
                if (bl) {
                    int n10;
                    int n11;
                    byte[] byArray5 = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n12 = this.Out.I;
                        n11 = n12;
                        this.Out.I = n12 + 1;
                    } else {
                        n11 = this.f();
                    }
                    byArray5[n11] = 92;
                    byte[] byArray6 = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n13 = this.Out.I;
                        n10 = n13;
                        this.Out.I = n13 + 1;
                    } else {
                        n10 = this.f();
                    }
                    byArray6[n10] = 92;
                    bl = false;
                    continue;
                }
                bl = true;
                continue;
            }
            if (this.startsLineSep(by2)) {
                this.error(String.valueOf(String.valueOf(string)).concat(".EOLN"));
                return false;
            }
            if (bl) {
                int n14;
                byte[] byArray7 = this.Out.Buf;
                if (this.Out.I < this.Out.Len) {
                    int n15 = this.Out.I;
                    n14 = n15;
                    this.Out.I = n15 + 1;
                } else {
                    n14 = this.f();
                }
                byArray7[n14] = 92;
            }
            bl = false;
            byte[] byArray8 = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n16 = this.Out.I;
                n3 = n16;
                this.Out.I = n16 + 1;
            } else {
                n3 = this.f();
            }
            byArray8[n3] = by2;
            ++this.Input.Index;
        }
    }

    private void outputThruNewline() throws IOException {
        boolean bl = false;
        while (this.Input.Index != this.Input.Length || this.reload()) {
            byte by = this.Input.Buffer[this.Input.Index];
            if (LexicalTables.IDLCharClass[by & 0xFF] == 0) {
                this.outputWhitespace();
                continue;
            }
            if (by == 47) {
                if (this.outputComment()) continue;
            } else if (by == 92) {
                if (this.eliminateLineContinuation()) continue;
                this.directiveError("lonelyBackslash2");
                return;
            }
            if (this.startsLineSep(by)) {
                this.processNewline(false);
                return;
            }
            if (!bl) {
                bl = true;
                this.directiveError("extraText");
            }
            ++this.Input.Index;
        }
        return;
    }

    private boolean outputWhitespace() throws IOException {
        block5: {
            int n;
            boolean bl = false;
            ++this.Input.Index;
            byte[] byArray = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n2 = this.Out.I;
                n = n2;
                this.Out.I = n2 + 1;
            } else {
                n = this.f();
            }
            byArray[n] = 32;
            while (true) {
                if (this.Input.Index < this.Input.Length && LexicalTables.IDLCharClass[this.Input.Buffer[this.Input.Index] & 0xFF] == 0) {
                    ++this.Input.Index;
                    continue;
                }
                if (this.Input.Index == this.Input.Length) {
                    if (this.reload()) continue;
                    return true;
                }
                if (this.Input.Buffer[this.Input.Index] != 92) break block5;
                if (!this.eliminateLineContinuation()) break;
            }
            return false;
        }
        return true;
    }

    private String prepFilename(String string) {
        return StringFunctions.prepFilename(string);
    }

    public static Result preprocess(IDLppOptions iDLppOptions, String string, BufferReader bufferReader) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        int n = IDLpp.preprocess(iDLppOptions, string, (OutputStream)byteArrayOutputStream, bufferReader, null);
        return new Result(byteArrayOutputStream.toString(), n);
    }

    public static int preprocess(IDLppOptions iDLppOptions, String string, OutputStream outputStream, BufferReader bufferReader, Vector vector) {
        iDLppOptions._ER.setToolName("preprocessor");
        ByteArrayInputStream byteArrayInputStream = IDLpp.makeBootstrapStream(iDLppOptions, string);
        IDLpp iDLpp = new IDLpp(System.getProperty("user.dir"), byteArrayInputStream, outputStream, iDLppOptions, bufferReader, vector);
        iDLpp.execute();
        return iDLppOptions._ER.getSummary();
    }

    public static int preprocess(IDLppOptions iDLppOptions, Vector vector, OutputStream outputStream, BufferReader bufferReader, Vector vector2) {
        iDLppOptions._ER.setToolName("preprocessor");
        ByteArrayInputStream byteArrayInputStream = IDLpp.makeBootstrapStream(iDLppOptions, vector);
        IDLpp iDLpp = new IDLpp(System.getProperty("user.dir"), byteArrayInputStream, outputStream, iDLppOptions, bufferReader, vector2);
        iDLpp.execute();
        return iDLppOptions._ER.getSummary();
    }

    public static Result preprocessToString(IDLppOptions iDLppOptions, Vector vector, BufferReader bufferReader, Vector vector2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        int n = IDLpp.preprocess(iDLppOptions, vector, (OutputStream)byteArrayOutputStream, bufferReader, vector2);
        return new Result(byteArrayOutputStream.toString(), n);
    }

    private void process() throws IOException {
        block0: while (this.Input.Index != this.Input.Length || this.reload()) {
            byte by = this.Input.Buffer[this.Input.Index];
            if (LexicalTables.IDLCharClass[by & 0xFF] == 0) {
                this.outputWhitespace();
                continue;
            }
            if (by == 47) {
                int n;
                if (this.outputComment()) continue;
                byte[] byArray = this.Out.Buf;
                if (this.Out.I < this.Out.Len) {
                    int n2 = this.Out.I;
                    n = n2;
                    this.Out.I = n2 + 1;
                } else {
                    n = this.f();
                }
                byArray[n] = 47;
                if (this.Input.Index == this.Input.Length) break;
                by = this.Input.Buffer[this.Input.Index];
            } else {
                if (this.startsLineSep(by)) {
                    this.processNewline(false);
                    continue;
                }
                if (by == 92) {
                    if (this.eliminateLineContinuation()) continue;
                    this.error("LonelyBackslash");
                }
            }
            if (by == 35 && this.processPound(true)) continue;
            while (this.Input.Index != this.Input.Length || this.reload()) {
                by = this.Input.Buffer[this.Input.Index];
                if (LexicalTables.IDLCharClass[by & 0xFF] == 0) {
                    this.outputWhitespace();
                    continue;
                }
                if (LexicalTables.IDLCharClass[by & 0xFF] == 3) {
                    int n;
                    byte[] byArray = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n3 = this.Out.I;
                        n = n3;
                        this.Out.I = n3 + 1;
                    } else {
                        n = this.f();
                    }
                    byArray[n] = by;
                    ++this.Input.Index;
                    continue;
                }
                if (by == 47) {
                    int n;
                    if (this.outputComment()) continue;
                    byte[] byArray = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n4 = this.Out.I;
                        n = n4;
                        this.Out.I = n4 + 1;
                    } else {
                        n = this.f();
                    }
                    byArray[n] = 47;
                    continue;
                }
                if (LexicalTables.IDLCharClass[by & 0xFF] == 1) {
                    if (this.Mode != 2 && !this.MacroHitTable[by]) {
                        this.outputIdentifier(by);
                        continue;
                    }
                    String string = this.gatherIdentifier();
                    if ("L".equals(string) && this.Input.Index < this.Input.Length && (this.Input.Buffer[this.Input.Index] == 39 || this.Input.Buffer[this.Input.Index] == 34)) {
                        this.writeString("L");
                        continue;
                    }
                    if (this.SubstituteMacros) {
                        if (this.Mode == 2) {
                            this.outputIdentifierInMacroBody(string);
                            continue;
                        }
                        Macro macro = (Macro)this.MacroTable.get(string);
                        if (macro != null) {
                            this.maybeInstantiateMacro(string, macro);
                            continue;
                        }
                    }
                    this.writeString(string);
                    continue;
                }
                if (this.startsLineSep(by)) {
                    this.processNewline(false);
                    continue block0;
                }
                if (LexicalTables.IDLCharClass[by & 0xFF] == 5) {
                    if (by == 44) {
                        if (this.Mode == 1 && this.ParenNestingLevel == 1) {
                            this.MacroArgs.addElement(this.Out.toString().trim());
                        } else {
                            int n;
                            byte[] byArray = this.Out.Buf;
                            if (this.Out.I < this.Out.Len) {
                                int n5 = this.Out.I;
                                n = n5;
                                this.Out.I = n5 + 1;
                            } else {
                                n = this.f();
                            }
                            byArray[n] = by;
                        }
                        ++this.Input.Index;
                        continue;
                    }
                    if (by == 40) {
                        if (this.Mode == 1) {
                            ++this.ParenNestingLevel;
                        } else {
                            int n;
                            byte[] byArray = this.Out.Buf;
                            if (this.Out.I < this.Out.Len) {
                                int n6 = this.Out.I;
                                n = n6;
                                this.Out.I = n6 + 1;
                            } else {
                                n = this.f();
                            }
                            byArray[n] = by;
                        }
                        ++this.Input.Index;
                        continue;
                    }
                    if (by == 41) {
                        int n;
                        ++this.Input.Index;
                        if (this.Mode == 1 && this.ParenNestingLevel-- == 1) {
                            this.invokeMacro();
                            continue;
                        }
                        byte[] byArray = this.Out.Buf;
                        if (this.Out.I < this.Out.Len) {
                            int n7 = this.Out.I;
                            n = n7;
                            this.Out.I = n7 + 1;
                        } else {
                            n = this.f();
                        }
                        byArray[n] = by;
                        continue;
                    }
                    if (by == 34) {
                        this.outputStringOrCharacterLiteral(by);
                        continue;
                    }
                    if (by == 39) {
                        this.outputStringOrCharacterLiteral(by);
                        continue;
                    }
                    if (by == 46) {
                        this.processPeriod();
                        continue;
                    }
                    if (by == 92) {
                        if (this.eliminateLineContinuation()) continue;
                        this.error("LonelyBackslash");
                        continue;
                    }
                    if (by == 35) {
                        this.processPound(false);
                        continue;
                    }
                    this.ER.internalError("unhandled OTHER class for character ".concat(String.valueOf(String.valueOf(this.escChar(by)))));
                    continue;
                }
                if (LexicalTables.IDLCharClass[by & 0xFF] == 2) {
                    this.outputNumericLiteral();
                    continue;
                }
                this.handleErrorChar(by);
            }
            break block0;
        }
        if (!this.Input.isTransient()) {
            this.EOFCleanup();
        }
    }

    private void processDefineDirective() throws IOException {
        if (!this.GenerateOutput) {
            this.gatherErrorText();
            return;
        }
        byte by = this.outputOptionalWhitespaceOrComment();
        if (by == 47) {
            this.directiveError("define.malformed", "/".concat(String.valueOf(String.valueOf(this.gatherUntilNewline().trim()))));
            this.cleanupNewline();
            return;
        }
        if (by == 92) {
            this.directiveError("lonelyBackslash2");
            this.gatherErrorText();
            return;
        }
        if (this.Input.Index == this.Input.Length && !this.reload()) {
            this.directiveError("define.empty");
            return;
        }
        if (LexicalTables.IDLCharClass[this.Input.Buffer[this.Input.Index] & 0xFF] != 1) {
            this.directiveError("define.malformedIdent");
            this.gatherErrorText();
            return;
        }
        String string = this.gatherIdentifier();
        if (this.Input.Index == this.Input.Length) {
            this.installMacro(new SimpleMacro(string, this.Input.FileName, this.Input.LineNumber, "".getBytes("8859_1")), true);
        } else if (this.Input.Buffer[this.Input.Index] == 40) {
            this.createFunctionalMacro(string);
        } else {
            this.createSimpleMacro(string);
        }
    }

    private void processElIfDirective() throws IOException {
        if (this.Input.conditionalStackEmpty()) {
            this.directiveError("elif.unmatched");
            this.gatherErrorText();
            return;
        }
        this.installMacro(this.BuiltinDefinedMacro, false);
        ConditionalInfo conditionalInfo = this.Input.conditionalStackPop();
        int n = conditionalInfo.Status;
        if (n == 0) {
            String string = this.stringCopyOfProcessedTextUntilNewline(true).trim();
            if (this.ConstParser.eval(this.ER, string, this.Input.FileName, this.Input.LineNumber)) {
                n = 2;
            }
            this.cleanupNewline();
        } else if (n == 2) {
            n = 1;
            this.gatherErrorText();
        } else {
            this.gatherErrorText();
        }
        this.updateConditionalStack(conditionalInfo, (byte)n);
        this.MacroTable.remove("defined");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processElseDirective() throws IOException {
        block7: {
            block6: {
                try {
                    if (this.Input.conditionalStackEmpty()) {
                        this.directiveError("else.unmatched");
                        Object var4_1 = null;
                        break block6;
                    }
                    ConditionalInfo conditionalInfo = this.Input.conditionalStackPop();
                    byte by = conditionalInfo.Status;
                    if (by == 0) {
                        by = 2;
                    } else if (by == 2) {
                        by = 1;
                    }
                    this.updateConditionalStack(conditionalInfo, by);
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    this.outputThruNewline();
                    throw throwable;
                }
            }
            this.outputThruNewline();
            return;
        }
        Object var4_2 = null;
        this.outputThruNewline();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processEndIfDirective() throws IOException {
        block6: {
            block5: {
                try {
                    if (this.Input.conditionalStackEmpty()) {
                        this.directiveWarn("endif.unmatched");
                        Object var2_1 = null;
                        break block5;
                    }
                    this.Input.conditionalStackPop();
                    if (this.Input.conditionalStackEmpty() || this.Input.conditionalStackPeek() == 2) {
                        this.startGeneratingOutput();
                        break block6;
                    } else {
                        this.stopGeneratingOutput();
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    this.outputThruNewline();
                    throw throwable;
                }
            }
            this.outputThruNewline();
            return;
        }
        Object var2_2 = null;
        this.outputThruNewline();
    }

    private void processErrorDirective() throws IOException {
        String string = this.stringCopyOfProcessedTextUntilNewline(false);
        if (!this.GenerateOutput) {
            return;
        }
        this.directiveWarn("error", string);
    }

    private void processIfDefDirective(boolean bl) throws IOException {
        String string = this.stringCopyOfProcessedTextUntilNewline(false).trim();
        boolean bl2 = false;
        if (string.length() == 0) {
            if (this.directiveError("ifdef.empty")) {
                this.ER.add("Comp.PP.Directive.conditional.assumedFalse");
            }
        } else if (!IDLpp.isLegalIdent(string)) {
            if (this.directiveError("ifdef.malformedIdent", string)) {
                this.ER.add("Comp.PP.Directive.conditional.assumedFalse");
            }
        } else {
            boolean bl3 = bl2 = this.MacroTable.get(string) != null;
        }
        if (bl) {
            bl2 = !bl2;
        }
        this.updateConditionalStack(bl ? "ifndef" : "ifdef", bl2 ? (byte)2 : 0);
    }

    private void processIfDirective() throws IOException {
        this.installMacro(this.BuiltinDefinedMacro, false);
        try {
            String string = this.stringCopyOfProcessedTextUntilNewline(true).trim();
            byte by = this.ConstParser.eval(this.ER, string, this.Input.FileName, this.Input.LineNumber) ? (byte)2 : 0;
            this.updateConditionalStack("if", by);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cleanupNewline();
            this.MacroTable.remove("defined");
            throw throwable;
        }
        this.cleanupNewline();
        this.MacroTable.remove("defined");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processIncludeDirective() throws IOException {
        boolean bl;
        block28: {
            block27: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            String string = this.stringCopyOfProcessedTextUntilNewline(true).trim();
                                            bl = false;
                                            try {
                                                int n;
                                                String[] stringArray;
                                                if (!this.GenerateOutput) {
                                                    Object var10_3 = null;
                                                    if (bl) return;
                                                    break block20;
                                                }
                                                int n2 = string.length();
                                                if (n2 == 0) {
                                                    this.directiveError("include.empty");
                                                    break block21;
                                                }
                                                if (n2 < 3) {
                                                    this.directiveError("include.malformed", string);
                                                    break block22;
                                                }
                                                if (string.charAt(0) == '\"') {
                                                    if (string.charAt(n2 - 1) != '\"') {
                                                        this.directiveError("include.unterminatedString", string.substring(1));
                                                        break block23;
                                                    }
                                                } else if (string.charAt(0) == '<') {
                                                    if (string.charAt(n2 - 1) != '>') {
                                                        this.directiveError("include.unterminatedString", string.substring(1));
                                                        break block24;
                                                    }
                                                } else {
                                                    this.directiveError("include.malformed", string);
                                                    break block25;
                                                }
                                                if ((stringArray = this.fileSpecToPathNames(string)).length == 0) {
                                                    this.directiveWarn("include.noDirs");
                                                    break block26;
                                                }
                                                for (n = 0; n < stringArray.length; ++n) {
                                                    OpenStream openStream = this.openFile(stringArray[n]);
                                                    if (openStream == null) continue;
                                                    if (this.NotifyInclusions) {
                                                        String string2 = stringArray[n] == null ? "-" : stringArray[n];
                                                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("including \"").append(string2).append("\""))));
                                                    }
                                                    if (this.InputDepth == (long)2 && this.TopLevelIncludedFiles != null) {
                                                        this.TopLevelIncludedFiles.addElement(string.substring(1, n2 - 1));
                                                    }
                                                    boolean bl2 = !this.cleanupNewline();
                                                    bl = true;
                                                    if (this.GenerateLineDirectives) {
                                                        if (bl2) {
                                                            this.writeString(this.LineSeparator);
                                                        }
                                                        String string3 = stringArray[n] == null ? "-" : stringArray[n];
                                                        this.writeString(String.valueOf(String.valueOf(new StringBuffer("#line 1 \"").append(string3).append("\"").append(this.LineSeparator))));
                                                    }
                                                    this.readFrom(openStream);
                                                    break block27;
                                                }
                                                if (this.directiveError("include.cantopen", this.prepFilename(stringArray[0]))) {
                                                    n = 0;
                                                    for (int i = 1; i < stringArray.length; ++i) {
                                                        File file;
                                                        if (this._sysInclLoc != null && n == 0 && (file = new File(stringArray[i])).getParent() != null && file.getParent().equals(this._sysInclLoc)) {
                                                            n = 1;
                                                            continue;
                                                        }
                                                        this.ER.add("Comp.PP.Directive.include.orthisone", new Object[]{stringArray[i]});
                                                    }
                                                }
                                                break block28;
                                            }
                                            catch (Throwable throwable) {
                                                Object var10_12 = null;
                                                if (bl) throw throwable;
                                                this.cleanupNewline();
                                                throw throwable;
                                            }
                                        }
                                        this.cleanupNewline();
                                        return;
                                    }
                                    Object var10_4 = null;
                                    if (bl) return;
                                    this.cleanupNewline();
                                    return;
                                }
                                Object var10_5 = null;
                                if (bl) return;
                                this.cleanupNewline();
                                return;
                            }
                            Object var10_6 = null;
                            if (bl) return;
                            this.cleanupNewline();
                            return;
                        }
                        Object var10_7 = null;
                        if (bl) return;
                        this.cleanupNewline();
                        return;
                    }
                    Object var10_8 = null;
                    if (bl) return;
                    this.cleanupNewline();
                    return;
                }
                Object var10_9 = null;
                if (bl) return;
                this.cleanupNewline();
                return;
            }
            Object var10_10 = null;
            if (bl) return;
            this.cleanupNewline();
            return;
        }
        Object var10_11 = null;
        if (bl) return;
        this.cleanupNewline();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processLineDirective() throws IOException {
        boolean bl;
        boolean bl2;
        String string;
        long l;
        boolean bl3;
        block30: {
            block29: {
                block28: {
                    block27: {
                        block25: {
                            block26: {
                                String string2 = this.stringCopyOfProcessedTextUntilNewline(true).trim();
                                if (!this.GenerateOutput) {
                                    return;
                                }
                                bl3 = false;
                                l = this.Input.LineNumber;
                                string = this.Input.FileName;
                                bl2 = false;
                                bl = false;
                                try {
                                    char c;
                                    if (string2.length() == 0) {
                                        this.directiveError("line.empty");
                                        Object var12_7 = null;
                                        if (bl3) break block25;
                                        break block26;
                                    }
                                    String string3 = "";
                                    int n = 0;
                                    if (string2.charAt(0) == '-') {
                                        string3 = "-";
                                        n = 1;
                                    }
                                    while (n < string2.length() && (c = string2.charAt(n)) >= '0' && c <= '9') {
                                        string3 = String.valueOf(String.valueOf(string3)).concat(String.valueOf(String.valueOf(c)));
                                        ++n;
                                    }
                                    if (string3.equals("")) {
                                        this.directiveError("line.malformed");
                                        break block27;
                                    }
                                    l = Long.parseLong(string3);
                                    bl2 = l != this.Input.LineNumber;
                                    string2 = string2.substring(string3.length());
                                    if ((string2 = string2.trim()).length() > 0) {
                                        if (string2.charAt(0) == '\"') {
                                            if (string2.charAt(string2.length() - 1) != '\"') {
                                                this.directiveError("line.unterminatedString", string2);
                                                break block28;
                                            }
                                            bl = !this.Input.FileName.equals(string2 = string2.substring(1, string2.length() - 1));
                                            string = string2;
                                        } else {
                                            this.directiveError("line.malformed2");
                                            break block29;
                                        }
                                    }
                                    c = !this.cleanupNewline() ? (char)'\u0001' : '\u0000';
                                    bl3 = true;
                                    if (this.RetainLineDirectives && l > (long)0 && (bl2 || bl)) {
                                        if (c != '\u0000') {
                                            this.writeString(this.LineSeparator);
                                        }
                                        this.writeString("#line ".concat(String.valueOf(String.valueOf(l))));
                                        if (bl) {
                                            this.writeString(String.valueOf(String.valueOf(new StringBuffer(" \"").append(string).append("\""))));
                                        }
                                        this.writeString(this.LineSeparator);
                                        this.Input.EndedWithLineSep = true;
                                    }
                                    break block30;
                                }
                                catch (Throwable throwable) {
                                    Object var12_12 = null;
                                    if (!bl3) {
                                        this.cleanupNewline();
                                    }
                                    if (bl2) {
                                        this.Input.LineNumber = l;
                                    }
                                    if (!bl) throw throwable;
                                    this.Input.FileName = string;
                                    throw throwable;
                                }
                            }
                            this.cleanupNewline();
                        }
                        if (bl2) {
                            this.Input.LineNumber = l;
                        }
                        if (!bl) return;
                        this.Input.FileName = string;
                        return;
                    }
                    Object var12_8 = null;
                    if (!bl3) {
                        this.cleanupNewline();
                    }
                    if (bl2) {
                        this.Input.LineNumber = l;
                    }
                    if (!bl) return;
                    this.Input.FileName = string;
                    return;
                }
                Object var12_9 = null;
                if (!bl3) {
                    this.cleanupNewline();
                }
                if (bl2) {
                    this.Input.LineNumber = l;
                }
                if (!bl) return;
                this.Input.FileName = string;
                return;
            }
            Object var12_10 = null;
            if (!bl3) {
                this.cleanupNewline();
            }
            if (bl2) {
                this.Input.LineNumber = l;
            }
            if (!bl) return;
            this.Input.FileName = string;
            return;
        }
        Object var12_11 = null;
        if (!bl3) {
            this.cleanupNewline();
        }
        if (bl2) {
            this.Input.LineNumber = l;
        }
        if (!bl) return;
        this.Input.FileName = string;
    }

    private void processNewline(boolean bl) throws IOException {
        int n = 0;
        byte by = this.Input.Buffer[this.Input.Index];
        if (by == this.FirstLineSeparatorChar) {
            ++this.Input.Index;
            n = 1;
        } else if (by == 13) {
            ++this.Input.Index;
        }
        for (int i = n; i < this.LineSeparatorLength && (this.Input.Index != this.Input.Length || this.reload()); ++i) {
            if (this.Input.Buffer[this.Input.Index] != this.LineSeparator.charAt(i)) continue;
            ++this.Input.Index;
        }
        if (this.Input.Index == this.Input.Length && !this.reload()) {
            this.Input.EndedWithLineSep = true;
        }
        ++this.Input.LineNumber;
        ++this.PendingOutputNewlines;
        if (this.GenerateOutput && !bl && this.Out == this.NormalSink) {
            this.processPendingNewlines();
        }
    }

    private void processPendingNewlines() throws IOException {
        while (this.PendingOutputNewlines > 0L) {
            --this.PendingOutputNewlines;
            this.newLine();
        }
    }

    private void processPeriod() throws IOException {
        int n;
        byte[] byArray = this.Out.Buf;
        if (this.Out.I < this.Out.Len) {
            int n2 = this.Out.I;
            n = n2;
            this.Out.I = n2 + 1;
        } else {
            n = this.f();
        }
        byArray[n] = 46;
        ++this.Input.Index;
        while (this.Input.Index != this.Input.Length || this.reload()) {
            byte by = this.Input.Buffer[this.Input.Index];
            if (by == 92) {
                if (this.eliminateLineContinuation()) continue;
                this.error("LonelyBackslash");
                break;
            }
            if (LexicalTables.IDLCharClass[by & 0xFF] != 2) break;
            this.outputEndOfFixedOrFloatingPointLiteral();
            return;
        }
    }

    private boolean processPound(boolean bl) throws IOException {
        ++this.Input.Index;
        if (this.Mode == 2) {
            String string;
            String string2 = this.Out.toString().trim();
            if (!string2.equals("") && (string = this.CurrentMacro.addLiteralString(string2)) != null) {
                this.error(string);
            }
            if ((string = this.CurrentMacro.processPound()) != null) {
                this.error(string);
            }
            return false;
        }
        if (bl) {
            this.handleDirective();
            return true;
        }
        this.handleErrorChar((byte)35);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processPragmaDirective() throws IOException {
        String string = this.stringCopyOfProcessedTextUntilNewline(false);
        String string2 = string.trim();
        if (!this.GenerateOutput) {
            return;
        }
        if (!string2.startsWith("Inprise ")) {
            this.writeString("#pragma ".concat(String.valueOf(String.valueOf(string))));
            return;
        }
        string2 = string2.substring("Inprise ".length(), string2.length());
        if (!(string2 = string2.trim()).startsWith("IDLpp ")) {
            if (string2.equals("IDLpp")) {
                this.directiveWarn("pragma.empty");
                return;
            }
            this.writeString("#pragma ".concat(String.valueOf(String.valueOf(string))));
            return;
        }
        string2 = string2.substring("IDLpp ".length(), string2.length());
        if ((string2 = string2.trim()).length() > 0 && string2.charAt(0) >= 'a' && string2.charAt(0) <= 'z') {
            if (string2.equals("suppressLinePragmas")) {
                this.GenerateLineDirectives = false;
                return;
            }
            if (string2.equals("nosuppressLinePragmas")) {
                this.GenerateLineDirectives = true;
                return;
            }
            if (string2.equals("showInclusions")) {
                this.NotifyInclusions = true;
                return;
            }
            if (string2.equals("noshowInclusions")) {
                this.NotifyInclusions = false;
                return;
            }
            if (string2.equals("retainComments")) {
                this.RetainComments = true;
                return;
            }
            if (string2.equals("noretainComments")) {
                this.RetainComments = false;
                return;
            }
            if (string2.equals("retainLineDirective")) {
                this.RetainLineDirectives = true;
                return;
            }
            if (string2.equals("noretainLineDirectives")) {
                this.RetainLineDirectives = false;
                return;
            }
            if (string2.equals("showAllLines")) {
                this.ShowAllLines = true;
                return;
            }
            if (string2.equals("noshowAllLines")) {
                this.ShowAllLines = false;
                return;
            }
            if (string2.equals("clearIncludePaths")) {
                this.IncludePaths.removeAllElements();
                return;
            }
            if (!string2.startsWith("appendToIncludePaths ")) {
                this.directiveError("pragma.unrecognized", string2);
                return;
            }
            String string3 = string2.substring(21, string2.length()).trim();
            if (string3.length() == 0) {
                this.directiveError("pragma.missingDirectory");
            }
            if (string3.length() >= 3 && string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
                String string4 = string3.substring(1, string3.length() - 1);
                this.IncludePaths.addElement(string4);
                return;
            }
            this.directiveError("pragma.malformedDirectory");
            return;
        }
        this.directiveError("pragma.unrecognized", string2);
    }

    private void processUnDefDirective() throws IOException {
        String string = this.stringCopyOfProcessedTextUntilNewline(false).trim();
        if (!this.GenerateOutput) {
            return;
        }
        if (string.length() == 0) {
            this.directiveError("undef.empty");
            return;
        }
        if (!IDLpp.isLegalIdent(string)) {
            this.directiveError("undef.malformedIdent", string);
            return;
        }
        Macro macro = (Macro)this.MacroTable.get(string);
        if (macro == null) {
            this.directiveWarn("undef.pointless", string);
            return;
        }
        if (macro.isBuiltin()) {
            this.directiveWarn("undef.builtin");
            return;
        }
        this.MacroTable.remove(string);
    }

    private void pushBack(byte by) throws IOException {
        this.pushTemporaryInput(new byte[]{by}, null);
    }

    private void pushTemporaryInput(byte[] byArray, Macro macro) throws IOException {
        this.Out.flush();
        this.Input = new OpenStream(byArray, this.Input, macro);
    }

    private void readFrom(OpenStream openStream) throws IOException {
        OpenStream openStream2 = this.Input;
        this.Input = openStream;
        try {
            this.Out.flush();
            this.SavedInputDepth = this.InputDepth--;
            this.process();
            this.maybeWarnOfOpenConditionals(this.Input.openConditionals());
            this.SavedInputDepth = -1L;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.Input.finished();
            --this.InputDepth;
            boolean bl = !this.Input.EndedWithLineSep;
            this.Input = openStream2;
            if (this.GenerateLineDirectives && !this.Input.FileName.equals("")) {
                if (bl) {
                    this.writeString(this.LineSeparator);
                }
                this.writeString(String.valueOf(String.valueOf(new StringBuffer("#line ").append(Long.toString(this.Input.LineNumber)).append(" \"").append(this.Input.FileName).append("\"").append(this.LineSeparator))));
                this.Input.EndedWithLineSep = true;
            }
            throw throwable;
        }
        this.Input.finished();
        boolean bl = !this.Input.EndedWithLineSep;
        this.Input = openStream2;
        if (this.GenerateLineDirectives && !this.Input.FileName.equals("")) {
            if (bl) {
                this.writeString(this.LineSeparator);
            }
            this.writeString(String.valueOf(String.valueOf(new StringBuffer("#line ").append(Long.toString(this.Input.LineNumber)).append(" \"").append(this.Input.FileName).append("\"").append(this.LineSeparator))));
            this.Input.EndedWithLineSep = true;
        }
    }

    private boolean reload() throws IOException {
        if (this.Out == this.OneLineSink) {
            if (this.Input.reload()) {
                this.ER.internalError("shouldn't be able to reload when collecting output in OneLineSink.");
            }
            return false;
        }
        this.Out.flush();
        if (this.Input.reload()) {
            return this.Input.Index < this.Input.Length ? true : this.reload();
        }
        if (this.Input.PreviousStream != null) {
            if (this.Input.Macro != null) {
                this.installMacro(this.Input.Macro, false);
            }
            this.Input = this.Input.PreviousStream;
            return this.Input.Index < this.Input.Length ? true : this.reload();
        }
        return false;
    }

    private void startGeneratingOutput() throws IOException {
        if (this.GenerateOutput) {
            return;
        }
        this.Out.reset();
        this.Out.Ignore = false;
        this.GenerateOutput = true;
        this.processPendingNewlines();
    }

    private void startLineGather() {
        this.Out = this.OneLineSink;
    }

    private void startMacroArgs() {
        this.PreviousSink = this.Out;
        this.Out = this.MacroArgSink;
    }

    private boolean startsLineSep(byte by) {
        return by == this.FirstLineSeparatorChar || by == 10 || by == 13;
    }

    private void stopGeneratingOutput() throws IOException {
        if (!this.GenerateOutput) {
            return;
        }
        this.processPendingNewlines();
        this.Out.flush();
        this.Out.Ignore = true;
        this.GenerateOutput = false;
    }

    private void stopLineGather() {
        this.Out = this.NormalSink;
    }

    private void stopMacroArgs() {
        this.Out = this.PreviousSink;
    }

    private String stringCopyOfProcessedTextUntilNewline(boolean bl) throws IOException {
        String string = this.gatherUntilNewline();
        if (string.length() == 0) {
            return string;
        }
        this.startLineGather();
        if (!bl) {
            this.SubstituteMacros = false;
        }
        OpenStream openStream = this.Input;
        this.Input = new OpenStream(string.getBytes("8859_1"), this.Input, null);
        this.process();
        this.Input = openStream;
        String string2 = this.Out.toString();
        this.stopLineGather();
        if (!bl) {
            this.SubstituteMacros = true;
        }
        return string2;
    }

    private void updateConditionalStack(ConditionalInfo conditionalInfo, byte by) throws IOException {
        if (this.Input.updateConditionalStack(conditionalInfo, by)) {
            this.startGeneratingOutput();
        } else {
            this.stopGeneratingOutput();
        }
    }

    private void updateConditionalStack(String string, byte by) throws IOException {
        if (this.Input.updateConditionalStack(string, by)) {
            this.startGeneratingOutput();
        } else {
            this.stopGeneratingOutput();
        }
    }

    private boolean warn(String string) {
        return this.ER.warn("Comp.PP.".concat(String.valueOf(String.valueOf(string))), this.ER.setFile(this.Input.FileName), this.Input.LineNumber);
    }

    private boolean warn(String string, String string2) {
        return this.ER.warn("Comp.PP.".concat(String.valueOf(String.valueOf(string))), this.ER.setFile(this.Input.FileName), this.Input.LineNumber, string2);
    }

    private boolean warn(String string, String string2, long l) {
        return this.ER.warn2("Comp.PP.".concat(String.valueOf(String.valueOf(string))), this.ER.setFile(this.Input.FileName), this.Input.LineNumber, "Comp.PP.".concat(String.valueOf(String.valueOf(string2))), this.ER.setFile(this.Input.FileName), l);
    }

    private void writeString(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            int n;
            byte[] byArray = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n2 = this.Out.I;
                n = n2;
                this.Out.I = n2 + 1;
            } else {
                n = this.f();
            }
            byArray[n] = (byte)string.charAt(i);
        }
    }

    static {
        Debug = false;
        Trace = false;
        Timing = false;
        _lineSeparator = System.getProperty("line.separator");
        NORMAL_MODE = 0;
        GATHERING_MACRO_ARGS_MODE = 1;
        READING_MACRO_BODY_MODE = 2;
    }

    public static final class Result {
        public String _output;
        public int _status;

        public Result(String string, int n) {
            this._output = string;
            this._status = n;
        }
    }

    class Sink {
        OutputStream Stream;
        byte[] Buf;
        int I;
        int Len;
        private boolean Temporary;
        boolean Ignore = false;

        Sink(OutputStream outputStream) {
            this.Stream = outputStream;
            this.Len = 0x119999;
            this.Buf = new byte[this.Len];
            this.I = 0;
            this.Temporary = false;
        }

        Sink() {
            this.Stream = new ByteArrayOutputStream();
            this.Len = 256;
            this.Buf = new byte[this.Len];
            this.I = 0;
            this.Temporary = true;
        }

        int flush() throws IOException {
            if (!this.Ignore) {
                this.Stream.write(this.Buf, 0, this.I);
            }
            this.I = 0;
            return 0;
        }

        void reset() {
            this.I = 0;
            if (this.Temporary) {
                ((ByteArrayOutputStream)this.Stream).reset();
            }
        }

        public String toString() {
            if (this.Ignore) {
                this.reset();
                return "";
            }
            if (this.Temporary) {
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.Stream;
                String string = null;
                if (byteArrayOutputStream.size() > 0) {
                    try {
                        this.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        string = byteArrayOutputStream.toString("8859_1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    byteArrayOutputStream.reset();
                } else {
                    try {
                        string = new String(this.Buf, 0, this.I, "8859_1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    this.I = 0;
                }
                return string;
            }
            IDLpp.this.ER.internalError("attempted to call toString() on a real output Sink instance");
            return null;
        }

        byte[] toByteArray() {
            if (this.Ignore) {
                this.reset();
                return new byte[0];
            }
            if (this.Temporary) {
                byte[] byArray;
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.Stream;
                if (byteArrayOutputStream.size() > 0) {
                    try {
                        this.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.reset();
                } else {
                    byArray = new byte[this.I];
                    System.arraycopy(this.Buf, 0, byArray, 0, this.I);
                    this.I = 0;
                }
                return byArray;
            }
            IDLpp.this.ER.internalError("attempted to call toString() on a real output Sink instance");
            return null;
        }
    }
}

