/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.preprocessor;

import com.inprise.vbroker.compiler.preprocessor.Macro;
import com.inprise.vbroker.util.StringFunctions;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

final class FunctionalMacro
extends Macro {
    private static final boolean Trace = false;
    private boolean Builtin;
    private int NumArgs;
    private int poundCount;
    private Vector ReplacementParts = new Vector();
    private StringBuffer Strbuf = new StringBuffer(128);

    FunctionalMacro(String string, String string2, long l, int n, boolean bl) {
        super(string, string2, l);
        this.Builtin = bl;
        this.NumArgs = n;
        if (!this.Builtin) {
            this.concatLiteral(" ");
        }
    }

    void addFormal(int n) {
        ++n;
        if (this.poundCount < 2) {
            this.concatLiteral(" ");
        }
        if (this.poundCount == 1 || this.poundCount == 3) {
            this.ReplacementParts.addElement(new Integer(-n));
        } else {
            this.ReplacementParts.addElement(new Integer(n));
        }
        if (this.poundCount < 2) {
            this.concatLiteral(" ");
        }
        this.poundCount = 0;
    }

    String addLiteralString(String string) {
        String string2 = null;
        if (this.poundCount == 1 || this.poundCount == 3) {
            string2 = "MacroDef.cantStringizeNonArgToken";
        }
        this.concatLiteral(string);
        this.poundCount = 0;
        return string2;
    }

    private void coerceNumberOfActualsTo(Vector vector) {
        if (vector.size() != this.NumArgs) {
            vector.setSize(this.NumArgs);
            for (int i = this.NumArgs - vector.size(); i >= 0 && i < this.NumArgs; ++i) {
                vector.setElementAt("", i);
            }
        }
    }

    private void concatLiteral(String string) {
        if (string.equals("")) {
            return;
        }
        if (this.ReplacementParts.size() == 0) {
            this.ReplacementParts.addElement(string);
            return;
        }
        Object e = this.ReplacementParts.lastElement();
        if (e instanceof String) {
            String string2 = (String)e;
            this.ReplacementParts.setElementAt(String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(string))), this.ReplacementParts.size() - 1);
        } else {
            this.ReplacementParts.addElement(string);
        }
    }

    boolean equals(Macro macro) {
        if (!(macro instanceof FunctionalMacro)) {
            return false;
        }
        FunctionalMacro functionalMacro = (FunctionalMacro)macro;
        if (this.ReplacementParts.size() != functionalMacro.ReplacementParts.size()) {
            return false;
        }
        for (int i = 0; i < this.ReplacementParts.size(); ++i) {
            if (this.ReplacementParts.elementAt(i).equals(functionalMacro.ReplacementParts.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    String finishDefinition() {
        String string = null;
        if (this.poundCount > 0) {
            string = "MacroDef.poundsAtEnd";
        }
        this.concatLiteral(" ");
        return string;
    }

    boolean isBuiltin() {
        return this.Builtin;
    }

    boolean isFunctional() {
        return true;
    }

    boolean isSimple() {
        return false;
    }

    int numArgs() {
        return this.NumArgs;
    }

    String processPound() {
        String string = null;
        if (++this.poundCount > 3) {
            string = "MacroDef.tooManyPounds";
            this.poundCount = 0;
        }
        if (this.poundCount == 2) {
            int n;
            Object e;
            if (this.ReplacementParts.size() == 1 && this.ReplacementParts.elementAt(0) instanceof String && ((String)this.ReplacementParts.elementAt(0)).equals(" ")) {
                string = "MacroDef.concatAtStart";
                this.poundCount = 0;
            } else if (this.ReplacementParts.size() >= 4 && (e = this.ReplacementParts.elementAt((n = this.ReplacementParts.size()) - 2)) instanceof Integer) {
                this.ReplacementParts.removeElementAt(n - 1);
            }
        }
        return string;
    }

    byte[] value(Vector vector) {
        if (this.Builtin) {
            return null;
        }
        this.coerceNumberOfActualsTo(vector);
        this.Strbuf.setLength(0);
        for (int i = 0; i < this.ReplacementParts.size(); ++i) {
            Object e = this.ReplacementParts.elementAt(i);
            if (e instanceof String) {
                this.Strbuf.append(e);
                continue;
            }
            int n = (Integer)e;
            if (n >= 0) {
                this.Strbuf.append((String)vector.elementAt(n - 1));
                continue;
            }
            this.Strbuf.append(StringFunctions.stringize((String)vector.elementAt(-n - 1), false, true));
        }
        byte[] byArray = null;
        try {
            byArray = this.Strbuf.toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray;
    }

    static {
        Trace = false;
    }
}

