/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.backends.pascal.ast;

import com.inprise.vbroker.compiler.ast.AliasNode;
import com.inprise.vbroker.compiler.ast.ArrayNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.FixedNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.NativeNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.ast.SequenceNode;
import com.inprise.vbroker.compiler.ast.StringNode;
import com.inprise.vbroker.compiler.ast.StructNode;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.TypeMapper;
import com.inprise.vbroker.compiler.ast.UnionNode;
import com.inprise.vbroker.compiler.ast.ValueBoxNode;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.ast.WStringNode;
import com.inprise.vbroker.compiler.backends.common.CommonOptions;
import com.inprise.vbroker.compiler.backends.pascal.ast.PAliasNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PArrayNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PEnumNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PExceptionNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PInterfaceNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PModuleNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PRepositoryNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PStructNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PUnionNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PascalBeOptions;
import com.inprise.vbroker.compiler.backends.pascal.ast.PascalMapperDefs;
import com.inprise.vbroker.util.SimpleStringBuffer;
import java.util.Vector;

public final class PascalMapper
extends TypeMapper
implements PascalMapperDefs {
    protected static final transient boolean trace = false;
    private final SimpleStringBuffer _buf = new SimpleStringBuffer();
    private final Vector _v = new Vector(20);
    public PascalBeOptions _options;

    public PascalMapper(CommonOptions commonOptions) {
        super(commonOptions);
        this._options = (PascalBeOptions)((TypeMapper)this)._options;
        this._keywordAvoider.avoid(this._options.keywordMap);
    }

    public String avoidKeywords(String string) {
        return this._keywordAvoider.convertSimpleName(string);
    }

    protected final String context2string(int n) {
        switch (n) {
            case 2: {
                return "$HOLDER";
            }
            case 3: {
                return "$HOLDER";
            }
        }
        return "";
    }

    private int countSuffixes(String string) {
        int n = string.length();
        if (n < 4) {
            return 0;
        }
        switch (string.charAt(n - 1)) {
            case 'r': {
                if (string.charAt(n - 2) != 'e') {
                    return 0;
                }
                if (n >= 6 && string.lastIndexOf("Helper") == n - 6) {
                    return this.countSuffixes(string.substring(0, n - 6)) + 1;
                }
                return 0;
            }
            case 'b': {
                if (string.charAt(n - 2) != 'u') {
                    return 0;
                }
                if (n >= 4 && string.lastIndexOf("Stub") == n - 4) {
                    return this.countSuffixes(string.substring(0, n - 4)) + 1;
                }
                return 0;
            }
            case 'y': {
                if (string.charAt(n - 2) != 'r') {
                    return 0;
                }
                if (n >= 7 && string.lastIndexOf("Factory") == n - 7) {
                    return this.countSuffixes(string.substring(0, n - 7)) + 1;
                }
                return 0;
            }
            case 'c': {
                if (string.charAt(n - 2) != 's') {
                    return 0;
                }
                if (n >= 4 && string.lastIndexOf("Desc") == n - 4) {
                    return this.countSuffixes(string.substring(0, n - 4)) + 1;
                }
                return 0;
            }
        }
        return 0;
    }

    public String fullName(ContainedNode containedNode, String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        this._buf.reset();
        if (containedNode.kind() == 6) {
            if (containedNode._container.kind() == 6) {
                this._buf.append(String.valueOf(String.valueOf(((PModuleNode)containedNode._container)._beFullName)).concat(String.valueOf(String.valueOf('_'))));
            }
        } else if (containedNode._container.kind() != 17 && containedNode._container.kind() != 6 && containedNode.kind() != 6) {
            this._buf.append(String.valueOf(String.valueOf(((ContainedNode)((Object)containedNode._container))._beFullName)).concat(String.valueOf(String.valueOf('_'))));
        }
        if (string != null) {
            this._buf.append(string);
        }
        return this._buf.toString();
    }

    protected static String genAdtStubName(String string) {
        if (string != null) {
            return "T".concat(String.valueOf(String.valueOf(PascalMapper.removeLeadingUnderbar(string))));
        }
        return null;
    }

    protected static String genClientModuleQualifiedName(String string) {
        return PascalMapper.genModuleQualifiedName(string, PascalBeOptions.clientExtension);
    }

    protected static String genClientModuleQualifiedName(String string, String string2) {
        return PascalMapper.genModuleQualifiedName(string, string2, PascalBeOptions.clientExtension);
    }

    protected static String genDescName(String string) {
        if (string != null) {
            return String.valueOf(String.valueOf(PascalMapper.removeLeadingUnderbar(string))).concat("Desc");
        }
        return null;
    }

    protected static String genExceptionName(String string) {
        if (string != null) {
            return "E".concat(String.valueOf(String.valueOf(PascalMapper.removeLeadingUnderbar(string))));
        }
        return null;
    }

    protected static String genFactoryName(String string) {
        if (string != null) {
            return String.valueOf(String.valueOf(PascalMapper.removeLeadingUnderbar(string))).concat("_Factory");
        }
        return null;
    }

    protected static String genFieldName(String string) {
        if (string != null) {
            return "F".concat(String.valueOf(String.valueOf(PascalMapper.removeLeadingUnderbar(string))));
        }
        return null;
    }

    protected static String genGetMethodName(String string) {
        if (string != null) {
            return "_get_".concat(String.valueOf(String.valueOf(PascalMapper.removeLeadingUnderbar(string))));
        }
        return null;
    }

    protected static String genHelperName(String string) {
        if (string != null) {
            return String.valueOf(String.valueOf(new StringBuffer("T").append(PascalMapper.removeLeadingUnderbar(string)).append("Helper")));
        }
        return null;
    }

    protected static String genIfaceModuleQualifiedName(String string) {
        return PascalMapper.genModuleQualifiedName(string, PascalBeOptions.interfaceExtension);
    }

    protected static String genIfaceModuleQualifiedName(String string, String string2) {
        return PascalMapper.genModuleQualifiedName(string, string2, PascalBeOptions.interfaceExtension);
    }

    protected static String genImplModuleQualifiedName(String string) {
        return PascalMapper.genModuleQualifiedName(string, PascalBeOptions.implExtension);
    }

    protected static String genImplModuleQualifiedName(String string, String string2) {
        return PascalMapper.genModuleQualifiedName(string, string2, PascalBeOptions.implExtension);
    }

    protected static String genImplName(String string) {
        if (string != null) {
            return "T".concat(String.valueOf(String.valueOf(PascalMapper.removeLeadingUnderbar(string))));
        }
        return null;
    }

    private static String genModuleQualifiedName(String string, String string2) {
        int n;
        if (string != null && (n = string.lastIndexOf(46)) > 0) {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string.substring(0, n).replace('.', '_')))).append(string2).append(string.substring(n, string.length()))));
        }
        return string;
    }

    private static String genModuleQualifiedName(String string, String string2, String string3) {
        if (string != null) {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(string3).append(".").append(string2)));
        }
        return string;
    }

    public final String genReadWriteType(String string) {
        String string2 = new String(string.toLowerCase());
        StringBuffer stringBuffer = null;
        if (string != null) {
            if (string2.equals("object")) {
                stringBuffer = new StringBuffer("Object");
            } else if (string2.equals("::corba::typecode")) {
                stringBuffer = new StringBuffer("TypeCode");
            } else if (string2.equals("::corba::principal")) {
                stringBuffer = new StringBuffer("Principal");
            } else {
                stringBuffer = new StringBuffer();
                int n = 0;
                boolean bl = false;
                if (string2.startsWith("unsigned")) {
                    stringBuffer.append('U');
                    n = 8;
                } else if (string2.startsWith("u")) {
                    stringBuffer.append('U');
                    n = 1;
                    bl = true;
                }
                while (n < string2.length()) {
                    if (string2.charAt(n) == ' ') {
                        bl = true;
                    } else {
                        if (bl) {
                            stringBuffer.append(Character.toUpperCase(string2.charAt(n)));
                        } else {
                            stringBuffer.append(Character.toLowerCase(string2.charAt(n)));
                        }
                        bl = false;
                    }
                    ++n;
                }
                stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
            }
        }
        if (stringBuffer == null) {
            return null;
        }
        return stringBuffer.toString();
    }

    protected static String genServerModuleQualifiedName(String string) {
        return PascalMapper.genModuleQualifiedName(string, PascalBeOptions.serverExtension);
    }

    protected static String genServerModuleQualifiedName(String string, String string2) {
        return PascalMapper.genModuleQualifiedName(string, string2, PascalBeOptions.serverExtension);
    }

    protected static String genSetMethodName(String string) {
        if (string != null) {
            return "_set_".concat(String.valueOf(String.valueOf(PascalMapper.removeLeadingUnderbar(string))));
        }
        return null;
    }

    protected static String genSkeletonMarshalName(String string) {
        if (string != null) {
            return "_".concat(String.valueOf(String.valueOf(string)));
        }
        return null;
    }

    protected static String genSkeletonName(String string) {
        if (string != null) {
            return String.valueOf(String.valueOf(new StringBuffer("T").append(PascalMapper.removeLeadingUnderbar(string)).append("Skeleton")));
        }
        return null;
    }

    protected static String genStubName(String string) {
        if (string != null) {
            return String.valueOf(String.valueOf(new StringBuffer("T").append(PascalMapper.removeLeadingUnderbar(string)).append("Stub")));
        }
        return null;
    }

    protected String genTkName(String string) {
        String string2 = this.genReadWriteType(PascalMapper.removeLeadingUnderbar(string)).toLowerCase();
        if (string2.equalsIgnoreCase("object")) {
            string2 = "objref";
        } else if (string2.charAt(0) == 'u') {
            string2 = string2.substring(1);
        }
        return "tk_".concat(String.valueOf(String.valueOf(string2)));
    }

    protected static String genVarName(String string) {
        if (string != null) {
            return "_".concat(String.valueOf(String.valueOf(PascalMapper.removeLeadingUnderbar(string))));
        }
        return null;
    }

    protected void initializeKeywordAvoider() {
        this._keywordAvoider.caseSensitive(false);
        this._keywordAvoider.avoid("and");
        this._keywordAvoider.avoid("array");
        this._keywordAvoider.avoid("as");
        this._keywordAvoider.avoid("asm");
        this._keywordAvoider.avoid("begin");
        this._keywordAvoider.avoid("case");
        this._keywordAvoider.avoid("class");
        this._keywordAvoider.avoid("const");
        this._keywordAvoider.avoid("constructor");
        this._keywordAvoider.avoid("destructor");
        this._keywordAvoider.avoid("dispinterface");
        this._keywordAvoider.avoid("div");
        this._keywordAvoider.avoid("do");
        this._keywordAvoider.avoid("downto");
        this._keywordAvoider.avoid("else");
        this._keywordAvoider.avoid("end");
        this._keywordAvoider.avoid("except");
        this._keywordAvoider.avoid("exports");
        this._keywordAvoider.avoid("file");
        this._keywordAvoider.avoid("finalization");
        this._keywordAvoider.avoid("finally");
        this._keywordAvoider.avoid("for");
        this._keywordAvoider.avoid("function");
        this._keywordAvoider.avoid("goto");
        this._keywordAvoider.avoid("if");
        this._keywordAvoider.avoid("inline");
        this._keywordAvoider.avoid("implementation");
        this._keywordAvoider.avoid("initialization");
        this._keywordAvoider.avoid("inherited");
        this._keywordAvoider.avoid("in");
        this._keywordAvoider.avoid("is");
        this._keywordAvoider.avoid("label");
        this._keywordAvoider.avoid("library");
        this._keywordAvoider.avoid("mod");
        this._keywordAvoider.avoid("nil");
        this._keywordAvoider.avoid("not");
        this._keywordAvoider.avoid("object");
        this._keywordAvoider.avoid("of");
        this._keywordAvoider.avoid("or");
        this._keywordAvoider.avoid("owner");
        this._keywordAvoider.avoid("packed");
        this._keywordAvoider.avoid("procedure");
        this._keywordAvoider.avoid("program");
        this._keywordAvoider.avoid("property");
        this._keywordAvoider.avoid("raise");
        this._keywordAvoider.avoid("record");
        this._keywordAvoider.avoid("repeat");
        this._keywordAvoider.avoid("resourcestring");
        this._keywordAvoider.avoid("self");
        this._keywordAvoider.avoid("set");
        this._keywordAvoider.avoid("shl");
        this._keywordAvoider.avoid("shr");
        this._keywordAvoider.avoid("string");
        this._keywordAvoider.avoid("then");
        this._keywordAvoider.avoid("threadvar");
        this._keywordAvoider.avoid("to");
        this._keywordAvoider.avoid("try");
        this._keywordAvoider.avoid("type");
        this._keywordAvoider.avoid("unit");
        this._keywordAvoider.avoid("until");
        this._keywordAvoider.avoid("uses");
        this._keywordAvoider.avoid("var");
        this._keywordAvoider.avoid("while");
        this._keywordAvoider.avoid("with");
        this._keywordAvoider.avoid("xor");
        this._keywordAvoider.avoid("Boolean");
        this._keywordAvoider.avoid("Char");
        this._keywordAvoider.avoid("WideChar");
        this._keywordAvoider.avoid("Shortint");
        this._keywordAvoider.avoid("Smallint");
        this._keywordAvoider.avoid("Integer");
        this._keywordAvoider.avoid("Byte");
        this._keywordAvoider.avoid("Word");
        this._keywordAvoider.avoid("Extended");
        this._keywordAvoider.avoid("Pointer");
        this._keywordAvoider.avoid("AnsiChar");
        this._keywordAvoider.avoid("Longint");
        this._keywordAvoider.avoid("Cardinal");
        this._keywordAvoider.avoid("Single");
        this._keywordAvoider.avoid("Double");
        this._keywordAvoider.avoid("Real");
        this._keywordAvoider.avoid("Real48");
        this._keywordAvoider.avoid("Comp");
        this._keywordAvoider.avoid("Currency");
        this._keywordAvoider.avoid("ShortString");
        this._keywordAvoider.avoid("OpenString");
        this._keywordAvoider.avoid("File");
        this._keywordAvoider.avoid("Text");
        this._keywordAvoider.avoid("Variant");
        this._keywordAvoider.avoid("Int64");
        this._keywordAvoider.avoid("PCurrency");
        this._keywordAvoider.avoid("AnsiString");
        this._keywordAvoider.avoid("PAnsiString");
        this._keywordAvoider.avoid("TextFile");
        this._keywordAvoider.avoid("PAnsiChar");
        this._keywordAvoider.avoid("PChar");
        this._keywordAvoider.avoid("ByteBool");
        this._keywordAvoider.avoid("WordBool");
        this._keywordAvoider.avoid("LongBool");
        this._keywordAvoider.avoid("WideString");
        this._keywordAvoider.avoid("TVarArrayBound");
        this._keywordAvoider.avoid("TVarArray");
        this._keywordAvoider.avoid("TVarData");
        this._keywordAvoider.avoid("PVarArray");
        this._keywordAvoider.avoid("PVarData");
        this._keywordAvoider.avoid("PShortString");
        this._keywordAvoider.avoid("PWideString");
        this._keywordAvoider.avoid("PWideChar");
        this._keywordAvoider.avoid("PString");
        this._keywordAvoider.avoid("PExtended");
        this._keywordAvoider.avoid("TDateTime");
        this._keywordAvoider.avoid("PVarRec");
        this._keywordAvoider.avoid("TObject");
        this._keywordAvoider.avoid("TClass");
        this._keywordAvoider.avoid("IUnknown");
        this._keywordAvoider.avoid("Create");
        this._keywordAvoider.avoid("Destroy");
        this._keywordAvoider.avoid("Print");
        this._keywordAvoider.avoid("Printer");
        this._keywordAvoider.avoid("Application");
        this._keywordAvoider.avoid("Screen");
    }

    protected void initializeNativeMap() {
        this._nativeMap.put("?initializeNativeMap()?", "?initializeNativeMap()?");
    }

    public String map(AliasNode aliasNode, int n, ContainerNode containerNode) {
        String string = null;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = ((PAliasNode)aliasNode).pascalName;
                break;
            }
            case 10: {
                string = ((PAliasNode)aliasNode).pascalHelperName;
                break;
            }
            case 9: 
            case 11: {
                string = this.map(aliasNode._type, n, null);
                break;
            }
            case 0: {
                string = this.map(aliasNode._type, n, null);
                break;
            }
            default: {
                aliasNode.ER().internalError(String.valueOf(String.valueOf(new StringBuffer("invalid context ").append(n).append(" in PascalMapper.map(AliasNode, int)"))));
            }
        }
        return string;
    }

    public String map(ArrayNode arrayNode, int n, ContainerNode containerNode) {
        String string = null;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = ((PArrayNode)arrayNode).pascalName;
                break;
            }
            case 10: {
                string = ((PArrayNode)arrayNode).pascalHelperName;
                break;
            }
            case 9: 
            case 11: {
                string = null;
                break;
            }
            case 0: {
                string = this.map(arrayNode._type, n, null);
                break;
            }
            default: {
                arrayNode.ER().internalError(String.valueOf(String.valueOf(new StringBuffer("invalid context ").append(n).append(" in PascalMapper.map(ArrayNode, int)"))));
            }
        }
        return string;
    }

    public String map(EnumNode enumNode, int n, ContainerNode containerNode) {
        String string = null;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = ((PEnumNode)enumNode).pascalName;
                break;
            }
            case 10: {
                string = ((PEnumNode)enumNode).pascalHelperName;
                break;
            }
            case 9: 
            case 11: {
                string = null;
                break;
            }
            default: {
                enumNode.ER().internalError(String.valueOf(String.valueOf(new StringBuffer("invalid context ").append(n).append(" in PascalMapper.map(EnumNode, int)"))));
            }
        }
        return string;
    }

    public String map(ExceptionNode exceptionNode, int n, ContainerNode containerNode) {
        String string = null;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = ((PExceptionNode)exceptionNode).pascalName;
                break;
            }
            case 10: {
                string = ((PExceptionNode)exceptionNode).pascalHelperName;
                break;
            }
            case 9: 
            case 11: {
                string = null;
                break;
            }
            default: {
                exceptionNode.ER().internalError(String.valueOf(String.valueOf(new StringBuffer("invalid context ").append(n).append(" in PascalMapper.map(InterfaceNode, int)"))));
            }
        }
        return string;
    }

    public String map(FixedNode fixedNode, int n, ContainerNode containerNode) {
        return "?map(FixedNode)?";
    }

    public String map(InterfaceNode interfaceNode, int n, ContainerNode containerNode) {
        String string = null;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = ((PInterfaceNode)interfaceNode).pascalFullName;
                break;
            }
            case 10: {
                string = ((PInterfaceNode)interfaceNode).pascalHelperName;
                break;
            }
            case 9: 
            case 11: {
                string = null;
                break;
            }
            default: {
                interfaceNode.ER().internalError(String.valueOf(String.valueOf(new StringBuffer("invalid context ").append(n).append(" in PascalMapper.map(InterfaceNode, int)"))));
            }
        }
        return string;
    }

    public String map(NativeNode nativeNode, int n, ContainerNode containerNode) {
        return "";
    }

    public String map(PrimitiveNode primitiveNode, int n, ContainerNode containerNode) {
        String string = null;
        block0 : switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                switch (primitiveNode._pkind) {
                    case 1: {
                        string = "void";
                        break block0;
                    }
                    case 2: {
                        string = "SmallInt";
                        break block0;
                    }
                    case 3: {
                        string = "Integer";
                        break block0;
                    }
                    case 16: {
                        string = "Int64";
                        break block0;
                    }
                    case 4: {
                        string = "Word";
                        break block0;
                    }
                    case 5: {
                        string = "Cardinal";
                        break block0;
                    }
                    case 17: {
                        string = "Int64";
                        break block0;
                    }
                    case 6: {
                        string = "Single";
                        break block0;
                    }
                    case 7: {
                        string = "Double";
                        break block0;
                    }
                    case 18: {
                        string = "Extended";
                        break block0;
                    }
                    case 8: {
                        string = "Boolean";
                        break block0;
                    }
                    case 9: {
                        string = "Char";
                        break block0;
                    }
                    case 19: {
                        string = "WideChar";
                        break block0;
                    }
                    case 10: {
                        string = "Byte";
                        break block0;
                    }
                    case 12: {
                        string = "TypeCode";
                        break block0;
                    }
                    case 13: {
                        string = "Principal";
                        break block0;
                    }
                    case 11: {
                        string = "Any";
                        break block0;
                    }
                    case 15: {
                        string = "CORBAObject";
                        break block0;
                    }
                    case 14: {
                        string = "AnsiString";
                        break block0;
                    }
                    case 20: {
                        string = "WideString";
                        break block0;
                    }
                }
                primitiveNode.ER().internalError(String.valueOf(String.valueOf(new StringBuffer("invalid primitive type ").append(primitiveNode.typeName()).append(" in PascalMapper.map(PrimitiveNode, int)"))));
                break;
            }
            case 10: {
                string = null;
                break;
            }
            case 9: {
                string = this.genTkName(primitiveNode.typeName());
                break;
            }
            case 11: {
                string = this.genReadWriteType(primitiveNode.typeName());
                break;
            }
            default: {
                primitiveNode.ER().internalError(String.valueOf(String.valueOf(new StringBuffer("invalid context ").append(n).append(" in PascalMapper.map(PrimitiveNode, int)"))));
            }
        }
        return string;
    }

    public String map(SequenceNode sequenceNode, int n, ContainerNode containerNode) {
        String string = null;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 10: {
                break;
            }
            case 9: {
                string = null;
                break;
            }
            case 11: {
                string = null;
                break;
            }
            case 0: {
                string = this.map(sequenceNode._type, n, null);
                break;
            }
            default: {
                sequenceNode.ER().internalError(String.valueOf(String.valueOf(new StringBuffer("invalid context ").append(n).append(" in PascalMapper.map(SequenceNode, int)"))));
            }
        }
        return string;
    }

    public String map(StringNode stringNode, int n, ContainerNode containerNode) {
        String string = null;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "AnsiString";
                break;
            }
            case 10: {
                string = null;
                break;
            }
            case 9: {
                string = this.genTkName(stringNode.typeName());
                break;
            }
            case 11: {
                string = this.genReadWriteType(stringNode.typeName());
                break;
            }
            default: {
                stringNode.ER().internalError(String.valueOf(String.valueOf(new StringBuffer("invalid context ").append(n).append(" in PascalMapper.map(StringNode, int)"))));
            }
        }
        return string;
    }

    public String map(StructNode structNode, int n, ContainerNode containerNode) {
        String string = null;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = ((PStructNode)structNode).pascalName;
                break;
            }
            case 10: {
                string = ((PStructNode)structNode).pascalHelperName;
                break;
            }
            case 9: 
            case 11: {
                string = null;
                break;
            }
            default: {
                structNode.ER().internalError(String.valueOf(String.valueOf(new StringBuffer("invalid context ").append(n).append(" in PascalMapper.map(StructNode, int)"))));
            }
        }
        return string;
    }

    public String map(Type type) {
        return this.map(type, 0);
    }

    public String map(Type type, int n) {
        String string = null;
        switch (type.kind()) {
            case 5: {
                string = this.map((InterfaceNode)type, n, null);
                break;
            }
            case 10: {
                string = this.map((StructNode)type, n, null);
                break;
            }
            case 11: {
                string = this.map((UnionNode)type, n, null);
                break;
            }
            case 12: {
                string = this.map((EnumNode)type, n, null);
                break;
            }
            case 4: 
            case 20: 
            case 21: {
                string = ((ContainedNode)((Object)type))._beName;
                break;
            }
            case 9: {
                string = this.map((AliasNode)type, n, null);
                break;
            }
            case 13: {
                string = this.map((PrimitiveNode)type, n, null);
                break;
            }
            case 14: {
                string = this.map((StringNode)type, n, null);
                break;
            }
            case 15: {
                string = this.map((SequenceNode)type, n, null);
                break;
            }
            case 16: {
                string = this.map((ArrayNode)type, n, null);
                break;
            }
            case 18: {
                string = this.map((WStringNode)type, n, null);
                break;
            }
            case 19: {
                string = this.map((FixedNode)type, n, null);
                break;
            }
            case 23: {
                string = this.map((NativeNode)type, n, null);
                break;
            }
            default: {
                type.ER().internalError(String.valueOf(String.valueOf(new StringBuffer("invalid type ").append(((Node)((Object)type)).typeName()).append(" in PascalMapper.map(Type, int)"))));
            }
        }
        return string;
    }

    public String map(UnionNode unionNode, int n, ContainerNode containerNode) {
        String string = null;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = ((PUnionNode)unionNode).pascalName;
                break;
            }
            case 10: {
                string = ((PUnionNode)unionNode).pascalHelperName;
                break;
            }
            case 9: 
            case 11: {
                string = null;
                break;
            }
            default: {
                unionNode.ER().internalError(String.valueOf(String.valueOf(new StringBuffer("invalid context ").append(n).append(" in PascalMapper.map(UnionNode, int)"))));
            }
        }
        return string;
    }

    public String map(ValueBoxNode valueBoxNode, int n, ContainerNode containerNode) {
        String string = this.relativeName(valueBoxNode, containerNode);
        switch (n) {
            case 2: 
            case 3: {
                return String.valueOf(String.valueOf(string)).concat("Holder");
            }
        }
        return this.map(valueBoxNode._type, n, containerNode);
    }

    public String map(ValueNode valueNode, int n, ContainerNode containerNode) {
        String string = this.relativeName(valueNode, containerNode);
        switch (n) {
            case 2: 
            case 3: {
                return String.valueOf(String.valueOf(string)).concat("Holder");
            }
        }
        return string;
    }

    public String map(WStringNode wStringNode, int n, ContainerNode containerNode) {
        String string = null;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "WideString";
                break;
            }
            case 10: {
                string = null;
                break;
            }
            case 9: {
                string = this.genTkName(wStringNode.typeName());
                break;
            }
            case 11: {
                string = this.genReadWriteType(wStringNode.typeName());
                break;
            }
            default: {
                wStringNode.ER().internalError(String.valueOf(String.valueOf(new StringBuffer("invalid context ").append(n).append(" in PascalMapper.map(WStringNode, int)"))));
            }
        }
        return string;
    }

    public String mapFull(NativeNode nativeNode, int n) {
        return "";
    }

    public String mapFull(Type type) {
        return this.mapFull(type, 0);
    }

    public String mapFull(Type type, int n) {
        if (type.kind() == 23) {
            return this.mapFull((NativeNode)type);
        }
        if (type.isContained()) {
            String string;
            this._buf.reset();
            ContainerNode containerNode = ((ContainedNode)((Object)type))._container;
            if (containerNode.kind() != 17 && n != 11) {
                this._buf.append(((ContainedNode)((Object)containerNode))._beFullName);
                this._buf.append('.');
            }
            if ((string = this.map(type, n)) != null) {
                this._buf.append(this.map(type, n));
                return this._buf.toString();
            }
            return string;
        }
        return this.map(type, n);
    }

    public String mapIdentifier(String string) {
        String string2 = this._keywordAvoider.convertSimpleName(string);
        if (string2.charAt(0) == '_') {
            return string2;
        }
        for (int i = this.countSuffixes(string); i > 0; --i) {
            string = "_".concat(String.valueOf(String.valueOf(string)));
        }
        return string;
    }

    public String mapPackage(ContainerNode containerNode) {
        this._v.setSize(0);
        ContainerNode containerNode2 = containerNode;
        while (containerNode2.kind() != 6 && containerNode2.kind() != 17) {
            containerNode2 = ((ContainedNode)((Object)containerNode2))._container;
        }
        if (containerNode2.kind() == 6) {
            this._v.addElement(containerNode2);
        }
        this._buf.reset();
        if (!((PRepositoryNode)((Node)((Object)containerNode))._repository).bUnitIsEmpty) {
            this._buf.append(((PRepositoryNode)((Node)((Object)containerNode))._repository).pascalName);
            if (this._v.size() > 0) {
                this._buf.append("_");
            }
        }
        for (int i = this._v.size() - 1; i >= 0; --i) {
            ContainedNode containedNode = (ContainedNode)this._v.elementAt(i);
            if (i > 0) {
                this._buf.append('_');
            }
            this._buf.append(containedNode._beFullName);
        }
        return this._buf.toString();
    }

    public String mapScoped(Type type, int n, String string) {
        int n2 = 0;
        String string2 = this.mapFull(type, n);
        int n3 = string2.length();
        int n4 = string.length();
        for (int i = 0; i < n3 && i < n4; ++i) {
            if (string2.charAt(i) != string.charAt(i)) {
                return string2.substring(n2, n3);
            }
            if (string2.charAt(i) != '_') continue;
            n2 = i + 1;
        }
        return string;
    }

    public String relativeName(ContainedNode containedNode, ContainerNode containerNode) {
        return this.relativeName(containedNode, containerNode, ".", false);
    }

    private static String removeLeadingUnderbar(String string) {
        if (string != null) {
            return string.charAt(0) == '_' ? string.substring(1) : string;
        }
        return null;
    }

    static {
        trace = false;
    }
}

