/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.backends.pascal.ast;

import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PType;

public final class PPrimitiveNode
extends PrimitiveNode
implements PType {
    public transient String pascalTypeName;

    public PPrimitiveNode(int n) {
        super(n);
    }

    public static String asString(String string, boolean bl) {
        return String.valueOf(String.valueOf(new StringBuffer("'").append(PPrimitiveNode.pascalISOLatin1StringToPrintable(string, bl)).append("'")));
    }

    private static void convertChar(StringBuffer stringBuffer, char c) {
        StringBuffer stringBuffer2 = new StringBuffer();
        switch (c) {
            case '\b': {
                stringBuffer.append("#8");
                break;
            }
            case '\f': {
                stringBuffer.append("#12");
                break;
            }
            case '\n': {
                stringBuffer.append("#10");
                break;
            }
            case '\r': {
                stringBuffer.append("#13");
                break;
            }
            case '\t': {
                stringBuffer.append("#9");
                break;
            }
            case '\\': {
                stringBuffer.append("''");
                break;
            }
            case '\'': {
                stringBuffer.append("''''");
                break;
            }
            default: {
                char c2 = c;
                stringBuffer.append(String.valueOf(String.valueOf('#')).concat(String.valueOf(String.valueOf(String.valueOf((int)c2)))));
            }
        }
    }

    private static void convertWChar(StringBuffer stringBuffer, char c) {
        StringBuffer stringBuffer2 = new StringBuffer();
        switch (c) {
            case '\b': {
                stringBuffer.append("#8");
                break;
            }
            case '\f': {
                stringBuffer.append("#12");
                break;
            }
            case '\n': {
                stringBuffer.append("#10");
                break;
            }
            case '\r': {
                stringBuffer.append("#13");
                break;
            }
            case '\t': {
                stringBuffer.append("#9");
                break;
            }
            case '\\': {
                stringBuffer.append("''");
                break;
            }
            case '\'': {
                stringBuffer.append("''''");
                break;
            }
            default: {
                char c2 = c;
                stringBuffer.append(String.valueOf(String.valueOf('#')).concat(String.valueOf(String.valueOf(String.valueOf((int)c2)))));
            }
        }
    }

    public boolean finish(int n) {
        this.pascalTypeName = this._repository._mapper.map(this, null);
        return true;
    }

    public String getHelperFullName() {
        return null;
    }

    public String getReadWritePrefix() {
        return this._repository._mapper.map(this, 11, null);
    }

    public String getScope() {
        return null;
    }

    public String getTkHelperFullName() {
        return null;
    }

    public String getTkName() {
        return this._repository._mapper.map(this, 9, null);
    }

    public String getTypeFullName() {
        return this._repository._mapper.map(this, 0, null);
    }

    private static boolean isSpecialChar(char c) {
        return c < ' ' || c > '~' || c == '\'';
    }

    private static boolean isSpecialWChar(char c) {
        return c < ' ' || c > '~' || c == '\'';
    }

    public static String pascalISOLatin1CharToPrintable(char c, boolean bl) {
        switch (c) {
            case '\\': {
                return "\\";
            }
            case '\"': {
                return "\"";
            }
            case '\'': {
                return "''";
            }
        }
        if (c >= ' ' && c <= '~') {
            return "".concat(String.valueOf(String.valueOf(c)));
        }
        switch (c) {
            case '\n': {
                return "#10";
            }
            case '\t': {
                return "#9";
            }
            case '\b': {
                return "#8";
            }
            case '\r': {
                return "#13";
            }
            case '\f': {
                return "#12";
            }
            case '\u0007': {
                if (!bl) {
                    return "\\a";
                }
            }
            case '\u000b': {
                if (bl) break;
                return "\\v";
            }
        }
        char c2 = c;
        char c3 = (char)(48 + (c2 >> 6));
        char c4 = (char)(48 + (c2 >> 3 & 7));
        char c5 = (char)(48 + (c2 & 7));
        return String.valueOf(String.valueOf(new StringBuffer("\\").append(c3).append(c4).append(c5)));
    }

    public static String pascalISOLatin1StringToPrintable(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(PPrimitiveNode.pascalISOLatin1CharToPrintable(string.charAt(i), bl));
        }
        return stringBuffer.toString();
    }

    public String toLiteral(Object object) {
        switch (this._pkind) {
            case 8: {
                return object == Boolean.TRUE ? "True" : "False";
            }
            case 10: {
                int n = ((Byte)object).byteValue();
                Integer n2 = new Integer(n < 0 ? 256 + n : n);
                return n2.toString();
            }
            case 14: {
                String string = object.toString();
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                int n3 = string.length();
                for (int i = 0; i < n3; ++i) {
                    if (n > 0) {
                        stringBuffer.append("+");
                    }
                    if (PPrimitiveNode.isSpecialChar(string.charAt(i))) {
                        PPrimitiveNode.convertChar(stringBuffer, string.charAt(i));
                    } else {
                        int n4;
                        for (n4 = i; n4 < n3 && !PPrimitiveNode.isSpecialChar(string.charAt(n4)); ++n4) {
                        }
                        stringBuffer.append("'");
                        if (n4 < n3) {
                            stringBuffer.append(string.substring(i, n4));
                            i = n4 - 1;
                        } else {
                            stringBuffer.append(string.substring(i));
                            i = n4 - 1;
                        }
                        stringBuffer.append("'");
                    }
                    ++n;
                }
                return stringBuffer.toString();
            }
            case 20: {
                String string = object.toString();
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                int n5 = string.length();
                for (int i = 0; i < n5; ++i) {
                    if (n > 0) {
                        stringBuffer.append("+");
                    }
                    if (PPrimitiveNode.isSpecialWChar(string.charAt(i))) {
                        PPrimitiveNode.convertWChar(stringBuffer, string.charAt(i));
                    } else {
                        int n6;
                        for (n6 = i; n6 < n5 && !PPrimitiveNode.isSpecialWChar(string.charAt(n6)); ++n6) {
                        }
                        stringBuffer.append("'");
                        if (n6 < n5) {
                            stringBuffer.append(string.substring(i, n6));
                            i = n6 - 1;
                        } else {
                            stringBuffer.append(string.substring(i));
                            i = n6 - 1;
                        }
                        stringBuffer.append("'");
                    }
                    ++n;
                }
                return stringBuffer.toString();
            }
            case 9: {
                StringBuffer stringBuffer = new StringBuffer();
                char c = ((Character)object).charValue();
                if (PPrimitiveNode.isSpecialChar(c)) {
                    PPrimitiveNode.convertChar(stringBuffer, c);
                } else {
                    stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer("'").append(c).append("'"))));
                }
                return stringBuffer.toString();
            }
            case 19: {
                StringBuffer stringBuffer = new StringBuffer();
                char c = ((Character)object).charValue();
                if (PPrimitiveNode.isSpecialWChar(c)) {
                    PPrimitiveNode.convertWChar(stringBuffer, c);
                } else {
                    stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer("'").append(c).append("'"))));
                }
                return stringBuffer.toString();
            }
        }
        return object.toString();
    }

    public String toPascalLiteral(Object object) {
        switch (this._pkind) {
            case 8: {
                return object == Boolean.TRUE ? "True" : "False";
            }
            case 10: {
                int n = ((Byte)object).byteValue();
                Integer n2 = new Integer(n < 0 ? 256 + n : n);
                return n2.toString();
            }
            case 14: {
                String string = object.toString();
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                int n3 = string.length();
                for (int i = 0; i < n3; ++i) {
                    if (n > 0) {
                        stringBuffer.append("+");
                    }
                    if (PPrimitiveNode.isSpecialChar(string.charAt(i))) {
                        PPrimitiveNode.convertChar(stringBuffer, string.charAt(i));
                    } else {
                        int n4;
                        for (n4 = i; n4 < n3 && !PPrimitiveNode.isSpecialChar(string.charAt(n4)); ++n4) {
                        }
                        stringBuffer.append("'");
                        if (n4 < n3) {
                            stringBuffer.append(string.substring(i, n4));
                            i = n4 - 1;
                        } else {
                            stringBuffer.append(string.substring(i));
                            i = n4 - 1;
                        }
                        stringBuffer.append("'");
                    }
                    ++n;
                }
                return stringBuffer.toString();
            }
            case 20: {
                String string = object.toString();
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                int n5 = string.length();
                for (int i = 0; i < n5; ++i) {
                    if (n > 0) {
                        stringBuffer.append("+");
                    }
                    if (PPrimitiveNode.isSpecialWChar(string.charAt(i))) {
                        PPrimitiveNode.convertWChar(stringBuffer, string.charAt(i));
                    } else {
                        int n6;
                        for (n6 = i; n6 < n5 && !PPrimitiveNode.isSpecialWChar(string.charAt(n6)); ++n6) {
                        }
                        stringBuffer.append("'");
                        if (n6 < n5) {
                            stringBuffer.append(string.substring(i, n6));
                            i = n6 - 1;
                        } else {
                            stringBuffer.append(string.substring(i));
                            i = n6 - 1;
                        }
                        stringBuffer.append("'");
                    }
                    ++n;
                }
                return stringBuffer.toString();
            }
            case 9: {
                StringBuffer stringBuffer = new StringBuffer();
                char c = ((Character)object).charValue();
                if (PPrimitiveNode.isSpecialChar(c)) {
                    PPrimitiveNode.convertChar(stringBuffer, c);
                } else {
                    stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer("'").append(c).append("'"))));
                }
                return stringBuffer.toString();
            }
            case 19: {
                StringBuffer stringBuffer = new StringBuffer();
                char c = ((Character)object).charValue();
                if (PPrimitiveNode.isSpecialWChar(c)) {
                    PPrimitiveNode.convertWChar(stringBuffer, c);
                } else {
                    stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer("'").append(c).append("'"))));
                }
                return stringBuffer.toString();
            }
        }
        return object.toString();
    }
}

