/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;

public final class Class
implements Serializable {
    private Class() {
    }

    public String toString() {
        return String.valueOf(this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    public static native Class forName(String var0) throws ClassNotFoundException;

    public native Object newInstance() throws InstantiationException, IllegalAccessException;

    public native boolean isInstance(Object var1);

    public native boolean isAssignableFrom(Class var1);

    public native boolean isInterface();

    public native boolean isArray();

    public native boolean isPrimitive();

    public native String getName();

    public native ClassLoader getClassLoader();

    public native Class getSuperclass();

    public native Class[] getInterfaces();

    public native Class getComponentType();

    public native int getModifiers();

    public native Object[] getSigners();

    native void setSigners(Object[] var1);

    public Class getDeclaringClass() {
        return null;
    }

    public Class[] getClasses() {
        return new Class[0];
    }

    public Field[] getFields() throws SecurityException {
        this.checkMemberAccess(0);
        return this.getFields0(0);
    }

    public Method[] getMethods() throws SecurityException {
        this.checkMemberAccess(0);
        return this.getMethods0(0);
    }

    public Constructor[] getConstructors() throws SecurityException {
        this.checkMemberAccess(0);
        return this.getConstructors0(0);
    }

    public Field getField(String string) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(0);
        return this.getField0(string, 0);
    }

    public Method getMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(0);
        return this.getMethod0(string, classArray, 0);
    }

    public Constructor getConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(0);
        return this.getConstructor0(classArray, 0);
    }

    public Class[] getDeclaredClasses() throws SecurityException {
        this.checkMemberAccess(1);
        return new Class[0];
    }

    public Field[] getDeclaredFields() throws SecurityException {
        this.checkMemberAccess(1);
        return this.getFields0(1);
    }

    public Method[] getDeclaredMethods() throws SecurityException {
        this.checkMemberAccess(1);
        return this.getMethods0(1);
    }

    public Constructor[] getDeclaredConstructors() throws SecurityException {
        this.checkMemberAccess(1);
        return this.getConstructors0(1);
    }

    public Field getDeclaredField(String string) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(1);
        return this.getField0(string, 1);
    }

    public Method getDeclaredMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(1);
        return this.getMethod0(string, classArray, 1);
    }

    public Constructor getDeclaredConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(1);
        return this.getConstructor0(classArray, 1);
    }

    public InputStream getResourceAsStream(String string) {
        string = this.resolveName(string);
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResourceAsStream(string);
        }
        return classLoader.getResourceAsStream(string);
    }

    public URL getResource(String string) {
        string = this.resolveName(string);
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        return classLoader.getResource(string);
    }

    static native Class getPrimitiveClass(String var0);

    private void checkMemberAccess(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, n);
        }
    }

    private String resolveName(String string) {
        if (string == null) {
            return string;
        }
        if (!string.startsWith("/")) {
            Class clazz = this;
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            String string2 = clazz.getName();
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string = String.valueOf(string2.substring(0, n).replace('.', '/')) + "/" + string;
            }
        } else {
            string = string.substring(1);
        }
        return string;
    }

    private native Field[] getFields0(int var1);

    private native Method[] getMethods0(int var1);

    private native Constructor[] getConstructors0(int var1);

    private native Field getField0(String var1, int var2);

    private native Method getMethod0(String var1, Class[] var2, int var3);

    private native Constructor getConstructor0(Class[] var1, int var2);
}

