/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

import com.inprise.vbroker.util.UnGuardedVectorEnumerator;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class UnGuardedVector
implements Cloneable,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;

    public UnGuardedVector() {
        this(10);
    }

    public UnGuardedVector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public UnGuardedVector(int initialCapacity, int capacityIncrement) {
        this.elementData = new Object[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public void addElement(Object obj) {
        int newcount = this.elementCount + 1;
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        this.elementData[this.elementCount++] = obj;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public Object clone() {
        try {
            UnGuardedVector v = (UnGuardedVector)super.clone();
            v.elementData = new Object[this.elementCount];
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.elementCount);
            UnGuardedVector unGuardedVector = v;
            return unGuardedVector;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean contains(Object elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public void copyInto(Object[] anArray) {
        int i = this.elementCount;
        while (i-- > 0) {
            anArray[i] = this.elementData[i];
        }
    }

    public Object elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(new StringBuffer(String.valueOf(index)).append(" >= ").append(this.elementCount)));
        }
        try {
            Object object = this.elementData[index];
            return object;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index).concat(" < 0"));
        }
    }

    public Enumeration elements() {
        return new UnGuardedVectorEnumerator(this);
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.elementData.length) {
            this.ensureCapacityHelper(minCapacity);
        }
    }

    private void ensureCapacityHelper(int minCapacity) {
        int newCapacity;
        int oldCapacity = this.elementData.length;
        Object[] oldData = this.elementData;
        int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.elementData = new Object[newCapacity];
        System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
    }

    public Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public int indexOf(Object elem) {
        return this.indexOf(elem, 0);
    }

    public int indexOf(Object elem, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (!elem.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public void insertElementAt(Object obj, int index) {
        int newcount = this.elementCount + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(new StringBuffer(String.valueOf(index)).append(" > ").append(this.elementCount)));
        }
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public int lastIndexOf(Object elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    public int lastIndexOf(Object elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (!elem.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public boolean removeElement(Object obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void removeElementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(new StringBuffer(String.valueOf(index)).append(" >= ").append(this.elementCount)));
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public void setElementAt(Object obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(new StringBuffer(String.valueOf(index)).append(" >= ").append(this.elementCount)));
        }
        this.elementData[index] = obj;
    }

    public void setSize(int newSize) {
        if (newSize > this.elementCount && newSize > this.elementData.length) {
            this.ensureCapacityHelper(newSize);
        } else {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = newSize;
    }

    public int size() {
        return this.elementCount;
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration e = this.elements();
        buf.append("[");
        for (int i = 0; i <= max; ++i) {
            String s = e.nextElement().toString();
            buf.append(s);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            Object[] oldData = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }
}

