/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

public final class Timer {
    private boolean Suspended;
    private String Mesg;
    private long ElapsedTimeMillis;
    private long StartTimeMillis;

    public Timer() {
        this("elapsed time: ");
    }

    public Timer(String mesg) {
        this(mesg, true);
    }

    public Timer(String mesg, boolean active) {
        this.Mesg = mesg;
        this.ElapsedTimeMillis = 0L;
        if (active) {
            this.resume();
        } else {
            this.Suspended = true;
        }
    }

    public long elapsedTimeMillis() {
        return this.ElapsedTimeMillis + (this.Suspended ? 0L : System.currentTimeMillis() - this.StartTimeMillis);
    }

    public String format() {
        long totalMillis = this.elapsedTimeMillis();
        long totalSeconds = totalMillis / (long)1000;
        long totalMinutes = totalSeconds / (long)60;
        long totalHours = totalMinutes / (long)60;
        long residualMinutes = totalMinutes - totalHours * (long)60;
        long residualSeconds = totalSeconds - totalMinutes * (long)60;
        long residualMillis = totalMillis - totalSeconds * (long)1000;
        String tmp = "00".concat(String.valueOf(residualMillis));
        String milliString = tmp.substring(tmp.length() - 3, tmp.length());
        if (totalHours > (long)0) {
            return String.valueOf(new StringBuffer("").append(totalHours).append(":").append(residualMinutes).append(" ").append(residualSeconds).append(".").append(milliString));
        }
        if (totalMinutes > (long)0) {
            return String.valueOf(new StringBuffer("").append(residualMinutes).append("m ").append(residualSeconds).append(".").append(milliString).append("s"));
        }
        if (totalSeconds > (long)0) {
            return String.valueOf(new StringBuffer("").append(residualSeconds).append(".").append(milliString).append("s"));
        }
        return String.valueOf(new StringBuffer("").append(totalMillis).append("ms"));
    }

    public String getMessage() {
        return this.Mesg;
    }

    public void print() {
        System.out.println(String.valueOf(this.Mesg).concat(String.valueOf(this.format())));
    }

    public void resume() {
        this.StartTimeMillis = System.currentTimeMillis();
        this.Suspended = false;
    }

    public void setMessage(String mesg) {
        this.Mesg = mesg;
    }

    public void stopAndPrint() {
        this.suspend();
        this.print();
    }

    public void suspend() {
        this.ElapsedTimeMillis = this.elapsedTimeMillis();
        this.Suspended = true;
    }
}

