/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

import java.io.File;
import java.util.StringTokenizer;

public final class StringFunctions {
    public static boolean ArrayContainsString(String[] array, String str) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(str)) continue;
            return true;
        }
        return false;
    }

    public static String ArrayToString(String[] array, String separator) {
        if (array == null || array.length == 0) {
            return "";
        }
        String retVal = array[0];
        for (int i = 1; i < array.length; ++i) {
            retVal = String.valueOf(new StringBuffer(String.valueOf(retVal)).append(separator).append(array[i]));
        }
        return retVal;
    }

    public static String ISOLatin1CharToPrintable(char c, boolean javaStyle) {
        switch (c) {
            case '\\': {
                return "\\\\";
            }
            case '\"': {
                return "\\\"";
            }
            case '\'': {
                return "\\'";
            }
        }
        if (c >= ' ' && c <= '~') {
            return "".concat(String.valueOf(c));
        }
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\b': {
                return "\\b";
            }
            case '\r': {
                return "\\r";
            }
            case '\f': {
                return "\\f";
            }
            case '\u0007': {
                if (!javaStyle) {
                    return "\\a";
                }
            }
            case '\u000b': {
                if (javaStyle) break;
                return "\\v";
            }
        }
        char i = c;
        char digit1 = (char)(48 + (i >> 6));
        char digit2 = (char)(48 + (i >> 3 & 7));
        char digit3 = (char)(48 + (i & 7));
        return String.valueOf(new StringBuffer("\\").append(digit1).append(digit2).append(digit3));
    }

    public static String ISOLatin1NoInvisibles(String s) {
        int len = s.length();
        StringBuffer buf = new StringBuffer(len * 2);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= ' ' && c < '\u007f') {
                buf.append(c);
                continue;
            }
            buf.append(StringFunctions.ISOLatin1CharToPrintable(c, true));
        }
        return buf.toString();
    }

    public static String ISOLatin1StringToPrintable(String s, boolean javaStyle) {
        int len = s.length();
        StringBuffer buf = new StringBuffer(len * 2);
        for (int i = 0; i < len; ++i) {
            buf.append(StringFunctions.ISOLatin1CharToPrintable(s.charAt(i), javaStyle));
        }
        return buf.toString();
    }

    public static String ISOLatin1ToUnicode(String s) {
        int len = s.length();
        if (s.indexOf(92) == -1) {
            return s;
        }
        StringBuffer buf = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                char nextChar;
                if (i == len) {
                    StringFunctions.bogusEscape(s);
                }
                if ((nextChar = s.charAt(++i)) == 'x' || nextChar == 'X') {
                    int j;
                    String hexNumeral = "";
                    for (j = i + 1; j < len && StringFunctions.isHex(c = s.charAt(j)); ++j) {
                        hexNumeral = String.valueOf(hexNumeral).concat(String.valueOf(c));
                    }
                    if (hexNumeral.length() == 0) {
                        StringFunctions.bogusEscape(s);
                    }
                    buf.append((char)StringFunctions.translateHexLiteral(hexNumeral, true));
                    i = j - 1;
                    continue;
                }
                if (nextChar >= '0' && nextChar <= '7') {
                    String octalNumeral = "".concat(String.valueOf(nextChar));
                    if (i + 1 < len && (c = s.charAt(i + 1)) >= '0' && c <= '7') {
                        octalNumeral = String.valueOf(octalNumeral).concat(String.valueOf(c));
                        if (++i + 1 < len && (c = s.charAt(i + 1)) >= '0' && c <= '7') {
                            octalNumeral = String.valueOf(octalNumeral).concat(String.valueOf(c));
                            ++i;
                        }
                    }
                    buf.append((char)StringFunctions.translateOctalLiteral(octalNumeral, true));
                    continue;
                }
                try {
                    buf.append((char)StringFunctions.translateCharacterLiteral(String.valueOf(new StringBuffer("'\\").append(nextChar).append("'")), false));
                }
                catch (NumberFormatException e) {
                    StringFunctions.bogusEscape(s);
                }
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static void bogusEscape(String s) {
        throw new IllegalArgumentException("Util.StringLit.invalidEscape");
    }

    public static boolean isEqual(String[] a1, String[] a2) {
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i].equals(a2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isHex(char chr) {
        return chr >= '0' && chr <= '9' || chr >= 'A' && chr <= 'F' || chr >= 'a' && chr <= 'f';
    }

    public static String prepFilename(String filename) {
        return File.separatorChar == '\\' ? StringFunctions.stringize(filename.replace('\\', '\u007f'), true, false).replace('\u007f', '\\') : StringFunctions.stringize(filename, true, false);
    }

    public static String replaceString(String source, String splitSep, String joinSep) {
        return StringFunctions.ArrayToString(StringFunctions.toStringArray(source, splitSep), joinSep);
    }

    public static String stringize(String str, boolean implicitlyQuoted, boolean addSurroundingQuotes) {
        if (implicitlyQuoted) {
            str = String.valueOf(new StringBuffer("\"").append(str).append("\""));
        }
        block0: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != '\"' && c != '\'') continue;
            char delimiter = c;
            if (delimiter == '\"') {
                str = String.valueOf(new StringBuffer(String.valueOf(str.substring(0, i))).append('\\').append(str.substring(i)));
                i += 2;
            } else {
                ++i;
            }
            while (i < str.length()) {
                char d = str.charAt(i);
                if (d == '\\') {
                    if ((i += 2) < (str = String.valueOf(new StringBuffer(String.valueOf(str.substring(0, i))).append('\\').append(str.substring(i)))).length() && str.charAt(i) == delimiter) {
                        str = String.valueOf(new StringBuffer(String.valueOf(str.substring(0, i))).append('\\').append(str.substring(i)));
                        i += 2;
                    }
                    --i;
                } else if (d == delimiter) {
                    if (delimiter != '\"') continue block0;
                    str = String.valueOf(new StringBuffer(String.valueOf(str.substring(0, i))).append('\\').append(str.substring(i)));
                    ++i;
                    continue block0;
                }
                ++i;
            }
        }
        if (implicitlyQuoted) {
            str = str.substring(2, str.length() - 2);
        }
        return addSurroundingQuotes ? String.valueOf(new StringBuffer("\"").append(str).append("\"")) : str;
    }

    public static int toInt(char chr) {
        return chr >= '0' && chr <= '9' ? chr - 48 : (chr >= 'A' && chr <= 'F' ? chr - 65 + 10 : (chr >= 'a' && chr <= 'f' ? chr - 97 + 10 : -1));
    }

    public static String[] toStringArray(String s, String sep) {
        StringTokenizer st;
        int numTokens;
        String[] retVal = null;
        if (s != null && (numTokens = (st = new StringTokenizer(s, sep)).countTokens()) != 0) {
            retVal = new String[numTokens];
            for (int i = 0; i < numTokens; ++i) {
                retVal[i] = st.nextToken();
            }
        }
        return retVal;
    }

    public static long translateCharacterLiteral(String lexeme, boolean allowUnicode) throws NumberFormatException {
        if ((lexeme = lexeme.substring(1, lexeme.length() - 1)).length() == 1 && lexeme.charAt(0) != '\\') {
            return lexeme.charAt(0);
        }
        if (lexeme.charAt(0) != '\\') {
            throw new NumberFormatException("Util.CharLit.malformed");
        }
        lexeme = lexeme.substring(1);
        int len = lexeme.length();
        char c = lexeme.charAt(0);
        if (len == 1) {
            switch (c) {
                case 'n': {
                    return 10L;
                }
                case 't': {
                    return 9L;
                }
                case 'v': {
                    return 11L;
                }
                case 'b': {
                    return 8L;
                }
                case 'r': {
                    return 13L;
                }
                case 'f': {
                    return 12L;
                }
                case 'a': {
                    return 7L;
                }
                case '\\': {
                    return 92L;
                }
                case '?': {
                    return 63L;
                }
                case '\'': {
                    return 39L;
                }
                case '\"': {
                    return 34L;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    return c - 48;
                }
            }
            throw new NumberFormatException("Util.CharLit.unrecognizedEscape");
        }
        if (c == 'x' || c == 'X') {
            if (len == 1) {
                throw new NumberFormatException("Util.HexLit.malformed");
            }
            for (int i = 1; i < len; ++i) {
                if (StringFunctions.isHex(lexeme.charAt(i))) continue;
                throw new NumberFormatException("Util.HexLit.malformed");
            }
            return StringFunctions.translateHexLiteral(lexeme.substring(1), true);
        }
        if (c >= '0' && c <= '7') {
            for (int i = 0; i < len; ++i) {
                if (lexeme.charAt(i) >= '0' && lexeme.charAt(i) <= '7') continue;
                throw new NumberFormatException("Util.OctalLit.malformed");
            }
            return StringFunctions.translateOctalLiteral(lexeme, true);
        }
        if (allowUnicode && c == 'u') {
            long ret = 0L;
            int i = 1;
            while ((c = lexeme.charAt(i)) == 'u') {
                ++i;
            }
            if (len - i != 4) {
                throw new NumberFormatException("Util.CharLit.malformedUnicode");
            }
            while (i < len) {
                c = lexeme.charAt(i);
                if (!StringFunctions.isHex(c)) {
                    throw new NumberFormatException("Util.CharLit.malformedUnicode");
                }
                ret = (ret << 8) + (long)StringFunctions.toInt(c);
                ++i;
            }
            return ret;
        }
        throw new NumberFormatException("Util.CharLit.unrecognizedEscape");
    }

    public static long translateHexLiteral(String lexeme, boolean mustBeByteSized) throws NumberFormatException {
        long ret = 0L;
        int len = lexeme.length();
        for (int i = 0; i < len; ++i) {
            char c = lexeme.charAt(i);
            long tmp = c >= '0' && c <= '9' ? (long)(c - 48) : (c >= 'a' && c <= 'f' ? (long)(c - 97 + 10) : (long)(c - 65 + 10));
            long newValue = ret * (long)16 + tmp;
            if (mustBeByteSized && newValue > (long)255 || !mustBeByteSized && ret < 0L && newValue >= 0L) {
                throw new NumberFormatException("Util.HexLit.overflow");
            }
            ret = newValue;
        }
        return ret;
    }

    public static long translateOctalLiteral(String lexeme, boolean mustBeByteSized) throws NumberFormatException {
        long ret = lexeme.charAt(0) - 48;
        int length = lexeme.length();
        for (int index = 1; index < length; ++index) {
            long newValue = ret * (long)8 + (long)lexeme.charAt(index) - (long)48;
            if (mustBeByteSized && index == 2) {
                if (newValue > (long)255) {
                    throw new NumberFormatException("Util.OctalLit.overflow");
                }
                if (index < length - 1) {
                    throw new NumberFormatException("Util.OctalLit.malformed");
                }
                return newValue;
            }
            if (!mustBeByteSized && ret < 0L && newValue >= 0L) {
                throw new NumberFormatException("Util.OctalLit.overflow");
            }
            ret = newValue;
        }
        return ret;
    }

    public static long translateWideCharacterLiteral(String lexeme, boolean allowUnicode) throws NumberFormatException {
        int i;
        lexeme = lexeme.substring(1, lexeme.length() - 1);
        int len = lexeme.length();
        long ret = 0L;
        block2: for (i = 0; i < 7 && len > 0; ++i) {
            int lastValidPrefix = 0;
            for (int j = 1; j < len; ++j) {
                int value = 0;
                try {
                    String testLexeme = String.valueOf(new StringBuffer(String.valueOf('\'')).append(lexeme.substring(0, j)).append('\''));
                    value = (byte)StringFunctions.translateCharacterLiteral(testLexeme, allowUnicode);
                    lastValidPrefix = j;
                    continue;
                }
                catch (NumberFormatException e) {
                    if (lastValidPrefix <= 0) continue;
                    ret |= (long)(value << i * 8);
                    lexeme = lexeme.substring(j - 1, len);
                    len = lexeme.length();
                    continue block2;
                }
            }
        }
        if (i == 0 || len > 0) {
            throw new NumberFormatException("Util.WideCharLit.malformed");
        }
        return ret;
    }
}

