/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

public final class SimpleStringBuffer {
    public static final int DEFAULT_CAPACITY = 1024;
    private int Length;
    private char[] Data;

    public SimpleStringBuffer() {
        this(1024);
    }

    public SimpleStringBuffer(int defaultCapacity) {
        this.Data = new char[defaultCapacity];
        this.Length = 0;
    }

    public SimpleStringBuffer(String initialContents) {
        this(initialContents.length());
        this.append(initialContents);
    }

    public void append(char c) {
        this.append(c, 1);
    }

    public void append(char c, int times) {
        if (this.Length + times > this.Data.length) {
            this.expand(this.Length + times - this.Data.length);
        }
        for (int i = 0; i < times; ++i) {
            this.Data[this.Length++] = c;
        }
    }

    public void append(SimpleStringBuffer buf) {
        this.ensureCapacity(this.Length + buf.Length);
        for (int i = 0; i < buf.Length; ++i) {
            this.Data[this.Length++] = buf.Data[i];
        }
    }

    public void append(String s) {
        int len = s.length();
        if (this.Length + len > this.Data.length) {
            this.expand(this.Length + len - this.Data.length);
        }
        s.getChars(0, len, this.Data, this.Length);
        this.Length += len;
    }

    public void append(String s, int len) {
        if (this.Length + len > this.Data.length) {
            this.expand(this.Length + len - this.Data.length);
        }
        s.getChars(0, len, this.Data, this.Length);
        this.Length += len;
    }

    public void ensureCapacity(int capacity) {
        if (this.Data.length < capacity) {
            char[] newData = new char[capacity];
            System.arraycopy(this.Data, 0, newData, 0, this.Data.length);
            this.Data = newData;
        }
    }

    public boolean equals(String s) {
        if (this.Length != s.length()) {
            return false;
        }
        for (int i = 0; i < this.Length; ++i) {
            if (this.Data[i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(char[] buf) {
        if (this.Length != buf.length) {
            return false;
        }
        for (int i = 0; i < this.Length; ++i) {
            if (this.Data[i] == buf[i]) continue;
            return false;
        }
        return true;
    }

    private void expand(int byAtLeast) {
        this.ensureCapacity(SimpleStringBuffer.max(this.Data.length * 2, this.Data.length + byAtLeast));
    }

    public int length() {
        return this.Length;
    }

    public static int max(int a, int b) {
        return a >= b ? a : b;
    }

    public void reset() {
        this.Length = 0;
    }

    public void reset(int length) throws IllegalArgumentException {
        if (length > this.Length) {
            throw new IllegalArgumentException(String.valueOf(new StringBuffer("").append(length).append(" exceeds current length of ").append(this.Length)));
        }
        this.Length = length;
    }

    public char[] toReadOnlyArray() {
        return this.Data;
    }

    public String toString() {
        return new String(this.Data, 0, this.Length);
    }
}

