/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

import com.inprise.vbroker.util.Mutex;

public class RWMutex {
    private int _waitingWriters = 0;
    private int _waitingReaders = 0;
    private int _activeReaders = 0;
    private int _activeWriters = 0;
    private Mutex _writerLock = new Mutex();
    private Thread _writerThread = null;

    public synchronized void readLock() {
        Thread _currentThread = Thread.currentThread();
        ++this._waitingReaders;
        if (this._writerThread != _currentThread) {
            while (this._waitingWriters > 0 || this._activeWriters > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        --this._waitingReaders;
        if (this._activeReaders++ == 0) {
            this._writerLock.lock();
            this._writerThread = _currentThread;
        }
    }

    public synchronized void unlock() {
        if (--this._activeReaders == 0) {
            this._writerThread = null;
            this._activeWriters = 0;
            this._writerLock.unlock();
            if (this._waitingReaders > 0 && this._waitingWriters == 0) {
                this.notifyAll();
            }
        }
    }

    public void writeLock() {
        RWMutex rWMutex;
        Thread _writerThread;
        Thread _currentThread = Thread.currentThread();
        RWMutex rWMutex2 = this;
        synchronized (rWMutex2) {
            _writerThread = this._writerThread;
            ++this._waitingWriters;
        }
        if (_writerThread != _currentThread) {
            this._writerLock.lock();
            rWMutex = this;
            synchronized (rWMutex) {
                this._writerThread = _currentThread;
                ++this._activeWriters;
            }
        }
        rWMutex = this;
        synchronized (rWMutex) {
            --this._waitingWriters;
            ++this._activeReaders;
        }
    }
}

