/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.util;

import com.inprise.vbroker.compiler.util.BufferReader;
import com.inprise.vbroker.compiler.util.BufferWriter;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.compiler.util.SerialBufferReader;
import com.inprise.vbroker.compiler.util.Utils;
import com.inprise.vbroker.util.SimpleStringBuffer;
import com.inprise.vbroker.util.Timer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Stack;

public class SerialBufferWriter
extends BufferWriter {
    private static final boolean _time = false;
    private Timer _timer;
    private Hashtable _pathTable = new Hashtable();

    public SerialBufferWriter(ErrorReporter ER) {
        this(ER, new SerialBufferReader(ER));
    }

    public SerialBufferWriter(ErrorReporter ER, BufferReader reader) {
        super(ER, reader);
        if (this._reader == null) {
            this._reader = new SerialBufferReader(this._ER);
        }
    }

    private boolean doVerify(File file, SimpleStringBuffer buf, String filename) {
        try {
            if (file.canRead() && file.isFile()) {
                int newLength;
                byte[] existingContents;
                InputStream istream = this._reader.getInputStream(file);
                int status = istream.read(existingContents = new byte[newLength = buf.length()]);
                if (status == newLength) {
                    boolean equal = true;
                    char[] newContents = buf.toReadOnlyArray();
                    for (int i = 0; i < newLength; ++i) {
                        if (existingContents[i] == (byte)newContents[i]) continue;
                        equal = false;
                        break;
                    }
                    if (equal && istream.read(existingContents) == -1) {
                        istream.close();
                        boolean bl = true;
                        return bl;
                    }
                }
                istream.close();
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException io) {
            this._ER.warn("Comp.Util.BufferWriter.unableToVerify", filename);
            this._ER.warn("Comp.Util.BufferWriter.unableToVerifyAdd");
        }
        return false;
    }

    private void doWrite(File file, SimpleStringBuffer buf, boolean lastCall, String filename) {
        try {
            FileWriter writer = new FileWriter(file);
            this._pathTable.put(filename, writer);
            this.doWrite(writer, buf, lastCall, filename);
        }
        catch (IOException e) {
            this._ER.error("Comp.Util.BufferWriter.badWriteOpen", filename);
        }
    }

    private void doWrite(FileWriter writer, SimpleStringBuffer buf, boolean lastCall, String filename) {
        boolean inWrite = true;
        try {
            writer.write(buf.toReadOnlyArray(), 0, buf.length());
            inWrite = false;
            if (lastCall) {
                writer.close();
            }
        }
        catch (IOException e) {
            if (inWrite) {
                this._ER.error("Comp.Util.BufferWriter.badWrite", filename);
            }
            this._ER.error("Comp.Util.BufferWriter.badClose", filename);
        }
    }

    public void done() {
    }

    private void mkdirs(String filename) {
        int index = filename.lastIndexOf(File.separatorChar);
        if (index != -1) {
            File directory = new File(filename.substring(0, index));
            directory.mkdirs();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean write(String filename, SimpleStringBuffer buf, boolean lastCall, Stack bufferPool, boolean overwriteIfDifferent) {
        boolean bl;
        block13: {
            boolean bl2;
            block12: {
                boolean bl3;
                block11: {
                    boolean bl4;
                    block10: {
                        boolean bl5;
                        block9: {
                            boolean bl6;
                            block8: {
                                try {
                                    if (filename.equals("-")) {
                                        System.out.println(buf.toString());
                                        boolean bl7 = true;
                                        Object var10_8 = null;
                                        buf.reset();
                                        if (bufferPool == null) return bl7;
                                        bufferPool.addElement(buf);
                                        return bl7;
                                    }
                                    Object o = this._pathTable.get(filename = Utils.mapHyphenNames(filename));
                                    if (o != null) {
                                        if (o == Boolean.FALSE) {
                                            bl6 = false;
                                            break block8;
                                        }
                                        this.doWrite((FileWriter)o, buf, lastCall, filename);
                                        bl5 = true;
                                        break block9;
                                    }
                                    this.mkdirs(filename);
                                    File file = new File(filename);
                                    if (!file.exists()) {
                                        this.doWrite(file, buf, lastCall, filename);
                                        bl4 = true;
                                        break block10;
                                    }
                                    if (lastCall && this.doVerify(file, buf, filename)) {
                                        bl3 = false;
                                        break block11;
                                    }
                                    if (overwriteIfDifferent) {
                                        this.doWrite(file, buf, lastCall, filename);
                                        bl2 = true;
                                        break block12;
                                    }
                                    bl = false;
                                    break block13;
                                }
                                catch (Throwable throwable) {
                                    Object var10_15 = null;
                                    buf.reset();
                                    if (bufferPool == null) throw throwable;
                                    bufferPool.addElement(buf);
                                    throw throwable;
                                }
                            }
                            Object var10_9 = null;
                            buf.reset();
                            if (bufferPool == null) return bl6;
                            bufferPool.addElement(buf);
                            return bl6;
                        }
                        Object var10_10 = null;
                        buf.reset();
                        if (bufferPool == null) return bl5;
                        bufferPool.addElement(buf);
                        return bl5;
                    }
                    Object var10_11 = null;
                    buf.reset();
                    if (bufferPool == null) return bl4;
                    bufferPool.addElement(buf);
                    return bl4;
                }
                Object var10_12 = null;
                buf.reset();
                if (bufferPool == null) return bl3;
                bufferPool.addElement(buf);
                return bl3;
            }
            Object var10_13 = null;
            buf.reset();
            if (bufferPool == null) return bl2;
            bufferPool.addElement(buf);
            return bl2;
        }
        Object var10_14 = null;
        buf.reset();
        if (bufferPool == null) return bl;
        bufferPool.addElement(buf);
        return bl;
    }
}

