/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.util;

import com.inprise.vbroker.compiler.util.Utils;
import com.inprise.vbroker.util.StringFunctions;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class ErrorReporter {
    public static final Object[] NO_ARGS = new Object[0];
    public static final int FATAL = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int ADDON = 3;
    public static final int MESSAGE = 4;
    public boolean _verbose = false;
    public boolean _multipleMessagesPerLine = false;
    private String _toolName;
    protected ResourceBundle _messageTranslations;
    public int _numErrors = 0;
    public int _numWarns = 0;
    public int _maxErrors = Integer.MAX_VALUE;
    public int _maxWarns = Integer.MAX_VALUE;
    public boolean _warnImpliesError = false;
    public boolean _errorImpliesFatal = false;
    public final int _defaultFatalExitCode = 1;
    public int _currentFileNumber;
    public long _currentLineNumber;
    private int _numFiles;
    public String[] _files = new String[50];
    public Hashtable _fileMap = new Hashtable(50);
    public int _previousFileNumber;
    public long _previousLineNumber;
    public int _lastFileNumber;
    public long _lastLineNumber;
    private int _lastErrorFileNumber = -1;
    private long _lastErrorLineNumber;
    private String _lastToolName;
    public boolean _printToStdout = false;
    public boolean _print = true;
    private ExitHandler _exitHandler = new ExitHandler(null){

        public void exit(int errorCode) {
            System.exit(errorCode);
        }
    };

    public ErrorReporter(String translationTableName) {
        this._messageTranslations = ResourceBundle.getBundle(translationTableName);
    }

    protected ErrorReporter(ResourceBundle messageTranslations) {
        this._messageTranslations = messageTranslations;
    }

    public final void add(String mesgName) {
        this.add(mesgName, NO_ARGS);
    }

    public final void add(String mesgName, Object[] args) {
        this.process(String.valueOf(this.prolog(this._lastFileNumber, this._lastLineNumber, true)).concat(String.valueOf(MessageFormat.format(this.getMesg(mesgName), args))), 3, mesgName, this._lastFileNumber, this._lastLineNumber, args);
    }

    public final boolean error(String mesgName) {
        return this.error(mesgName, this._currentFileNumber, this._currentLineNumber);
    }

    public final boolean error(String mesgName, int fileNumber, long lineNumber) {
        return this.error(mesgName, fileNumber, lineNumber, NO_ARGS);
    }

    public final boolean error(String mesgName, int fileNumber, long lineNumber, String arg) {
        if (arg == null) {
            this.internalError("null string passed to error function with message ".concat(String.valueOf(mesgName)));
        }
        return this.error(mesgName, fileNumber, lineNumber, new Object[]{arg});
    }

    public final boolean error(String mesgName, int fileNumber, long lineNumber, Object[] args) {
        if (!this.register(true, fileNumber, lineNumber)) {
            return false;
        }
        this.process(String.valueOf(this.prolog(fileNumber, lineNumber, true)).concat(String.valueOf(MessageFormat.format(this.getMesg(mesgName), args))), 1, mesgName, fileNumber, lineNumber, null);
        if (this._errorImpliesFatal) {
            this._exitHandler.exit(1);
        }
        return true;
    }

    public final boolean error(String mesgName, String arg) {
        return this.error(mesgName, this._currentFileNumber, this._currentLineNumber, arg);
    }

    public final boolean error(String mesgName, Object[] args) {
        return this.error(mesgName, this._currentFileNumber, this._currentLineNumber, args);
    }

    public final boolean error2(String mesgName, int currentFileNumber, long currentLineNumber, String refName, int previousFileNumber, long previousLineNumber) {
        String message;
        Object[] args;
        if (!this.register(true, currentFileNumber, currentLineNumber)) {
            return false;
        }
        if (currentFileNumber == previousFileNumber) {
            args = new Object[]{this.getMesg(refName), new Long(previousLineNumber)};
            message = String.valueOf(this.prolog(currentFileNumber, currentLineNumber, true)).concat(String.valueOf(MessageFormat.format(this.getMesg(String.valueOf(mesgName).concat("SameFile")), args)));
        } else {
            args = new Object[]{this.getMesg(refName), this._files[previousFileNumber], new Long(previousLineNumber)};
            message = String.valueOf(this.prolog(currentFileNumber, currentLineNumber, true)).concat(String.valueOf(MessageFormat.format(this.getMesg(mesgName), args)));
        }
        this.process(message, 1, mesgName, currentFileNumber, currentLineNumber, args);
        if (this._errorImpliesFatal) {
            this._exitHandler.exit(1);
        }
        return true;
    }

    public final boolean error2(String mesgName, int currentFileNumber, long currentLineNumber, Object[] args, int previousFileNumber, long previousLineNumber) {
        String message;
        Object[] completeArgList;
        if (!this.register(true, currentFileNumber, currentLineNumber)) {
            return false;
        }
        if (currentFileNumber == previousFileNumber) {
            completeArgList = new Object[args.length + 1];
            for (int i = 0; i < args.length; ++i) {
                completeArgList[i] = args[i];
            }
            completeArgList[args.length] = new Long(previousLineNumber);
            message = String.valueOf(this.prolog(currentFileNumber, currentLineNumber, true)).concat(String.valueOf(MessageFormat.format(this.getMesg(String.valueOf(mesgName).concat("SameFile")), completeArgList)));
        } else {
            completeArgList = new Object[args.length + 2];
            for (int i = 0; i < args.length; ++i) {
                completeArgList[i] = args[i];
            }
            completeArgList[args.length + 0] = this._files[previousFileNumber];
            completeArgList[args.length + 1] = new Long(previousLineNumber);
            message = String.valueOf(this.prolog(currentFileNumber, currentLineNumber, true)).concat(String.valueOf(MessageFormat.format(this.getMesg(mesgName), completeArgList)));
        }
        this.process(message, 1, mesgName, currentFileNumber, currentLineNumber, completeArgList);
        if (this._errorImpliesFatal) {
            this._exitHandler.exit(1);
        }
        return true;
    }

    public final boolean error2(String mesgName, String refName) {
        return this.error2(mesgName, this._currentFileNumber, this._currentLineNumber, refName, this._previousFileNumber, this._previousLineNumber);
    }

    public final boolean error2(String mesgName, Object[] args) {
        return this.error2(mesgName, this._currentFileNumber, this._currentLineNumber, args, this._previousFileNumber, this._previousLineNumber);
    }

    public final void fatal(String mesgName) {
        this.fatal(mesgName, 1);
    }

    public final void fatal(String mesgName, int exitCode) {
        this.fatal(mesgName, NO_ARGS, exitCode);
    }

    public final void fatal(String mesgName, Object[] args) {
        this.fatal(mesgName, args, 1);
    }

    public final void fatal(String mesgName, Object[] args, int exitCode) {
        String text = MessageFormat.format(this.getMesg(mesgName), args);
        this.process(MessageFormat.format(this.getMesg("Comp.Fatal"), this._toolName, text), 0, mesgName, -1, -1L, args);
        this._exitHandler.exit(exitCode);
    }

    public String getFileName() {
        return this._files[this._currentFileNumber] == null ? "<<unknown file>>" : this._files[this._currentFileNumber];
    }

    public String getFileName(int fileNumber) {
        return this._files[fileNumber] == null ? "<<unknown file>>" : this._files[fileNumber];
    }

    public final String getMesg(String mesgName) {
        String ret = "???";
        try {
            ret = this._messageTranslations.getString(mesgName);
        }
        catch (MissingResourceException e) {
            System.err.println(String.valueOf(new StringBuffer(String.valueOf(this._toolName)).append(": unable to translate message: \"").append(mesgName).append("\" (Missing, incomplete or damaged resource bundle?)")));
            this._exitHandler.exit(1);
        }
        return ret;
    }

    public final ResourceBundle getMessageTranslations() {
        return this._messageTranslations;
    }

    public final int getSummary() {
        return this._numErrors > 0 ? -this._numErrors : this._numWarns;
    }

    public final String getToolName() {
        return this._toolName;
    }

    public final void internalError(String message) {
        if (this._currentFileNumber != -1 && this._currentLineNumber > (long)0) {
            message = String.valueOf(message).concat(String.valueOf(String.valueOf(new StringBuffer(" (may have happened near line ").append(this._currentLineNumber).append(", file \"").append(this.getFileName()).append("\")"))));
        }
        this.fatal(this._verbose ? "Comp.VerboseInternal" : "Comp.Internal", new Object[]{message});
    }

    public final void internalError(Throwable t) {
        if (this._verbose) {
            this.fatal("Comp.VerboseInternal", new Object[]{"unexpected exception: ".concat(String.valueOf(Utils.getStackTrace(t)))});
        } else {
            this.fatal("Comp.Internal");
        }
    }

    public final void print(String mesgName, Object[] args) {
        this.process(MessageFormat.format(this.getMesg(mesgName), args), 4, mesgName, this._lastFileNumber, this._lastLineNumber, args);
    }

    public final void printUntranslated(String message) {
        this.print("Comp.Tools.printUntranslated", new Object[]{message});
    }

    protected abstract void process(String var1, int var2, String var3, int var4, long var5, Object[] var7);

    private final String prolog(int fileNumber, long lineNumber, boolean isError) {
        if (lineNumber > (long)0) {
            String fileName = StringFunctions.prepFilename(this._files[fileNumber]);
            return MessageFormat.format(this.getMesg(isError ? "Comp.Error" : "Comp.Warn"), fileName, new Long(lineNumber));
        }
        return MessageFormat.format(this.getMesg(isError ? "Comp.ToolError" : "Comp.ToolWarn"), this._toolName);
    }

    private final boolean register(boolean isError, int fileNumber, long lineNumber) {
        if (this._lastToolName != null && this._lastToolName.equals(this._toolName) && this._lastErrorFileNumber != -1 && this._lastErrorFileNumber == fileNumber && this._lastErrorLineNumber == lineNumber && !this._multipleMessagesPerLine) {
            return false;
        }
        this._lastFileNumber = fileNumber;
        this._lastLineNumber = lineNumber;
        if (isError) {
            if (++this._numErrors == this._maxErrors) {
                this.fatal("maxErrorsReached");
            }
            this._lastToolName = this._toolName;
            this._lastErrorFileNumber = fileNumber;
            this._lastErrorLineNumber = lineNumber;
        } else if (++this._numWarns == this._maxWarns) {
            this.fatal("maxWarnsReached");
        }
        return true;
    }

    public void report() {
    }

    public void setExitHandler(ExitHandler e) {
        this._exitHandler = e;
    }

    public int setFile(String fileName) {
        Object object = this._fileMap.get(fileName);
        if (object != null) {
            this._currentFileNumber = (Integer)object;
            return this._currentFileNumber;
        }
        int len = this._files.length;
        if (this._numFiles == len) {
            String[] tmp = new String[len * 2];
            System.arraycopy(this._files, 0, tmp, 0, len);
            this._files = tmp;
        }
        this._files[this._numFiles] = fileName;
        this._fileMap.put(fileName, new Integer(this._numFiles));
        this._currentFileNumber = this._numFiles;
        return this._numFiles++;
    }

    public final void setToolName(String toolName) {
        this._toolName = this.getMesg(toolName);
    }

    public final void unimplemented(String methodName) {
        this.internalError("unimplemented routine ".concat(String.valueOf(methodName)));
    }

    public final void untranslatedMessage(String message) {
        this.process(String.valueOf(this.prolog(this._lastFileNumber, this._lastLineNumber, true)).concat(String.valueOf(message)), 4, null, this._lastFileNumber, this._lastLineNumber, NO_ARGS);
    }

    public final boolean warn(String mesgName) {
        return this.warn(mesgName, this._currentFileNumber, this._currentLineNumber);
    }

    public final boolean warn(String mesgName, int fileNumber, long lineNumber) {
        return this.warn(mesgName, fileNumber, lineNumber, NO_ARGS);
    }

    public final boolean warn(String mesgName, int fileNumber, long lineNumber, String arg) {
        if (arg == null) {
            this.internalError("null string passed to error function with message ".concat(String.valueOf(mesgName)));
        }
        return this.warn(mesgName, fileNumber, lineNumber, new Object[]{arg});
    }

    public final boolean warn(String mesgName, int fileNumber, long lineNumber, Object[] args) {
        if (this._warnImpliesError) {
            return this.error(mesgName, fileNumber, lineNumber, args);
        }
        if (!this.register(false, fileNumber, lineNumber)) {
            return false;
        }
        this.process(String.valueOf(this.prolog(fileNumber, lineNumber, false)).concat(String.valueOf(MessageFormat.format(this.getMesg(mesgName), args))), 2, mesgName, fileNumber, lineNumber, args);
        return true;
    }

    public final boolean warn(String mesgName, String arg) {
        return this.warn(mesgName, new Object[]{arg});
    }

    public final boolean warn(String mesgName, Object[] args) {
        return this.warn(mesgName, this._currentFileNumber, this._currentLineNumber, args);
    }

    public final boolean warn2(String mesgName, int currentFileNumber, long currentLineNumber, String refName, int previousFileNumber, long previousLineNumber) {
        String message;
        Object[] args;
        if (this._warnImpliesError) {
            return this.error2(mesgName, currentFileNumber, currentLineNumber, refName, previousFileNumber, previousLineNumber);
        }
        if (!this.register(false, currentFileNumber, currentLineNumber)) {
            return false;
        }
        if (currentFileNumber == previousFileNumber) {
            args = new Object[]{this.getMesg(refName), new Long(previousLineNumber)};
            message = String.valueOf(this.prolog(currentFileNumber, currentLineNumber, false)).concat(String.valueOf(MessageFormat.format(this.getMesg(String.valueOf(mesgName).concat("SameFile")), args)));
        } else {
            args = new Object[]{this.getMesg(refName), this._files[previousFileNumber], new Long(previousLineNumber)};
            message = String.valueOf(this.prolog(currentFileNumber, currentLineNumber, false)).concat(String.valueOf(MessageFormat.format(this.getMesg(mesgName), args)));
        }
        this.process(message, 2, mesgName, currentFileNumber, currentLineNumber, args);
        return true;
    }

    public final boolean warn2(String mesgName, int currentFileNumber, long currentLineNumber, Object[] args, int previousFileNumber, long previousLineNumber) {
        String message;
        Object[] completeArgList;
        if (this._warnImpliesError) {
            return this.error2(mesgName, currentFileNumber, currentLineNumber, args, previousFileNumber, previousLineNumber);
        }
        if (!this.register(false, currentFileNumber, currentLineNumber)) {
            return false;
        }
        if (currentFileNumber == previousFileNumber) {
            completeArgList = new Object[args.length + 1];
            for (int i = 0; i < args.length; ++i) {
                completeArgList[i] = args[i];
            }
            completeArgList[args.length] = new Long(previousLineNumber);
            message = String.valueOf(this.prolog(currentFileNumber, currentLineNumber, false)).concat(String.valueOf(MessageFormat.format(this.getMesg(String.valueOf(mesgName).concat("SameFile")), completeArgList)));
        } else {
            completeArgList = new Object[args.length + 2];
            for (int i = 0; i < args.length; ++i) {
                completeArgList[i] = args[i];
            }
            completeArgList[args.length + 0] = this._files[previousFileNumber];
            completeArgList[args.length + 1] = new Long(previousLineNumber);
            message = String.valueOf(this.prolog(currentFileNumber, currentLineNumber, false)).concat(String.valueOf(MessageFormat.format(this.getMesg(mesgName), completeArgList)));
        }
        this.process(message, 2, mesgName, currentFileNumber, currentLineNumber, completeArgList);
        return true;
    }

    public final boolean warn2(String mesgName, String refName) {
        return this.warn2(mesgName, this._currentFileNumber, this._currentLineNumber, refName, this._previousFileNumber, this._previousLineNumber);
    }

    public final boolean warn2(String mesgName, Object[] args) {
        return this.warn2(mesgName, this._currentFileNumber, this._currentLineNumber, args, this._previousFileNumber, this._previousLineNumber);
    }

    public final void warnAdd(String mesgName) {
        if (this._warnImpliesError) {
            this.add(mesgName);
            return;
        }
        this.process(String.valueOf(this.prolog(this._lastFileNumber, this._lastLineNumber, false)).concat(String.valueOf(this.getMesg(mesgName))), 3, mesgName, this._lastFileNumber, this._lastLineNumber, NO_ARGS);
    }

    public static interface ExitHandler {
        public void exit(int var1);
    }
}

